/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import oracle.rat.tfa.MessageHandler;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Profile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class DBGProfileMonitor
implements Runnable {
    Thread mythread;
    public String type;

    DBGProfileMonitor(String string) {
        this.type = string;
        this.mythread = new Thread((Runnable)this, "DBGProfileMonitor");
        Output.printTrace("DBGProfileMonitor created" + this.mythread, 3);
        this.mythread.start();
    }

    @Override
    public void run() {
        block8: {
            String string = "";
            if (new File(Properties.perlexe).exists()) {
                string = Properties.perlexe;
            }
            try {
                if (!this.type.equals("DBGLevel")) break block8;
                Calendar calendar = Calendar.getInstance();
                while (true) {
                    calendar.setTime(new Date());
                    if (!Global.profileProperties.isEmpty()) {
                        Enumeration enumeration = Global.profileProperties.keys();
                        while (enumeration.hasMoreElements()) {
                            String string2 = (String)enumeration.nextElement();
                            Profile profile = (Profile)Global.profileProperties.get(string2);
                            if (profile.getInfiniteTimeoutFlag() != 0 || !profile.getTimeout().before(calendar.getTime())) continue;
                            String string3 = string + " " + Properties.tfaHome + File.separator + "bin" + File.separator + "tfactl.pl dbglevel -unset " + string2;
                            Output.printTrace("FileHelper : Command : " + string3, 3);
                            try {
                                Output.printTrace("Unsetting the profile...", 3);
                                Runtime.getRuntime().exec(string3);
                            }
                            catch (Exception exception) {
                                Output.printTrace("Perl command run failed...", 3);
                            }
                            Output.printTrace("Processing the element " + string2, 3);
                            Output.printTrace("Timeout reached " + Global.profileProperties.remove(string2), 3);
                        }
                        MessageHandler.printHash(Global.profileProperties);
                    }
                    Output.printTrace("Time: " + calendar.getTime(), 3);
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                Output.printTrace("DBGProfileMonitor thread interrupted", 3);
            }
        }
        Output.printTrace("DBGProfileMonitor run is over", 3);
    }
}

