/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import oracle.rat.tfa.db.DataAccessor.ProfilesDA;
import oracle.rat.tfa.entity.Profile;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;

public class DBGProfileAccessManager {
    private static void addTFAProfile(Profile profile) {
        new ProfilesDA().pIdx.put((Object)profile);
    }

    public static boolean addTFAProfile(String string, Date date, int n) {
        Profile profile = new Profile(string, date, n);
        boolean bl = false;
        try {
            DBGProfileAccessManager.addTFAProfile(profile);
            LogFile.writeLog("DBGProfileAccessManager: Added TFA DBGLevel Profile '" + profile.getProfileName() + "'");
            bl = true;
        }
        catch (Exception exception) {
            Output.print("DBGProfileAccessManager: Unable to add TFA DBGLevel Profile '" + profile.getProfileName() + "'");
        }
        return bl;
    }

    private static boolean removeTFAProfile(Profile profile) {
        return new ProfilesDA().pIdx.delete((Object)profile.getProfileName());
    }

    public static boolean removeTFAProfile(String string) {
        Profile profile = DBGProfileAccessManager.getTFAProfile(string.trim());
        boolean bl = false;
        if (profile != null) {
            bl = DBGProfileAccessManager.removeTFAProfile(profile);
            LogFile.writeLog("DBGProfileAccessManager: Removing Profile '" + profile.getProfileName() + ".");
        }
        return bl;
    }

    private static Profile getTFAProfile(String string) {
        return (Profile)new ProfilesDA().pIdx.get((Object)string.trim());
    }

    public static List<Profile> getAllProfiles() {
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(String.class, Profile.class);
            EntityCursor entityCursor = primaryIndex.entities();
            for (Profile profile : entityCursor) {
                arrayList.add(profile);
            }
            entityCursor.close();
        }
        catch (Exception exception) {
            Output.print("TFAAccessManager: Exception in getAllUsers: " + exception.getMessage());
            exception.printStackTrace();
        }
        return arrayList;
    }
}

