/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.ThreadInterruptedException;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.MessageHandler;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.nls.Omsg;
import oracle.rat.tfa.nls.Oprint;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;

public class ConnectionAcceptor
implements Runnable {
    @Override
    public void run() {
        SSLServerSocket sSLServerSocket = null;
        boolean bl = true;
        Properties properties = Properties.getInstance();
        String string = Properties.keyStore;
        char[] cArray = Properties.serverTrustStorePassword.toCharArray();
        char[] cArray2 = Properties.serverKeyStorePassword.toCharArray();
        System.setProperty("javax.net.ssl.trustStore", string);
        System.setProperty("javax.net.ssl.trustStorePassword", Properties.serverKeyStorePassword);
        System.setProperty("javax.net.ssl.keyStorePassword", Properties.serverKeyStorePassword);
        Output.printTrace("Connection Acceptor Thread started", 3);
        StringBuilder stringBuilder = new StringBuilder().append("Setting port in ConnectionAcceptor ");
        Properties.getInstance();
        Output.printTrace(stringBuilder.append(Properties.getSocketPort()).toString(), 3);
        Properties.getInstance();
        int n = new Integer(Properties.getSocketPort());
        if (n == -1) {
            Output.print("Could not find a free port to run TFA");
            return;
        }
        Global.setSocketPort(n);
        try {
            Object object;
            Object object2;
            Object object3;
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(string), cArray);
            String string2 = Properties.platform;
            Output.printTrace("OS Name : " + string2, 3);
            KeyManagerFactory keyManagerFactory = SocketManager.getSystemSpecificKeyManager();
            if (keyManagerFactory == null) {
                Output.print("Platform " + string2 + " is not supported.");
                return;
            }
            keyManagerFactory.init(keyStore, cArray2);
            if (Global.protocol == null) {
                object3 = System.getProperty("java.version");
                double d = new Double((String)(object3 = ((String)object3).substring(0, 3)));
                Global.protocol = d >= 1.7 ? "TLSv1.2" : "TLS";
            }
            Output.printTrace("Restricted Protocols : " + Global.restrictedProtocols, 3);
            Output.printTrace("SSLContext Protocol : " + Global.protocol, 3);
            object3 = SSLContext.getInstance(Global.protocol);
            ((SSLContext)object3).init(keyManagerFactory.getKeyManagers(), null, null);
            SSLServerSocketFactory sSLServerSocketFactory = ((SSLContext)object3).getServerSocketFactory();
            if (Properties.publicIp.booleanValue()) {
                sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(n);
            } else {
                Output.print("Starting Connection Acceptor on LoopBack Address 127.0.0.1");
                sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(0, 5, InetAddress.getByName("127.0.0.1"));
                n = sSLServerSocket.getLocalPort();
                Properties.getInstance().writePortToFile(n);
                Global.setSocketPort(n);
                Properties.setSocketPort(Integer.toString(n));
                object2 = new HashMap();
                object = new Host().getHostname().trim();
                object2.put(object, n);
                Properties.writePortMappingToFile((Map<String, Integer>)object2);
                Global.setPortMapping((Map<String, Integer>)object2);
            }
            sSLServerSocket.setSoTimeout(5000);
            sSLServerSocket.setNeedClientAuth(true);
            object2 = sSLServerSocket.getEnabledProtocols();
            object = new HashSet();
            for (String string3 : object2) {
                if (Global.restrictedProtocols.contains(string3)) continue;
                object.add(string3);
            }
            Output.print("EnabledProtocol : " + object);
            sSLServerSocket.setEnabledProtocols(object.toArray(new String[0]));
            Global.availableProtocols = new ArrayList<String>((Collection<String>)object);
            Output.print("Inet Address : " + sSLServerSocket.getInetAddress());
            Output.print("Port : " + sSLServerSocket.getLocalPort());
            Output.printTrace("Supported Cipher Suites :", 3);
            for (String string3 : sSLServerSocket.getSupportedCipherSuites()) {
                Output.printTrace(string3, 3);
            }
            Properties.getInstance();
            Properties.setKeystoresUpdated(true);
            String[] stringArray = new String[]{"SSL_RSA_WITH_3DES_EDE_CBC_SHA"};
            sSLServerSocket.setEnabledCipherSuites(stringArray);
            Output.printTrace("Enabled Cipher Suites :", 3);
            for (String string4 : sSLServerSocket.getEnabledCipherSuites()) {
                Output.printTrace(string4, 3);
            }
            while (bl) {
                try {
                    new Thread(new MessageHandler((SSLSocket)sSLServerSocket.accept())).start();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    Output.printTrace("SocketTimeoutException while listening", 2);
                }
                catch (ThreadInterruptedException threadInterruptedException) {
                    Output.print("ThreadInterruptedException while listening");
                    bl = false;
                }
                catch (Exception exception) {
                    Output.print("Exception while listening");
                    exception.printStackTrace();
                }
                if (!Thread.interrupted()) continue;
                Output.printTrace("ConnectionAcceptor is Interrupted", 2);
                bl = false;
            }
            Output.print("Received Message to shutdown through Interrupt");
            if (!sSLServerSocket.isClosed()) {
                sSLServerSocket.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Output.printTrace("Could not listen on port : " + n, 1);
            System.exit(-1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private boolean isPortAvailable(int n) {
        Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
        Omsg omsg = new Omsg("en-US", "en", "UTF-8", "US");
        Output.printTrace("Checking for port availability : " + n, 3);
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(n);
            serverSocket.close();
        }
        catch (IOException iOException) {
            System.out.println("Could not listen on port: " + n);
            return false;
        }
        return true;
    }

    private static void printServerSocketInfo(SSLServerSocket sSLServerSocket) {
        Output.printTrace("Server socket class: " + sSLServerSocket.getClass(), 4);
        Output.printTrace("   Socker address = " + sSLServerSocket.getInetAddress().toString(), 4);
        Output.printTrace("   Socker port = " + sSLServerSocket.getLocalPort(), 4);
        Output.printTrace("   Need client authentication = " + sSLServerSocket.getNeedClientAuth(), 4);
        Output.printTrace("   Want client authentication = " + sSLServerSocket.getWantClientAuth(), 4);
        Output.printTrace("   Use client mode = " + sSLServerSocket.getUseClientMode(), 4);
    }
}

