/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityIndex;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import java.util.Map;
import oracle.rat.tfa.entity.ComponentEntity;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;

public class ComponentEntityManager {
    public static synchronized void printAll() throws DatabaseException {
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(Long.class, ComponentEntity.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (ComponentEntity componentEntity : entityCursor) {
                    Output.print("seci : " + componentEntity.getComponent());
                    Output.print("seci : " + componentEntity.getSubComponents());
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static String getSubCompValues(String string) {
        String string2 = "";
        Transaction transaction = null;
        EntityCursor entityCursor = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(Long.class, ComponentEntity.class);
            SecondaryIndex secondaryIndex = DbManager.getInstance().getEntityStore().getSecondaryIndex(primaryIndex, String.class, "component");
            EntityIndex entityIndex = secondaryIndex.subIndex((Object)string.toUpperCase());
            entityCursor = entityIndex.entities(transaction, cursorConfig);
            for (ComponentEntity componentEntity : entityCursor) {
                string2 = string2 + "node=" + componentEntity.getHost() + ",component=" + componentEntity.getComponent();
                for (Map.Entry<String, String> entry : componentEntity.getSubComponents().entrySet()) {
                    string2 = string2 + "," + entry.getKey() + "=" + entry.getValue();
                }
                string2 = string2 + "\n";
            }
            entityCursor.close();
            entityCursor = null;
            transaction.commit();
            transaction = null;
        }
        catch (Exception exception) {
            if (entityCursor != null) {
                entityCursor.close();
            }
            if (transaction != null) {
                transaction.abort();
                transaction = null;
            }
            exception.printStackTrace();
        }
        return string2;
    }
}

