/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Arrays;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.nls.Omsg;
import oracle.rat.tfa.nls.Oprint;
import oracle.rat.tfa.util.EncryptionUtil;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;

public class CommandLine {
    private boolean debug = false;
    private String tfaHome;

    private static String getHostName() {
        Host host = new Host();
        if (host != null) {
            return host.getHostname();
        }
        return null;
    }

    private static void sendMessage(SSLSocket sSLSocket, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
            printWriter.println(string);
        }
        catch (IOException iOException) {
            Output.print("CommandLine : IOException in writing message to socket");
            iOException.printStackTrace();
        }
    }

    private static void sendNonRootMessage(Socket socket, String string, String string2) {
        CommandLine.validateSession(socket, string2);
        try {
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            printWriter.println(string);
        }
        catch (Exception exception) {
            Output.print("CommandLine : Exception in writing message to socket ");
            exception.printStackTrace();
        }
    }

    private static boolean isNumber(String string) {
        return string.matches("^[0-9]+$");
    }

    private static void validateSession(Socket socket, String string) {
        Object object;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        String string2 = null;
        File file = new File(CommandLine.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        String string3 = file.getParentFile().getParentFile().getAbsolutePath();
        try {
            printWriter = new PrintWriter(socket.getOutputStream(), true);
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
        catch (Exception exception) {
            Output.print("CommandLine : Failed in session validation.");
            exception.printStackTrace();
        }
        printWriter.println("~~~~~~reqUser=" + string + "~~~~~~");
        String string4 = null;
        try {
            string2 = bufferedReader.readLine();
            if (string2 != null && string2.contains("sessionid=")) {
                string4 = string2.split("=")[1];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string4 == null || !CommandLine.isNumber(string4)) {
            Output.print("CommandLine : Failed in reading session id");
            System.exit(0);
        }
        String string5 = Properties.getEscapedUserName(string);
        String string6 = string3 + File.separator + "." + string5 + File.separator + string4 + "_session.lk";
        try {
            long l;
            long l2;
            long l3;
            object = new File(string6);
            if (!((File)object).exists()) {
                Output.print("CommandLine : Unable to read session details : " + string4);
                Output.print("FAILED");
                System.exit(0);
            }
            if ((l3 = (l2 = System.currentTimeMillis() / 1000L) - (l = ((File)object).lastModified() / 1000L)) > 10L) {
                Output.print("CommandLine : Invalid session.");
                Output.print("FAILED");
                System.exit(0);
            }
            ((File)object).delete();
        }
        catch (Exception exception) {
            Output.print("CommandLine : Failed in session validation.");
            exception.printStackTrace();
        }
        try {
            object = string3 + File.separator + "." + string5 + File.separator + string5 + "_mykey.rsa.pub";
            File file2 = new File((String)object);
            if (!file2.exists()) {
                Output.print("CommandLine : Missing KeyFile : " + (String)object);
                System.exit(0);
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(fileInputStream));
            printWriter.println("~~~~~~reqUser=" + string + "~~~~~~");
            String string7 = null;
            while ((string7 = bufferedReader2.readLine()) != null) {
                printWriter.println(EncryptionUtil.encrypt(string7, (String)object));
            }
            bufferedReader2.close();
            printWriter.println("------finished_keyfile------");
        }
        catch (Exception exception) {
            Output.print("CommandLine : Failed in session validation.");
            exception.printStackTrace();
        }
    }

    private static String processCommand(String string, String string2, String string3, String string4) {
        String string5;
        block27: {
            String string6 = CommandLine.getHostName();
            String string7 = string;
            string5 = "FAIL";
            try {
                int n;
                Socket socket;
                Socket socket2;
                block26: {
                    socket2 = null;
                    socket = null;
                    n = -1;
                    try {
                        Output.printTrace("Inside processCommand : " + Global.getSocketPort(), 3);
                        Output.printTrace("CommandString : " + string, 3);
                        if (string3 != null) {
                            n = new Integer(string3);
                        }
                        if (n == -1) break block26;
                        if (string4.equals("root")) {
                            String string8;
                            Object object;
                            String string9 = "";
                            String string10 = "";
                            String string11 = "";
                            String string12 = string2 + File.separator + "internal" + File.separator + "ssl.properties";
                            int n2 = 0;
                            int n3 = 0;
                            if (new File(string12).exists()) {
                                try {
                                    String string13;
                                    java.util.Properties properties = new java.util.Properties();
                                    object = new FileInputStream(string12);
                                    properties.load((InputStream)object);
                                    ((FileInputStream)object).close();
                                    string9 = properties.getProperty("clientCert") != null ? (string8 = properties.getProperty("clientCert").trim()) : string2 + File.separator + "client.jks";
                                    string8 = properties.getProperty("clientKeyStorePass").trim();
                                    string11 = EncryptionUtil.decrypt(string8);
                                    String string14 = properties.getProperty("clientTrustStorePass").trim();
                                    string10 = EncryptionUtil.decrypt(string14);
                                    if (properties.getProperty("sslKey") != null) {
                                        string13 = properties.getProperty("sslKey").trim();
                                        n2 = new Integer(string13);
                                    }
                                    if (properties.getProperty("userCert") != null) {
                                        string13 = properties.getProperty("userCert").trim();
                                        n3 = new Integer(string13);
                                    }
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    fileNotFoundException.printStackTrace();
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            if (n2 == 0 && n3 == 0) {
                                string9 = string2 + File.separator + "public.jks";
                                string10 = "0B814746119D8392A426BD144294D9A9";
                                string11 = "0B814746119D8392A426BD144294D9A9";
                                try {
                                    string10 = EncryptionUtil.decrypt(string10);
                                    string11 = EncryptionUtil.decrypt(string11);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            System.setProperty("javax.net.ssl.trustStore", string9);
                            System.setProperty("javax.net.ssl.trustStorePassword", string10);
                            System.setProperty("javax.net.ssl.keyStorePassword", string11);
                            object = CommandLine.getConfigValue(string2, "publicIp");
                            boolean bl = false;
                            if (object != null) {
                                bl = Boolean.parseBoolean((String)object);
                            }
                            string8 = string6;
                            if (!bl) {
                                string8 = "127.0.0.1";
                            }
                            socket2 = SocketManager.getSecureSocketConnection(string8, n, string9, string11, string10, string2);
                            break block26;
                        }
                        socket = SocketManager.getSocketConnection("127.0.0.1", n);
                    }
                    catch (Exception exception) {
                        Output.print("CommandLine : Exception in connecting to socket in " + string6);
                        exception.printStackTrace();
                    }
                }
                if (string4.equals("root")) {
                    if (socket2 == null) {
                        string5 = "CONNFAIL";
                        System.out.println("Cannot establish connection to TFA on port " + n);
                    } else {
                        CommandLine.sendMessage(socket2, string7);
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket2.getInputStream()));
                        while (!((string5 = bufferedReader.readLine()) == null || string5.contentEquals("DONE") || string5.startsWith("SUCCESS") || string5.contentEquals("FAIL") || string5.contentEquals("CheckOK") || string5.startsWith("FAILED"))) {
                            System.out.println(string5);
                        }
                        bufferedReader.close();
                        socket2.close();
                    }
                    break block27;
                }
                if (socket == null) {
                    string5 = "CONNFAIL";
                    System.out.println("Cannot establish connection to TFA on port " + n);
                    break block27;
                }
                CommandLine.sendNonRootMessage(socket, string7, string4);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                try {
                    while (!((string5 = bufferedReader.readLine()) == null || string5.contentEquals("DONE") || string5.startsWith("SUCCESS") || string5.contentEquals("FAIL") || string5.contentEquals("CheckOK") || string5.startsWith("FAILED") || string5.startsWith("LOGINFAILED"))) {
                        System.out.println(string5);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                bufferedReader.close();
                socket.close();
            }
            catch (IOException iOException) {
                Output.print("CommandLine : IOException in reading from socket input stream");
            }
        }
        return string5;
    }

    private static String getUserGroupName() {
        String string = "/usr/bin/id | awk '{print $2}' | awk -F\\( '{print $2}' | awk -F\\) '{print $1}'";
        String string2 = null;
        try {
            String string3;
            Properties.getInstance();
            Process process = Properties.isWindows() ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", string}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", string});
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string3;
            }
        }
        catch (IOException iOException) {
            Output.print("CommandLine : Exception in getting Group Name in getGroupName");
        }
        return string2;
    }

    public static String getConfigValue(String string, String string2) {
        String string3 = null;
        String string4 = string + File.separator + "internal" + File.separator + "config.properties";
        if (!new File(string4).exists()) {
            return string3;
        }
        try {
            java.util.Properties properties = new java.util.Properties();
            FileInputStream fileInputStream = new FileInputStream(string4);
            properties.load(fileInputStream);
            fileInputStream.close();
            string3 = properties.getProperty(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    public static void main(String[] stringArray) {
        String string;
        File file;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = null;
        Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
        Omsg omsg = new Omsg("en-US", "en", "UTF-8", "US");
        Output.printTrace("In Main of CommandLine : " + Arrays.asList(stringArray), 3);
        if (stringArray.length == 0) {
            string3 = "checkTFAMain";
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-tfaHome")) {
                    string4 = stringArray[i + 1].trim();
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("-port")) {
                    string5 = stringArray[i + 1].trim();
                    ++i;
                    continue;
                }
                string3 = string3 + stringArray[i] + " ";
            }
        }
        string3 = string3.trim();
        if (Properties.platform == null) {
            Properties.platform = System.getProperty("os.name").toLowerCase();
        }
        String string6 = Properties.getUserName();
        String string7 = Properties.getEscapedUserName(string6);
        if (!string6.equals("root") && !(file = new File(string = string4 + File.separator + "." + string7 + File.separator + string7 + "_mykey.rsa.pub")).exists()) {
            Output.print("CommandLine : Missing KeyFile : " + string);
            System.out.println("User '" + string6 + "' does not have keys to run TFA. Please check with TFA Admin(root).");
            System.exit(0);
        }
        Output.printTrace("Input to processCommand : " + string3, 3);
        string2 = CommandLine.processCommand(string3, string4, string5, string6);
        System.out.println(string2);
    }
}

