/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.CollectionDA;
import oracle.rat.tfa.entity.Collection;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.nls.Omsg;
import oracle.rat.tfa.nls.Oprint;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;
import oracle.rat.tfa.util.ThreadUtilities;
import org.apache.commons.io.FileUtils;

public class CollectionManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String printCollections(PrintWriter printWriter) {
        String string = "ALL COLLECTIONS PRINTED";
        int n = 0;
        EntityCursor entityCursor = null;
        Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
        Omsg omsg = new Omsg("en-US", "en", "UTF-8", "US");
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(Collection.class);
            entityCursor = primaryIndex.entities();
            for (Collection collection : entityCursor) {
                ++n;
                printWriter.println("######################################");
                omsg.write(printWriter, "TFA10259", collection.getCollectionId());
                omsg.write(printWriter, "TFA11694", collection.getTFAVersion());
                omsg.write(printWriter, "TFA11662", collection.getTFABuildId());
                omsg.write(printWriter, "TFA11080", collection.isManual());
                omsg.write(printWriter, "TFA11397", collection.getRequestUser());
                omsg.write(printWriter, "TFA11082", collection.getMasterHost());
                omsg.write(printWriter, "TFA11157", collection.getNodeList());
                omsg.write(printWriter, "TFA10251", collection.getTag());
                omsg.write(printWriter, "TFA11893", collection.getZipFileName());
                omsg.write(printWriter, "TFA10492", collection.getDiagcollectLog());
                omsg.write(printWriter, "TFA10307", collection.getComponentList());
                omsg.write(printWriter, "TFA11565", collection.getStartTime());
                omsg.write(printWriter, "TFA10678", collection.getEndTime());
                omsg.write(printWriter, "TFA10788", collection.getFilesInRange());
                omsg.write(printWriter, "TFA11512", collection.getSizeOfFilesInRange());
                omsg.write(printWriter, "TFA11508", collection.getSizeOfExtraFiles());
                omsg.write(printWriter, "TFA11510", collection.getSizeOfFilesBeforeZip());
                omsg.write(printWriter, "TFA11893", collection.getZipFileSize());
                omsg.write(printWriter, "TFA11190", collection.getNumTrimmedFiles());
                omsg.write(printWriter, "TFA11782", collection.getTrimSavings());
                omsg.write(printWriter, "TFA10264", collection.getCollectionTime());
                omsg.write(printWriter, "TFA10257", collection.getScore());
            }
        }
        catch (Exception exception) {
            Output.printTrace("Exception: in print collections", 1);
        }
        finally {
            if (entityCursor != null) {
                entityCursor.close();
            }
        }
        if (n == 0) {
            string = "NO COLLECTIONS TO PRINT";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String printCollections(PrintWriter printWriter, long l, String string) {
        String string2 = "SUCCESS";
        int n = 0;
        try (EntityCursor entityCursor = null;){
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(Collection.class);
            entityCursor = primaryIndex.entities();
            for (Collection collection : entityCursor) {
                if (string != null && !string.equalsIgnoreCase(collection.getRequestUser())) continue;
                if (l > 0L) {
                    long l2 = 0L;
                    if (collection.getCollectionDate() != null) {
                        l2 = collection.getCollectionDate().getTime();
                    } else {
                        String string3 = collection.getCollectionId().substring(0, 14);
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
                        Date date = collection.getEndTime();
                        try {
                            date = simpleDateFormat.parse(string3);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        l2 = date.getTime();
                    }
                    long l3 = Calendar.getInstance().getTimeInMillis();
                    long l4 = (l3 - l2) / 1000L;
                    if (l4 > l) continue;
                }
                ++n;
                String string4 = "Manual Collection";
                if (!collection.isManual()) {
                    string4 = "Auto Collection";
                }
                String string5 = collection.getCollectionId() + "!" + string4 + "!" + collection.getRequestUser() + "!" + collection.getNodeList() + "!" + collection.getMasterHost() + "!" + collection.getStartTime() + "!" + collection.getEndTime() + "!" + collection.getTag() + "!" + collection.getZipFileName() + "!" + collection.getComponentList() + "!" + collection.getZipFileSize() + "!" + collection.getCollectionTime();
                if (collection.getEvents() != null && collection.getEvents().size() > 0) {
                    string5 = string5 + "!" + collection.getEvents();
                }
                printWriter.println(string5);
            }
        }
        if (n == 0) {
            string2 = "NO COLLECTIONS TO PRINT";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printCollections() {
        try (EntityCursor entityCursor = null;){
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(Collection.class);
            entityCursor = primaryIndex.entities();
            for (Collection collection : entityCursor) {
                LogFile.writeLog("######################################");
                LogFile.writeLog("CollectionId: " + collection.getCollectionId());
                LogFile.writeLog("TFAVersion: " + collection.getTFAVersion());
                LogFile.writeLog("TFABuildId: " + collection.getTFABuildId());
                LogFile.writeLog("Manual Collection: " + collection.isManual());
                LogFile.writeLog("RequestUser: " + collection.getRequestUser());
                LogFile.writeLog("MasterHost: " + collection.getMasterHost());
                LogFile.writeLog("NodeList: " + collection.getNodeList());
                LogFile.writeLog("Collection Name: " + collection.getTag());
                LogFile.writeLog("Temp Dir: " + collection.getTempFile());
                LogFile.writeLog("ZipFileName: " + collection.getZipFileName());
                LogFile.writeLog("DiagcollectLog: " + collection.getDiagcollectLog());
                LogFile.writeLog("ComponentList: " + collection.getComponentList());
                LogFile.writeLog("StartTime: " + collection.getStartTime());
                LogFile.writeLog("EndTime: " + collection.getEndTime());
                LogFile.writeLog("FilesInRange: " + collection.getFilesInRange());
                LogFile.writeLog("SizeOfFilesInRange: " + collection.getSizeOfFilesInRange());
                LogFile.writeLog("SizeOfExtraFiles: " + collection.getSizeOfExtraFiles());
                LogFile.writeLog("SizeOfFilesBeforeZip: " + collection.getSizeOfFilesBeforeZip());
                LogFile.writeLog("ZipFileSize: " + collection.getZipFileSize());
                LogFile.writeLog("NumTrimmedFiles: " + collection.getNumTrimmedFiles());
                LogFile.writeLog("TrimSavings: " + collection.getTrimSavings());
                LogFile.writeLog("CollectionTime: " + collection.getCollectionTime());
                LogFile.writeLog("Collection Score: " + collection.getScore());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stopCollection(String string, PrintWriter printWriter, boolean bl) {
        String string2 = "FAILED";
        Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
        Omsg omsg = new Omsg("en-US", "en", "UTF-8", "US");
        try {
            String string3;
            Object object;
            Thread[] threadArray;
            ThreadGroup threadGroup = ThreadUtilities.getThreadGroup(string);
            if (threadGroup != null) {
                Output.printTrace("ThreadGroup:" + threadGroup.getName(), 3);
                int n = threadGroup.activeCount();
                Output.printTrace("ThreadGroup activeCount" + n, 3);
                threadArray = new Thread[n];
                threadGroup.enumerate(threadArray);
                for (Thread object2 : threadArray) {
                    Output.printTrace("Active:" + object2.getName(), 3);
                    if (object2.getName().startsWith("Inventory")) continue;
                    object2.interrupt();
                }
                string2 = "SUCCESS";
            } else {
                omsg.write(printWriter, "TFA10362", string);
            }
            CollectionDA collectionDA = new CollectionDA();
            threadArray = (Thread[])collectionDA.pIdx.get((Object)string);
            Thread[] threadArray2 = null;
            String string4 = null;
            if (threadArray != null) {
                Set<String> set;
                threadArray2 = threadArray.getTag();
                string4 = threadArray.getTempFile();
                if (bl && (set = threadArray.getNodeList()) != null) {
                    CursorConfig cursorConfig = new CursorConfig();
                    cursorConfig.setReadUncommitted(true);
                    Properties.getInstance();
                    object = Properties.trustStore;
                    Properties.getInstance();
                    string3 = Properties.trustStorePassword;
                    SSLSocket sSLSocket = null;
                    PrintWriter printWriter2 = null;
                    String string5 = null;
                    String string6 = new Host().getHostname().trim();
                    Object var19_29 = null;
                    for (String string7 : set) {
                        if (string7.equals(string6)) continue;
                        try {
                            Output.printTrace("Making Socket connection to :" + string7, 3);
                            sSLSocket = SocketManager.getSecureSocketConnection(string7.trim(), Global.getSocketPort(), (String)object, string3);
                            if (sSLSocket == null) {
                                Output.printTrace("CollectionManger: Unable to connect to " + string7 + " to stop collection: " + string, 1);
                                omsg.write(printWriter, "TFA10742", string7, string);
                                continue;
                            }
                            string5 = string6 + ":stopcollection:" + string;
                            Output.printTrace("Remote Request: " + string5, 3);
                            printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                            omsg.write(printWriter, "TFA10740", string7, string);
                            printWriter2.println(string5);
                            if (sSLSocket.isClosed()) continue;
                            sSLSocket.close();
                        }
                        catch (UnknownHostException unknownHostException) {
                            Output.printTrace("UnknownHostException in sending diagcollect to remote host " + string7, 1);
                            omsg.write(printWriter, "TFA10742", string7, string);
                        }
                        catch (IOException iOException) {
                            Output.printTrace("IOException in sending diagcollect to remote host  " + string7, 1);
                            omsg.write(printWriter, "TFA10742", string7, string);
                        }
                        finally {
                            try {
                                if (var19_29 == null) continue;
                                var19_29.close();
                            }
                            catch (DatabaseException databaseException) {
                                Output.printTrace("Exception encountered in closing cursor", 1);
                            }
                        }
                    }
                }
            }
            Thread.sleep(10000L);
            try {
                if (threadArray2 != null && new File((String)threadArray2).exists()) {
                    FileUtils.deleteDirectory((File)new File((String)threadArray2));
                }
                if (string4 != null && new File(string4).exists()) {
                    FileUtils.deleteDirectory((File)new File(string4));
                }
            }
            catch (Exception exception) {
                omsg.write(printWriter, "TFA10352", string);
                Output.printTrace("Could not delete the collection directory for CollectionId: " + string, 1);
            }
            for (String string8 : Collection.remoteCollectionMessages) {
                if (string8 == null || !string.equals(string3 = (object = string8.split(":"))[0].trim())) continue;
                Collection.remoteCollectionMessages.remove(string8);
            }
        }
        catch (Exception exception) {
            Output.printTrace("CollectionManager: Exception in stop Collection for collectionId: " + string + " : " + exception.getMessage(), 1);
        }
        return string2;
    }

    public static boolean isCollectionRunning(String string) {
        ThreadGroup threadGroup = ThreadUtilities.getThreadGroup(string);
        if (threadGroup != null) {
            Output.printTrace("ThreadGroup:" + threadGroup.getName(), 3);
            int n = threadGroup.activeCount();
            Output.printTrace("ThreadGroup activeCount" + n, 3);
            if (n > 0) {
                return true;
            }
        }
        return false;
    }

    public static Collection getCollection(String string) {
        CollectionDA collectionDA = new CollectionDA();
        Collection collection = (Collection)collectionDA.pIdx.get((Object)string);
        return collection;
    }
}

