/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.entity.TFAReceiver;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;

public class BroadcastMessage {
    private String message;
    private String cluster;
    private boolean ack;

    public BroadcastMessage() {
    }

    public BroadcastMessage(String string) {
        this(string, "collector", false);
    }

    public BroadcastMessage(String string, String string2) {
        this(string, string2, false);
    }

    public BroadcastMessage(String string, boolean bl) {
        this(string, "collector", bl);
    }

    public BroadcastMessage(String string, String string2, boolean bl) {
        this.message = string;
        this.cluster = string2;
        this.ack = bl;
    }

    public void broadcast() {
        if (this.cluster.equalsIgnoreCase("receiver")) {
            this.broadcastInR();
        } else {
            this.broadcastInC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastInC() {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        Object var4_4 = null;
        String string = null;
        String string2 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            for (TFAHost tFAHost : entityCursor) {
                string = tFAHost.getHostname().trim();
                Output.printTrace("BroadcastMessage.broadcastInC: NodeName=" + string, 3);
                if (string.equalsIgnoreCase(string2)) continue;
                Output.printTrace("BroadcastMessage.broadcastInC: Make socket con to: " + string, 3);
                Properties.getInstance();
                String string3 = Properties.trustStore;
                Properties.getInstance();
                String string4 = Properties.trustStorePassword;
                sSLSocket = SocketManager.getSecureSocketConnection(string, Global.getSocketPort(), string3, string4);
                if (null == sSLSocket) continue;
                printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter.println(this.message);
                bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string, 1);
            iOException.printStackTrace();
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastInR() {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = null;
        String string3 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            for (TFAReceiver tFAReceiver : entityCursor) {
                string2 = tFAReceiver.getAttr("receivername").trim();
                Output.printTrace("BroadcastMessage.broadcastInC: NodeName=" + string2, 3);
                if (string2.equalsIgnoreCase(string3)) continue;
                Output.printTrace("BroadcastMessage.broadcastInC: Make socket con to: " + string2, 3);
                Properties.getInstance();
                String string4 = Properties.trustStore;
                Properties.getInstance();
                String string5 = Properties.trustStorePassword;
                sSLSocket = SocketManager.getSecureSocketConnection(string2, Global.getSocketPort(), string4, string5);
                if (null == sSLSocket) continue;
                printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter.println(this.message);
                bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string = bufferedReader.readLine()) != null) {
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string2, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string2, 1);
            iOException.printStackTrace();
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }
}

