/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.persist.EntityStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.BroadcastMessage;
import oracle.rat.tfa.TFAHostManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.TFAHostDA;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;
import oracle.rat.tfa.util.Utilities;
import oracle.rat.tfa.xml.GPNPProfileXMLReader;

public class AddNodesThread
extends Thread {
    private boolean stopThread = false;
    private Set<String> clusterNodes = new HashSet<String>();

    @Override
    public void run() {
        Object object;
        Output.printTrace("Started Add Nodes Thread...", 3);
        boolean bl = false;
        if (Properties.getInstance().getNodeType().equals("ODA")) {
            Properties.getInstance();
            if (!Properties.getInstallType().equals("GI")) {
                bl = true;
            }
        }
        if (bl) {
            Output.printTrace("Installing on ODA, so stopping AddNodesThread...", 3);
            this.stopThread = true;
            return;
        }
        String string = new Host().getHostname().trim();
        List<String> list = TFAHost.getHostsInTFA();
        if (list.size() > 1) {
            TFAHostManager.syncHostsOnTFAStart();
            TFAHostManager.setMasterNode(false);
            object = string + ":setmaster:" + Global.master_node;
            new BroadcastMessage((String)object).broadcast();
        } else if (list.size() == 1) {
            Global.master_node = string;
            object = string + ":setmaster:" + Global.master_node;
            new BroadcastMessage((String)object).broadcast();
        }
        while (!this.stopThread) {
            try {
                if (Properties.crsHome != null) {
                    String string2;
                    this.setClusterNodes();
                    object = TFAHost.getHostsInTFA();
                    Output.printTrace("hosts already added to TFA : " + object, 3);
                    for (String string3 : this.clusterNodes) {
                        if (object.contains(string3 = string3.trim().toLowerCase())) continue;
                        Output.printTrace("Host " + string3 + " is not present in TFA. Trying to add host to TFA", 3);
                        if (this.isHostPartOfCRSCluster(string3)) {
                            Output.printTrace("Node " + string3 + " is part of CRS cluster", 3);
                            if (this.isRemovedNode(string3)) continue;
                            Output.printTrace("Add Node " + string3, 3);
                            TFAHostManager.addHost(string3, "blah", "blah", "/blah");
                            continue;
                        }
                        if (this.isHostInOLSNodes(string3)) {
                            string2 = SocketManager.getTFAPort(string3);
                            if (string2 == null) {
                                Output.printTrace("Could not determine the port on which TFA is listening in " + string3, 3);
                                continue;
                            }
                            Output.printTrace("Node " + string3 + " is part of OLS nodes", 3);
                            if (this.isRemovedNode(string3)) continue;
                            Output.printTrace("Add Node " + string3, 3);
                            TFAHostManager.addHost(string3, "blah", "blah", "/blah");
                            continue;
                        }
                        Output.printTrace("Could not add host " + string3 + " as its not part of CRS cluster or OLS nodes", 3);
                    }
                    if (this.clusterNodes.size() > 0 && object.size() > 1 && this.clusterNodes.size() != object.size()) {
                        Iterator<String> iterator = object.iterator();
                        while (iterator.hasNext()) {
                            String string3;
                            string3 = iterator.next();
                            if (this.clusterNodes.contains(string3) || string3.equalsIgnoreCase(string) || this.getOLSNodeList("-f").contains(string3)) continue;
                            TFAHostManager.updateRemovedNode(string3);
                            string2 = DbManager.getInstance().getEntityStore();
                            TFAHostDA tFAHostDA = new TFAHostDA((EntityStore)string2);
                            Output.printTrace("Removing Host: " + string3, 1);
                            boolean bl2 = tFAHostDA.pIdx.delete((Object)string3);
                            if (!bl2) continue;
                            Output.printTrace("Host: " + string3 + " deleted", 1);
                            TFAHostManager.removeFromOtherNodes(string3);
                        }
                    }
                } else {
                    Output.printTrace("AddNodesThread : CRS Home is not set. Will sleep for 5 minutes and restart", 3);
                }
                Output.printTrace("AddNodes thread sleep begin", 3);
                Thread.sleep(300000L);
                Output.printTrace("AddNodes thread sleep end", 3);
            }
            catch (InterruptedException interruptedException) {
                Output.printTrace("Caught interrupt signal in AddNodes thread...", 3);
                this.stopThread = true;
            }
        }
    }

    public void setClusterNodes() {
        List<Object> list = new ArrayList();
        boolean bl = false;
        if (Utilities.isCRSRunning()) {
            list = this.getOLSNodeList();
            Output.printTrace("OLS Node List : " + list, 3);
            if (list.size() > 0) {
                bl = true;
            }
            for (String string : list) {
                if (!string.toLowerCase().contains("failure") && !string.toLowerCase().contains("unable to communicate")) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.clusterNodes = new HashSet<Object>(list);
            }
        }
        if (!bl) {
            List<String> list2 = this.getCRSNodeList();
            Output.printTrace("CRS Node List : " + list2, 3);
            this.clusterNodes = new HashSet<String>(list2);
        }
    }

    public Set<String> getClusterNodes() {
        if (this.clusterNodes.size() == 0) {
            this.setClusterNodes();
        }
        return this.clusterNodes;
    }

    private boolean isHostPartOfCRSCluster(String string) {
        String string2 = SocketManager.getTFAPort(string);
        if (string2 == null) {
            Output.printTrace("Could not determine the port on which TFA is listening in " + string, 3);
            return false;
        }
        Output.printTrace("Port on which TFA is listening in node " + string + " : " + string2, 3);
        Map<String, Integer> map = Global.getPortMapping();
        map.put(string, (int)new Integer(string2));
        Output.printTrace("AddNodes : Updating portMapping for node " + string + " with port " + string2, 3);
        Properties.getInstance();
        Properties.writePortMappingToFile(map);
        Output.printTrace("AddNodes : After determining remotePort, portMapping in Global : " + Global.getPortMapping(), 3);
        String string3 = new Host().getHostname().trim();
        String string4 = this.getHashKey(string3);
        String string5 = this.getHashKey(string);
        if (string5 != null && string4 != null && string5.equals(string4)) {
            return true;
        }
        Global.getPortMapping().remove(string);
        Properties.getInstance();
        Properties.writePortMappingToFile(map);
        return false;
    }

    private boolean isHostInOLSNodes(String string) {
        boolean bl = false;
        List<Object> list = new ArrayList();
        if (Utilities.isCRSRunning()) {
            list = this.getOLSNodeList();
        }
        if (list.contains(string)) {
            bl = true;
        }
        Output.printTrace("Is " + string + " part of OLSNodes : " + bl, 3);
        return bl;
    }

    private boolean isRemovedNode(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (new File(Properties.removedHostsFile).exists()) {
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(Properties.removedHostsFile));
                while ((string2 = bufferedReader.readLine()) != null) {
                    arrayList.add(string2);
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Output.print("AddNodes : FileNotFoundException encountered in isRemovedNode");
            }
            catch (IOException iOException) {
                Output.print("AddNodes : IOException encountered in isRemovedNode");
            }
            if (arrayList.contains(string)) {
                Output.printTrace(string + " has been removed from TFA, cannot be added by AddNodesThread", 3);
                return true;
            }
        }
        return false;
    }

    private String getHashKey(String string) {
        Output.printTrace("Getting hashKey for " + string, 3);
        String string2 = null;
        String string3 = new Host().getHostname().trim();
        if (string.equals(string3)) {
            string2 = GPNPProfileXMLReader.getInstance().getHashKey();
        } else {
            try {
                String string4 = string3 + ":gethashkey:";
                Properties.getInstance();
                String string5 = Properties.trustStore;
                Properties.getInstance();
                String string6 = Properties.trustStorePassword;
                SSLSocket sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string5, string6);
                if (sSLSocket == null) {
                    Output.printTrace("Could not connect to socket on " + string, 1);
                    return string2;
                }
                PrintWriter printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter.println(string4);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                String string7 = null;
                while ((string7 = bufferedReader.readLine()) != null && !string7.equals("DONE")) {
                    string2 = string7;
                }
                bufferedReader.close();
                if (!sSLSocket.isClosed()) {
                    sSLSocket.close();
                }
            }
            catch (Exception exception) {
                Output.print("AddNodesThread : Exception in getting hash key for " + string);
            }
        }
        return string2;
    }

    private List<String> getOLSNodeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(Properties.crsHome + File.separator + "bin" + File.separator + "olsnodes");
        if (file.exists()) {
            String string = Properties.crsHome + File.separator + "bin" + File.separator + "olsnodes";
            try {
                String string2;
                Process process = Runtime.getRuntime().exec(string);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    Output.printTrace("OLSNode : " + string2, 3);
                    arrayList.add(string2.trim());
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                Output.print("AddNodesThread : Exception in getting OLS node list");
            }
        }
        return arrayList;
    }

    private List<String> getOLSNodeList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(Properties.crsHome + File.separator + "bin" + File.separator + "olsnodes");
        if (file.exists()) {
            String string2 = Properties.crsHome + File.separator + "bin" + File.separator + "olsnodes " + string;
            try {
                String string3;
                Process process = Runtime.getRuntime().exec(string2);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    Output.printTrace("OLS Node : " + string3, 3);
                    arrayList.add(string3.trim());
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                Output.print("AddNodesThread : Exception in getting OLS Node list with arguments");
            }
        }
        return arrayList;
    }

    private List<String> getCRSNodeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(Properties.crsHome + File.separator + "crs" + File.separator + "install" + File.separator + "crsconfig_params");
        Output.printTrace("Getting CRS nodelist from " + file.getAbsolutePath(), 3);
        if (file.exists()) {
            String string = null;
            String string2 = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getAbsolutePath()));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("NODELIST=")) {
                        string = string.substring(9);
                        Output.printTrace("Node List : " + string, 3);
                        string2 = string;
                        break;
                    }
                    if (!string.startsWith("NODE_NAME_LIST=")) continue;
                    string = string.substring(15);
                    Output.printTrace("Node List : " + string, 3);
                    string2 = string;
                    break;
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Output.print("AddNodesThread : FileNotFoundException for " + file.getAbsolutePath());
            }
            catch (IOException iOException) {
                Output.print("AddNodesThread : IOException in getting CRS node list");
            }
            if (string2 != null) {
                String[] stringArray;
                for (String string3 : stringArray = string2.split(",")) {
                    arrayList.add(string3.toLowerCase());
                }
            }
        }
        return arrayList;
    }

    private Set<String> combine(List<String> list, List<String> list2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : list) {
            hashSet.add(string.trim());
        }
        for (String string : list2) {
            hashSet.add(string.trim());
        }
        return hashSet;
    }
}

