/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import oracle.rat.tfa.DiagCollection;
import oracle.rat.tfa.DoZipTransfer;
import oracle.rat.tfa.RepositoryManager;
import oracle.rat.tfa.TFAInventoryManager;
import oracle.rat.tfa.TFAScanningMainOD;
import oracle.rat.tfa.TFAScanningMainRT;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.entitykey.ActionKey;
import oracle.rat.tfa.receiver.ProcessCollection;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;

public class ActionHandler
implements Runnable {
    private Integer numthreads = 10;
    private Thread[] ActionThreads = new Thread[this.numthreads.intValue()];

    private Thread[] expandThreads(Thread[] threadArray, int n) {
        Thread[] threadArray2 = new Thread[n];
        System.arraycopy(threadArray, 0, threadArray2, 0, threadArray.length);
        return threadArray2;
    }

    @Override
    public void run() {
        boolean bl = true;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(ActionKey.class, Action.class);
        Output.printTrace("Action Handler Thread Started", 3);
        while (bl) {
            Transaction transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (Action action : entityCursor) {
                    Object object;
                    if (!action.getActionStatus().equalsIgnoreCase("REQUESTED")) continue;
                    Output.printTrace("We have an Action to Process", 3);
                    Output.printTrace("Action is : " + action.getActionName(), 3);
                    if (action.getActionName().trim().equalsIgnoreCase("runinventory")) {
                        Output.printTrace("Action to Process : runinventory", 3);
                        int n = this.getThreadSlot();
                        Output.printTrace("Return from getThread for new Inventory Run " + n, 3);
                        if (n == -1) continue;
                        try {
                            action.setActionStatus("RUNNING");
                            action.store();
                            Output.printTrace("ActionClient : " + action.getActionRequestClient(), 3);
                            Output.printTrace("ActionArgs :" + action.getActionRequestArgs(), 3);
                            TFAInventoryManager tFAInventoryManager = new TFAInventoryManager(action);
                            object = new Thread((Runnable)tFAInventoryManager, "InventoryThread");
                            if (action.getActionRequestArgs() == null || action.getActionRequestArgs().trim().equals("-c")) {
                                Global.inventoryManagerThread = tFAInventoryManager;
                                Global.inventoryThread = object;
                                Output.printTrace("Setting InventoryThread in Global", 3);
                            }
                            ((Thread)object).start();
                            this.ActionThreads[n] = object;
                            Output.printTrace("Started Thread for new Inventory Run", 3);
                            if (!Global.offlineMode.booleanValue()) continue;
                            ((Thread)object).join();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            action.setActionFailed("Exception occurred");
                            action.store();
                        }
                        continue;
                    }
                    if (action.getActionName().equalsIgnoreCase("startrtscan")) {
                        Output.printTrace("Starting/Restarting the Real Time Scanner", 3);
                        action.setActionStatus("RUNNING");
                        action.store();
                        TFAScanningMainRT tFAScanningMainRT = Global.getRtScanThread();
                        if (Global.rtScanRunning.booleanValue()) {
                            Output.printTrace("Waiting for scanThread to stop by.... " + action.getActionRequestClient(), 3);
                            tFAScanningMainRT.stopRTScanner();
                            Integer n = 1;
                            while (tFAScanningMainRT.isAlive() && n < 31) {
                                Output.printTrace("Waiting for RT Scan Thread to Quit " + n + "times", 3);
                                Thread.sleep(2000L);
                                object = n;
                                Integer n2 = n = Integer.valueOf(n + 1);
                            }
                        }
                        if (tFAScanningMainRT.isAlive()) {
                            action.setActionFailed("Unable to Stop RT Thread in a timely fashion");
                            Output.printTrace("Failed to Start/Restart Thread for RT Scanner - Cannot stop Thread", 2);
                        } else {
                            tFAScanningMainRT = new TFAScanningMainRT();
                            tFAScanningMainRT.start();
                            Global.setRtScanThread(tFAScanningMainRT);
                            Global.setRtScanRunning(true);
                            Output.printTrace("Started/Restarted Thread for RT Scanner", 3);
                            Output.printTrace("Started/Restarted RT Scanner for .... " + action.getActionRequestClient(), 3);
                            action.setActionComplete();
                        }
                        action.store();
                        continue;
                    }
                    if (action.getActionName().equalsIgnoreCase("stoprtscan")) {
                        Output.printTrace("Stopping the Real Time Scanner", 3);
                        action.setActionStatus("RUNNING");
                        action.store();
                        TFAScanningMainRT tFAScanningMainRT = Global.getRtScanThread();
                        if (Global.rtScanRunning.booleanValue()) {
                            Output.printTrace("Waiting for scanThread to stop....", 3);
                            tFAScanningMainRT.stopRTScanner();
                            Integer n = 1;
                            while (tFAScanningMainRT.isAlive() && n < 31) {
                                Output.printTrace("Waiting for RT Scan Thread to Quit " + n + "times", 3);
                                Thread.sleep(2000L);
                                object = n;
                                Integer n3 = n = Integer.valueOf(n + 1);
                            }
                        }
                        if (tFAScanningMainRT.isAlive()) {
                            action.setActionFailed("Unable to Stop RT Thread in a timely fashion");
                            Output.printTrace("Failed to Stop Thread for RT Scanner - Cannot stop Thread", 2);
                        } else {
                            Global.setRtScanRunning(false);
                            Output.printTrace("Stopped Thread for RT Scanner", 3);
                            Output.printTrace("Stopped RT Scanner for ... " + action.getActionRequestClient(), 3);
                            action.setActionComplete();
                        }
                        action.store();
                        continue;
                    }
                    if (action.getActionName().equalsIgnoreCase("donebuildingremotezip")) {
                        Output.printTrace("Will collect remote zip now...", 3);
                        action.setActionStatus("RUNNING");
                        action.store();
                        Thread thread = new Thread((Runnable)new DoZipTransfer(action), "ZipTransferThread");
                        thread.start();
                        Output.printTrace("Started Thread for new Zip Transfer Run", 3);
                        continue;
                    }
                    if (action.getActionName().equalsIgnoreCase("changerepositorysize") || action.getActionName().equalsIgnoreCase("changerepositorydir")) {
                        String string = action.getActionRequestArgs();
                        Output.printTrace("Arguments for change repository : " + string, 3);
                        action.setActionStatus("RUNNING");
                        action.store();
                        String[] stringArray = string.split(" ");
                        object = stringArray[0];
                        if (stringArray[0].equalsIgnoreCase("CURRENT")) {
                            object = RepositoryManager.getInstance().getDirectory();
                        }
                        long l = new Long(stringArray[1]);
                        RepositoryManager.getInstance().changeRepository((String)object, l);
                        action.setActionComplete();
                        action.store();
                        continue;
                    }
                    if (action.getActionName().equalsIgnoreCase("startdiagcollection")) {
                        Output.printTrace("Action to Process : startdiagcollection", 3);
                        String string = action.getActionRequestArgs();
                        int n = this.getThreadSlot();
                        Output.printTrace("Return from getThread for new DiagCollection run " + n, 3);
                        if (n == -1) continue;
                        try {
                            String[] stringArray;
                            action.setActionStatus("RUNNING");
                            action.store();
                            object = "dummy";
                            if (string != null && (stringArray = string.split(":")).length > 1) {
                                object = stringArray[stringArray.length - 1].trim();
                                Output.printTrace("DiagCollectionThread Id: " + (String)object, 3);
                            }
                            ThreadGroup threadGroup = new ThreadGroup((String)object);
                            Thread thread = new Thread(threadGroup, new DiagCollection(action), "Collection_" + (String)object);
                            thread.start();
                            this.ActionThreads[n] = thread;
                            Output.printTrace("Started Thread for new DiagCollection Run", 3);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            action.setActionFailed("Exception occurred");
                            action.store();
                        }
                        continue;
                    }
                    if (action.getActionName().equalsIgnoreCase("runodscan")) {
                        if (!Global.isOdScanOn()) {
                            action.setActionFailed("On Demand scan is disabled");
                            action.store();
                            continue;
                        }
                        if (Global.isRtScanRunning().booleanValue()) {
                            action.setActionFailed("Real Time scan is running");
                            action.store();
                            continue;
                        }
                        Output.printTrace("Action to Process : OD Scan", 3);
                        int n = this.getThreadSlot();
                        Output.printTrace("Return from getThread for new Run OD Scan " + n, 3);
                        if (n == -1) continue;
                        try {
                            action.setActionStatus("RUNNING");
                            action.store();
                            Thread thread = new Thread((Runnable)new TFAScanningMainOD(action), "ODscannerThr");
                            thread.start();
                            this.ActionThreads[n] = thread;
                            Output.printTrace("Started Thread for OD Scanner", 3);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            action.setActionFailed("Exception occurred");
                            action.store();
                        }
                        continue;
                    }
                    if (action.getActionName().equalsIgnoreCase("processcollection")) {
                        Output.printTrace("Unzip the collection and process it ...", 3);
                        action.setActionStatus("RUNNING");
                        action.store();
                        Thread thread = new Thread((Runnable)new ProcessCollection(action), "ProcessCollectionThread");
                        thread.start();
                        Output.printTrace("Started thread for processing collection", 3);
                        continue;
                    }
                    if (action.getActionName().equalsIgnoreCase("updatereceivers") || action.getActionName().equalsIgnoreCase("stopproducer") || action.getActionName().equalsIgnoreCase("startmonitor") || action.getActionName().startsWith("tfar_") || action.getActionName().equalsIgnoreCase("removecollector")) continue;
                    Output.printTrace("No matching Action name", 2);
                    action.setActionFailed("Unknown action");
                    action.store();
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
                Thread.sleep(2000L);
                if (Thread.interrupted()) {
                    Output.printTrace("This Thread was Interrupted", 2);
                    bl = false;
                    this.interruptAllThreads();
                }
            }
            catch (InterruptedException interruptedException) {
                Output.printTrace("This Thread was Interrupted due to InterruptedException", 2);
                bl = false;
                this.interruptAllThreads();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!Global.offlineMode.booleanValue()) continue;
            bl = false;
            Output.printTrace("Offline mode should only run one action.", 3);
        }
    }

    private int getThreadSlot() {
        boolean bl = false;
        int n = -1;
        while (!bl) {
            for (n = 0; n < this.ActionThreads.length; ++n) {
                if (this.ActionThreads[n] != null && this.ActionThreads[n].getState() != Thread.State.TERMINATED) continue;
                Output.printTrace("Got a thread", 3);
                bl = true;
                break;
            }
            if (bl) continue;
            Output.printTrace("Did not get a thread on this loop", 2);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        Output.printTrace("Returning Thread .. Number is : " + n, 3);
        return n;
    }

    private void interruptAllThreads() {
        Output.printTrace("Inside interruptAllThreads, ActionThreads count = " + this.ActionThreads.length, 3);
        for (int i = 0; i < this.ActionThreads.length; ++i) {
            Thread thread = this.ActionThreads[i];
            Output.printTrace("Inside interruptAllThreads ... " + thread, 3);
            if (thread == null) continue;
            Output.printTrace("Interrupting thread " + thread.getName(), 3);
            thread.interrupt();
        }
    }
}

