/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.ByteArrayKey;
import oracle.jdbc.driver.ClientDataSupport;
import oracle.jdbc.driver.LRUStmtCache;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleDatabaseMetaData;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobDBAccessImpl;

public class OracleConnection
implements oracle.jdbc.internal.OracleConnection,
ClientDataSupport {
    public static final boolean DEBUG = false;
    private static String dll_string = "dll";
    private String url;
    private String user;
    private String password;
    protected String database;
    private boolean auto_commit;
    private String protocol;
    public DBAccess db_access;
    public DBConversion conversion;
    public LobDBAccessImpl lob_dbaccess;
    public boolean XA_wants_error;
    public boolean UsingXA;
    private byte[] fdo;
    private Boolean big_endian;
    Hashtable statement_table;
    protected boolean closed;
    private boolean m_clientIdSet = false;
    private String m_clientId = null;
    int default_batch;
    int default_row_prefetch;
    boolean report_remarks;
    boolean include_synonyms = false;
    boolean restrict_getTables = false;
    boolean m_accumulateBatchResult = true;
    boolean m_j2ee13Compliant = false;
    int dataSizeScale = 1;
    private int trans_level;
    Map map;
    Map m_javaObjectMap;
    Hashtable descriptorCache;
    OracleStatement statement_holding_line;
    oracle.jdbc.OracleDatabaseMetaData m_dbMetaData = null;
    private boolean physicalStatus;
    private boolean logicalHandle;
    private OraclePooledConnection m_opc = null;
    private OracleConnection m_opc_oc = null;
    static int DEFAULT_ROW_PREFETCH = 10;
    private static OracleSql s_osql = null;
    SQLWarning m_warning = null;
    boolean m_readOnly = false;
    private long m_startTime = 0L;
    private int m_stmtCacheSize = 0;
    private LRUStmtCache m_stmtCache = null;
    boolean m_stmtClearMetaData = false;
    boolean m_defaultAutoRefetch = true;
    private OracleCloseCallback m_occ = null;
    private Object m_privData = null;
    boolean defaultFixedString = false;
    private static boolean m_traceEnabled = false;
    static final int BINARYSTREAM = 0;
    static final int ASCIISTREAM = 1;
    static final int UNICODESTREAM = 2;
    static final int EOJ_NON = 0;
    static final int EOJ_B_TO_A = 1;
    static final int EOJ_B_TO_U = 2;
    static final int EOJ_A_TO_U = 3;
    static final int EOJ_8_TO_A = 4;
    static final int EOJ_8_TO_U = 5;
    static final int EOJ_U_TO_A = 6;
    static final int ASCII_CHARSET = 0;
    static final int NLS_CHARSET = 1;
    public static final int CHAR_TO_ASCII = 0;
    public static final int CHAR_TO_UNICODE = 1;
    public static final int RAW_TO_ASCII = 2;
    public static final int RAW_TO_UNICODE = 3;
    public static final int UNICODE_TO_CHAR = 4;
    public static final int ASCII_TO_CHAR = 5;
    public static final int NONE = 6;
    public static final int JAVACHAR_TO_CHAR = 7;
    public static final int RAW_TO_JAVACHAR = 8;
    public static final int CHAR_TO_JAVACHAR = 9;
    private Hashtable m_clientData;
    private String m_sessionTimeZone = null;
    private Calendar m_dbTzCalendar = null;

    public OracleConnection(DBAccess dBAccess, String string, String string2, String string3, String string4, Properties properties) throws SQLException {
        String string5 = null;
        String string6 = null;
        boolean bl = true;
        if (properties != null) {
            string5 = (String)((Hashtable)properties).get("protocol");
        }
        this.password = string3;
        this.initialize(string, string2, string5, dBAccess, null, null, null, string4);
        this.logicalHandle = false;
        try {
            this.needLine();
            this.conversion = this.db_access.logon(string2, string3, string4, properties);
            this.m_warning = DBError.addSqlWarning(this.m_warning, this.db_access.getWarnings());
            if (properties == null || properties.getProperty("connection_pool") != "connection_pool") {
                this.default_row_prefetch = this.db_access.getDefaultPrefetch();
                if (properties != null && (string6 = properties.getProperty("autoCommit")) != null && string6.equalsIgnoreCase("false")) {
                    bl = false;
                }
                this.setAutoCommit(bl);
                this.db_access.initNls(this);
            }
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        catch (SQLException sQLException) {
            try {
                this.db_access.logoff();
            }
            catch (IOException iOException) {
            }
            catch (SQLException sQLException2) {}
            throw sQLException;
        }
    }

    public OracleConnection(OraclePooledConnection oraclePooledConnection, OracleConnection oracleConnection, boolean bl) throws SQLException {
        this.initialize(oracleConnection.url, oracleConnection.user, oracleConnection.protocol, oracleConnection.db_access, oracleConnection.descriptorCache, oracleConnection.map, oracleConnection.m_javaObjectMap, null);
        this.logicalHandle = true;
        if (oracleConnection.trans_level == 8) {
            this.setTransactionIsolation(2);
        }
        this.m_opc = oraclePooledConnection;
        this.m_opc_oc = oracleConnection;
        this.conversion = oracleConnection.conversion;
        if (oracleConnection.isStmtCacheEnabled() && oracleConnection.m_stmtCacheSize == 0 && oracleConnection.m_stmtCache != null) {
            oracleConnection.m_stmtCache.close();
            oracleConnection.m_stmtCache = null;
        }
        this.setAutoCommit(bl);
        if (this.getProtocolType().equals("oci") || this.getProtocolType().equals("oci8")) {
            try {
                if (this.db_access.getVersion() == null) {
                    throw new SQLException("Connection Closed");
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
    }

    public synchronized Connection _getPC() {
        if (this.logicalHandle) {
            return this.m_opc_oc;
        }
        return null;
    }

    synchronized void add_statement(Statement statement) {
        this.statement_table.put(statement, statement);
    }

    public synchronized void archive(int n, int n2, String string) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        this.db_access.archive(n, n2, string);
    }

    public void assertComplete() throws SQLException {
    }

    synchronized void cacheStatement(OracleStatement oracleStatement) throws SQLException {
        if (this.m_stmtCache != null) {
            this.m_stmtCache.add(oracleStatement);
        }
    }

    public void cancel() throws SQLException {
        Enumeration enumeration = this.statement_table.elements();
        while (enumeration != null && enumeration.hasMoreElements()) {
            OracleStatement oracleStatement = (OracleStatement)enumeration.nextElement();
            if (oracleStatement == null) continue;
            try {
                oracleStatement.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void checkPhyiscalStatus() throws SQLException {
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
    }

    private void cleanup() {
        this.fdo = null;
        this.db_access = null;
        this.conversion = null;
        this.statement_table = null;
        this.descriptorCache = null;
        this.map = null;
        this.m_javaObjectMap = null;
        this.statement_holding_line = null;
        this.m_opc = null;
        s_osql = null;
    }

    public void clearClientIdentifier(String string) throws SQLException {
        if (this.m_clientIdSet) {
            this.db_access.clearClientIdentifier(this, string);
        }
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
    }

    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.m_occ != null) {
            this.m_occ.beforeClose(this, this.m_privData);
        }
        this.close_statements();
        this.closed = true;
        if (this.logicalHandle) {
            this.logicalClose();
            if (this.m_occ != null) {
                this.m_occ.afterClose(this.m_privData);
            }
            return;
        }
        try {
            this.XA_wants_error = false;
            this.needLine();
            this.db_access.logoff();
            this.cleanup();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        if (this.m_occ != null) {
            this.m_occ.afterClose(this.m_privData);
        }
    }

    public synchronized void close_statements() throws SQLException {
        if (this.m_stmtCacheSize > 0 && !this.logicalHandle) {
            this.m_stmtCacheSize = 0;
            this.m_stmtClearMetaData = true;
            this.m_stmtCache.close();
            this.m_stmtCache = null;
        } else {
            OracleStatement oracleStatement;
            Enumeration enumeration = this.statement_table.elements();
            while (enumeration.hasMoreElements()) {
                oracleStatement = (OracleStatement)enumeration.nextElement();
                if (oracleStatement == null || !oracleStatement.serverCursor) continue;
                oracleStatement.close();
                this.remove_statement(oracleStatement);
                oracleStatement = null;
            }
            enumeration = this.statement_table.elements();
            while (enumeration.hasMoreElements()) {
                oracleStatement = (OracleStatement)enumeration.nextElement();
                if (oracleStatement == null) continue;
                oracleStatement.close();
                oracleStatement = null;
            }
        }
    }

    public synchronized void commit() throws SQLException {
        this.checkPhyiscalStatus();
        if (this.XA_wants_error || this.UsingXA) {
            DBError.throwSqlException(69);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        Enumeration enumeration = this.statement_table.elements();
        while (enumeration.hasMoreElements()) {
            OracleStatement oracleStatement = (OracleStatement)enumeration.nextElement();
            oracleStatement.sendBatch();
        }
        try {
            this.needLine();
            this.db_access.commit();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
    }

    public synchronized BfileDBAccess createBfileDBAccess() throws SQLException {
        if (this.lob_dbaccess == null) {
            this.lob_dbaccess = new LobDBAccessImpl(this);
        }
        return this.lob_dbaccess;
    }

    public synchronized BlobDBAccess createBlobDBAccess() throws SQLException {
        if (this.lob_dbaccess == null) {
            this.lob_dbaccess = new LobDBAccessImpl(this);
        }
        return this.lob_dbaccess;
    }

    public synchronized ClobDBAccess createClobDBAccess() throws SQLException {
        if (this.lob_dbaccess == null) {
            this.lob_dbaccess = new LobDBAccessImpl(this);
        }
        return this.lob_dbaccess;
    }

    public synchronized Statement createStatement() throws SQLException {
        return this.privateCreateStatement(-1, -1, null);
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        return this.privateCreateStatement(n, n2, null);
    }

    public synchronized Statement createStatementWithKey(String string) throws SQLException {
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        if (string != null && this.m_stmtCacheSize <= 0) {
            DBError.throwSqlException(95);
        }
        if (string == null) {
            return null;
        }
        return this.privateCreateStatement(-1, -1, string);
    }

    public boolean getAutoClose() throws SQLException {
        return true;
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        return this.auto_commit;
    }

    public synchronized boolean getBigEndian() throws SQLException {
        if (this.big_endian == null) {
            int[] nArray = Util.toJavaUnsignedBytes(this.getFDO(true));
            int n = nArray[6 + nArray[5] + nArray[6] + 5];
            int n2 = n & 0x10;
            if (n2 < 0) {
                n2 += 256;
            }
            this.big_endian = n2 > 0 ? new Boolean(true) : new Boolean(false);
        }
        return this.big_endian;
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public synchronized Object getClientData(Object object) {
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.get(object);
    }

    public boolean getCreateStatementAsRefCursor() {
        return this.db_access.getCreateStatementAsRefCursor();
    }

    public Properties getDBAccessProperties() throws SQLException {
        if (this.db_access == null) {
            return null;
        }
        return this.db_access.getDBAccessProperties();
    }

    public String getDatabaseProductVersion() throws SQLException {
        int[] nArray = new int[1];
        try {
            this.needLine();
            byte[] byArray = this.db_access.getVersion();
            return this.conversion.CharBytesToString(byArray, byArray.length);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public short getDbCsId() throws SQLException {
        if (this.conversion == null) {
            DBError.throwSqlException(65);
        }
        return this.conversion.getDbCharSet();
    }

    public Calendar getDbTzCalendar() {
        return this.m_dbTzCalendar;
    }

    public boolean getDefaultAutoRefetch() throws SQLException {
        return this.m_defaultAutoRefetch;
    }

    public synchronized int getDefaultExecuteBatch() {
        return this.default_batch;
    }

    public boolean getDefaultFixedString() {
        return this.defaultFixedString;
    }

    public synchronized int getDefaultRowPrefetch() {
        return this.default_row_prefetch;
    }

    public synchronized Object getDescriptor(String string) {
        Object var2_2 = null;
        if (string != null && this.descriptorCache != null) {
            var2_2 = this.descriptorCache.get(string);
        }
        return var2_2;
    }

    public synchronized Object getDescriptor(byte[] byArray) {
        Object var2_2 = null;
        if (byArray != null && this.descriptorCache != null) {
            var2_2 = this.descriptorCache.get(new ByteArrayKey(byArray));
        }
        return var2_2;
    }

    public synchronized byte[] getFDO(boolean bl) throws SQLException {
        if (this.fdo == null && bl) {
            CallableStatement callableStatement = null;
            try {
                this.checkPhyiscalStatus();
                callableStatement = this.prepareCall("begin ? := dbms_pickler.get_format (?); end;");
                callableStatement.registerOutParameter(1, 2);
                callableStatement.registerOutParameter(2, -4);
                callableStatement.execute();
                this.fdo = callableStatement.getBytes(2);
            }
            finally {
                Object var4_3 = null;
                if (callableStatement != null) {
                    callableStatement.close();
                }
                callableStatement = null;
            }
        }
        return this.fdo;
    }

    public boolean getIncludeSynonyms() {
        return this.include_synonyms;
    }

    public boolean getJ2EE13Compliant() {
        return this.m_j2ee13Compliant;
    }

    public synchronized Object getJavaObject(String string) throws SQLException {
        Object var2_2 = null;
        try {
            if (string != null && this.map != null) {
                Class clazz = (Class)this.map.get(string);
                var2_2 = clazz.newInstance();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        return var2_2;
    }

    public synchronized Map getJavaObjectTypeMap() {
        if (this.logicalHandle) {
            return this.m_opc_oc.m_javaObjectMap;
        }
        return this.m_javaObjectMap;
    }

    public short getJdbcCsId() throws SQLException {
        if (this.conversion == null) {
            DBError.throwSqlException(65);
        }
        return this.conversion.getAccessCharSet();
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        if (this.m_dbMetaData == null) {
            this.m_dbMetaData = new OracleDatabaseMetaData(this);
        }
        return this.m_dbMetaData;
    }

    public void getPropertyForPooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        Hashtable<String, Map> hashtable = new Hashtable<String, Map>();
        hashtable.put("obj_type_map", this.m_javaObjectMap);
        Properties properties = new Properties();
        ((Hashtable)properties).put("user", this.user);
        ((Hashtable)properties).put("password", this.password);
        ((Hashtable)properties).put("connection_url", this.url);
        ((Hashtable)properties).put("connect_auto_commit", String.valueOf(this.auto_commit));
        ((Hashtable)properties).put("trans_isolation", String.valueOf(this.trans_level));
        if (this.getStmtCacheSize() != 0) {
            ((Hashtable)properties).put("stmt_cache_size", String.valueOf(this.getStmtCacheSize()));
        }
        ((Hashtable)properties).put("defaultExecuteBatch", String.valueOf(this.default_batch));
        ((Hashtable)properties).put("prefetch", String.valueOf(this.default_row_prefetch));
        ((Hashtable)properties).put("remarks", String.valueOf(this.report_remarks));
        ((Hashtable)properties).put("AccumulateBatchResult", String.valueOf(this.m_accumulateBatchResult));
        ((Hashtable)properties).put("oracle.jdbc.J2EE13Compliant", String.valueOf(this.m_j2ee13Compliant));
        ((Hashtable)properties).put("restrictGetTables", String.valueOf(this.restrict_getTables));
        ((Hashtable)properties).put("synonyms", String.valueOf(this.include_synonyms));
        ((Hashtable)properties).put("fixedString", String.valueOf(this.defaultFixedString));
        hashtable.put("connection_properties", properties);
        oraclePooledConnection.setProperties(hashtable);
    }

    public String getProtocolType() {
        return this.protocol;
    }

    public synchronized boolean getRemarksReporting() {
        return this.report_remarks;
    }

    public synchronized boolean getReportRemarks() {
        return this.report_remarks;
    }

    public boolean getRestrictGetTables() {
        return this.restrict_getTables;
    }

    public synchronized String getSQLType(Object object) throws SQLException {
        if (object != null && this.map != null) {
            String string = object.getClass().getName();
            return (String)this.map.get(string);
        }
        return null;
    }

    public String getSessionTimeZone() {
        return this.m_sessionTimeZone;
    }

    public synchronized long getStartTime() throws SQLException {
        return this.m_startTime;
    }

    public synchronized int getStmtCacheSize() {
        return this.m_stmtCacheSize;
    }

    public synchronized short getStructAttrCsId() throws SQLException {
        return this.getDbCsId();
    }

    public boolean getSynchronousMode() {
        return true;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.trans_level;
    }

    public synchronized Map getTypeMap() {
        if (this.logicalHandle) {
            return this.m_opc_oc.map;
        }
        return this.map;
    }

    public String getURL() {
        return this.url;
    }

    public synchronized String getUserName() throws SQLException {
        if (this.user == null) {
            this.initUserName();
        }
        return this.user;
    }

    public synchronized boolean getUsingXAFlag() {
        return this.UsingXA;
    }

    public synchronized short getVersionNumber() throws SQLException {
        return this.db_access.getVersionNumber();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_warning;
    }

    public synchronized boolean getXAErrorFlag() {
        return this.XA_wants_error;
    }

    public synchronized void holdLine(OracleStatement oracleStatement) {
        this.statement_holding_line = oracleStatement;
    }

    private void initClientDataSupport() {
        this.m_clientData = null;
    }

    public synchronized void initUserName() throws SQLException {
        if (this.user != null) {
            return;
        }
        this.checkPhyiscalStatus();
        Statement statement = this.createStatement();
        ((OracleStatement)statement).setRowPrefetch(1);
        try {
            ResultSet resultSet = statement.executeQuery("select USER from dual");
            if (resultSet.next()) {
                this.user = resultSet.getString(1);
            }
            resultSet.close();
            resultSet = null;
        }
        finally {
            Object var3_3 = null;
            statement.close();
            statement = null;
        }
    }

    private void initialize(String string, String string2, String string3, DBAccess dBAccess, Hashtable hashtable, Map map, Map map2, String string4) throws SQLException {
        this.initClientDataSupport();
        this.m_stmtCacheSize = 0;
        this.m_stmtCache = null;
        this.m_stmtClearMetaData = false;
        this.database = string4;
        this.url = string;
        this.user = string2 != null ? string2.toUpperCase() : string2;
        this.db_access = dBAccess;
        this.protocol = string3;
        this.physicalStatus = true;
        this.default_row_prefetch = DEFAULT_ROW_PREFETCH;
        this.default_batch = 1;
        this.statement_table = new Hashtable(10);
        this.descriptorCache = hashtable != null ? hashtable : new Hashtable(10);
        this.map = map != null ? map : new Hashtable(10);
        this.m_javaObjectMap = map2 != null ? map2 : new Hashtable(10);
        this.closed = false;
        this.trans_level = 2;
        this.XA_wants_error = false;
        this.UsingXA = false;
        this.fdo = null;
        this.big_endian = null;
        this.m_occ = null;
        this.m_privData = null;
        this.m_clientIdSet = false;
        this.m_clientId = null;
    }

    public boolean isAccumulateBatchResult() {
        return this.m_accumulateBatchResult;
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.closed;
    }

    public synchronized boolean isLogicalConnection() {
        return this.logicalHandle;
    }

    public boolean isReadOnly() throws SQLException {
        return this.m_readOnly;
    }

    synchronized boolean isStmtCacheEnabled() {
        return this.m_stmtCacheSize > 0;
    }

    public synchronized void logicalClose() throws SQLException {
        if (this.m_opc != null && this.physicalStatus) {
            this.m_opc.logicalClose();
        }
        this.setPhysicalStatus(false);
        if (this.m_clientIdSet) {
            this.clearClientIdentifier(this.m_clientId);
        }
        this.m_startTime = 0L;
    }

    public String nativeSQL(String string) throws SQLException {
        if (s_osql == null) {
            s_osql = new OracleSql();
        }
        String string2 = s_osql.parse(string);
        return string2;
    }

    public synchronized void needLine() throws SQLException {
        if (this.XA_wants_error) {
            DBError.throwSqlException(63);
        }
        if (this.statement_holding_line != null) {
            this.statement_holding_line.freeLine();
        }
    }

    public int numberOfDescriptorCacheEntries() {
        if (this.descriptorCache != null) {
            return this.descriptorCache.size();
        }
        return 0;
    }

    public Object openJoltConnection(String string, short s, short s2) {
        return null;
    }

    public int pingDatabase(int n) throws SQLException {
        if (this.closed) {
            return -1;
        }
        return this.db_access.pingDatabase(n);
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        return this.privatePrepareCall(string, null, -1, -1);
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.privatePrepareCall(string, null, n, n2);
    }

    public synchronized CallableStatement prepareCallWithKey(String string) throws SQLException {
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        if (string != null && this.m_stmtCacheSize <= 0) {
            DBError.throwSqlException(95);
        }
        if (string == null) {
            return null;
        }
        return this.privatePrepareCall(null, string, -1, -1);
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        return this.privatePrepareStatement(string, null, -1, -1);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.privatePrepareStatement(string, null, n, n2);
    }

    public synchronized PreparedStatement prepareStatementWithKey(String string) throws SQLException {
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        if (string != null && (!this.logicalHandle && this.m_stmtCacheSize <= 0 || this.logicalHandle && this.m_opc.getStmtCacheSize() <= 0)) {
            DBError.throwSqlException(95);
        }
        if (string == null) {
            return null;
        }
        return this.privatePrepareStatement(null, string, -1, -1);
    }

    public void printState() {
        try {
            short s = this.getJdbcCsId();
            OracleLog.print(this, 1, 8, 32, "Jdbc character set id is   " + s);
            short s2 = this.getDbCsId();
            OracleLog.print(this, 1, 8, 32, "Db character set id is     " + s2);
            short s3 = this.getStructAttrCsId();
            OracleLog.print(this, 1, 8, 32, "STRUCT character set id is " + s3);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private Statement privateCreateStatement(int n, int n2, String string) throws SQLException {
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        OracleStatement oracleStatement = null;
        if (this.logicalHandle && this.m_opc.getStmtCacheSize() > 0) {
            oracleStatement = (OracleStatement)this.m_opc_oc.privateCreateStatement(n, n2, string);
        } else {
            int n3 = OracleStatement.DEFAULT_RSET_TYPE;
            if (n != -1 || n2 != -1) {
                n3 = ResultSetUtil.getRsetTypeCode(n, n2);
            }
            if (this.m_stmtCacheSize > 0 && string != null) {
                oracleStatement = this.m_stmtCache.lookup(string, 0, n3);
                if (oracleStatement != null) {
                    oracleStatement.m_key = null;
                }
            } else {
                oracleStatement = n != -1 || n2 != -1 ? new OracleStatement(this, 1, this.default_row_prefetch, n, n2) : new OracleStatement(this, 1, this.default_row_prefetch);
            }
        }
        return oracleStatement;
    }

    private CallableStatement privatePrepareCall(String string, String string2, int n, int n2) throws SQLException {
        if (string2 == null && string == null || string == "") {
            DBError.throwSqlException(104);
        }
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        OracleCallableStatement oracleCallableStatement = null;
        if (this.logicalHandle && this.m_opc.getStmtCacheSize() > 0) {
            oracleCallableStatement = (OracleCallableStatement)this.m_opc_oc.privatePrepareCall(string, string2, n, n2);
        } else {
            int n3 = OracleStatement.DEFAULT_RSET_TYPE;
            if (n != -1 || n2 != -1) {
                n3 = ResultSetUtil.getRsetTypeCode(n, n2);
            }
            if (this.m_stmtCacheSize > 0) {
                if (string2 != null) {
                    oracleCallableStatement = (OracleCallableStatement)this.m_stmtCache.lookup(string2, 2, n3);
                    if (oracleCallableStatement != null) {
                        oracleCallableStatement.m_key = null;
                    }
                } else {
                    oracleCallableStatement = (OracleCallableStatement)this.m_stmtCache.lookup(string, 2, n3);
                    if (oracleCallableStatement != null) {
                        oracleCallableStatement.initializeStateAndData(this.default_batch, this.default_row_prefetch, this.m_defaultAutoRefetch, false, true);
                        oracleCallableStatement.resetFirstRows();
                        if (this.m_stmtClearMetaData) {
                            oracleCallableStatement.initializeMetaData();
                        }
                    }
                }
            }
            if ((this.m_stmtCacheSize == 0 || string2 == null) && oracleCallableStatement == null) {
                oracleCallableStatement = n != -1 || n2 != -1 ? new OracleCallableStatement(this, string, 1, this.default_row_prefetch, n, n2) : new OracleCallableStatement(this, string, 1, this.default_row_prefetch);
            }
        }
        return oracleCallableStatement;
    }

    private PreparedStatement privatePrepareStatement(String string, String string2, int n, int n2) throws SQLException {
        if (string2 == null && string == null || string == "") {
            DBError.throwSqlException(104);
        }
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        OraclePreparedStatement oraclePreparedStatement = null;
        if (this.logicalHandle && this.m_opc.getStmtCacheSize() > 0) {
            oraclePreparedStatement = (OraclePreparedStatement)this.m_opc_oc.privatePrepareStatement(string, string2, n, n2);
        } else {
            int n3 = OracleStatement.DEFAULT_RSET_TYPE;
            if (n != -1 || n2 != -1) {
                n3 = ResultSetUtil.getRsetTypeCode(n, n2);
            }
            if (this.m_stmtCacheSize > 0) {
                if (string2 != null) {
                    oraclePreparedStatement = (OraclePreparedStatement)this.m_stmtCache.lookup(string2, 1, n3);
                    if (oraclePreparedStatement != null) {
                        oraclePreparedStatement.m_key = null;
                    }
                } else {
                    oraclePreparedStatement = (OraclePreparedStatement)this.m_stmtCache.lookup(string, 1, n3);
                    if (oraclePreparedStatement != null) {
                        oraclePreparedStatement.initializeStateAndData(this.default_batch, this.default_row_prefetch, this.m_defaultAutoRefetch, false, true);
                        oraclePreparedStatement.resetFirstRows();
                        if (this.m_stmtClearMetaData) {
                            oraclePreparedStatement.initializeMetaData();
                        }
                    }
                }
            }
            if ((this.m_stmtCacheSize == 0 || string2 == null) && oraclePreparedStatement == null) {
                oraclePreparedStatement = n != -1 || n2 != -1 ? new OraclePreparedStatement(this, string, this.default_batch, this.default_row_prefetch, n, n2) : new OraclePreparedStatement(this, string, this.default_batch, this.default_row_prefetch);
            }
        }
        return oraclePreparedStatement;
    }

    public synchronized void putDescriptor(String string, Object object) throws SQLException {
        if (string != null && object != null) {
            if (this.descriptorCache == null) {
                this.descriptorCache = new Hashtable(10);
            }
            this.descriptorCache.put(string, object);
        } else {
            DBError.throwSqlException(68);
        }
    }

    public synchronized void putDescriptor(byte[] byArray, Object object) throws SQLException {
        if (byArray != null && object != null) {
            if (this.descriptorCache == null) {
                this.descriptorCache = new Hashtable(10);
            }
            this.descriptorCache.put(new ByteArrayKey(byArray), object);
        } else {
            DBError.throwSqlException(68);
        }
    }

    public void registerApiDescription(String string, short s, short s2, String string2) {
    }

    public synchronized void registerCloseCallback(OracleCloseCallback oracleCloseCallback, Object object) {
        this.m_occ = oracleCloseCallback;
        this.m_privData = object;
    }

    public synchronized void registerSQLType(String string, Class clazz) throws SQLException {
        if (string == null || clazz == null) {
            DBError.throwSqlException(68);
        }
        if (this.map == null) {
            this.map = new Hashtable(10);
        }
        this.map.put(string, clazz);
        this.map.put(clazz.getName(), string);
    }

    public synchronized void registerSQLType(String string, String string2) throws SQLException {
        if (string == null || string2 == null) {
            DBError.throwSqlException(68);
        }
        try {
            this.registerSQLType(string, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            DBError.throwSqlException(1, "Class not found: " + string2);
        }
    }

    public synchronized void registerTAFCallback(OracleOCIFailover oracleOCIFailover, Object object) throws SQLException {
        if (this.db_access != null) {
            this.db_access.registerTAFCallback(this, oracleOCIFailover, object);
        }
    }

    public synchronized void releaseLine() {
        this.releaseLineForCancel();
    }

    void releaseLineForCancel() {
        this.statement_holding_line = null;
    }

    public synchronized void removeAllDescriptor() {
        if (this.descriptorCache != null) {
            this.descriptorCache.clear();
        }
    }

    public synchronized Object removeClientData(Object object) {
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.remove(object);
    }

    public synchronized void removeDecriptor(String string) {
        if (string != null && this.descriptorCache != null) {
            this.descriptorCache.remove(string);
        }
    }

    public synchronized void removeDecriptor(byte[] byArray) {
        if (byArray != null && this.descriptorCache != null) {
            this.descriptorCache.remove(new ByteArrayKey(byArray));
        }
    }

    synchronized void remove_statement(Statement statement) {
        this.statement_table.remove(statement);
    }

    public synchronized void rollback() throws SQLException {
        this.checkPhyiscalStatus();
        if (this.XA_wants_error || this.UsingXA) {
            DBError.throwSqlException(69);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        try {
            this.needLine();
            this.db_access.rollback();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
    }

    public void setAccumulateBatchResult(boolean bl) {
        this.m_accumulateBatchResult = bl;
    }

    public synchronized void setAutoClose(boolean bl) throws SQLException {
        if (!bl) {
            DBError.throwSqlException(31);
        }
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkPhyiscalStatus();
        if (this.XA_wants_error || this.UsingXA && bl) {
            DBError.throwSqlException(69);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        try {
            this.needLine();
            this.db_access.setAutoCommit(bl);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.auto_commit = bl;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public synchronized Object setClientData(Object object, Object object2) {
        if (this.m_clientData == null) {
            this.m_clientData = new Hashtable();
        }
        return this.m_clientData.put(object, object2);
    }

    public void setClientIdentifier(String string) throws SQLException {
        this.m_clientIdSet = true;
        this.m_clientId = string;
        this.db_access.setClientIdentifier(this, string);
    }

    public void setCreateStatementAsRefCursor(boolean bl) {
        this.db_access.setCreateStatementAsRefCursor(bl);
    }

    public synchronized void setDataSizeUnits(String string) throws SQLException {
        if (string.equalsIgnoreCase("ClientBytes")) {
            this.dataSizeScale = 1;
        } else if (string.equalsIgnoreCase("ServerBytes")) {
            this.dataSizeScale = this.db_access.getNlsRatio();
        } else {
            DBError.throwSqlException(68);
        }
    }

    private void setDbTzCalendar(String string) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        char c = string.charAt(0);
        if (c == '+') {
            bl = true;
            stringBuffer.append(string.toCharArray(), 1, string.length() - 1);
        } else if (c == '-') {
            bl = false;
            stringBuffer.append(string.toCharArray(), 1, string.length() - 1);
        } else {
            bl = true;
            stringBuffer.append(string);
        }
        stringBuffer.append(":00");
        Time time = Time.valueOf(stringBuffer.toString());
        long l = time.getTime() - 28800000L;
        if (!bl) {
            l *= -1L;
        }
        TimeZone timeZone = TimeZone.getDefault();
        timeZone.setRawOffset((int)l);
        this.m_dbTzCalendar = new GregorianCalendar(timeZone);
    }

    public void setDefaultAutoRefetch(boolean bl) throws SQLException {
        this.m_defaultAutoRefetch = bl;
    }

    public synchronized void setDefaultExecuteBatch(int n) throws SQLException {
        if (n <= 0) {
            DBError.throwSqlException(42);
        }
        this.default_batch = n;
    }

    public void setDefaultFixedString(boolean bl) {
        this.defaultFixedString = bl;
    }

    public synchronized void setDefaultRowPrefetch(int n) throws SQLException {
        if (n <= 0) {
            DBError.throwSqlException(20);
        }
        this.default_row_prefetch = n;
    }

    public synchronized void setFDO(byte[] byArray) throws SQLException {
        this.fdo = byArray;
    }

    public void setIncludeSynonyms(boolean bl) {
        this.include_synonyms = bl;
    }

    public void setJ2EE13Compliant(boolean bl) {
        this.m_j2ee13Compliant = bl;
    }

    public synchronized void setJavaObjectTypeMap(Map map) {
        if (this.logicalHandle) {
            this.m_opc_oc.m_javaObjectMap = map;
        } else {
            this.m_javaObjectMap = map;
        }
    }

    public synchronized void setPhysicalStatus(boolean bl) {
        this.physicalStatus = bl;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        Statement statement = null;
        try {
            String string = null;
            string = bl ? "SET TRANSACTION READ ONLY" : "SET TRANSACTION READ WRITE";
            statement = this.prepareStatement(string);
            statement.execute();
        }
        finally {
            Object var4_4 = null;
            if (statement != null) {
                statement.close();
            }
        }
        this.m_readOnly = bl;
    }

    public synchronized void setRemarksReporting(boolean bl) {
        this.report_remarks = bl;
    }

    public void setRestrictGetTables(boolean bl) {
        this.restrict_getTables = bl;
    }

    public void setSessionTimeZone(String string) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement("ALTER SESSION SET TIME_ZONE = '" + string + "'");
            statement.executeUpdate();
            statement = this.prepareStatement("SELECT DBTIMEZONE FROM DUAL");
            resultSet = statement.executeQuery();
            resultSet.next();
            String string2 = resultSet.getString(1);
            this.setDbTzCalendar(string2);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            statement.close();
            throw throwable;
        }
        statement.close();
        this.m_sessionTimeZone = string;
    }

    public synchronized void setStartTime(long l) throws SQLException {
        if (l <= 0L) {
            DBError.throwSqlException(68);
        } else {
            this.m_startTime = l;
        }
    }

    public synchronized void setStmtCacheSize(int n) throws SQLException {
        this.setStmtCacheSize(n, false);
    }

    public synchronized void setStmtCacheSize(int n, boolean bl) throws SQLException {
        if (this.logicalHandle) {
            DBError.throwSqlException(96);
        }
        if (n < 0) {
            DBError.throwSqlException(68);
        }
        this.m_stmtCacheSize = n;
        if (n == 0 && this.m_stmtCache != null) {
            this.m_stmtCache.close();
            this.m_stmtCache = null;
            return;
        }
        if (this.m_stmtCache == null) {
            this.m_stmtCache = new LRUStmtCache(n);
        } else {
            this.m_stmtCache.setCacheSize(n);
        }
        this.m_stmtClearMetaData = bl;
    }

    public void setSynchronousMode(boolean bl) {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setTransactionIsolation(int var1_1) throws SQLException {
        this.checkPhyiscalStatus();
        var2_2 = (OracleStatement)this.createStatement();
        try {
            switch (var1_1) {
                case 2: {
                    var2_2.execute("ALTER SESSION SET ISOLATION_LEVEL = READ COMMITTED");
                    this.trans_level = 2;
                    ** break;
                }
                case 8: {
                    var2_2.execute("ALTER SESSION SET ISOLATION_LEVEL = SERIALIZABLE");
                    this.trans_level = 8;
                    ** break;
                }
            }
            DBError.throwSqlException(30);
        }
        catch (Throwable var3_5) {
            var4_4 = null;
            if (this.logicalHandle) {
                this.m_opc_oc.trans_level = this.trans_level;
            }
            var2_2.close();
            throw var3_5;
        }
lbl24:
        // 3 sources

        var4_3 = null;
        if (this.logicalHandle) {
            this.m_opc_oc.trans_level = this.trans_level;
        }
        var2_2.close();
    }

    public synchronized void setTypeMap(Map map) {
        if (this.logicalHandle) {
            this.m_opc_oc.map = map;
        } else {
            this.map = map;
        }
    }

    public synchronized void setUsingXAFlag(boolean bl) {
        this.UsingXA = bl;
    }

    public synchronized void setXAErrorFlag(boolean bl) {
        this.XA_wants_error = bl;
    }

    public synchronized void shutdown(int n) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        this.db_access.shutdown(n);
    }

    public synchronized void startup(String string, int n) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        this.db_access.startup(string, n);
    }

    public void trace(String string) {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            if (m_traceEnabled) {
                OracleLog.setLogStream(null);
            }
            m_traceEnabled = false;
        } else {
            if (!m_traceEnabled) {
                OracleLog.setLogStream(printStream);
            }
            OracleLog.print(1, 32, string);
            m_traceEnabled = true;
        }
    }
}

