/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.asm.operation.ha;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import oracle.ops.mgmt.asm.operation.ha.ASMModifyDepOperation;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationImpl;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.operation.ha.HARegisterOperation;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ASMOperationImpl
extends HAOperationImpl
implements HALiterals {
    public static HAOperationResult modify(ASMModifyDepOperation op) {
        String requiredResources;
        String resourceName = op.getResourceName();
        try {
            HAOperationImpl.writeProfileOnDisk((HAOperation)op);
        }
        catch (IOException e) {
            Trace.out((String)("modify: IOException caught:" + e));
            return ASMOperationImpl.handleException((int)1, null, (Exception)e);
        }
        String profileFileName = op.getProfileHome() + File.separator + op.getResourceName() + ".cap";
        Trace.out((String)("profileFileName=" + profileFileName));
        try {
            requiredResources = Utils.getPropertyValue((String)profileFileName, (String)"REQUIRED_RESOURCES", (boolean)true);
        }
        catch (FileNotFoundException e) {
            Trace.out((String)("modify: FileNotFoundException caught:" + e));
            return ASMOperationImpl.handleException((int)1, null, (Exception)e);
        }
        catch (IOException e) {
            Trace.out((String)("modify: IOException caught:" + e));
            return ASMOperationImpl.handleException((int)1, null, (Exception)e);
        }
        Trace.out((String)("ORG: bModify:" + op.getModify() + " Reqd. resources =" + requiredResources));
        if (requiredResources == null) {
            Object[] args = new String[]{"REQUIRED_RESOURCES", profileFileName, requiredResources};
            HAOperationException e = new HAOperationException("1078", args, null);
            return ASMOperationImpl.handleException((int)1, null, (Exception)((Object)e));
        }
        StringTokenizer st = new StringTokenizer(requiredResources, " ", true);
        StringBuffer sb = new StringBuffer();
        boolean bExists = false;
        String asmInstResource = op.getASMInstanceResource();
        while (st.hasMoreTokens()) {
            String token = (String)st.nextElement();
            if (token.equals(asmInstResource)) {
                bExists = true;
                if (op.getModify()) {
                    sb.append(token);
                    continue;
                }
                if (!st.hasMoreTokens()) continue;
                st.nextElement();
                continue;
            }
            sb.append(token);
        }
        Trace.out((String)("bModify:" + op.getModify() + " resources sb =" + sb.toString()));
        if (op.getModify() && !bExists) {
            sb.append(" ");
            sb.append(asmInstResource);
        }
        Trace.out((String)("NEW: bModify:" + op.getModify() + " reqd. resources =" + sb.toString()));
        if (op.getModify() && !bExists || !op.getModify() && bExists) {
            HARegisterOperation regOp;
            int index = 0;
            String[] cmd = new String[5];
            cmd[index++] = op.getVerb();
            cmd[index++] = "-update";
            cmd[index++] = op.getResourceName();
            cmd[index++] = "-r";
            cmd[index++] = sb.toString();
            HAOperationResult result = ASMOperationImpl.runCommand((String[])cmd);
            Trace.out((String)("modify: required resources result status =" + result.getStatus()));
            if (result.getStatus() == 1) {
                return result;
            }
            try {
                regOp = new HARegisterOperation(resourceName, true, op.getVersion());
            }
            catch (HAOperationException haoe) {
                return ASMOperationImpl.handleException((int)1, null, (Exception)((Object)haoe));
            }
            result = ASMOperationImpl.register((HARegisterOperation)regOp);
            Trace.out((String)("modify: re-register result status =" + result.getStatus()));
            if (result.getStatus() == 1) {
                return result;
            }
        }
        return ASMOperationImpl.handleException((int)0, null, null);
    }
}

