/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.asm.operation;

import java.io.Serializable;
import oracle.ops.mgmt.asm.ASMConfigurationException;
import oracle.ops.mgmt.asm.operation.ASMConfigurationResult;
import oracle.ops.mgmt.asm.operation.ASMTree;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.trace.Trace;

public class SetASMInstanceOraHomeOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = -7298492198926649893L;
    private String m_instance;
    private String m_node;
    private String m_oracleHome;

    public SetASMInstanceOraHomeOperation(String instance, String node, String oracleHome, Version version) {
        super(true, version);
        this.m_instance = instance;
        this.m_node = node;
        this.m_oracleHome = oracleHome;
    }

    public OperationResult run() {
        ASMConfigurationResult result;
        try {
            ASMTree asmTree = ASMTree.init(this.getVersion());
            asmTree.setOracleHome(this.m_instance, this.m_node, this.m_oracleHome);
            Trace.out((String)("Set ORACLE_HOME=" + this.m_oracleHome));
            result = new ASMConfigurationResult(0);
        }
        catch (ASMConfigurationException e) {
            result = new ASMConfigurationResult(1, (Exception)((Object)e));
        }
        Trace.out((String)("result status " + result.getStatus()));
        return result;
    }
}

