/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.asm.operation;

import java.util.Enumeration;
import java.util.Vector;
import oracle.ops.mgmt.asm.ASMConfigurationException;
import oracle.ops.mgmt.asm.ASMLiterals;
import oracle.ops.mgmt.asm.operation.ASMInstanceConfiguration;
import oracle.ops.mgmt.asm.operation.ASMTreeDefinition;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterLock;
import oracle.ops.mgmt.has.ClusterLockException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.trace.Trace;

class ASMTree
implements ASMLiterals {
    private static ASMTree s_asmTree;
    private ASMTreeDefinition m_asmTreeDef;
    private ClusterLock m_clusterLock;
    private MessageBundle m_msgBundle;
    private OCR m_ocr;
    private Version m_version;

    private ASMTree(int ocrInitLevel, Version version) throws ASMConfigurationException {
        try {
            this.m_ocr = OCR.init((int)ocrInitLevel, (Version)version);
            this.m_clusterLock = new ClusterLock();
        }
        catch (OCRException e) {
            throw new ASMConfigurationException((Exception)((Object)e));
        }
        catch (ClusterLockException e) {
            throw new ASMConfigurationException((Exception)((Object)e));
        }
        this.m_version = version;
        this.m_msgBundle = MessageBundle.getMessageBundle((String)"Prks");
        this.m_asmTreeDef = new ASMTreeDefinition();
    }

    public static synchronized ASMTree init(Version version) throws ASMConfigurationException {
        return ASMTree.init(7, version);
    }

    public static synchronized ASMTree init(int ocrInitLevel, Version version) throws ASMConfigurationException {
        if (s_asmTree == null) {
            s_asmTree = new ASMTree(ocrInitLevel, version);
            Trace.out((String)"Out of ASMTree constructor.");
        } else {
            Trace.out((String)"Returning an existing instance of ASMTree");
        }
        return s_asmTree;
    }

    public ASMTreeDefinition getTreeDefinition() {
        return this.m_asmTreeDef;
    }

    public synchronized Boolean isASMInstanceExists(String instance, String node) throws ASMConfigurationException {
        String asmRootKey = this.m_asmTreeDef.getASMRootKey();
        Trace.out((String)("asmRootKey=" + asmRootKey));
        try {
            boolean bExists;
            if (!this.m_ocr.keyExists(asmRootKey)) {
                bExists = false;
            } else {
                String asmNodeKey = this.m_asmTreeDef.getASMNodeKey(node);
                Trace.out((String)("asmNodeKey=" + asmNodeKey));
                if (!this.m_ocr.keyExists(asmNodeKey)) {
                    bExists = false;
                } else {
                    String asmInstanceKey = this.m_asmTreeDef.getASMInstanceKey(instance, node);
                    Trace.out((String)("asmInstanceKey=" + asmInstanceKey));
                    bExists = this.m_ocr.keyExists(asmInstanceKey);
                }
            }
            Trace.out((String)("ASMTree.isASMInstanceExists=" + bExists));
            return new Boolean(bExists);
        }
        catch (OCRException e) {
            throw new ASMConfigurationException((Exception)((Object)e));
        }
    }

    public synchronized ASMInstanceConfiguration getASMInstanceConfiguration(String instance, String node) throws ASMConfigurationException {
        String[] envs;
        boolean enabled;
        String startOpt;
        String spfile;
        String ohome;
        String inst;
        String instanceKey = this.m_asmTreeDef.getASMInstanceKey(instance, node);
        Trace.out((String)("Acquiring shared CSS lock SRVM.ASM." + instanceKey));
        try {
            this.m_clusterLock.acquireShared("SRVM.ASM." + instanceKey);
        }
        catch (ClusterLockException e) {
            throw new ASMConfigurationException((Exception)((Object)e));
        }
        try {
            if (!this.m_ocr.keyExists(instanceKey)) {
                Trace.out((String)(instanceKey + " does not exist"));
                Object[] args = new String[]{instance, node};
                String msg = this.m_msgBundle.getMessage("1028", true, args);
                Trace.out((String)("ASMInstanceNotExists:" + msg));
                throw new ASMConfigurationException(msg);
            }
            Trace.out((String)(instanceKey + " does exist"));
            inst = this.m_ocr.getKeyValue(instanceKey);
            Trace.out((String)("case preserved ASM instance name is " + inst));
            ohome = this.m_ocr.getKeyValue(this.m_asmTreeDef.getASMInstanceOHomeKey(instance, node));
            spfile = this.m_ocr.getKeyValue(this.m_asmTreeDef.getASMInstanceSPFileKey(instance, node));
            startOpt = this.m_ocr.getKeyValue(this.m_asmTreeDef.getASMInstanceStartOptKey(instance, node));
            enabled = new Boolean(this.m_ocr.getKeyValue(this.m_asmTreeDef.getASMInstanceEnabledKey(instance, node)));
            String versionString = this.m_ocr.getKeyValue(this.m_asmTreeDef.getASMInstanceVersionKey(instance, node));
            if (this.m_version.toString().compareTo(versionString) < 0) {
                Object[] args = new String[]{this.m_version.toString(), versionString};
                String msg = this.m_msgBundle.getMessage("1029", true, args);
                throw new ASMConfigurationException(msg);
            }
            envs = this.m_ocr.getKeyValues(this.m_asmTreeDef.getASMInstanceEnvKey(instance, node));
        }
        catch (OCRException e) {
            Object[] args = new String[]{instance, node, e.getMessage()};
            String msg = this.m_msgBundle.getMessage("1031", true, args);
            throw new ASMConfigurationException(msg, (Exception)((Object)e));
        }
        finally {
            Trace.out((String)("Releasing shared CSS lock SRVM.ASM." + instanceKey));
            try {
                this.m_clusterLock.release("SRVM.ASM." + instanceKey);
            }
            catch (ClusterLockException e) {
                throw new ASMConfigurationException((Exception)((Object)e));
            }
        }
        ASMInstanceConfiguration asmConfig = new ASMInstanceConfiguration(inst, node, ohome, spfile, startOpt, enabled, this.m_version, envs);
        asmConfig.print();
        return asmConfig;
    }

    public synchronized void addASMInstanceConfiguration(ASMInstanceConfiguration asmConfig) throws ASMConfigurationException {
        String node = asmConfig.getNode();
        String instance = asmConfig.getInstance();
        String asmRootKey = this.m_asmTreeDef.getASMRootKey();
        String asmNodeKey = this.m_asmTreeDef.getASMNodeKey(node);
        String asmInstanceKey = this.m_asmTreeDef.getASMInstanceKey(instance, node);
        String existKey = null;
        String logKey = null;
        boolean bLog = true;
        Trace.out((String)"addASMInstanceConfiguration:config =\n");
        asmConfig.print();
        try {
            if (!this.m_ocr.keyExists(asmRootKey)) {
                existKey = this.m_asmTreeDef.getASMRootParentKey(!bLog);
                logKey = this.m_asmTreeDef.getASMRootKey(bLog);
            } else if (!this.m_ocr.keyExists(asmNodeKey)) {
                existKey = asmRootKey;
                logKey = this.m_asmTreeDef.getASMNodeKey(node, bLog);
            } else if (!this.m_ocr.keyExists(asmInstanceKey)) {
                existKey = asmNodeKey;
                logKey = this.m_asmTreeDef.getASMInstanceKey(instance, node, bLog);
            }
        }
        catch (OCRException e) {
            throw new ASMConfigurationException((Exception)((Object)e));
        }
        Trace.out((String)("existKey " + existKey));
        Trace.out((String)("logKey " + logKey));
        String curExistKey = existKey;
        String lockName = "SRVM.ASM." + existKey;
        Trace.out((String)("Acquiring exclusive CSS lock " + lockName));
        try {
            this.m_clusterLock.acquire(lockName);
        }
        catch (ClusterLockException e) {
            Trace.out((Exception)((Object)e));
            throw new ASMConfigurationException((Exception)((Object)e));
        }
        try {
            String ohome = asmConfig.getOracleHome();
            this.m_ocr.setOracleGrpName(ohome);
            this.m_ocr.deleteKey(logKey, true);
            if (curExistKey.equals("DATABASE")) {
                Trace.out((String)("creating " + asmRootKey));
                this.m_ocr.setKeyValue(this.m_asmTreeDef.getASMRootKey(bLog), String.valueOf(true), 3, this.m_asmTreeDef.getASMRootParentKey(bLog), ohome);
                curExistKey = asmRootKey;
            }
            if (curExistKey.equals(asmRootKey)) {
                Trace.out((String)("creating " + asmNodeKey));
                this.m_ocr.setKeyValue(this.m_asmTreeDef.getASMNodeKey(node, bLog), node, 3, this.m_asmTreeDef.getASMRootKey(bLog), ohome);
                curExistKey = asmNodeKey;
            }
            if (curExistKey.equals(asmNodeKey)) {
                Trace.out((String)("creating " + asmInstanceKey));
                this.m_ocr.setKeyValue(this.m_asmTreeDef.getASMInstanceKey(instance, node, bLog), instance, 3, this.m_asmTreeDef.getASMNodeKey(node, bLog), ohome);
            }
            this.setASMInstanceConfiguration(asmConfig, false, bLog);
            this.m_ocr.moveKey(logKey, existKey, "", 1);
        }
        catch (OCRException e) {
            try {
                this.m_ocr.deleteKey(logKey, true);
            }
            catch (OCRException e2) {
                Trace.out((Exception)((Object)e2));
            }
            Object[] args = new String[]{instance, node, e.getMessage()};
            String msg = this.m_msgBundle.getMessage("1030", true, args);
            Trace.out((String)("msg=" + msg));
            Trace.out((Exception)((Object)e));
            throw new ASMConfigurationException(msg, (Exception)((Object)e));
        }
        finally {
            Trace.out((String)("Releasing exclusive CSS lock " + lockName));
            try {
                this.m_clusterLock.release(lockName);
            }
            catch (ClusterLockException e) {
                Trace.out((Exception)((Object)e));
                throw new ASMConfigurationException((Exception)((Object)e));
            }
        }
    }

    protected synchronized void setASMInstanceConfiguration(ASMInstanceConfiguration asmConfig, boolean bPurge, boolean bLog) throws OCRException {
        String instance = asmConfig.getInstance();
        String node = asmConfig.getNode();
        String asmInstanceKey = this.m_asmTreeDef.getASMInstanceKey(instance, node, bLog);
        if (bPurge) {
            String[] subKeys = this.m_ocr.listSubKeys(asmInstanceKey);
            for (int i = 0; i < subKeys.length; ++i) {
                this.m_ocr.deleteKey(asmInstanceKey + "." + subKeys[i], true);
            }
        }
        Enumeration enumKeys = asmConfig.getSubKeyEnum();
        while (enumKeys.hasMoreElements()) {
            String subKeyName = (String)enumKeys.nextElement();
            if (!subKeyName.equals("ENVIRONMENT")) {
                Object value = asmConfig.getValue(subKeyName);
                String subKeyValue = value != null ? asmConfig.getValue(subKeyName).toString() : (String)value;
                Trace.out((String)("creating subkey " + subKeyName + " with value=" + subKeyValue));
                this.m_ocr.setKeyValue(this.m_asmTreeDef.getASMInstanceSubKey(instance, node, subKeyName, bLog), subKeyValue, 3, asmInstanceKey, asmConfig.getOracleHome());
                continue;
            }
            String[] env = (String[])asmConfig.getValue(subKeyName);
            Trace.out((String)("creating subkey " + subKeyName + " with value=" + env));
            this.m_ocr.setKeyValues(this.m_asmTreeDef.getASMInstanceSubKey(instance, node, subKeyName, bLog), env, 3, asmInstanceKey, asmConfig.getOracleHome());
        }
    }

    public synchronized void removeAllInstancesConfiguration(String node) throws ASMConfigurationException {
        String asmNodeKey = this.m_asmTreeDef.getASMNodeKey(node);
        String lockKey = "SRVM.ASM." + asmNodeKey;
        Trace.out((String)("Acquiring exclusive CSS lock " + lockKey));
        try {
            this.m_clusterLock.acquire(lockKey);
        }
        catch (ClusterLockException e) {
            throw new ASMConfigurationException((Exception)((Object)e));
        }
        try {
            this.m_ocr.deleteKey(asmNodeKey, true);
        }
        catch (OCRException e) {
            Object[] args = new String[3];
            args[0] = node;
            StringBuffer sbInstances = new StringBuffer();
            try {
                String[] instances = this.m_ocr.listSubKeys(asmNodeKey);
                for (int i = 0; i < instances.length; ++i) {
                    if (i == 0) {
                        sbInstances.append(instances[i]);
                        continue;
                    }
                    sbInstances.append("," + instances[i]);
                }
            }
            catch (OCRException oe) {
                throw new ASMConfigurationException((Exception)((Object)oe));
            }
            args[1] = sbInstances.toString();
            args[2] = e.getMessage();
            String msg = this.m_msgBundle.getMessage("1034", true, args);
            throw new ASMConfigurationException(msg, (Exception)((Object)e));
        }
        finally {
            Trace.out((String)("Releasing exclusive CSS lock " + lockKey));
            try {
                this.m_clusterLock.release(lockKey);
            }
            catch (ClusterLockException e) {
                throw new ASMConfigurationException((Exception)((Object)e));
            }
        }
    }

    public synchronized void removeASMInstanceConfiguration(String instance, String node) throws ASMConfigurationException {
        block13: {
            String asmNodeKey = this.m_asmTreeDef.getASMNodeKey(node);
            String asmInstanceKey = this.m_asmTreeDef.getASMInstanceKey(instance, node);
            String lockKey = "SRVM.ASM." + asmNodeKey;
            boolean bLockAcquired = false;
            try {
                if (this.m_ocr.listSubKeys(asmNodeKey).length == 1) {
                    this.removeAllInstancesConfiguration(node);
                    break block13;
                }
                Trace.out((String)("Acquiring exclusive CSS lock " + lockKey));
                try {
                    this.m_clusterLock.acquire(lockKey);
                    bLockAcquired = true;
                }
                catch (ClusterLockException e) {
                    throw new ASMConfigurationException((Exception)((Object)e));
                }
                this.m_ocr.deleteKey(asmInstanceKey, true);
            }
            catch (OCRException e) {
                Object[] args = new String[]{instance, node, e.getMessage()};
                String msg = this.m_msgBundle.getMessage("1033", true, args);
                throw new ASMConfigurationException(msg, (Exception)((Object)e));
            }
            finally {
                if (bLockAcquired) {
                    Trace.out((String)("Releasing exclusive CSS lock " + lockKey));
                    try {
                        this.m_clusterLock.release(lockKey);
                    }
                    catch (ClusterLockException e) {
                        throw new ASMConfigurationException((Exception)((Object)e));
                    }
                }
            }
        }
    }

    public synchronized void setASMInstanceEnableDisable(String instance, String node, boolean bEnabled) throws ASMConfigurationException {
        String asmInstanceKey = this.m_asmTreeDef.getASMInstanceKey(instance, node);
        String lockKey = "SRVM.ASM." + asmInstanceKey;
        try {
            this.m_clusterLock.acquire(lockKey);
        }
        catch (ClusterLockException e) {
            throw new ASMConfigurationException((Exception)((Object)e));
        }
        try {
            String versionString = this.m_ocr.getKeyValue(this.m_asmTreeDef.getASMInstanceVersionKey(instance, node));
            if (this.m_version.toString().compareTo(versionString) < 0) {
                Object[] args = new String[]{this.m_version.toString(), versionString};
                String msg = this.m_msgBundle.getMessage("1029", true, args);
                throw new ASMConfigurationException(msg);
            }
            this.m_ocr.setKeyValue(this.m_asmTreeDef.getASMInstanceEnabledKey(instance, node), new Boolean(bEnabled).toString(), 2, asmInstanceKey, null);
        }
        catch (OCRException e) {
            Object[] args = new String[]{instance, node, e.getMessage()};
            String msg = this.m_msgBundle.getMessage("1032", true, args);
            throw new ASMConfigurationException(msg, (Exception)((Object)e));
        }
        finally {
            Trace.out((String)("Releasing shared CSS lock " + lockKey));
            try {
                this.m_clusterLock.release(lockKey);
            }
            catch (ClusterLockException e) {
                throw new ASMConfigurationException((Exception)((Object)e));
            }
        }
    }

    public synchronized void setOracleHome(String instance, String node, String oracleHome) throws ASMConfigurationException {
        String asmInstanceKey = this.m_asmTreeDef.getASMInstanceKey(instance, node);
        String lockKey = "SRVM.ASM." + asmInstanceKey;
        try {
            this.m_clusterLock.acquire(lockKey);
        }
        catch (ClusterLockException e) {
            throw new ASMConfigurationException((Exception)((Object)e));
        }
        try {
            String versionString = this.m_ocr.getKeyValue(this.m_asmTreeDef.getASMInstanceVersionKey(instance, node));
            if (this.m_version.toString().compareTo(versionString) < 0) {
                Object[] args = new String[]{this.m_version.toString(), versionString};
                String msg = this.m_msgBundle.getMessage("1029", true, args);
                throw new ASMConfigurationException(msg);
            }
            this.m_ocr.setKeyValue(this.m_asmTreeDef.getASMInstanceOHomeKey(instance, node), oracleHome, 2, asmInstanceKey, oracleHome);
        }
        catch (OCRException e) {
            Object[] args = new String[]{instance, node, e.getMessage()};
            String msg = this.m_msgBundle.getMessage("1032", true, args);
            throw new ASMConfigurationException(msg, (Exception)((Object)e));
        }
        finally {
            Trace.out((String)("Releasing shared CSS lock " + lockKey));
            try {
                this.m_clusterLock.release(lockKey);
            }
            catch (ClusterLockException e) {
                throw new ASMConfigurationException((Exception)((Object)e));
            }
        }
    }

    public synchronized void setASMInstanceSPFile(String instance, String node, String spfile) throws ASMConfigurationException {
        String asmInstanceKey = this.m_asmTreeDef.getASMInstanceKey(instance, node);
        String lockKey = "SRVM.ASM." + asmInstanceKey;
        try {
            this.m_clusterLock.acquire(lockKey);
        }
        catch (ClusterLockException e) {
            throw new ASMConfigurationException((Exception)((Object)e));
        }
        try {
            String versionString = this.m_ocr.getKeyValue(this.m_asmTreeDef.getASMInstanceVersionKey(instance, node));
            if (this.m_version.toString().compareTo(versionString) < 0) {
                Object[] args = new String[]{this.m_version.toString(), versionString};
                String msg = this.m_msgBundle.getMessage("1029", true, args);
                throw new ASMConfigurationException(msg);
            }
            this.m_ocr.setKeyValue(this.m_asmTreeDef.getASMInstanceSPFileKey(instance, node), spfile, 2, asmInstanceKey, null);
        }
        catch (OCRException e) {
            Object[] args = new String[]{instance, node, e.getMessage()};
            String msg = this.m_msgBundle.getMessage("1032", true, args);
            throw new ASMConfigurationException(msg, (Exception)((Object)e));
        }
        finally {
            Trace.out((String)("Releasing shared CSS lock " + lockKey));
            try {
                this.m_clusterLock.release(lockKey);
            }
            catch (ClusterLockException e) {
                throw new ASMConfigurationException((Exception)((Object)e));
            }
        }
    }

    public synchronized String[] getInstances(String node) throws ASMConfigurationException {
        String asmNodeKey = this.m_asmTreeDef.getASMNodeKey(node);
        String lockKey = "SRVM.ASM." + asmNodeKey;
        try {
            if (!this.m_ocr.keyExists(asmNodeKey)) {
                Trace.out((String)(asmNodeKey + " does not exist"));
                return new String[0];
            }
        }
        catch (OCRException e) {
            throw new ASMConfigurationException((Exception)((Object)e));
        }
        Trace.out((String)(asmNodeKey + " does exist"));
        Trace.out((String)("Acquiring shared CSS lock " + lockKey));
        try {
            this.m_clusterLock.acquireShared(lockKey);
        }
        catch (ClusterLockException e) {
            throw new ASMConfigurationException((Exception)((Object)e));
        }
        try {
            String[] instances;
            String[] stringArray = instances = this.m_ocr.listSubKeys(asmNodeKey);
            return stringArray;
        }
        catch (OCRException e) {
            throw new ASMConfigurationException((Exception)((Object)e));
        }
        finally {
            Trace.out((String)("Releasing shared CSS lock " + lockKey));
            try {
                this.m_clusterLock.release(lockKey);
            }
            catch (ClusterLockException e) {
                throw new ASMConfigurationException((Exception)((Object)e));
            }
        }
    }

    public synchronized String[] getASMInstanceNodes(String instance) throws ASMConfigurationException {
        String asmRootKey = this.m_asmTreeDef.getASMRootKey();
        String lockKey = "SRVM.ASM." + asmRootKey;
        Vector<String> nodev = new Vector<String>();
        boolean bLockAcquired = false;
        try {
            if (this.m_ocr.keyExists(asmRootKey)) {
                Trace.out((String)(asmRootKey + " does exist"));
                Trace.out((String)("Acquiring shared CSS lock " + lockKey));
                try {
                    this.m_clusterLock.acquireShared(lockKey);
                    bLockAcquired = true;
                }
                catch (ClusterLockException e) {
                    throw new ASMConfigurationException((Exception)((Object)e));
                }
                String[] nodeList = this.m_ocr.listSubKeys(asmRootKey);
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.length; ++i) {
                        String[] instanceList = this.m_ocr.listSubKeys(this.m_asmTreeDef.getASMNodeKey(nodeList[i]));
                        if (instanceList == null) continue;
                        for (int j = 0; j < instanceList.length; ++j) {
                            Trace.out((String)("nodeList[" + i + "]=" + nodeList[i] + "instanceList[" + j + "]=" + instanceList[j]));
                            if (!instance.equals(instanceList[j])) continue;
                            nodev.addElement(nodeList[i]);
                        }
                    }
                }
            }
            Trace.out((String)("nodev = " + nodev.toString()));
            if (nodev.isEmpty()) {
                Object[] args = new String[]{instance};
                String msg = this.m_msgBundle.getMessage("1027", true, args);
                Trace.out((String)("ASMInstanceNotExists:" + msg));
                throw new ASMConfigurationException(msg);
            }
            Object[] nodes = new String[nodev.size()];
            nodev.copyInto(nodes);
            Object[] objectArray = nodes;
            return objectArray;
        }
        catch (OCRException e) {
            throw new ASMConfigurationException((Exception)((Object)e));
        }
        finally {
            if (bLockAcquired) {
                Trace.out((String)("Releasing shared CSS lock " + lockKey));
                try {
                    this.m_clusterLock.release(lockKey);
                }
                catch (ClusterLockException e) {
                    throw new ASMConfigurationException((Exception)((Object)e));
                }
            }
        }
    }

    public synchronized String[] getNodes() throws ASMConfigurationException {
        String[] nodeList;
        block13: {
            String asmRootKey = this.m_asmTreeDef.getASMRootKey();
            String lockKey = "SRVM.ASM." + asmRootKey;
            nodeList = null;
            boolean bLockAcquired = false;
            try {
                if (!this.m_ocr.keyExists(asmRootKey)) break block13;
                Trace.out((String)(asmRootKey + " does exist"));
                Trace.out((String)("Acquiring shared CSS lock " + lockKey));
                try {
                    this.m_clusterLock.acquireShared(lockKey);
                    bLockAcquired = true;
                }
                catch (ClusterLockException e) {
                    throw new ASMConfigurationException((Exception)((Object)e));
                }
                nodeList = this.m_ocr.listSubKeys(asmRootKey);
            }
            catch (OCRException e) {
                Object[] args = new String[]{e.getMessage()};
                String msg = this.m_msgBundle.getMessage("1039", true, args);
                throw new ASMConfigurationException(msg, (Exception)((Object)e));
            }
            finally {
                if (nodeList == null) {
                    nodeList = new String[]{};
                }
                if (bLockAcquired) {
                    Trace.out((String)("Releasing shared CSS lock " + lockKey));
                    try {
                        this.m_clusterLock.release(lockKey);
                    }
                    catch (ClusterLockException e) {
                        throw new ASMConfigurationException((Exception)((Object)e));
                    }
                }
            }
        }
        return nodeList;
    }

    public synchronized String getASMInstanceOracleHome(String instance, String node) throws ASMConfigurationException {
        String asmInstanceKey = this.m_asmTreeDef.getASMInstanceKey(instance, node);
        String lockKey = "SRVM.ASM." + asmInstanceKey;
        boolean bLockAcquired = false;
        try {
            if (!this.m_ocr.keyExists(asmInstanceKey)) {
                Trace.out((String)(asmInstanceKey + " does not exist"));
                Object[] args = new String[]{instance, node};
                String msg = this.m_msgBundle.getMessage("1028", true, args);
                Trace.out((String)("ASMInstanceNotExists:" + msg));
                throw new ASMConfigurationException(msg);
            }
            Trace.out((String)(asmInstanceKey + " does exist"));
            Trace.out((String)("Acquiring shared CSS lock " + lockKey));
            try {
                this.m_clusterLock.acquireShared(lockKey);
                bLockAcquired = true;
            }
            catch (ClusterLockException e) {
                throw new ASMConfigurationException((Exception)((Object)e));
            }
            String ohome = this.m_ocr.getKeyValue(this.m_asmTreeDef.getASMInstanceOHomeKey(instance, node));
            Trace.out((String)("getASMInstanceOracleHome:ohome=" + ohome));
            String msg = ohome;
            return msg;
        }
        catch (OCRException e) {
            Object[] args = new String[]{instance, node, e.getMessage()};
            String msg = this.m_msgBundle.getMessage("1035", true, args);
            throw new ASMConfigurationException(msg, (Exception)((Object)e));
        }
        finally {
            if (bLockAcquired) {
                Trace.out((String)("Releasing shared CSS lock " + lockKey));
                try {
                    this.m_clusterLock.release(lockKey);
                }
                catch (ClusterLockException e) {
                    throw new ASMConfigurationException((Exception)((Object)e));
                }
            }
        }
    }
}

