/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.asm.operation;

import java.io.Serializable;
import oracle.ops.mgmt.asm.ASMConfigurationException;
import oracle.ops.mgmt.asm.operation.ASMConfigurationResult;
import oracle.ops.mgmt.asm.operation.ASMTree;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.trace.Trace;

public class ASMInstanceEnableDisableOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = -7298492198926649893L;
    private String m_instance;
    private String m_node;
    private boolean m_bEnabled;

    public ASMInstanceEnableDisableOperation(String instance, String node, boolean bEnabled, Version version) {
        super(true, version);
        this.m_instance = instance;
        this.m_node = node;
        this.m_bEnabled = bEnabled;
    }

    public String getInstance() {
        return this.m_instance;
    }

    public String getNode() {
        return this.m_node;
    }

    public boolean isEnabled() {
        return this.m_bEnabled;
    }

    public OperationResult run() {
        ASMConfigurationResult result;
        try {
            ASMTree asmTree = ASMTree.init(this.getVersion());
            asmTree.setASMInstanceEnableDisable(this.m_instance, this.m_node, this.m_bEnabled);
            result = new ASMConfigurationResult(0);
        }
        catch (ASMConfigurationException e) {
            result = new ASMConfigurationResult(1, (Exception)((Object)e));
        }
        Trace.out((String)("result status " + result.getStatus()));
        return result;
    }
}

