/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.asm;

import java.util.Vector;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.ops.mgmt.asm.ASMConfigurationException;
import oracle.ops.mgmt.asm.ASMInstanceException;
import oracle.ops.mgmt.asm.ASMInstanceExistException;
import oracle.ops.mgmt.asm.ASMInstanceMode;
import oracle.ops.mgmt.asm.ASMInstanceNotExistException;
import oracle.ops.mgmt.asm.ASMInstanceNotRunningException;
import oracle.ops.mgmt.asm.ASMInstanceRunningException;
import oracle.ops.mgmt.asm.ASMLiterals;
import oracle.ops.mgmt.asm.operation.ASMConfigurationResult;
import oracle.ops.mgmt.asm.operation.ASMInstanceEnableDisableOperation;
import oracle.ops.mgmt.asm.operation.ASMInstanceExistOperation;
import oracle.ops.mgmt.asm.operation.ASMInstanceSPFileOperation;
import oracle.ops.mgmt.asm.operation.ASMTreeDefinition;
import oracle.ops.mgmt.asm.operation.AddASMInstanceConfigOperation;
import oracle.ops.mgmt.asm.operation.GetASMInstanceConfigOperation;
import oracle.ops.mgmt.asm.operation.RemoveASMInstanceConfigOperation;
import oracle.ops.mgmt.asm.operation.SetASMInstanceOraHomeOperation;
import oracle.ops.mgmt.asm.operation.ha.ASMModifyDepOperation;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.LocalCommand;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.database.Credentials;
import oracle.ops.mgmt.database.HAResourceStatus;
import oracle.ops.mgmt.database.InstanceException;
import oracle.ops.mgmt.database.ParallelServer;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.database.ParallelServerHA;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.ha.HAGetPermOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.operation.ha.HAProfileOperation;
import oracle.ops.mgmt.operation.ha.HARegisterOperation;
import oracle.ops.mgmt.operation.ha.HAStartOperation;
import oracle.ops.mgmt.operation.ha.HAStatusOperation;
import oracle.ops.mgmt.operation.ha.HAStopOperation;
import oracle.ops.mgmt.operation.ha.HAUnregisterOperation;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRTree;
import oracle.ops.mgmt.trace.Trace;

public class ASMInstance
implements ASMLiterals {
    private String m_instance;
    private String m_node;
    private String m_oracleHome;
    private String m_resource;
    private Version m_version;
    private MessageBundle m_msgBundle;

    public ASMInstance(String instance, String node, String oracleHome, Version version) {
        this.m_instance = instance;
        this.m_node = node;
        this.m_oracleHome = oracleHome;
        this.m_version = version;
        this.m_resource = ASMInstance.getResourceName(instance, node, version);
        this.m_msgBundle = MessageBundle.getMessageBundle((String)"Prks");
    }

    static String getResourceName(String instance, String node, Version v) {
        String resName = instance.startsWith("+") ? "ora." + node.toLowerCase() + "." + instance.substring("+".length()) + ".asm" : "ora." + node.toLowerCase() + "." + instance + ".asm";
        return resName;
    }

    public boolean exists() throws ASMInstanceException {
        ASMInstanceExistOperation existOp = new ASMInstanceExistOperation(this.m_instance, this.m_node, this.m_version);
        LocalCommand localCommand = new LocalCommand((Operation)existOp);
        localCommand.execute();
        ASMConfigurationResult result = (ASMConfigurationResult)localCommand.getOperationResult();
        if (result.getStatus() == 0) {
            return (Boolean)result.getResult();
        }
        throw new ASMInstanceException(result.getException());
    }

    public void create() throws ASMInstanceExistException, ASMInstanceException {
        this.create(null, new ASMInstanceMode(true), true, null);
    }

    public void create(String spfile, ASMInstanceMode mode, boolean bEnabled, String[] env) throws ASMInstanceExistException, ASMInstanceException {
        if (this.exists()) {
            Object[] args = new String[]{this.m_instance, this.m_node};
            String msg = this.m_msgBundle.getMessage("1000", true, args);
            Trace.out((String)("ASMInstanceExists:" + msg));
            throw new ASMInstanceExistException(this.m_instance, this.m_node, this.m_oracleHome, msg);
        }
        if (!this.m_instance.startsWith("+")) {
            Object[] args = new String[]{this.m_instance, "+"};
            throw new ASMInstanceException(this.m_msgBundle.getMessage("1041", true, args));
        }
        Trace.out((String)("Creating profile for " + this.m_resource + " on " + this.m_node));
        this.createProfile();
        this.registerProfile();
        AddASMInstanceConfigOperation addConfigOp = new AddASMInstanceConfigOperation(this.m_instance, this.m_node, this.m_oracleHome, spfile, mode.getModeString(), bEnabled, env, this.m_version);
        LocalCommand localCommand = new LocalCommand((Operation)addConfigOp);
        localCommand.execute();
        ASMConfigurationResult result = (ASMConfigurationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            try {
                this.unregisterProfile(true);
            }
            catch (ASMInstanceException e) {
                Trace.out((Exception)((Object)e));
            }
            throw new ASMInstanceException(result.getException());
        }
    }

    public void start(ASMInstanceMode mode, Credentials creds, String paramFile) throws ASMInstanceNotExistException, ASMInstanceRunningException, ASMInstanceException {
        HAStartOperation startOp;
        if (this.isRunning()) {
            Object[] args = new String[]{this.m_instance, this.m_node};
            String msg = this.m_msgBundle.getMessage("1006", false, args);
            Trace.out((String)("ASMInstanceRunning:" + msg));
            ASMInstanceRunningException exception = new ASMInstanceRunningException(this.m_instance, this.m_node, this.m_oracleHome);
            exception.setMessage(msg);
            throw exception;
        }
        boolean disabled = false;
        try {
            disabled = !this.isEnabled();
        }
        catch (ASMConfigurationException e) {
            throw new ASMInstanceException(e.getMessage(), (Exception)((Object)e));
        }
        if (disabled) {
            Object[] args = new String[]{this.m_instance};
            MessageBundle pmsgBundle = MessageBundle.getMessageBundle((String)"Prkp");
            String msg = pmsgBundle.getMessage("1020", true, args);
            Trace.out((String)("ASMInstance disabled: " + msg));
            throw new ASMInstanceException(msg);
        }
        try {
            startOp = new HAStartOperation(this.m_resource, mode.getModeString(), paramFile, creds, this.m_version);
        }
        catch (HAOperationException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        LocalCommand localCommand = new LocalCommand((Operation)startOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Object[] args = new String[]{this.m_instance, this.m_node, result.getOutputAll()};
            String msg = this.m_msgBundle.getMessage("1009", true, args);
            Trace.out((String)("Start failed:" + msg));
            throw new ASMInstanceException(msg);
        }
    }

    public boolean isRunning() throws ASMInstanceException {
        return this.getResourceStatus().isOnline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(String dbName, String dbInstance, boolean bModify) throws InstanceException, ASMInstanceNotExistException, ASMInstanceException {
        block5: {
            ConfigurationException exception = null;
            try {
                ParallelServer ps = Cluster.getParallelServer((String)dbName, null, (Version)this.m_version);
                ParallelServerConfig psConfig = ps.getConfiguration();
                this.modify(psConfig, dbInstance, bModify);
            }
            catch (ConfigurationException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block5;
                throw new InstanceException(exception.getMessage());
            }
        }
    }

    public void modify(ParallelServerConfig psConfig, String dbInstance, boolean bModify) throws ASMInstanceNotExistException, ASMInstanceException {
        ASMModifyDepOperation modifyOp;
        if (!this.exists()) {
            Object[] args = new String[]{this.m_instance, this.m_node};
            String msg = this.m_msgBundle.getMessage("1001", true, args);
            Trace.out((String)("ASMInstanceNotExists:" + msg));
            throw new ASMInstanceNotExistException(this.m_instance, msg);
        }
        boolean iscrsuser = false;
        if (!Version.isPre112((Version)Cluster.getVersion())) {
            try {
                iscrsuser = CRSFactoryImpl.getInstance().hasCrsAdminRole();
            }
            catch (CRSException crse) {
                throw new ASMInstanceException((Exception)((Object)crse));
            }
        }
        try {
            if (!iscrsuser) {
                new Util().checkOracleUser(psConfig.getOracleHome());
            }
        }
        catch (UtilException e) {
            throw new ASMInstanceException(e.getMessage());
        }
        Object exception = null;
        String instNode = psConfig.getNode(dbInstance);
        if (!this.m_node.equals(instNode)) {
            Object[] args = new String[]{dbInstance, instNode, this.m_instance, this.m_node};
            String msg = this.m_msgBundle.getMessage("1019", true, args);
            Trace.out((String)("Modify failed:" + msg));
            throw new ASMInstanceException(msg);
        }
        String dbInstanceResource = ParallelServerHA.getInstResourceName((String)psConfig.getName(), (String)dbInstance, (ParallelServerConfig)psConfig);
        try {
            modifyOp = new ASMModifyDepOperation(dbInstanceResource, this.m_resource, bModify, this.m_version);
        }
        catch (HAOperationException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        HAOperationResult result = (HAOperationResult)modifyOp.run();
        if (result.getStatus() != 0) {
            Object[] args = new String[]{dbInstance, this.m_instance, result.getOutputAll()};
            String msg = this.m_msgBundle.getMessage(bModify ? "1020" : "1021", true, args);
            Trace.out((String)("Modify failed:" + msg));
            throw new ASMInstanceException(msg);
        }
    }

    public void stop(ASMInstanceMode mode, Credentials creds) throws ASMInstanceNotRunningException, ASMInstanceException {
        HAStopOperation stopOp;
        HAResourceStatus stat = this.getResourceStatus();
        if (!(stat.isTargetOnline() || stat.isOnline() || stat.isUnknown())) {
            Object[] args = new String[]{this.m_instance, this.m_node};
            String msg = this.m_msgBundle.getMessage("1008", false, args);
            Trace.out((String)("ASMInstanceRunning:" + msg));
            ASMInstanceNotRunningException exception = new ASMInstanceNotRunningException(this.m_instance, this.m_node, this.m_oracleHome);
            exception.setMessage(msg);
            throw exception;
        }
        try {
            stopOp = new HAStopOperation(this.m_resource, mode.getModeString(), creds, this.m_version);
        }
        catch (HAOperationException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        LocalCommand localCommand = new LocalCommand((Operation)stopOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Object[] args = new String[]{this.m_instance, this.m_node, result.getOutputAll()};
            String msg = this.m_msgBundle.getMessage("1012", true, args);
            Trace.out((String)("Stop failed:" + msg));
            throw new ASMInstanceException(msg);
        }
    }

    public void enable() throws ASMInstanceNotExistException, ASMInstanceException {
        this.setEnableDisable(true);
    }

    public void disable() throws ASMInstanceNotExistException, ASMInstanceException {
        this.setEnableDisable(false);
    }

    public boolean isEnabled() throws ASMConfigurationException, ASMInstanceException {
        GetASMInstanceConfigOperation configOp = new GetASMInstanceConfigOperation(this.m_instance, this.m_node, this.m_version);
        LocalCommand localCommand = new LocalCommand((Operation)configOp);
        localCommand.execute();
        ASMConfigurationResult result = (ASMConfigurationResult)localCommand.getOperationResult();
        if (result.getStatus() == 0) {
            boolean bEnabled = result.isEnabled();
            Trace.out((String)("bEnabled=" + bEnabled));
            return bEnabled;
        }
        throw (ASMConfigurationException)((Object)result.getException());
    }

    public void setOracleHome(String oracleHome) throws ASMInstanceNotExistException, ASMInstanceRunningException, ASMInstanceException {
        Object result;
        LocalCommand localCommand;
        if (oracleHome == null || oracleHome.trim().length() == 0) {
            throw new ASMInstanceException(MessageBundle.getMessageBundle((String)"Prkc").getMessage("1076", true));
        }
        if (!this.exists()) {
            Object[] args = new String[]{this.m_instance, this.m_node};
            String msg = this.m_msgBundle.getMessage("1028", true, args);
            Trace.out((String)("ASMInstanceNotExists:" + msg));
            throw new ASMInstanceNotExistException(this.m_instance, msg);
        }
        boolean iscrsuser = false;
        if (!Version.isPre112((Version)Cluster.getVersion())) {
            try {
                iscrsuser = CRSFactoryImpl.getInstance().hasCrsAdminRole();
            }
            catch (CRSException crse) {
                throw new ASMInstanceException((Exception)((Object)crse));
            }
        }
        try {
            if (!iscrsuser) {
                new Util().checkOracleUser(this.m_oracleHome, OCRTree.init((Version)this.m_version).getUserName(new ASMTreeDefinition().getASMInstanceKey(this.m_instance, this.m_node)));
            }
        }
        catch (UtilException e) {
            throw new ASMInstanceException(e.getMessage(), (Exception)((Object)e));
        }
        catch (OCRException e) {
            throw new ASMInstanceException(e.getMessage(), (Exception)((Object)e));
        }
        if (this.isRunning()) {
            Object[] args = new String[]{this.m_instance, this.m_node};
            String msg = this.m_msgBundle.getMessage("1007", false, args);
            Trace.out((String)("ASMInstanceRunning:" + msg));
            ASMInstanceRunningException exception = new ASMInstanceRunningException(this.m_instance, this.m_node, this.m_oracleHome);
            exception.setMessage(msg);
            throw exception;
        }
        String originalOH = this.m_oracleHome;
        this.m_oracleHome = oracleHome;
        Trace.out((String)("Creating profile for " + this.m_resource + " on " + this.m_node));
        this.createProfile();
        try {
            HARegisterOperation registerOp = new HARegisterOperation(this.m_resource, true, this.m_version);
            localCommand = new LocalCommand((Operation)registerOp);
            localCommand.execute();
            result = (HAOperationResult)localCommand.getOperationResult();
            if (result.getStatus() != 0) {
                Object[] args = new String[]{this.m_instance, this.m_node, result.getOutputAll()};
                String msg = this.m_msgBundle.getMessage("1003", true, args);
                Trace.out((String)("HARegisterOperation failed: " + msg));
                throw new ASMInstanceException(msg);
            }
        }
        catch (HAOperationException e) {
            Object[] args = new String[]{this.m_instance, this.m_node, e.getMessage()};
            String msg = this.m_msgBundle.getMessage("1003", true, args);
            throw new ASMInstanceException(msg, (Exception)((Object)e));
        }
        SetASMInstanceOraHomeOperation setOraHomeOp = new SetASMInstanceOraHomeOperation(this.m_instance, this.m_node, oracleHome, this.m_version);
        localCommand = new LocalCommand((Operation)setOraHomeOp);
        localCommand.execute();
        result = (ASMConfigurationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            try {
                this.m_oracleHome = originalOH;
                this.createProfile();
                HARegisterOperation registerOp = new HARegisterOperation(this.m_resource, true, this.m_version);
                localCommand = new LocalCommand((Operation)registerOp);
                localCommand.execute();
                HAOperationResult result2 = (HAOperationResult)localCommand.getOperationResult();
                Trace.out((String)("Undo ORACLE_HOME update status=" + result2.getStatus()));
            }
            catch (ASMInstanceException registerOp) {
            }
            catch (HAOperationException registerOp) {
                // empty catch block
            }
            Object[] args = new String[]{oracleHome, this.m_instance, this.m_node, ((ASMConfigurationResult)result).getError()};
            String msg = this.m_msgBundle.getMessage("1040", true, args);
            throw new ASMInstanceException(msg, result.getException());
        }
    }

    public void setSPFile(String spfile) throws ASMInstanceNotExistException, ASMInstanceException {
        if (!this.exists()) {
            Object[] args = new String[]{this.m_instance, this.m_node};
            String msg = this.m_msgBundle.getMessage("1001", true, args);
            Trace.out((String)("ASMInstanceNotExists:" + msg));
            throw new ASMInstanceNotExistException(this.m_instance, msg);
        }
        boolean iscrsuser = false;
        if (!Version.isPre112((Version)Cluster.getVersion())) {
            try {
                iscrsuser = CRSFactoryImpl.getInstance().hasCrsAdminRole();
            }
            catch (CRSException crse) {
                throw new ASMInstanceException((Exception)((Object)crse));
            }
        }
        try {
            if (!iscrsuser) {
                new Util().checkOracleUser(this.m_oracleHome);
            }
        }
        catch (UtilException e) {
            throw new ASMInstanceException(e.getMessage());
        }
        ASMInstanceSPFileOperation spfileOp = new ASMInstanceSPFileOperation(this.m_instance, this.m_node, spfile, this.m_version);
        LocalCommand localCommand = new LocalCommand((Operation)spfileOp);
        localCommand.execute();
        ASMConfigurationResult result = (ASMConfigurationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Object[] args = new String[]{spfile, this.m_instance, this.m_node, result.getError()};
            String msg = this.m_msgBundle.getMessage("1038", true, args);
            throw new ASMInstanceException(msg, result.getException());
        }
    }

    public void remove(boolean force) throws ASMInstanceRunningException, ASMInstanceException {
        LocalCommand localCommand;
        StringBuffer stagedExceptionMesgs = new StringBuffer();
        boolean iscrsuser = false;
        if (!Version.isPre112((Version)Cluster.getVersion())) {
            try {
                iscrsuser = CRSFactoryImpl.getInstance().hasCrsAdminRole();
            }
            catch (CRSException crse) {
                throw new ASMInstanceException((Exception)((Object)crse));
            }
        }
        try {
            if (this.exists()) {
                if (!iscrsuser) {
                    new Util().checkOracleUser(this.m_oracleHome, OCRTree.init((Version)this.m_version).getUserName(new ASMTreeDefinition().getASMInstanceKey(this.m_instance, this.m_node)));
                }
            } else {
                HAGetPermOperation operation = new HAGetPermOperation(this.m_resource, this.m_version);
                localCommand = new LocalCommand((Operation)operation);
                localCommand.execute();
                HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
                if (!iscrsuser) {
                    if (result.getStatus() == 0) {
                        new Util().checkOracleUser(this.m_oracleHome, operation.getUserName());
                    } else {
                        new Util().checkOracleUser(this.m_oracleHome);
                    }
                }
            }
        }
        catch (UtilException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        catch (OCRException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        catch (HAOperationException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        try {
            HAResourceStatus stat = this.getResourceStatus();
            if (!force && stat.isTargetOnline() && stat.isOnline()) {
                Object[] args = new String[]{this.m_instance, this.m_node};
                String msg = this.m_msgBundle.getMessage("1007", false, args);
                Trace.out((String)("ASMInstanceRunning:" + msg));
                ASMInstanceRunningException exception = new ASMInstanceRunningException(this.m_instance, this.m_node, this.m_oracleHome);
                exception.setMessage(msg);
                throw exception;
            }
            if (force && (stat.isTargetOnline() && !stat.isOnline() || !stat.isTargetOnline() && (stat.isOnline() || stat.isUnknown()))) {
                Credentials creds = new Credentials();
                Version version = Version.get102Version();
                if (this.m_version.getMajorVersion().compareTo(version.getMajorVersion()) > 0) {
                    creds.setRole(3);
                }
                this.stop(new ASMInstanceMode(false), creds);
            }
        }
        catch (ASMInstanceRunningException e) {
            if (force) {
                stagedExceptionMesgs.append(System.getProperty("line.separator"));
                stagedExceptionMesgs.append(e.getMessage());
            }
            throw e;
        }
        catch (ASMInstanceException e) {
            if (force) {
                stagedExceptionMesgs.append(System.getProperty("line.separator"));
                stagedExceptionMesgs.append(e.getMessage());
            }
            throw e;
        }
        try {
            this.unregisterProfile(force);
        }
        catch (ASMInstanceException e) {
            if (force) {
                stagedExceptionMesgs.append(System.getProperty("line.separator"));
                stagedExceptionMesgs.append(e.getMessage());
            }
            throw e;
        }
        RemoveASMInstanceConfigOperation removeOp = new RemoveASMInstanceConfigOperation(this.m_instance, this.m_node, this.m_version);
        localCommand = new LocalCommand((Operation)removeOp);
        localCommand.execute();
        ASMConfigurationResult asmConfigResult = (ASMConfigurationResult)localCommand.getOperationResult();
        if (asmConfigResult.getStatus() != 0) {
            if (force) {
                stagedExceptionMesgs.append(System.getProperty("line.separator"));
                stagedExceptionMesgs.append(asmConfigResult.getException().getMessage());
            } else {
                throw new ASMInstanceException(asmConfigResult.getException());
            }
        }
        if (stagedExceptionMesgs.length() > 0) {
            throw new ASMInstanceException(stagedExceptionMesgs.toString());
        }
    }

    void createProfile() throws ASMInstanceException {
        HAProfileOperation profileOp;
        try {
            Cluster.getHostName((String)this.m_node);
            profileOp = new HAProfileOperation(this.m_resource, this.m_oracleHome, "asm", this.m_node, this.m_version);
        }
        catch (ClusterException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        catch (HAOperationException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        Trace.out((String)("Generating profile for " + this.m_resource + " on " + this.m_node));
        LocalCommand localCommand = new LocalCommand((Operation)profileOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Object[] args = new String[]{this.m_instance, this.m_node, result.getOutputAll()};
            String msg = this.m_msgBundle.getMessage("1002", true, args);
            Trace.out((String)("ASMInstance: profile operation failed: " + msg));
            throw new ASMInstanceException(msg);
        }
    }

    void registerProfile() throws ASMInstanceException {
        try {
            HARegisterOperation registerOp = new HARegisterOperation(this.m_resource, this.m_version);
            LocalCommand localCommand = new LocalCommand((Operation)registerOp);
            localCommand.execute();
            HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
            if (result.getStatus() != 0) {
                Object[] args = new String[]{this.m_instance, this.m_node, result.getOutputAll()};
                String msg = this.m_msgBundle.getMessage("1003", true, args);
                Trace.out((String)("HARegisterOperation failed: " + msg));
                throw new ASMInstanceException(msg);
            }
        }
        catch (HAOperationException e) {
            Object[] args = new String[]{this.m_instance, this.m_node, e.getMessage()};
            String msg = this.m_msgBundle.getMessage("1005", true, args);
            throw new ASMInstanceException(msg, (Exception)((Object)e));
        }
    }

    private void unregisterProfile(boolean force) throws ASMInstanceException {
        HAUnregisterOperation unRegOp;
        try {
            unRegOp = new HAUnregisterOperation(this.m_resource, this.m_version, force);
        }
        catch (HAOperationException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        Trace.out((String)("Unregistering ASM Instance with resource name " + this.m_resource + " on node " + this.m_node));
        LocalCommand localCommand = new LocalCommand((Operation)unRegOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Object[] args = new String[]{this.m_instance, this.m_node, result.getOutputAll()};
            String msg = this.m_msgBundle.getMessage("1023", true, args);
            throw new ASMInstanceException(msg);
        }
    }

    private void setEnableDisable(boolean bEnabled) throws ASMInstanceNotExistException, ASMInstanceException {
        if (!this.exists()) {
            Object[] args = new String[]{this.m_instance, this.m_node};
            String msg = this.m_msgBundle.getMessage("1001", true, args);
            Trace.out((String)("ASMInstanceNotExists:" + msg));
            throw new ASMInstanceNotExistException(this.m_instance, msg);
        }
        boolean iscrsuser = false;
        if (!Version.isPre112((Version)Cluster.getVersion())) {
            try {
                iscrsuser = CRSFactoryImpl.getInstance().hasCrsAdminRole();
            }
            catch (CRSException crse) {
                throw new ASMInstanceException((Exception)((Object)crse));
            }
        }
        try {
            if (!iscrsuser) {
                new Util().checkOracleUser(this.m_oracleHome);
            }
        }
        catch (UtilException e) {
            throw new ASMInstanceException(e.getMessage());
        }
        ASMInstanceEnableDisableOperation enableDisableOp = new ASMInstanceEnableDisableOperation(this.m_instance, this.m_node, bEnabled, this.m_version);
        LocalCommand localCommand = new LocalCommand((Operation)enableDisableOp);
        localCommand.execute();
        ASMConfigurationResult result = (ASMConfigurationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Object[] args = new String[]{this.m_instance, this.m_node, result.getError()};
            String msg = this.m_msgBundle.getMessage(bEnabled ? "1014" : "1016", true, args);
            Trace.out((String)("setEnableDisable failed:" + msg));
            throw new ASMInstanceException(msg, result.getException());
        }
    }

    protected HAResourceStatus getResourceStatus() throws ASMInstanceException {
        HAStatusOperation statOp;
        try {
            statOp = new HAStatusOperation(this.m_resource, this.m_version);
        }
        catch (HAOperationException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        LocalCommand localCommand = new LocalCommand((Operation)statOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Object[] args = new String[]{this.m_instance, this.m_node, result.getOutputAll()};
            String msg = this.m_msgBundle.getMessage("1011", true, args);
            Trace.out((String)("HAStatusOperation failed:" + msg));
            throw new ASMInstanceException(msg);
        }
        String[] statOutput = result.getOutput();
        Vector stats = HAResourceStatus.parseHAStatusOutput((String[])statOutput);
        HAResourceStatus stat = (HAResourceStatus)stats.elementAt(0);
        return stat;
    }
}

