/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.asm;

import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.ops.mgmt.asm.ASMConfigurationException;
import oracle.ops.mgmt.asm.ASMInstance;
import oracle.ops.mgmt.asm.ASMInstanceException;
import oracle.ops.mgmt.asm.ASMInstanceMode;
import oracle.ops.mgmt.asm.ASMInstanceNotExistException;
import oracle.ops.mgmt.asm.ASMInstanceNotRunningException;
import oracle.ops.mgmt.asm.ASMInstanceRunningException;
import oracle.ops.mgmt.asm.operation.ASMConfigurationResult;
import oracle.ops.mgmt.asm.operation.GetASMInstanceListOperation;
import oracle.ops.mgmt.asm.operation.GetASMInstanceNodeListOperation;
import oracle.ops.mgmt.asm.operation.GetASMInstanceOraHomeOperation;
import oracle.ops.mgmt.asm.operation.GetASMNodeListOperation;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.LocalCommand;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.database.Credentials;
import oracle.ops.mgmt.database.HAResourceStatus;
import oracle.ops.mgmt.database.InstanceException;
import oracle.ops.mgmt.database.ParallelServer;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.config.NodeApps;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.operation.ha.HAStatusOperation;
import oracle.ops.mgmt.trace.Trace;

public class ASM {
    static final String s_newline = System.getProperty("line.separator");

    private ASM() {
    }

    public static String[] getNodes(Version version) throws ASMConfigurationException {
        GetASMNodeListOperation getNodeListOp = new GetASMNodeListOperation(version);
        LocalCommand localCommand = new LocalCommand((Operation)getNodeListOp);
        localCommand.execute();
        ASMConfigurationResult result = (ASMConfigurationResult)localCommand.getOperationResult();
        if (result.getStatus() == 0) {
            return (String[])result.getResult();
        }
        throw (ASMConfigurationException)((Object)result.getException());
    }

    public static String[] getInstances(String node, Version version) throws ASMConfigurationException {
        GetASMInstanceListOperation getInstListOp = new GetASMInstanceListOperation(node, version);
        LocalCommand localCommand = new LocalCommand((Operation)getInstListOp);
        localCommand.execute();
        ASMConfigurationResult result = (ASMConfigurationResult)localCommand.getOperationResult();
        if (result.getStatus() == 0) {
            return (String[])result.getResult();
        }
        throw (ASMConfigurationException)((Object)result.getException());
    }

    public static String getOracleHome(String instance, String node, Version version) throws ASMInstanceNotExistException, ASMConfigurationException {
        GetASMInstanceOraHomeOperation getOraHomeOp = new GetASMInstanceOraHomeOperation(instance, node, version);
        LocalCommand localCommand = new LocalCommand((Operation)getOraHomeOp);
        localCommand.execute();
        ASMConfigurationResult result = (ASMConfigurationResult)localCommand.getOperationResult();
        if (result.getStatus() == 0) {
            return (String)result.getResult();
        }
        ASMConfigurationException exp = (ASMConfigurationException)((Object)result.getException());
        String resName = ASMInstance.getResourceName(instance, node, version);
        try {
            return new NodeApps(null, version).getOracleHome(resName);
        }
        catch (NodeException e) {
            exp.setMessage(exp.getMessage() + s_newline + e.getMessage());
            throw exp;
        }
    }

    public static void setOracleHome(String asmInstance, String oracleHome, Version version) throws ASMInstanceNotExistException, ASMInstanceRunningException, ASMConfigurationException, ASMInstanceException {
        GetASMInstanceNodeListOperation getNodeListOp = new GetASMInstanceNodeListOperation(asmInstance, version);
        LocalCommand localCommand = new LocalCommand((Operation)getNodeListOp);
        localCommand.execute();
        ASMConfigurationResult result = (ASMConfigurationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            ASMInstanceNotExistException e = new ASMInstanceNotExistException(asmInstance);
            e.setException((Exception)((Object)((ASMConfigurationException)((Object)result.getException()))));
            throw e;
        }
        String[] nodeList = (String[])result.getResult();
        String asmInstanceNode = nodeList[0];
        Trace.out((String)("asmInstanceNode =" + asmInstanceNode));
        String currentOH = ASM.getOracleHome(asmInstance, asmInstanceNode, version);
        Trace.out((String)("currentOH =" + currentOH));
        ASMInstance asmInst = new ASMInstance(asmInstance, asmInstanceNode, currentOH, version);
        asmInst.setOracleHome(oracleHome);
    }

    public static void setSPFile(String instance, String spfile, Version version) throws ASMInstanceNotExistException, ASMConfigurationException, ASMInstanceException {
        GetASMInstanceNodeListOperation getNodeListOp = new GetASMInstanceNodeListOperation(instance, version);
        LocalCommand localCommand = new LocalCommand((Operation)getNodeListOp);
        localCommand.execute();
        ASMConfigurationResult result = (ASMConfigurationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            ASMInstanceNotExistException e = new ASMInstanceNotExistException(instance);
            e.setException((Exception)((Object)((ASMConfigurationException)((Object)result.getException()))));
            throw e;
        }
        String[] nodeList = (String[])result.getResult();
        String asmInstanceNode = nodeList[0];
        Trace.out((String)("asmInstanceNode =" + asmInstanceNode));
        String oracleHome = ASM.getOracleHome(instance, asmInstanceNode, version);
        Trace.out((String)(instance + " has OH=" + oracleHome));
        ASMInstance asmInst = new ASMInstance(instance, asmInstanceNode, oracleHome, version);
        asmInst.setSPFile(spfile);
    }

    public static void start(String node) throws ASMInstanceNotExistException, ASMInstanceException {
        ASM.start(node, new Credentials(), new ASMInstanceMode(true), new Version());
    }

    public static void start(String node, Credentials creds, ASMInstanceMode mode, Version version) throws ASMInstanceNotExistException, ASMInstanceException {
        String[] instanceList;
        try {
            instanceList = ASM.getInstances(node, version);
        }
        catch (ASMConfigurationException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        Object exception = null;
        Vector<String> failList = new Vector<String>(instanceList.length);
        Trace.out((String)("instanceList.length=" + instanceList.length));
        for (int i = 0; i < instanceList.length; ++i) {
            try {
                String oracleHome = ASM.getOracleHome(instanceList[i], node, version);
                Trace.out((String)(instanceList[i] + " has OH=" + oracleHome));
                ASMInstance asmInstance = new ASMInstance(instanceList[i], node, oracleHome, version);
                asmInstance.start(mode, creds, null);
                continue;
            }
            catch (ASMConfigurationException e) {
                failList.addElement(instanceList[i]);
                exception = e;
                Trace.out((Exception)((Object)e));
                continue;
            }
            catch (ASMInstanceRunningException e) {
                Trace.out((Exception)((Object)e));
                continue;
            }
            catch (ASMInstanceException e) {
                failList.addElement(instanceList[i]);
                exception = e;
            }
        }
        if (!failList.isEmpty()) {
            Object[] args = new String[]{failList.size() == 1 ? (String)failList.elementAt(0) : failList.toString(), node, ((Throwable)exception).getMessage()};
            String msg = MessageBundle.getMessageBundle((String)"Prks").getMessage(failList.size() == 1 ? "1009" : "1010", true, args);
            Trace.out((String)("Start failed:" + msg));
            throw new ASMInstanceException(msg, (Exception)exception);
        }
    }

    public static void modify(String dbName, String dbInstance, String asmInstance) throws InstanceException, ASMInstanceNotExistException, ASMInstanceException {
        ASM.modify(dbName, dbInstance, asmInstance, new Version());
    }

    public static void modify(String dbName, String dbInstance, String asmInstance, Version version) throws InstanceException, ASMInstanceNotExistException, ASMInstanceException {
        block19: {
            Object exception = null;
            Trace.out((String)("version = " + version.toString()));
            try {
                String[] instanceList;
                ParallelServer ps = Cluster.getParallelServer((String)dbName, null, (Version)version);
                if (ps == null) {
                    Object[] args = new String[]{dbName};
                    String msg = MessageBundle.getMessageBundle((String)"Prkp").getMessage("1000", true, args);
                    Trace.out((String)("modify failed:" + msg));
                    throw new ConfigurationException(msg);
                }
                ParallelServerConfig psConfig = ps.getConfiguration();
                String node = psConfig.getNode(dbInstance);
                Trace.out((String)("database instance=" + dbInstance + " is configured on node=" + node));
                if (asmInstance != null) {
                    GetASMInstanceNodeListOperation getNodeListOp = new GetASMInstanceNodeListOperation(asmInstance, version);
                    LocalCommand localCommand = new LocalCommand((Operation)getNodeListOp);
                    localCommand.execute();
                    ASMConfigurationResult result = (ASMConfigurationResult)localCommand.getOperationResult();
                    if (result.getStatus() != 0) {
                        ASMInstanceNotExistException e = new ASMInstanceNotExistException(asmInstance);
                        e.setException((Exception)((Object)((ASMConfigurationException)((Object)result.getException()))));
                        throw e;
                    }
                    String[] nodeList = (String[])result.getResult();
                    String asmInstanceNode = null;
                    if (nodeList.length == 1) {
                        asmInstanceNode = nodeList[0];
                    } else {
                        for (int i = 0; i < nodeList.length; ++i) {
                            if (!nodeList[i].equalsIgnoreCase(node)) continue;
                            asmInstanceNode = nodeList[i];
                            break;
                        }
                        if (asmInstanceNode == null) {
                            asmInstanceNode = nodeList[0];
                        }
                    }
                    Trace.out((String)("asmInstanceNode =" + asmInstanceNode));
                    try {
                        String oracleHome = ASM.getOracleHome(asmInstance, asmInstanceNode, version);
                        Trace.out((String)(asmInstance + " has OH=" + oracleHome));
                        ASMInstance asmInst = new ASMInstance(asmInstance, asmInstanceNode, oracleHome, version);
                        asmInst.modify(psConfig, dbInstance, true);
                        break block19;
                    }
                    catch (ASMConfigurationException e) {
                        throw new ASMInstanceException((Exception)((Object)e));
                    }
                }
                try {
                    instanceList = ASM.getInstances(node, version);
                }
                catch (ASMConfigurationException e) {
                    throw new ASMInstanceException((Exception)((Object)e));
                }
                Vector<String> failList = new Vector<String>(instanceList.length);
                Trace.out((String)("instanceList.length=" + instanceList.length));
                for (int i = 0; i < instanceList.length; ++i) {
                    try {
                        String oracleHome = ASM.getOracleHome(instanceList[i], node, version);
                        Trace.out((String)(instanceList[i] + " has OH=" + oracleHome));
                        ASMInstance asmInst = new ASMInstance(instanceList[i], node, oracleHome, version);
                        asmInst.modify(psConfig, dbInstance, false);
                        continue;
                    }
                    catch (ASMConfigurationException e) {
                        failList.addElement(instanceList[i]);
                        exception = e;
                        Trace.out((Exception)((Object)e));
                        continue;
                    }
                    catch (ASMInstanceNotExistException e) {
                        Trace.out((Exception)((Object)e));
                        continue;
                    }
                    catch (ASMInstanceException e) {
                        failList.addElement(instanceList[i]);
                        exception = e;
                    }
                }
                if (!failList.isEmpty()) {
                    Object[] args = new String[]{dbInstance, failList.size() == 1 ? (String)failList.elementAt(0) : failList.toString(), ((Throwable)exception).getMessage()};
                    String msg = MessageBundle.getMessageBundle((String)"Prks").getMessage(failList.size() == 1 ? "1021" : "1022", true, args);
                    Trace.out((String)("Remove dep failed:" + msg));
                    throw new ASMInstanceException(msg, (Exception)exception);
                }
            }
            catch (ConfigurationException e) {
                throw new InstanceException(((Throwable)exception).getMessage(), (Throwable)e);
            }
        }
    }

    public static void stop(String node) throws ASMInstanceNotExistException, ASMInstanceException {
        ASM.stop(node, new Credentials(), new ASMInstanceMode(false), new Version());
    }

    public static void stop(String node, Credentials creds, ASMInstanceMode mode, Version version) throws ASMInstanceException {
        String[] instanceList;
        try {
            instanceList = ASM.getInstances(node, version);
        }
        catch (ASMConfigurationException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        Object exception = null;
        Vector<String> failList = new Vector<String>(instanceList.length);
        Trace.out((String)("instanceList.length=" + instanceList.length));
        for (int i = 0; i < instanceList.length; ++i) {
            try {
                String oracleHome = ASM.getOracleHome(instanceList[i], node, version);
                Trace.out((String)(instanceList[i] + " has OH=" + oracleHome));
                ASMInstance asmInstance = new ASMInstance(instanceList[i], node, oracleHome, version);
                asmInstance.stop(mode, creds);
                continue;
            }
            catch (ASMConfigurationException e) {
                failList.addElement(instanceList[i]);
                exception = e;
                Trace.out((Exception)((Object)e));
                continue;
            }
            catch (ASMInstanceNotRunningException e) {
                Trace.out((Exception)((Object)e));
                continue;
            }
            catch (ASMInstanceException e) {
                failList.addElement(instanceList[i]);
                exception = e;
            }
        }
        if (!failList.isEmpty()) {
            Object[] args = new String[]{failList.size() == 1 ? (String)failList.elementAt(0) : failList.toString(), node, ((Throwable)exception).getMessage()};
            String msg = MessageBundle.getMessageBundle((String)"Prks").getMessage(failList.size() == 1 ? "1012" : "1013", true, args);
            Trace.out((String)("Stop failed:" + msg));
            throw new ASMInstanceException(msg, (Exception)exception);
        }
    }

    public static void enable(String node) throws ASMInstanceNotExistException, ASMInstanceException {
        ASM.setEnableDisable(node, true);
    }

    public static void disable(String node) throws ASMInstanceNotExistException, ASMInstanceException {
        ASM.setEnableDisable(node, false);
    }

    public static void remove(String node, boolean force) throws ASMInstanceException {
        String[] instanceList;
        Version version = new Version();
        try {
            instanceList = ASM.getInstances(node, version);
        }
        catch (ASMConfigurationException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        ASMInstanceException exception = null;
        StringBuffer stagedExceptionMesgs = new StringBuffer();
        Vector<String> failList = new Vector<String>(instanceList.length);
        Trace.out((String)("instanceList.length=" + instanceList.length));
        if (force && instanceList.length == 0) {
            try {
                LocalCommand localCommand = new LocalCommand((Operation)new HAStatusOperation(version));
                localCommand.execute();
                HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
                if (result.getStatus() != 0) {
                    Trace.out((String)"Stat operation failed");
                    String msg = result.getOutputSingle() + s_newline + result.getError();
                    stagedExceptionMesgs.append(msg);
                }
                Vector vResourceStats = HAResourceStatus.parseHAStatusOutput((String[])result.getOutput());
                Pattern pattern = Pattern.compile("ora." + node + "." + "*" + "." + "asm");
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < vResourceStats.size(); ++i) {
                    String resName = ((HAResourceStatus)vResourceStats.elementAt(i)).getResourceName();
                    if (!pattern.matcher(resName).matches()) continue;
                    String[] resCompNames = resName.replace('.', ':').split(":");
                    list.add(resCompNames[resCompNames.length - 2]);
                }
                if (list.size() > 0) {
                    instanceList = new String[list.size()];
                    list.toArray(instanceList);
                }
            }
            catch (HAOperationException e) {
                stagedExceptionMesgs.append(s_newline + e.getMessage());
            }
        }
        for (int i = 0; i < instanceList.length; ++i) {
            try {
                String oracleHome = ASM.getOracleHome(instanceList[i], node, version);
                Trace.out((String)(instanceList[i] + " has OH=" + oracleHome));
                ASMInstance asmInstance = new ASMInstance(instanceList[i], node, oracleHome, version);
                asmInstance.remove(force);
                continue;
            }
            catch (ASMConfigurationException e) {
                Trace.out((Exception)((Object)e));
                continue;
            }
            catch (ASMInstanceRunningException e) {
                failList.addElement(instanceList[i]);
                if (force) {
                    stagedExceptionMesgs.append(s_newline + e.getMessage());
                }
                exception = e;
                continue;
            }
            catch (ASMInstanceException e) {
                failList.addElement(instanceList[i]);
                exception = e;
                if (!force) continue;
                stagedExceptionMesgs.append(s_newline + e.getMessage());
            }
        }
        if (!failList.isEmpty()) {
            Object[] args = new String[]{failList.size() == 1 ? (String)failList.elementAt(0) : failList.toString(), node, !force ? ((Throwable)((Object)exception)).getMessage() : stagedExceptionMesgs.toString()};
            String msg = MessageBundle.getMessageBundle((String)"Prks").getMessage(failList.size() == 1 ? "1033" : "1034", true, args);
            Trace.out((String)("Remove failed:" + msg));
            throw new ASMInstanceException(msg, (Exception)((Object)exception));
        }
    }

    private static void setEnableDisable(String node, boolean bEnabled) throws ASMInstanceNotExistException, ASMInstanceException {
        String[] instanceList;
        Version version = new Version();
        try {
            instanceList = ASM.getInstances(node, version);
        }
        catch (ASMConfigurationException e) {
            throw new ASMInstanceException((Exception)((Object)e));
        }
        ASMInstanceException exception = null;
        Vector<String> failList = new Vector<String>(instanceList.length);
        Trace.out((String)("instanceList.length=" + instanceList.length));
        for (int i = 0; i < instanceList.length; ++i) {
            try {
                String oracleHome = ASM.getOracleHome(instanceList[i], node, version);
                Trace.out((String)(instanceList[i] + " has OH=" + oracleHome));
                ASMInstance asmInstance = new ASMInstance(instanceList[i], node, oracleHome, version);
                if (bEnabled) {
                    asmInstance.enable();
                    continue;
                }
                asmInstance.disable();
                continue;
            }
            catch (ASMConfigurationException e) {
                Trace.out((Exception)((Object)e));
                continue;
            }
            catch (ASMInstanceNotExistException e) {
                failList.addElement(instanceList[i]);
                Trace.out((Exception)((Object)e));
                exception = e;
                continue;
            }
            catch (ASMInstanceException e) {
                failList.addElement(instanceList[i]);
                exception = e;
            }
        }
        if (!failList.isEmpty()) {
            Object[] args = new String[]{failList.size() == 1 ? (String)failList.elementAt(0) : failList.toString(), node, ((Throwable)((Object)exception)).getMessage()};
            String msg = MessageBundle.getMessageBundle((String)"Prks").getMessage(failList.size() == 1 ? (bEnabled ? "1014" : "1016") : (bEnabled ? "1015" : "1017"), true, args);
            Trace.out((String)("setEnableDisable failed:" + msg));
            throw new ASMInstanceException(msg, (Exception)((Object)exception));
        }
    }
}

