/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMPresence;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.asm.ProxyASM;
import oracle.cluster.asm.Volume;
import oracle.cluster.asm.VolumeException;
import oracle.cluster.cmdtools.ADVMUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceNames;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.RTEArg;
import oracle.cluster.impl.crs.cops.RTENativeException;
import oracle.cluster.impl.crs.cops.RTENativeResult;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class VolumeImpl
extends SoftwareModuleImpl
implements Volume {
    private ResourceAttribute m_nameAttr;
    private String m_dgName;
    private String m_volName;

    VolumeImpl(ResourceAttribute nameAttr) throws VolumeException {
        if (!nameAttr.getName().equalsIgnoreCase(ResourceType.Volume.NAME.name())) {
            throw new VolumeException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, ResourceType.Volume.NAME.name(), nameAttr.getName());
        }
        Trace.out((String)("value of attribute = " + nameAttr.getValue()));
        String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
        if (values.length != 4 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.ADVM.toString().equalsIgnoreCase(values[values.length - 1])) {
            throw new VolumeException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.Volume.NAME.name(), nameAttr.getValue());
        }
        this.m_nameAttr = nameAttr;
        this.m_name = this.m_nameAttr.getValue();
        this.m_displayName = values[1] + '.' + values[2];
        this.m_dgName = values[1];
        this.m_volName = values[2];
        Trace.out((String)("m_name = " + this.m_name + ", m_displayName = " + this.m_displayName + ", disk group name = " + this.m_dgName + ", volume name = " + this.m_volName));
        try {
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr);
        }
        catch (NotExistsException notExistsException) {
        }
        catch (CRSException e) {
            throw new VolumeException(e);
        }
    }

    public void create(String volDevice) throws AlreadyExistsException, VolumeException {
        String canonicalDevice = null;
        try {
            List attrList = null;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute volumeTypeAttr = crsFactory.create(ResourceType.Volume.NAME.name(), ResourceType.Volume.NAME.toString());
            attrList = crsFactory.getResourceTypeEntity(volumeTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile((List)attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.Volume.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.Volume.VOLUME_DEVICE.name())) {
                    attr.setValue(volDevice);
                    continue;
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.Volume.CANONICAL_VOLUME_DEVICE.name())) continue;
                try {
                    String crsHome = new Util().getCRSHome();
                    ADVMUtil advmutil = new ADVMUtil(crsHome);
                    canonicalDevice = advmutil.getCanonicalVolume(volDevice);
                    Trace.out((String)("Canonical form of the volume device = " + canonicalDevice));
                }
                catch (CmdToolUtilException e) {
                    Trace.out((String)("Get CmdToolUtilException: " + e.getMessage()));
                    Trace.out((String)"Unable to get canonical device path because the volume is not enabled. Set canonical device path to empty string. This value will be updated when the volume is started.");
                    canonicalDevice = "";
                }
                catch (UtilException e) {
                    Trace.out((String)("Failed to get canonical device path. Get UtilException: " + e.getMessage()));
                    throw new VolumeException(e);
                }
                attr.setValue(canonicalDevice);
            }
            this.createVolumeDepAttrs(attrList, volDevice);
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.ROOT);
            this.ntGrantAclsForTransparentHA();
        }
        catch (VolumeException e) {
            Trace.out((Exception)((Object)e));
            throw e;
        }
        catch (AlreadyExistsException e) {
            throw new AlreadyExistsException((MessageKey)PrCaMsgID.VOLUME_ALREADY_EXISTS, new Object[]{this.m_dgName, this.m_volName, e});
        }
        catch (CRSException e) {
            throw new VolumeException((MessageKey)PrCaMsgID.VOLUME_RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
    }

    void upgradeVolumeDepAttrs(List<ResourceAttribute> attrList, boolean inclStartDep, boolean inclStopDep) throws VolumeException {
        String volDevice = this.getVolumeDevice();
        this.createVolumeDepAttrsHelper(attrList, volDevice, inclStartDep, inclStopDep);
    }

    void createVolumeDepAttrs(List<ResourceAttribute> attrList, String volDevice) throws VolumeException {
        this.createVolumeDepAttrsHelper(attrList, volDevice, true, true);
    }

    private void createVolumeDepAttrsHelper(List<ResourceAttribute> attrList, String volDevice, boolean inclStartDep, boolean inclStopDep) throws VolumeException {
        Trace.out((String)"Calling createVolumeDepAttrs");
        if (!inclStartDep && !inclStopDep) {
            return;
        }
        try {
            DiskGroup dg = null;
            ASMFactoryImpl afImpl = ASMFactoryImpl.getInstance();
            try {
                Trace.out((String)("DiskGroup name is " + this.m_dgName));
                dg = afImpl.getDiskGroup(this.m_dgName);
            }
            catch (ASMException e) {
                throw new VolumeException((MessageKey)PrCaMsgID.CHECK_DG_EXIST_FOR_FS_FAILED, (Throwable)((Object)e), this.m_dgName, volDevice);
            }
            catch (NotExistsException e) {
                throw new VolumeException((MessageKey)PrCaMsgID.CHECK_DG_EXIST_FOR_FS_FAILED, e, this.m_dgName, volDevice);
            }
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ASMPresence asmPresence = ASMPresence.LEGACY;
            ProxyASM proxyASM = null;
            asmPresence = afImpl.getASM().getPresence();
            if (asmPresence == ASMPresence.REMOTE) {
                proxyASM = afImpl.getProxyASM();
            }
            HashMap<String, RTEArg> argMap = new HashMap<String, RTEArg>();
            HashMap<String, String> condMap = new HashMap<String, String>();
            try {
                argMap.put("dg", new RTEArg("dg", RTEArg.RTEArgType.Res, new String[]{dg.getName()}));
                argMap.put("proxyASM", new RTEArg("proxyASM", RTEArg.RTEArgType.Res, new String[]{null != proxyASM ? proxyASM.getName() : ""}));
            }
            catch (RTENativeException e) {
                throw new VolumeException(e);
            }
            String asmpresence = asmPresence.toString();
            Trace.out((String)("asmPresence is " + asmpresence));
            condMap.put("ASMmode", asmpresence);
            try {
                String depHint;
                String dep;
                RTENativeResult result;
                String template;
                if (inclStartDep) {
                    template = ResourceType.Volume.START_DEPENDENCIES_TEMPLATE.toString();
                    result = CRSFactoryImpl.getInstance().rteEvalAttrValue(template, argMap, null, condMap, this.m_nameAttr.getValue());
                    dep = result.getAttrValue();
                    depHint = result.getAttrValueHint();
                    Trace.out((Object)"START_DEPENDENCIES is %s", (String)dep);
                    Trace.out((Object)"START_DEPENDENCIES_RTE_INTERNAL is %s", (String)depHint);
                    attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), dep));
                    attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), depHint));
                }
                if (inclStopDep) {
                    template = ResourceType.Volume.STOP_DEPENDENCIES_TEMPLATE.toString();
                    result = CRSFactoryImpl.getInstance().rteEvalAttrValue(template, argMap, null, condMap, this.m_nameAttr.getValue());
                    dep = result.getAttrValue();
                    depHint = result.getAttrValueHint();
                    Trace.out((Object)"STOP_DEPENDENCIES is %s", (String)dep);
                    Trace.out((Object)"STOP_DEPENDENCIES_RTE_INTERNAL is %s", (String)depHint);
                    attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), dep));
                    attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES_RTE_INTERNAL.name(), depHint));
                }
            }
            catch (CRSException e) {
                Trace.out((Exception)((Object)e));
                throw new VolumeException(e);
            }
        }
        catch (SoftwareModuleException se) {
            throw new VolumeException(se);
        }
        catch (CRSException ae) {
            throw new VolumeException(ae);
        }
        catch (NotExistsException nee) {
            throw new VolumeException(nee);
        }
    }

    @Override
    public void ntGrantAclsForTransparentHA() throws VolumeException {
        try {
            if (!new SystemFactory().CreateSystem().isUnixSystem() && this.m_crsResource != null) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                this.m_crsResource.setPermissions((ResourcePermissions)perm);
            }
        }
        catch (CRSException e) {
            throw new VolumeException(e);
        }
    }

    @Override
    public String getDiskGroup() {
        return this.m_dgName;
    }

    @Override
    public String getVolumeName() {
        return this.m_volName;
    }

    @Override
    public String getVolumeDevice() throws VolumeException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.Volume.VOLUME_DEVICE.name()).getValue();
        }
        catch (CRSException e) {
            throw new VolumeException(e);
        }
    }

    @Override
    public String getCanonicalVolumeDevice() throws VolumeException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.Volume.CANONICAL_VOLUME_DEVICE.name()).getValue();
        }
        catch (CRSException e) {
            throw new VolumeException(e);
        }
    }

    @Override
    public boolean isGHCreated() throws VolumeException {
        try {
            String ghCreated = this.m_crsResource.getAttribute(ResourceType.Volume.GH_CREATED.name()).getValue();
            Trace.out((String)("Gridhomes created resource flag:" + ghCreated));
            return ghCreated.equals("true");
        }
        catch (CRSException cse) {
            throw new VolumeException(cse);
        }
    }

    public void start() throws AlreadyRunningException, SoftwareModuleException {
        super.start();
        this.setCanonicalDevicePath();
    }

    @Override
    public void start(List<Node> nodes) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException {
        super.start(nodes);
        this.setCanonicalDevicePath();
    }

    @Override
    public void enable(Node node) throws AlreadyEnabledException, CompositeOperationException, SoftwareModuleException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        super.enable(nodeList);
    }

    @Override
    public void disable(Node node) throws AlreadyDisabledException, CompositeOperationException, SoftwareModuleException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        super.disable(nodeList);
    }

    private void setCanonicalDevicePath() throws VolumeException {
        try {
            ResourceAttribute canonicalAttr = this.m_crsResource.getAttribute(ResourceType.Volume.CANONICAL_VOLUME_DEVICE.name());
            if (canonicalAttr.getValue().equals("")) {
                ResourceAttribute volDeviceAttr = this.m_crsResource.getAttribute(ResourceType.Volume.VOLUME_DEVICE.name());
                String crsHome = new Util().getCRSHome();
                ADVMUtil advmutil = new ADVMUtil(crsHome);
                String canonicalDevice = advmutil.getCanonicalVolume(volDeviceAttr.getValue());
                Trace.out((String)("Canonical form of the volume device = " + canonicalDevice));
                canonicalAttr.setValue(canonicalDevice);
                this.m_crsResource.update(canonicalAttr);
            }
        }
        catch (CmdToolUtilException e) {
            Trace.out((String)("Failed to get canonical device path. Get CmdToolUtilException: " + e.getMessage()));
            throw new VolumeException(e);
        }
        catch (UtilException e) {
            Trace.out((String)("Failed to get canonical device path. Get UtilException: " + e.getMessage()));
            throw new VolumeException(e);
        }
        catch (CRSException e) {
            Trace.out((String)("Got CRSException: " + e.getMessage()));
            throw new VolumeException(e);
        }
    }

    @Override
    public void setGHCreated(boolean ghCreated) throws VolumeException {
        try {
            ResourceAttribute ghCreatedAttr = this.m_crsResource.getAttribute(ResourceType.Volume.GH_CREATED.name());
            Trace.out((String)("Setting GH created flag to " + ghCreated));
            String value = ghCreated ? "true" : "false";
            ghCreatedAttr.setValue(value);
            this.m_crsResource.update(ghCreatedAttr);
        }
        catch (CRSException e) {
            Trace.out((String)("Got CRSException: " + e.getMessage()));
            throw new VolumeException(e);
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, VolumeException {
        try {
            Trace.out((String)"calling parent's crsResource");
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new VolumeException(e);
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, VolumeException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new VolumeException((MessageKey)PrCaMsgID.VOLUME_REMOVE_FAILED, e, this.m_dgName, this.m_volName);
        }
    }

    public static String getResourceName(String dgName, String volName) throws CRSException {
        return ResourceNames.getVolumeResourceName((String)dgName, (String)volName);
    }

    public static final String[] getUserAssignedNames(String volumeResName) throws VolumeException {
        if (volumeResName == null || volumeResName.trim().length() == 0) {
            throw new VolumeException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "volumeResName");
        }
        String[] values = volumeResName.split(Pattern.quote(String.valueOf('.')));
        if (values.length != 4 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.ADVM.toString().equalsIgnoreCase(values[values.length - 1])) {
            throw new VolumeException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.Volume.NAME.name(), volumeResName);
        }
        String[] volumeValues = new String[]{values[1], values[2]};
        return volumeValues;
    }
}

