/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMInstance;
import oracle.cluster.asm.ClusterASM;
import oracle.cluster.asm.ProxyASM;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.common.UpgradePhase;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.asm.ASMInstanceImpl;
import oracle.cluster.impl.asm.BaseASMImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class ProxyASMImpl
extends BaseASMImpl
implements ProxyASM {
    ProxyASMImpl(ResourceAttribute nameAttr) throws ASMException {
        if (!nameAttr.getName().equalsIgnoreCase(ResourceType.ProxyASM.NAME.name())) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, ResourceType.ProxyASM.NAME.name(), nameAttr.getName());
        }
        String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
        Trace.out((String)("values.length is " + values.length + ", values[0]=" + values[0] + ", values[1]=" + values[1]));
        if (values.length != 2 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.PROXY_ASM.toString().equalsIgnoreCase(values[1])) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ProxyASM.NAME.name(), nameAttr.getValue());
        }
        this.m_nameAttr = nameAttr;
        this.m_name = this.m_nameAttr.getValue();
        this.m_displayName = values[1];
        try {
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr);
        }
        catch (NotExistsException notExistsException) {
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    void create(String spfile, Version version) throws AlreadyExistsException, ASMException {
        Trace.out((String)"Create helper for Proxy ADVM");
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute asmTypeAttr = crsFactory.create(ResourceType.ProxyASM.NAME.name(), ResourceType.ProxyASM.NAME.toString());
            List attrList = crsFactory.getResourceTypeEntity(asmTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile((List)attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(asmTypeAttr.getName())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    break;
                }
                if (spfile == null || !attr.getName().equalsIgnoreCase(ResourceType.IOServer.SPFILE.name())) continue;
                attr.setValue(spfile);
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            ASMFactoryImpl asmFactory = ASMFactoryImpl.getInstance();
            ClusterASM clusterasm = asmFactory.getClusterASM();
            ResourceAttribute asmAttr = crsFactory.create(ResourceType.ClusterASM.NAME.name(), clusterasm.getName());
            ResourceDependency hardStartDep = asmFactory.getUpgradePhase() == UpgradePhase.FIRST ? crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]) : crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            ResourceDependency pullupDep = asmFactory.getUpgradePhase() == UpgradePhase.FIRST ? crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]) : crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.PULLUP_ALWAYS_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{hardStartDep, pullupDep})));
            ResourceDependency hardStopDep = asmFactory.getUpgradePhase() == UpgradePhase.FIRST ? crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]) : crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP});
            attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{hardStopDep})));
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.CRS_USER);
            if (!new SystemFactory().CreateSystem().isUnixSystem()) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                this.m_crsResource.setPermissions((ResourcePermissions)perm);
            }
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.PROXYASM_CREATE_FAILED, e, this.getUserAssignedName(), this.m_nameAttr.getValue());
        }
        catch (NotExistsException e) {
            throw new ASMException((MessageKey)PrCaMsgID.PROXYASM_CREATE_FAILED, e, this.getUserAssignedName(), this.m_nameAttr.getValue());
        }
        catch (SoftwareModuleException e) {
            throw new ASMException((MessageKey)PrCaMsgID.PROXYASM_CREATE_FAILED, e, this.getUserAssignedName(), this.m_nameAttr.getValue());
        }
    }

    @Override
    public String getSPFile() throws ASMException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.Database.SPFILE.name()).getValue();
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_SPFILE_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public void setSPFile(String spfile) throws ASMException {
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.SPFILE.name(), spfile));
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.SET_SPFILE_FAILED, e, spfile, this.getUserAssignedName());
        }
    }

    @Override
    public List<ASMInstance> allInstances() throws ASMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.ProxyASM.NAME.toString());
            Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.ProxyASM.NAME.name(), this.getName());
            Filter finalFilter = crsFactory.getFilter(Filter.Operator.AND, typeFilter, nameFilter);
            return this.getInstances(finalFilter);
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public List<ASMInstance> instances() throws AlreadyStoppedException, ASMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.ProxyASM.NAME.toString());
            Filter finalFilter = crsFactory.getFilter(Filter.Operator.AND, typeFilter, FilterFactoryImpl.getFilter4RunningResource((CRSResource)this.m_crsResource, null));
            List<ASMInstance> asmInstList = this.getInstances(finalFilter);
            if (asmInstList.size() == 0) {
                throw new AlreadyStoppedException((MessageKey)PrCaMsgID.NO_RUNNING_ASMINSTANCE, new Object[]{this.getUserAssignedName()});
            }
            return asmInstList;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
    }

    private List<ASMInstance> getInstances(Filter filter) throws ASMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            String nodeAttr = ResourceLiterals.CRS_LAST_SERVER.toString();
            String instAttr = ResourceType.LocalASM.USR_ORA_INST_NAME.name();
            Map resultData = crsFactory.searchEntities(CRSEntity.Type.ResourceInstance, true, filter, new String[]{nodeAttr, instAttr});
            ServerFactoryImpl sfImpl = ServerFactoryImpl.getInstance();
            LinkedList<ASMInstance> asmInstList = new LinkedList<ASMInstance>();
            for (String riID : resultData.keySet()) {
                Map result = (Map)resultData.get(riID);
                String instName = (String)result.get(instAttr);
                String nodeName = (String)result.get(nodeAttr);
                asmInstList.add(new ASMInstanceImpl(this, instName, sfImpl.getNode(nodeName, false)));
            }
            return asmInstList;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public void start(List<Node> nodes, List<StartOptions> startupOptions) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException {
        if (!(nodes != null && nodes.size() != 0 || startupOptions != null && startupOptions.size() != 0)) {
            super.start();
            return;
        }
        if (startupOptions == null || startupOptions.size() == 0) {
            this.start(nodes);
            return;
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            StartOptions[] soarr = startupOptions.toArray(new StartOptions[startupOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.USR_ORA_OPEN_MODE.name(), Utils.getEnumString((Enum[])soarr, (String)String.valueOf(" ")));
            if (nodes == null || nodes.size() == 0) {
                this.m_crsResource.start(options);
            } else {
                this.m_crsResource.start(nodes, options);
            }
        }
        catch (CRSException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    public void stop(boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        if (force) {
            try {
                ResourceAttribute[] attrs = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.USR_ORA_STOP_MODE.name(), StopOptions.ABORT.toString())};
                this.m_crsResource.stop(true, attrs);
            }
            catch (CRSException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        } else {
            super.stop(false);
        }
    }

    @Override
    public void stop(List<Node> nodeList, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (nodeList == null || nodeList.size() == 0) {
            throw new SoftwareModuleException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"nodeList"});
        }
        if (force) {
            try {
                ResourceAttribute[] attrs = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.USR_ORA_STOP_MODE.name(), StopOptions.ABORT.toString())};
                this.m_crsResource.stop(nodeList, true, attrs);
            }
            catch (CRSException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        } else {
            super.stop(nodeList, false);
        }
    }

    @Override
    public void stop(List<Node> nodeList, List<StopOptions> stopOptions, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (nodeList == null && stopOptions == null) {
            this.stop(force);
            return;
        }
        if (nodeList == null) {
            this.stop(force, stopOptions);
            return;
        }
        if (stopOptions == null) {
            this.stop(nodeList, force);
            return;
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            StopOptions[] soarr = stopOptions.toArray(new StopOptions[stopOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.USR_ORA_STOP_MODE.name(), Utils.getEnumString((Enum[])soarr, (String)String.valueOf(" ")));
            this.m_crsResource.stop(nodeList, force, options);
        }
        catch (CRSException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    @Override
    public void stop(boolean force, List<StopOptions> stopOptions) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (stopOptions == null || stopOptions.size() == 0) {
            throw new SoftwareModuleException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"stopOptions", stopOptions});
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            StopOptions[] soarr = stopOptions.toArray(new StopOptions[stopOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.USR_ORA_STOP_MODE.name(), Utils.getEnumString((Enum[])soarr, (String)String.valueOf(" ")));
            this.m_crsResource.stop(force, options);
        }
        catch (CRSException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    public static String getResourceName() {
        return ResourceLiterals.PROXY_ASM_RES_NAME.toString();
    }
}

