/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.IOServer;
import oracle.cluster.asm.IOServerInstance;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.impl.asm.IOServerImpl;
import oracle.cluster.impl.database.InstanceImpl;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.ops.mgmt.trace.Trace;

public class IOServerInstanceImpl
extends InstanceImpl
implements IOServerInstance {
    private IOServer m_ioserver;
    private String m_riID;
    private String m_state;
    private boolean m_isCluster;

    IOServerInstanceImpl(IOServer ioserver, String riID, String instanceName, Node node, String state) {
        this.m_ioserver = ioserver;
        this.m_riID = riID;
        this.m_name = this.m_ioserver.getUserAssignedName();
        this.m_displayName = instanceName;
        this.m_isDBInstance = false;
        this.m_node = node;
        this.m_state = state;
        this.m_isCluster = true;
    }

    @Override
    public IOServer getIOServer() throws ASMException {
        return this.m_ioserver;
    }

    @Override
    public String getID() {
        return this.m_riID;
    }

    @Override
    public String getState() {
        return this.m_state;
    }

    public boolean isRunning() throws SoftwareModuleException {
        Trace.out((String)"check whether ASM is running");
        return this.m_ioserver.isRunning();
    }

    public boolean isRunning(Node node) throws SoftwareModuleException {
        return this.m_ioserver.isRunning(node);
    }

    public boolean isEnabled() throws SoftwareModuleException {
        return this.m_ioserver.isEnabled(this.m_node);
    }

    public boolean isEnabled(Node node) throws SoftwareModuleException {
        return this.m_ioserver.isEnabled(node);
    }

    public void enable() throws AlreadyEnabledException, SoftwareModuleException {
        try {
            ArrayList<Node> nodelist = new ArrayList<Node>(1);
            nodelist.add(this.m_node);
            ((IOServerImpl)this.m_ioserver).enable(nodelist);
        }
        catch (CompositeOperationException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    public void disable() throws AlreadyDisabledException, SoftwareModuleException {
        try {
            ArrayList<Node> nodelist = new ArrayList<Node>(1);
            nodelist.add(this.m_node);
            ((IOServerImpl)this.m_ioserver).disable(nodelist);
        }
        catch (CompositeOperationException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    public void start() throws AlreadyRunningException, SoftwareModuleException {
        try {
            ArrayList<Node> nodelist = new ArrayList<Node>(1);
            nodelist.add(this.m_node);
            ((IOServerImpl)this.m_ioserver).start(nodelist);
        }
        catch (CompositeOperationException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    public void stop(boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        try {
            ArrayList<Node> nodelist = new ArrayList<Node>(1);
            nodelist.add(this.m_node);
            ((IOServerImpl)this.m_ioserver).stop((List<Node>)nodelist, force);
        }
        catch (CompositeOperationException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }
}

