/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.database.Database;
import oracle.cluster.impl.asm.ASMImpl;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class DiskGroupImpl
extends SoftwareModuleImpl
implements DiskGroup {
    private ResourceAttribute m_nameAttr;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String CRS_DEP_FAILED_MOVE = "CRS-2912:";
    private static final String CRS_UNABLE_RELOCATE = "CRS-2529:";
    private static final String CRS_FAILED_STOP_ASM = "CRS-2675:";
    private static final String CRS_START_DG_DEP_ASM = "CRS-2527:";
    private static final String CRS_ASM_ALL_INST_RUN = "CRS-2525:";

    DiskGroupImpl(ResourceAttribute nameAttr) throws NotExistsException, ASMException {
        this(nameAttr, null, EntityOperations.EntityOpsMode.CRS);
    }

    DiskGroupImpl(ResourceAttribute nameAttr, String dgName) throws NotExistsException, ASMException {
        this(nameAttr, dgName, EntityOperations.EntityOpsMode.CRS);
    }

    DiskGroupImpl(ResourceAttribute nameAttr, String dgName, EntityOperations.EntityOpsMode mode) throws NotExistsException, ASMException {
        if (!nameAttr.getName().equalsIgnoreCase(ResourceType.DiskGroup.NAME.name())) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, ResourceType.DiskGroup.NAME.name(), nameAttr.getName());
        }
        String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
        if (values.length != 3 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.DG.toString().equalsIgnoreCase(values[2])) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.DiskGroup.NAME.name(), nameAttr.getValue());
        }
        this.m_nameAttr = nameAttr;
        this.m_name = this.m_nameAttr.getValue();
        this.m_displayName = dgName == null ? values[1] : dgName;
        Trace.out((String)("name = " + this.m_name + ", display name = " + this.m_displayName));
        try {
            this.m_crsResource = mode == EntityOperations.EntityOpsMode.Local ? (CRSResourceImpl)CRSFactoryImpl.getInstance().getResource(nameAttr, mode) : (CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr);
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        catch (NotExistsException e) {
            throw new NotExistsException((MessageKey)PrCaMsgID.DG_NOT_EXIST, (Throwable)e, new Object[]{this.m_displayName});
        }
    }

    @Override
    public ASM asm() throws ASMException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            String[] resNames = ResourceDependency.getResourceNames((ResourceAttribute)attr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP);
            for (int i = 0; i < resNames.length; ++i) {
                if (!resNames[i].startsWith("ora.") || !resNames[i].endsWith(ResourceLiterals.ASM.toString())) continue;
                return new ASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.NAME.name(), resNames[i]));
            }
            throw new ASMException((MessageKey)PrCnMsgID.DEP_RES_NOT_FOUND, ResourceLiterals.ASM.toString(), this.m_nameAttr.getValue(), Utils.getString((String[])resNames, (String)String.valueOf(",")));
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCnMsgID.DEP_RES_NOT_FOUND, e, ResourceLiterals.ASM.toString(), this.m_nameAttr.getValue(), e.getMessage());
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, ASMException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void stop(List<Node> nodeList, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (force) {
            try {
                ResourceAttribute[] attrs = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.DiskGroup.USR_ORA_STOP_MODE.name(), ResourceLiterals.FORCE.toString())};
                this.m_crsResource.stop(nodeList, true, attrs);
            }
            catch (CRSException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        } else {
            super.stop(nodeList, false);
        }
    }

    public void stop(boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        if (force) {
            try {
                ResourceAttribute[] attrs = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.DiskGroup.USR_ORA_STOP_MODE.name(), ResourceLiterals.FORCE.toString())};
                this.m_crsResource.stop(true, attrs);
            }
            catch (CRSException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        } else {
            super.stop(false);
        }
    }

    public void start() throws AlreadyRunningException, SoftwareModuleException {
        StringBuilder filteredMsg = new StringBuilder();
        boolean getDepMoveMsg = false;
        boolean alreadyRunning = false;
        SoftwareModuleException excep = null;
        try {
            super.start();
        }
        catch (SoftwareModuleException sme) {
            String[] errLines;
            excep = sme;
            String errMsg = sme.getMessage();
            getDepMoveMsg = false;
            for (String err : errLines = errMsg.split(NEWLINE)) {
                Trace.out((String)("Get error message: " + err));
                if (err.contains(CRS_DEP_FAILED_MOVE)) {
                    getDepMoveMsg = true;
                    continue;
                }
                if (getDepMoveMsg && (err.contains(CRS_UNABLE_RELOCATE) || err.contains(CRS_FAILED_STOP_ASM) || err.contains(CRS_START_DG_DEP_ASM))) continue;
                if (err.contains(CRS_ASM_ALL_INST_RUN)) {
                    alreadyRunning = true;
                    continue;
                }
                filteredMsg.append(err);
            }
        }
        try {
            Trace.out((String)("Get filtered errors: " + filteredMsg.toString()));
            if (alreadyRunning) {
                List dgRunNodes = this.crsResource().fetchRunningNodes();
                List asmRunNodes = this.asm().crsResource().fetchRunningNodes();
                Trace.out((String)"Diskgroup runs on %d nodes. ASM runs on %d nodes", (Object[])new Object[]{dgRunNodes.size(), asmRunNodes.size()});
                if (dgRunNodes.size() == asmRunNodes.size()) {
                    throw new AlreadyRunningException((MessageKey)PrCrMsgID.RES_ALREADY_RUNNING, new Object[]{this.m_nameAttr.getValue()});
                }
            }
            if (filteredMsg.length() != 0) {
                throw excep;
            }
        }
        catch (CRSException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
        catch (NotExistsException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, ASMException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new ASMException((MessageKey)PrCaMsgID.DG_REMOVE_FAILED, e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public List<Database> databases() throws ASMException {
        return this.databases(false);
    }

    @Override
    public List<Database> databases(boolean allDBVersions) throws ASMException {
        try {
            return DatabaseFactoryImpl.getInstance().getDatabases((DiskGroup)this, allDBVersions);
        }
        catch (SoftwareModuleException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_DG_DATABASES_FAILED, e, this.getUserAssignedName());
        }
    }

    public static String getResourceName(String dgName) {
        return "ora." + dgName.toUpperCase() + '.' + ResourceLiterals.DG.toString();
    }

    public static String getFilter() {
        return "ora." + ResourceLiterals.STAR.toString() + '.' + ResourceLiterals.DG.toString();
    }

    public static final String getUserAssignedName(String dgResName) throws ASMException {
        if (dgResName == null || dgResName.trim().length() == 0) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dgResName", dgResName);
        }
        String[] values = dgResName.split(Pattern.quote(String.valueOf('.')));
        if (values.length != 3 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.DG.toString().equalsIgnoreCase(values[2])) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.DiskGroup.NAME.name(), dgResName);
        }
        return values[1];
    }

    @Override
    public void setASMPullUp() throws SoftwareModuleException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceDependency pullAlwaysDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.LocalASM.NAME.name(), ASMImpl.getResourceName()), ResourceDependency.DepType.PULLUP_ALWAYS_DEP, new ResourceDependency.DepModifier[0]);
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            String value = attr.getValue();
            String[] values = value.split(" ");
            StringBuilder attrSB = new StringBuilder(ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{pullAlwaysDep}));
            for (String str : values) {
                if (str.equalsIgnoreCase("pullup(ora.asm)") || str.equalsIgnoreCase("pullup:always(ora.asm)")) continue;
                attrSB.append(" " + str);
            }
            attr.setValue(attrSB.toString());
            Trace.out((String)("new value= " + attr.getValue()));
            this.m_crsResource.update(attr);
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    @Override
    public void ntGrantAclsForTransparentHA() throws ASMException {
        try {
            if (!new SystemFactory().CreateSystem().isUnixSystem() && this.m_crsResource != null) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                this.m_crsResource.setPermissions((ResourcePermissions)perm);
            }
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }
}

