/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.util.ArrayList;
import java.util.regex.Pattern;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.CCMB;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class CCMBImpl
extends SoftwareModuleImpl
implements CCMB {
    private ResourceAttribute m_nameAttr;

    public CCMBImpl(ResourceAttribute nameAttr) throws ASMException {
        if (!nameAttr.getName().equalsIgnoreCase(ResourceLiterals.NAME.name())) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, ResourceLiterals.NAME.name(), nameAttr.getName());
        }
        String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
        if (values.length != 2 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.CCMB.toString().equalsIgnoreCase(values[1])) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceLiterals.NAME.name(), nameAttr.getValue());
        }
        this.m_nameAttr = nameAttr;
        this.m_name = this.m_nameAttr.getValue();
        this.m_displayName = values[1];
        try {
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr);
        }
        catch (NotExistsException e) {
            Trace.out((String)"Creation not done yet, ignoring NotExistsException");
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    public void create() throws AlreadyExistsException, ASMException {
        try {
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            attrList.add(new ResourceAttribute(ResourceType.CCMB.NAME.name(), this.m_nameAttr.getValue()));
            attrList.add(new ResourceAttribute(ResourceLiterals.TYPE.name(), ResourceType.CCMB.NAME.toString()));
            ResourcePermissionsImpl perm = CRSFactoryImpl.getInstance().createPerm(ResourceType.ACL_CREATOR.CRS_USER);
            perm.setPerm(ResourceType.ACL.OTHER, "", new ResourceType.ACL_PERM[]{ResourceType.ACL_PERM.READ});
            attrList.add(CRSFactoryImpl.getInstance().create(ResourceLiterals.ACL_ATTR.toString(), perm.getAclString()));
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.CCMB_CREATE_FAILED, e, this.m_nameAttr.getValue());
        }
    }

    public static String getResourceName() {
        return "ora." + ResourceLiterals.CCMB.toString();
    }
}

