/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMPresence;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.nodeapps.ListenerImpl;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

abstract class BaseASMImpl
extends SoftwareModuleImpl {
    protected ResourceAttribute m_nameAttr;
    protected static boolean m_isCluster = Cluster.isCluster();

    protected BaseASMImpl() {
    }

    protected BaseASMImpl(ResourceAttribute nameAttr) throws ASMException {
        if (!nameAttr.getName().equalsIgnoreCase(ResourceType.ClusterASM.NAME.name())) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, ResourceType.ClusterASM.NAME.name(), nameAttr.getName());
        }
        String attVal = nameAttr.getValue();
        String[] values = attVal.split(Pattern.quote(String.valueOf('.')));
        Trace.out((String)("values.length is " + values.length + ", values[0]=" + values[0] + ", values[1]=" + values[1]));
        this.m_nameAttr = nameAttr;
        this.m_name = attVal;
        this.m_displayName = values[1];
        try {
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr);
        }
        catch (NotExistsException notExistsException) {
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    public Listener listener() throws ASMException {
        Trace.out((String)"Getting public listener for ASM...");
        List<Listener> lsnrList = this.listeners();
        Trace.out((String)("No of public listeners = " + lsnrList.size()));
        return lsnrList.get(0);
    }

    public List<Listener> listeners() throws ASMException {
        Trace.out((String)"Getting list of public listeners...");
        ArrayList<Object> lsnrList = new ArrayList<Listener>();
        String lsnrName = ResourceLiterals.LISTENER.name();
        try {
            String[] depNames;
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            for (String res : depNames = ResourceDependency.getResourceNames((ResourceAttribute)attr, (ResourceDependency.DepType)ResourceDependency.DepType.WEAK_DEP)) {
                if (!res.endsWith(ResourceLiterals.LSNR.toString())) continue;
                lsnrName = ListenerImpl.getUserAssignedName((String)res);
                Trace.out((String)("Public listener name = " + lsnrName));
                lsnrList = new ArrayList(1);
                lsnrList.add(NodeAppsFactory.getInstance().getListener(lsnrName));
            }
            if (lsnrList.isEmpty()) {
                Trace.out((String)"No public listeners found.");
                throw new ASMException((MessageKey)PrCaMsgID.ASM_LSNR_NOT_EXIST, lsnrName);
            }
            return lsnrList;
        }
        catch (CRSException e) {
            Trace.out((String)("CRSException getting public listeners: " + e.getMessage()));
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASM_LSNR_FAILED, new Object[]{this.getUserAssignedName(), e});
        }
        catch (NotExistsException e) {
            Trace.out((String)("NotExistsException getting public listeners: " + e.getMessage()));
            throw new ASMException((MessageKey)PrCaMsgID.ASM_LSNR_NOT_EXIST, new Object[]{lsnrName, e});
        }
        catch (SoftwareModuleException e) {
            Trace.out((String)("SoftwareModuleException getting public listeners: " + e.getMessage()));
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASM_LSNR_FAILED, new Object[]{this.getUserAssignedName(), e});
        }
    }

    public void setListener(Listener listener) throws ASMException {
        this.setListener(listener, false);
    }

    public void setListener(Listener listener, boolean forceFlag) throws ASMException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            Listener lsnr = this.listener();
            Trace.out((String)("current value=" + attr.getValue()));
            attr.setValue(attr.getValue().replaceAll(lsnr.getName(), listener.getName()));
            Trace.out((String)("new value=" + attr.getValue()));
            this.m_crsResource.update(attr, forceFlag);
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.SET_ASM_LSNR_FAILED, new Object[]{listener.getUserAssignedName(), this.getUserAssignedName(), e});
        }
    }

    public String getPWFile() throws ASMException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.ClusterASM.PWFILE.name()).getValue();
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_PWFILE_FAILED, e, this.getUserAssignedName());
        }
    }

    public void setPWFile(String pwfile) throws ASMException {
        if (pwfile == null) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "spfile", pwfile);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.PWFILE.name(), pwfile));
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.SET_PWFILE_FAILED, e, pwfile, this.getUserAssignedName());
        }
    }

    public String getSPFile() throws ASMException {
        if (m_isCluster) {
            throw new ASMException((MessageKey)PrCaMsgID.API_NOT_SUPPORTED_CLUSTER, new Object[0]);
        }
        try {
            return this.m_crsResource.getAttribute(ResourceType.Database.SPFILE.name()).getValue();
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_SPFILE_FAILED, e, this.getUserAssignedName());
        }
    }

    public void setSPFile(String spfile) throws ASMException {
        if (m_isCluster) {
            throw new ASMException((MessageKey)PrCaMsgID.API_NOT_SUPPORTED_CLUSTER, new Object[0]);
        }
        if (spfile == null) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "spfile", spfile);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.SPFILE.name(), spfile));
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.SET_SPFILE_FAILED, e, spfile, this.getUserAssignedName());
        }
    }

    public String getDiskString() throws ASMException {
        if (m_isCluster) {
            throw new ASMException((MessageKey)PrCaMsgID.API_NOT_SUPPORTED_CLUSTER, new Object[0]);
        }
        try {
            return this.m_crsResource.getAttribute(ResourceLiterals.ASM_DISKSTRING.name()).getValue();
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_DISKSTRING_FAILED, e, this.getUserAssignedName());
        }
    }

    public void setDiskString(String diskString) throws ASMException {
        if (m_isCluster) {
            throw new ASMException((MessageKey)PrCaMsgID.API_NOT_SUPPORTED_CLUSTER, new Object[0]);
        }
        if (diskString == null) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "diskString", diskString);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceLiterals.ASM_DISKSTRING.name(), diskString));
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.SET_DISKSTRING_FAILED, e, diskString, this.getUserAssignedName());
        }
    }

    public Map<String, String> getParameters() throws NotExistsException, ASMException {
        throw new NotExistsException((MessageKey)PrCaMsgID.PARAMS_NOT_USED, new Object[]{this.getUserAssignedName(), "PLEASE DO NOT CALL THIS API ANYMORE"});
    }

    public CRSResource crsResource() throws NotExistsException, ASMException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new ASMException(e);
        }
    }

    public void remove(boolean force) throws AlreadyRunningException, ASMException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new ASMException(e);
        }
    }

    public ASMPresence getPresence() throws ASMException {
        ASMPresence presence = ASMPresence.LEGACY;
        String pStr = "";
        try {
            Trace.out((String)("m_crsResource = " + this.m_crsResource));
            pStr = this.m_crsResource.getAttribute(ResourceType.ClusterASM.PRESENCE.name()).getValue();
            presence = ASMPresence.getEnumMember(pStr);
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        catch (EnumConstNotFoundException e) {
            throw new ASMException((MessageKey)PrCaMsgID.INVALID_ASMPRESENCE, e, pStr);
        }
        return presence;
    }
}

