/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.cluster.asm.AsmClusterFileSystem;
import oracle.cluster.asm.AsmClusterFileSystemException;
import oracle.cluster.asm.FSEnums;
import oracle.cluster.asm.FileSystemOptionalArgs;
import oracle.cluster.asm.Volume;
import oracle.cluster.asm.VolumeException;
import oracle.cluster.cmdtools.ADVMUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OFSUtil;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.asm.AsmBaseFileSystemImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class AsmClusterFileSystemImpl
extends AsmBaseFileSystemImpl
implements AsmClusterFileSystem {
    AsmClusterFileSystemImpl(ResourceAttribute nameAttr) throws AsmClusterFileSystemException {
        super(nameAttr);
    }

    public void create(String volDevice, String mountpointPath, String user, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        this.create(volDevice, mountpointPath, user, null, null, version);
    }

    public void create(String volDevice, String mountpointPath, String user, String fsOptions, String description, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        this.create(volDevice, mountpointPath, new String[]{user}, fsOptions, description, version, null, null, false, false);
    }

    public void create(String volDevice, String mountpointPath, String user, String fsOptions, String description, Version version, String autostart, String[] auxvolumes) throws AlreadyExistsException, AsmClusterFileSystemException {
        this.create(volDevice, mountpointPath, new String[]{user}, fsOptions, description, version, autostart, auxvolumes, false, false);
    }

    public void create(String volDevice, String mountpointPath, String user, String fsOptions, String description, Version version, String autostart, List<Volume> auxvolumes) throws AlreadyExistsException, AsmClusterFileSystemException {
        String[] auxVolArray = new String[auxvolumes.size()];
        int i = 0;
        for (Volume v : auxvolumes) {
            auxVolArray[i] = v.getVolumeName();
            ++i;
        }
        this.create(volDevice, mountpointPath, new String[]{user}, fsOptions, description, version, autostart, auxVolArray, false, false);
    }

    public void create(String volDevice, String mountpointPath, String[] users, String fsOptions, String description, Version version, String autostart, String[] auxvolumes, boolean ghCreated, boolean isClientCluster) throws AlreadyExistsException, AsmClusterFileSystemException {
        this.create(volDevice, mountpointPath, null, users, fsOptions, description, version, autostart, auxvolumes, ghCreated, isClientCluster);
    }

    public void create(String volDevice, String mountpointPath, String mountOwner, String[] users, String fsOptions, String description, Version version, String autostart, String[] auxvolumes, boolean ghCreated, boolean isClientCluster) throws AlreadyExistsException, AsmClusterFileSystemException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException e) {
            throw new AsmClusterFileSystemException(e);
        }
        try {
            boolean isUsersDefined;
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            String crsHome = new Util().getCRSHome();
            OFSUtil acfsutil = nativeSystem.isUnixSystem() ? new OFSUtil() : new OFSUtil(crsHome + File.separator + "bin");
            String mountPointPath = mountpointPath;
            if (mountPointPath == null || mountPointPath.trim().length() == 0) {
                mountPointPath = acfsutil.getMtPtFromVolDev(volDevice, crsHome);
                Trace.out((String)("mountPoint = " + mountPointPath));
            }
            ADVMUtil advmutil = new ADVMUtil(crsHome);
            String canVolDevice = advmutil.getCanonicalVolume(volDevice);
            Trace.out((String)("Canonical form of the volume device = " + canVolDevice));
            try {
                String mtPt = acfsutil.getMountPointFromVolDevice(volDevice);
                if (mtPt != null) {
                    throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FILESYSTEM_IN_ACFS_REG, volDevice);
                }
            }
            catch (CmdToolUtilException mtPt) {
                // empty catch block
            }
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            ResourceAttribute attr = new ResourceAttribute(ResourceType.AsmClusterFileSystem.NAME.name(), this.m_nameAttr.getValue());
            Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
            attrList.add(attr);
            attr = isClientCluster ? new ResourceAttribute(ResourceLiterals.TYPE.name(), ResourceType.DBAASFSLocal.NAME.toString()) : new ResourceAttribute(ResourceLiterals.TYPE.name(), ResourceType.AsmClusterFileSystem.NAME.toString());
            Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
            attrList.add(attr);
            attr = new ResourceAttribute(ResourceType.AsmClusterFileSystem.VOLUME_DEVICE.name(), volDevice);
            Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
            attrList.add(attr);
            attr = new ResourceAttribute(ResourceType.AsmClusterFileSystem.CANONICAL_VOLUME_DEVICE.name(), canVolDevice);
            Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
            attrList.add(attr);
            if (auxvolumes != null && auxvolumes.length > 0) {
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.AUX_VOLUMES.name(), Utils.getString((String[])auxvolumes, (String)","));
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
            }
            if (mountPointPath != null) {
                mountPointPath = mountPointPath.trim();
                AsmClusterFileSystemImpl.validateMountPointPath(mountPointPath);
                attr = new ResourceAttribute(ResourceType.AsmClusterFileSystem.MOUNTPOINT_PATH.name(), mountPointPath);
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
                attr = new ResourceAttribute(ResourceType.AsmClusterFileSystem.INTERNAL_MOUNTPOINT_PATH.name(), ASMFactoryImpl.getInternalMountPoint(mountPointPath));
                attrList.add(attr);
            }
            if (fsOptions != null) {
                attr = new ResourceAttribute(ResourceType.AsmClusterFileSystem.FS_OPTIONS.name(), fsOptions);
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
            }
            if (description != null) {
                attr = new ResourceAttribute(ResourceType.AsmClusterFileSystem.FS_DESCRIPTION.name(), description);
                Trace.out((String)("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\""));
                attrList.add(attr);
            }
            Trace.out((String)"Adding Version attribute");
            attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString()));
            if (autostart != null && autostart.length() > 0) {
                attr = new ResourceAttribute(ResourceType.ClusterResource.AUTO_START.name(), autostart);
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
            }
            if (ghCreated) {
                Trace.out((String)"File system created in Gridhomes");
                attr = new ResourceAttribute(ResourceType.AsmClusterFileSystem.GH_CREATED.name(), "true");
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
            }
            Volume volume = null;
            ASMFactoryImpl afImpl = ASMFactoryImpl.getInstance();
            if (!isClientCluster) {
                try {
                    List<Volume> volList = afImpl.getVolumes(volDevice, this.m_volName, this.m_dgName);
                    if (volList.size() != 1) {
                        Object[] args = new Object[]{this.m_volName, this.m_dgName};
                        Trace.out((String)("Found multiple volume resource. Number of volume resource is " + volList.size()));
                    }
                    volume = volList.get(0);
                }
                catch (VolumeException ve) {
                    throw new AsmClusterFileSystemException((Throwable)((Object)ve));
                }
                catch (NotExistsException nee) {
                    Trace.out((String)"Get NotExistsException for volume resource");
                    throw new AsmClusterFileSystemException(nee);
                }
            }
            AsmBaseFileSystemImpl parentFS = (AsmBaseFileSystemImpl)this.getNestedFS(mountPointPath);
            attrList.addAll(isClientCluster ? this.generateDBAASFSDependencies(parentFS) : this.generateFSDependencies(volume, auxvolumes, parentFS));
            Trace.out((String)"Generating ACL attribute");
            boolean isUnix = new SystemFactory().CreateSystem().isUnixSystem();
            boolean bl = isUsersDefined = users != null && users.length > 0;
            if (isUnix) {
                attrList.add(this.generateACL(mountOwner, users != null ? Arrays.asList(users) : null));
            } else if (isUsersDefined) {
                for (String user : users) {
                    if (new Util().isUserValid(user)) continue;
                    throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.INVALID_USER, user);
                }
            }
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
            Trace.out((String)"Successfully created acfs filesystem resource");
            if (!isUnix) {
                this.ntGrantAclsForTransparentHA();
                if (isUsersDefined) {
                    this.setUser(users);
                }
            }
        }
        catch (AlreadyExistsException e) {
            throw new AlreadyExistsException((MessageKey)PrCaMsgID.ACFS_ALREADY_EXISTS, new Object[]{this.m_dgName, this.m_volName, e});
        }
        catch (CmdToolUtilException e) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.ACFS_RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
        catch (CRSException e) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.ACFS_RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
        catch (NotExistsException e) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.ACFS_RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
        catch (SoftwareModuleException e) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.ACFS_RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
        catch (UtilException e) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.ACFS_RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
    }

    @Override
    public void ntGrantAclsForTransparentHA() throws AsmClusterFileSystemException {
        try {
            if (!new SystemFactory().CreateSystem().isUnixSystem() && this.m_crsResource != null) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                this.m_crsResource.setPermissions((ResourcePermissions)perm);
            }
        }
        catch (CRSException e) {
            throw new AsmClusterFileSystemException(e);
        }
    }

    public void modifyLocalResource(FileSystemOptionalArgs fsOptionalArgs) throws AsmClusterFileSystemException {
        try {
            FSEnums.AutostartEnum autostart;
            String description;
            String fsOptions;
            ResourceAttribute attr;
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            String mountPointPath = fsOptionalArgs.getMountPointPath();
            if (mountPointPath != null) {
                if (this.isRunning()) {
                    Trace.out((String)"Resource is running, unable to modify the mount point path.");
                    throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FS_RUNNING_MOD_MTPT, new Object[0]);
                }
                mountPointPath = mountPointPath.trim();
                AsmClusterFileSystemImpl.validateMountPointPath(mountPointPath);
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.MOUNTPOINT_PATH.name(), mountPointPath);
                Trace.out((String)("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\""));
                attrList.add(attr);
                attr = new ResourceAttribute(ResourceType.AsmClusterFileSystem.INTERNAL_MOUNTPOINT_PATH.name(), ASMFactoryImpl.getInternalMountPoint(mountPointPath));
                Trace.out((String)("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\""));
                attrList.add(attr);
            }
            if ((fsOptions = fsOptionalArgs.getFSOptions()) != null) {
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.FS_OPTIONS.name(), fsOptions);
                Trace.out((String)("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\""));
                attrList.add(attr);
            }
            if ((description = fsOptionalArgs.getDescription()) != null) {
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.FS_DESCRIPTION.name(), description);
                Trace.out((String)("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\""));
                attrList.add(attr);
            }
            if ((autostart = fsOptionalArgs.getAutostart()) != null) {
                attr = new ResourceAttribute(ResourceType.LocalResource.AUTO_START.name(), autostart.getValue());
                Trace.out((String)("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\""));
                attrList.add(attr);
            }
            if (fsOptionalArgs.getMountOwner() != null && !fsOptionalArgs.getMountOwner().isEmpty()) {
                this.setMountOwner(fsOptionalArgs.getMountOwner());
            }
            if (fsOptionalArgs.getUsers() != null && fsOptionalArgs.getUsers().length > 0) {
                this.setUsers(Arrays.asList(fsOptionalArgs.getUsers()));
            }
            if (attrList.size() > 0) {
                this.m_crsResource.update(attrList.toArray(new ResourceAttribute[attrList.size()]));
            }
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.MODIFY_FILESYSTEM_FAILED, crse, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
        catch (SoftwareModuleException sme) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.MODIFY_FILESYSTEM_FAILED, sme, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
        catch (NotExistsException nee) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.MODIFY_FILESYSTEM_FAILED, nee, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AsmClusterFileSystemImpl fs = (AsmClusterFileSystemImpl)obj;
        return this.m_name != null && this.m_name.equals(fs.getName());
    }
}

