/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMInstance;
import oracle.cluster.asm.ASMInstanceException;
import oracle.cluster.asm.ASMType;
import oracle.cluster.asm.ClusterASM;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.asm.ProxyASM;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.impl.asm.ASMImpl;
import oracle.cluster.impl.asm.BaseASMImpl;
import oracle.cluster.impl.database.InstanceImpl;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ASMInstanceImpl
extends InstanceImpl
implements ASMInstance {
    private BaseASMImpl m_asm;
    private ASMType m_type;
    private boolean m_isCluster;
    private String m_riID;
    private String m_state;

    ASMInstanceImpl(ASM asm, String instanceName, Node node, boolean isCluster) {
        this.m_asm = (BaseASMImpl)((Object)asm);
        this.m_type = ASMType.LEGACY_ASM;
        this.m_name = this.m_asm.getUserAssignedName();
        this.m_displayName = instanceName;
        this.m_isDBInstance = false;
        this.m_node = node;
        this.m_isCluster = isCluster;
    }

    ASMInstanceImpl(ClusterASM asm, String riID, String instanceName, Node node, String state) {
        this.m_asm = (BaseASMImpl)((Object)asm);
        this.m_type = ASMType.CLUSTER_ASM;
        this.m_riID = riID;
        this.m_name = this.m_asm.getUserAssignedName();
        this.m_displayName = instanceName;
        this.m_isDBInstance = false;
        this.m_node = node;
        this.m_state = state;
        this.m_isCluster = true;
    }

    ASMInstanceImpl(ProxyASM advm, String instanceName, Node node) {
        this.m_asm = (BaseASMImpl)((Object)advm);
        this.m_type = ASMType.PROXY_ASM;
        this.m_name = this.m_asm.getUserAssignedName();
        this.m_displayName = instanceName;
        this.m_isDBInstance = false;
        this.m_node = node;
        this.m_isCluster = true;
    }

    @Override
    public String getSPFile() throws NotExistsException, ASMInstanceException {
        return "";
    }

    @Override
    public void setSPFile(String spfile) throws ASMInstanceException {
    }

    @Override
    public ASM getASM() throws ASMException {
        return (ASM)((Object)this.m_asm);
    }

    @Override
    public String getID() {
        return this.m_riID;
    }

    @Override
    public String getState() {
        return this.m_state;
    }

    @Override
    public List<DatabaseInstance> instances() throws NotExistsException, ASMInstanceException {
        throw new ASMInstanceException((MessageKey)PrCrMsgID.RES_ATTR_NOT_EXISTS, this.getUserAssignedName(), "NOT IMPLEMENTED YET");
    }

    @Override
    public List<DiskGroup> diskgroups() throws ASMInstanceException {
        throw new ASMInstanceException((MessageKey)PrCrMsgID.RES_ATTR_NOT_EXISTS, this.getUserAssignedName(), "NOT IMPLEMENTED YET");
    }

    public boolean isRunning() throws SoftwareModuleException {
        if (!this.m_isCluster) {
            Trace.out((String)"check whether ASM is running");
            return this.m_asm.isRunning();
        }
        return this.m_asm.isRunning(this.m_node);
    }

    public boolean isRunning(Node node) throws SoftwareModuleException {
        return this.m_asm.isRunning(node);
    }

    public boolean isEnabled() throws SoftwareModuleException {
        if (!this.m_isCluster) {
            return this.m_asm.isEnabled();
        }
        return this.m_asm.isEnabled(this.m_node);
    }

    public boolean isEnabled(Node node) throws SoftwareModuleException {
        return this.m_asm.isEnabled(node);
    }

    public void enable() throws AlreadyEnabledException, SoftwareModuleException {
        if (!this.m_isCluster) {
            this.m_asm.enable();
        } else {
            try {
                ArrayList<Node> nodelist = new ArrayList<Node>(1);
                nodelist.add(this.m_node);
                ((ASMImpl)this.m_asm).enable(nodelist);
            }
            catch (CompositeOperationException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        }
    }

    public void disable() throws AlreadyDisabledException, SoftwareModuleException {
        if (!this.m_isCluster) {
            this.m_asm.disable();
        } else {
            try {
                ArrayList<Node> nodelist = new ArrayList<Node>(1);
                nodelist.add(this.m_node);
                ((ASMImpl)this.m_asm).disable(nodelist);
            }
            catch (CompositeOperationException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        }
    }

    public void start() throws AlreadyRunningException, SoftwareModuleException {
        if (!this.m_isCluster) {
            this.m_asm.start();
        } else {
            try {
                ArrayList<Node> nodelist = new ArrayList<Node>(1);
                nodelist.add(this.m_node);
                ((ASMImpl)this.m_asm).start(nodelist);
            }
            catch (CompositeOperationException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        }
    }

    public void stop(boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        if (!this.m_isCluster) {
            this.m_asm.stop(force);
        } else {
            try {
                ArrayList<Node> nodelist = new ArrayList<Node>(1);
                nodelist.add(this.m_node);
                ((ASMImpl)this.m_asm).stop((List<Node>)nodelist, force);
            }
            catch (CompositeOperationException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        }
    }
}

