/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.asm.ACFSInfo;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMInstance;
import oracle.cluster.asm.ASMMode;
import oracle.cluster.asm.ASMPresence;
import oracle.cluster.asm.AsmBaseFileSystem;
import oracle.cluster.asm.AsmClusterFileSystem;
import oracle.cluster.asm.AsmClusterFileSystemException;
import oracle.cluster.asm.CCMB;
import oracle.cluster.asm.ClusterASM;
import oracle.cluster.asm.ConnectionInfo;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.asm.FSEnums;
import oracle.cluster.asm.FileSystem;
import oracle.cluster.asm.FileSystemOptionalArgs;
import oracle.cluster.asm.IOServer;
import oracle.cluster.asm.IOServerInstance;
import oracle.cluster.asm.ProxyASM;
import oracle.cluster.asm.Volume;
import oracle.cluster.asm.VolumeException;
import oracle.cluster.cmdtools.ADVMUtil;
import oracle.cluster.cmdtools.ASMCMDUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OFSUtil;
import oracle.cluster.cmdtools.USMDriverUtil;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.common.UpgradePhase;
import oracle.cluster.crs.ActionAttribute;
import oracle.cluster.crs.ActionListener;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.CompositeActionException;
import oracle.cluster.crs.CompositeActionStatus;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.MgmtDatabase;
import oracle.cluster.impl.asm.ACFSInfoImpl;
import oracle.cluster.impl.asm.ASMImpl;
import oracle.cluster.impl.asm.AsmBaseFileSystemImpl;
import oracle.cluster.impl.asm.AsmClusterFileSystemImpl;
import oracle.cluster.impl.asm.CCMBImpl;
import oracle.cluster.impl.asm.ClusterASMImpl;
import oracle.cluster.impl.asm.ConnNative;
import oracle.cluster.impl.asm.ConnNativeException;
import oracle.cluster.impl.asm.ConnNativeResult;
import oracle.cluster.impl.asm.DiskGroupImpl;
import oracle.cluster.impl.asm.FileSystemImpl;
import oracle.cluster.impl.asm.IOServerImpl;
import oracle.cluster.impl.asm.ProxyASMImpl;
import oracle.cluster.impl.asm.VolumeImpl;
import oracle.cluster.impl.crs.ActionListenerImpl;
import oracle.cluster.impl.crs.ActionStatusImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.CompositeActionStatusImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.SiteException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.UpgradeException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.OCRNative;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.rawdevice.OCRResult;
import oracle.ops.mgmt.trace.Trace;

public class ASMFactoryImpl {
    private static ASMFactoryImpl s_instance;
    private static String m_crsHome;
    private static ASMMode m_asmmode;
    private static UpgradePhase m_upgradePhase;
    private String m_autostart = null;
    private static final int s_trialLimit = 30;
    private static final String DEVICE_REGEX;
    private static final String CRS_ALREADY_RUNNING = "CRS-5702";

    private ASMFactoryImpl() throws SoftwareModuleException {
        try {
            m_crsHome = new Util().getCRSHome();
        }
        catch (UtilException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    public static synchronized ASMFactoryImpl getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new ASMFactoryImpl();
        }
        return s_instance;
    }

    public static boolean isClientMode() throws ASMException {
        if (!Cluster.isCluster()) {
            return false;
        }
        if (m_asmmode == null) {
            try {
                m_asmmode = new ClusterUtil().getASMMode();
                Trace.out((String)("ASMMode = " + (Object)((Object)m_asmmode)));
            }
            catch (ClusterUtilException ce) {
                throw new ASMException((MessageKey)PrCaMsgID.GET_ASM_MODE_FAILED, ce, new Object[0]);
            }
        }
        return m_asmmode == ASMMode.CLIENT;
    }

    public static void setUpgradePhase(UpgradePhase phase) {
        m_upgradePhase = phase;
    }

    public static UpgradePhase getUpgradePhase() {
        return m_upgradePhase;
    }

    public Volume getVolume(String device) throws NotExistsException, VolumeException {
        List<Volume> volumes = this.getVolumes(device, null, null);
        int volSize = volumes.size();
        if (volSize < 1) {
            throw new NotExistsException((MessageKey)PrCaMsgID.VOLUME_DEVICE_NOT_EXIST, new Object[]{device});
        }
        if (volSize > 1) {
            throw new VolumeException((MessageKey)PrCaMsgID.NOT_UNIQUE_VOLUME_DEVICE, device);
        }
        return volumes.iterator().next();
    }

    public Volume getVolume(String volumename, String diskgroup) throws NotExistsException, VolumeException {
        List<Volume> volumes = this.getVolumes(null, volumename, diskgroup);
        int volSize = volumes.size();
        if (volSize < 1) {
            throw new NotExistsException((MessageKey)PrCaMsgID.VOLUME_DG_VOLNAME_NOT_EXIST, new Object[]{diskgroup, volumename});
        }
        if (volSize > 1) {
            throw new VolumeException((MessageKey)PrCaMsgID.NOT_SINGLE_VOLUME_ERROR, diskgroup, volumename);
        }
        return volumes.iterator().next();
    }

    public List<Volume> getVolumes() throws NotExistsException, VolumeException {
        return this.getVolumes(null, null, null);
    }

    public List<Volume> getVolumes(String device, String volumename, String diskgroup) throws NotExistsException, VolumeException {
        Trace.out((String)("Get volume(s) for device (" + device + "), volume name (" + volumename + "), diskgroup (" + diskgroup + ")"));
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter allVolumeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Volume.NAME.toString());
            if (diskgroup != null) {
                Filter startsWith = crsFactory.getFilter(Filter.Comparator.STARTS_WITH, ResourceType.Volume.NAME.name(), "ora." + diskgroup.toUpperCase() + '.');
                allVolumeFilter = crsFactory.getFilter(Filter.Operator.AND, allVolumeFilter, startsWith);
            }
            if (volumename != null) {
                Filter endsWith = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceType.Volume.NAME.name(), '.' + volumename.toUpperCase() + '.' + ResourceLiterals.ADVM);
                allVolumeFilter = crsFactory.getFilter(Filter.Operator.AND, allVolumeFilter, endsWith);
            }
            if (device != null) {
                String canonicalDevice = device;
                try {
                    ADVMUtil advmutil = new ADVMUtil(m_crsHome);
                    canonicalDevice = advmutil.getCanonicalVolume(device);
                    Trace.out((String)("canonical volume device = " + canonicalDevice));
                }
                catch (CmdToolUtilException e) {
                    Trace.out((String)("Failed to get the canonical volume device for " + device));
                    Trace.out((String)("Got CmdToolUtilException " + e.getMessage()));
                }
                Filter deviceFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.Volume.VOLUME_DEVICE.name(), device);
                Filter canonicalDeviceFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.Volume.CANONICAL_VOLUME_DEVICE.name(), canonicalDevice);
                allVolumeFilter = crsFactory.getFilter(Filter.Operator.AND, allVolumeFilter, crsFactory.getFilter(Filter.Operator.OR, deviceFilter, canonicalDeviceFilter));
            }
            Trace.out((String)("Using the filter: " + allVolumeFilter.toString()));
            Map resList = crsFactory.searchEntities(CRSEntity.Type.Resource, false, allVolumeFilter, new String[0]);
            if (resList.size() == 0) {
                Trace.out((String)("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.Volume.NAME.toString()));
                throw new NotExistsException((MessageKey)PrCaMsgID.VOLUME_RES_NOT_EXIST, new Object[]{resList.toString()});
            }
            ArrayList<VolumeImpl> volumeList = new ArrayList<VolumeImpl>();
            for (Map.Entry entry : resList.entrySet()) {
                String vName = (String)entry.getKey();
                ResourceAttribute attr = new ResourceAttribute(ResourceType.Volume.NAME.name(), vName);
                VolumeImpl volume = new VolumeImpl(attr);
                volumeList.add(volume);
            }
            if (volumeList.size() > 0) {
                return Collections.unmodifiableList(volumeList);
            }
            Trace.out((String)("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.Volume.NAME.toString()));
            throw new NotExistsException((MessageKey)PrCaMsgID.VOLUME_RES_NOT_EXIST, new Object[]{resList.toString()});
        }
        catch (VolumeException e) {
            throw new VolumeException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, (Throwable)((Object)e), ResourceType.Volume.NAME.toString());
        }
        catch (CRSException e) {
            throw new VolumeException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, e, ResourceType.Volume.NAME.toString());
        }
    }

    public List<DiskGroup> getDiskGroups() throws NotExistsException, ASMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List resList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.DiskGroup.NAME.toString()));
            if (resList.size() == 0) {
                Trace.out((String)("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.DiskGroup.NAME.toString()));
                throw new NotExistsException((MessageKey)PrCaMsgID.DG_RES_NOT_EXIST, new Object[]{resList.toString()});
            }
            ArrayList<DiskGroupImpl> dgList = new ArrayList<DiskGroupImpl>(resList.size());
            for (ResourceAttribute attr : resList) {
                try {
                    dgList.add(new DiskGroupImpl(attr));
                }
                catch (NotExistsException notExistsException) {}
            }
            if (dgList.size() > 0) {
                return Collections.unmodifiableList(dgList);
            }
            Trace.out((String)("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.DiskGroup.NAME.toString()));
            throw new NotExistsException((MessageKey)PrCaMsgID.DG_RES_NOT_EXIST, new Object[]{resList.toString()});
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, e, ResourceType.DiskGroup.NAME.toString());
        }
    }

    public DiskGroup getDiskGroup(String dgName) throws NotExistsException, ASMException {
        if (null == dgName) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dgName", dgName);
        }
        try {
            EntityOperations.EntityOpsMode mode = EntityOperations.EntityOpsMode.CRS;
            if (ASMFactoryImpl.isClientMode()) {
                mode = EntityOperations.EntityOpsMode.Local;
            }
            return new DiskGroupImpl(CRSFactoryImpl.getInstance().create(ResourceType.DiskGroup.NAME.name(), DiskGroupImpl.getResourceName(dgName)), dgName, mode);
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.DG_NOT_EXIST, e, dgName);
        }
    }

    public void startDiskGroup(String dgName, Node node) throws ASMException, AlreadyRunningException {
        if (null == dgName || dgName.trim().length() == 0) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dgName", dgName);
        }
        if (null == node) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node", dgName);
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute ra = crsFactory.create(ResourceType.DiskGroup.NAME.name(), DiskGroupImpl.getResourceName(dgName));
            CRSResourceImpl dg = (CRSResourceImpl)crsFactory.getRegisteredOrNot(ra);
            dg.start(node);
        }
        catch (CRSException ce) {
            throw new ASMException(ce);
        }
        catch (NodeException ne) {
            throw new ASMException(ne);
        }
    }

    public void startDiskGroup(String dgName) throws ASMException, AlreadyRunningException {
        if (null == dgName || dgName.trim().length() == 0) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dgName", dgName);
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute ra = crsFactory.create(ResourceType.DiskGroup.NAME.name(), DiskGroupImpl.getResourceName(dgName));
            CRSResourceImpl dg = (CRSResourceImpl)crsFactory.getRegisteredOrNot(ra);
            dg.start();
        }
        catch (CRSException ce) {
            throw new ASMException(ce);
        }
    }

    public void startDiskGroupByName(String dgName, Node node) throws ASMException {
        try {
            this.startDiskGroup(dgName, node);
        }
        catch (AlreadyRunningException ar) {
            throw new ASMException(ar);
        }
    }

    public void startDiskGroupByName(String dgName) throws ASMException {
        try {
            this.startDiskGroup(dgName);
        }
        catch (AlreadyRunningException ar) {
            throw new ASMException(ar);
        }
    }

    public void startFileSystems(String[] volNames, String[] dgNames) throws AsmClusterFileSystemException, NotExistsException, AlreadyRunningException {
        this.startFileSystems(volNames, dgNames, null);
    }

    public void startFileSystems(String[] volNames, String[] dgNames, Node node) throws AsmClusterFileSystemException, NotExistsException, AlreadyRunningException {
        try {
            Utils.assertInput((String[])volNames, (String)"volume names");
            Utils.assertInput((String[])dgNames, (String)"disk group names");
            if (volNames.length != dgNames.length) {
                Trace.out((String)"Unmatching size for volume names and disk group names");
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.UNMATCHING_VOLDG_NAME, new Object[0]);
            }
            ArrayList<AsmBaseFileSystem> fsList = new ArrayList<AsmBaseFileSystem>(volNames.length);
            for (int i = 0; i < volNames.length; ++i) {
                fsList.add(this.getFileSystem(volNames[i], dgNames[i]));
            }
            ASMFactoryImpl.startFileSystems(fsList, node);
        }
        catch (InvalidArgsException iae) {
            throw new AsmClusterFileSystemException(iae);
        }
        catch (ASMException ae) {
            throw new AsmClusterFileSystemException((Throwable)((Object)ae));
        }
        catch (CompositeOperationException coe) {
            throw new AsmClusterFileSystemException(coe);
        }
    }

    public static void startFileSystems(List<AsmBaseFileSystem> baseFSList, Node node) throws CompositeOperationException, ASMException, AlreadyRunningException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            String resName = null;
            Filter filter = null;
            Filter resFilter = null;
            for (AsmBaseFileSystem baseFS : baseFSList) {
                resName = baseFS.getName();
                Trace.out((String)("resname is " + resName));
                resFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.BaseFileSystem.NAME.name(), resName);
                if (filter == null) {
                    filter = resFilter;
                    continue;
                }
                filter = crsFactory.getFilter(Filter.Operator.OR, filter, resFilter);
            }
            if (filter != null) {
                if (node == null) {
                    CRSFactoryImpl.startResources(filter, null, null);
                } else {
                    CRSFactoryImpl.startResources(filter, (String)node.getName(), null);
                }
            }
        }
        catch (NodeException ne) {
            throw new ASMException(ne);
        }
        catch (CRSException ce) {
            throw new ASMException(ce);
        }
        catch (CompositeOperationException coe) {
            Trace.out((String)"CompositeOperationException, check if the cause is from mixed disabled/running FS");
            String outMsg = coe.getCompositeMessages() != null ? coe.getCompositeMessages() : "";
            for (String message : outMsg.split(Constants.NEWLINE)) {
                if (message.contains(CRS_ALREADY_RUNNING)) continue;
                throw new ASMException((MessageKey)PrCaMsgID.START_FILESYSTEMS_FAIL, outMsg);
            }
            throw new AlreadyRunningException((MessageKey)PrCrMsgID.RES_ALREADY_RUNNING, new Object[]{outMsg});
        }
    }

    private AsmBaseFileSystem createClusterResource(FileSystemOptionalArgs fsOptionalArgs, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        if (version == null) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        String volDevicePath = fsOptionalArgs.getVolumeDevicePath();
        String volName = fsOptionalArgs.getVolumeName();
        String dgName = fsOptionalArgs.getDiskGroupName();
        String mountPoint = fsOptionalArgs.getMountPointPath();
        String[] nodeNames = fsOptionalArgs.getNodeNames();
        boolean isACFS = fsOptionalArgs.getFSType() == FSEnums.FSTypeEnum.ACFS;
        Trace.out((String)("Canonicalize volume device " + volDevicePath));
        volDevicePath = this.canonicalizeDevicePath(volDevicePath);
        if (isACFS && !this.isACFSSupported(m_crsHome)) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.ACFS_NOT_SUPPORTED_MSG, new Object[0]);
        }
        try {
            this.getFileSystem(volDevicePath);
        }
        catch (NotExistsException nee) {
            Trace.out((String)("No filesystem resource found (as expected) for the volume device path \"" + volDevicePath + "\""));
        }
        AsmBaseFileSystemImpl.validateMountPointPath(mountPoint);
        Boolean isClusterFS = true;
        if (nodeNames != null) {
            for (String node : nodeNames) {
                if (!this.isLocalFSMountPoint(mountPoint, node)) continue;
                Trace.out((String)("Mount point path " + mountPoint + " is already in use by another node local FS resource in the node " + node));
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FS_MOUNTPOINT_IN_USE_ON_NODE, mountPoint, node);
            }
        } else if (this.isFSMountPoint(mountPoint, isClusterFS)) {
            Trace.out((String)("Mount point path " + mountPoint + " is already in use by another ACFS resource"));
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FS_MOUNTPOINT_IN_USE, mountPoint);
        }
        String resourceName = fsOptionalArgs.isClientCluster() ? this.generateODAFSResourceName(volDevicePath, isACFS) : this.generateFSResourceName(dgName, volName, isACFS);
        Trace.out((String)("resourceName = " + resourceName));
        try {
            Trace.out((String)"Ready to create filesystem cluster resource");
            AsmBaseFileSystemImpl clusterFS = isACFS ? new AsmClusterFileSystemImpl(CRSFactoryImpl.getInstance().create(ResourceType.BaseFileSystem.NAME.name(), resourceName)) : new FileSystemImpl(CRSFactoryImpl.getInstance().create(ResourceType.BaseFileSystem.NAME.name(), resourceName));
            clusterFS.createClusterResource(fsOptionalArgs, version);
            return clusterFS;
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.ACFS_CREATE_FAILED, crse, resourceName, volDevicePath);
        }
    }

    public AsmClusterFileSystem getACFS(String volName, String dgName) throws NotExistsException, AsmClusterFileSystemException {
        return (AsmClusterFileSystemImpl)this.doGetFileSystem(volName, dgName, true);
    }

    public AsmClusterFileSystem getAsmClusterFileSystem(String volDevice) throws NotExistsException, AsmClusterFileSystemException {
        String crsHome;
        try {
            crsHome = new Util().getCRSHome();
        }
        catch (UtilException e) {
            throw new AsmClusterFileSystemException(e);
        }
        return this.getAsmClusterFileSystem(volDevice, crsHome);
    }

    public AsmClusterFileSystem getAsmClusterFileSystem(String volDevice, String oracleHome) throws NotExistsException, AsmClusterFileSystemException {
        if (null == volDevice || volDevice.trim().length() == 0) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "volDevice", volDevice);
        }
        Trace.out((String)("Getting Asm Cluster file system for volume device " + volDevice));
        Trace.out((String)("Canonicalize volume device " + volDevice));
        volDevice = this.canonicalizeDevicePath(volDevice);
        Trace.out((String)("new volume device = " + volDevice));
        try {
            if (ASMFactoryImpl.isClientMode()) {
                return (AsmClusterFileSystem)this.getDBAASFS(volDevice);
            }
        }
        catch (ASMException ae) {
            Trace.out((String)"failed to determine ASM mode");
            throw new AsmClusterFileSystemException((Throwable)((Object)ae));
        }
        List<AsmClusterFileSystem> fslist = this.getAsmClusterFileSystems();
        for (AsmClusterFileSystem fs : fslist) {
            String canVolDevice = fs.getCanonicalVolumeDevice();
            Trace.out((String)("canonical form of volume device = " + canVolDevice));
            if (!volDevice.equalsIgnoreCase(canVolDevice)) continue;
            Trace.out((String)("Getting Asm Cluster file system for volume device, " + fs.getVolumeDevice() + " disk group name, " + fs.getDiskGroup() + " volume name, " + fs.getVolumeName() + " and resource name, " + fs.getName()));
            return fs;
        }
        throw new NotExistsException((MessageKey)PrCaMsgID.ACFS_RES_NOT_EXIST, new Object[]{volDevice});
    }

    public List<AsmClusterFileSystem> getAsmClusterFileSystems() throws NotExistsException, AsmClusterFileSystemException {
        try {
            if (ASMFactoryImpl.isClientMode()) {
                Trace.out((String)"ACFS-Remote cluster, looking for dbaasfs resources");
                List<AsmBaseFileSystem> dbaasFSList = this.getDBAASFSList();
                ArrayList<AsmClusterFileSystem> fsList = new ArrayList<AsmClusterFileSystem>(dbaasFSList.size());
                for (AsmBaseFileSystem fs : dbaasFSList) {
                    fsList.add((AsmClusterFileSystem)fs);
                }
                return fsList;
            }
        }
        catch (ASMException ae) {
            Trace.out((String)"failed to determine ASM mode");
            throw new AsmClusterFileSystemException((Throwable)((Object)ae));
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            String appId_res_suffix = '_' + ResourceLiterals.FS.toString() + '.' + ResourceLiterals.TYPE.toString();
            Filter filter_eqAcfstype = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE_ATTR.toString(), ResourceLiterals.ACFS_TYPE.toString());
            Filter filter_eqCAcfstype = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE_ATTR.toString(), ResourceLiterals.CLUSTER_ACFS_TYPE.toString());
            Filter filter_enWAppIdtype = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.TYPE_ATTR.toString(), appId_res_suffix);
            Filter filter_orAcfsType = crsFactory.getFilter(Filter.Operator.OR, filter_eqAcfstype, filter_eqCAcfstype);
            Filter filter_orType = crsFactory.getFilter(Filter.Operator.OR, filter_orAcfsType, filter_enWAppIdtype);
            Filter filter_FSTYPE = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.AsmClusterFileSystem.FS_TYPE.name(), FSEnums.FSTypeEnum.ACFS.name());
            Filter filter_emptyFSTYPE = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.AsmClusterFileSystem.FS_TYPE.name(), "");
            Filter filter_orFSTYPE = crsFactory.getFilter(Filter.Operator.OR, filter_FSTYPE, filter_emptyFSTYPE);
            Filter filter_fs = crsFactory.getFilter(Filter.Operator.AND, filter_orType, filter_orFSTYPE);
            List resList = crsFactory.searchResources(CRSEntity.Type.Resource, filter_fs);
            if (resList.size() == 0) {
                Trace.out((String)("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.AsmClusterFileSystem.NAME.toString()));
                throw new NotExistsException((MessageKey)PrCaMsgID.ACFS_RES_NOT_EXIST_CLUSTER, new Object[0]);
            }
            ArrayList<AsmClusterFileSystemImpl> fsList = new ArrayList<AsmClusterFileSystemImpl>(resList.size());
            for (ResourceAttribute attr : resList) {
                fsList.add(new AsmClusterFileSystemImpl(attr));
            }
            if (fsList.size() > 0) {
                return Collections.unmodifiableList(fsList);
            }
            Trace.out((String)("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.AsmClusterFileSystem.NAME.toString()));
            throw new NotExistsException((MessageKey)PrCaMsgID.ACFS_RES_NOT_EXIST_CLUSTER, new Object[0]);
        }
        catch (CRSException e) {
            throw new AsmClusterFileSystemException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, e, ResourceType.AsmClusterFileSystem.NAME.toString());
        }
    }

    public AsmBaseFileSystem getFileSystem(String volName, String dgName) throws NotExistsException, AsmClusterFileSystemException {
        try {
            return this.doGetFileSystem(volName, dgName, true);
        }
        catch (NotExistsException nee) {
            Trace.out((String)"Volume and diskgroup are not for an ACFS resource");
            return this.doGetFileSystem(volName, dgName, false);
        }
    }

    private AsmBaseFileSystem doGetFileSystem(String volName, String dgName, boolean isACFS) throws NotExistsException, AsmClusterFileSystemException {
        try {
            Utils.assertInput((String)dgName, (String)"disk group name");
            Utils.assertInput((String)volName, (String)"volume name");
            volName = volName.toLowerCase();
            dgName = dgName.toLowerCase();
            String resName = isACFS ? "ora." + dgName + '.' + volName + '.' + ResourceLiterals.ACFS.toString() : "ora." + dgName + '.' + volName + '.' + ResourceLiterals.FS.toString();
            ResourceAttribute nameAttr = CRSFactoryImpl.getInstance().create(ResourceType.AsmClusterFileSystem.NAME.name(), resName);
            CRSFactoryImpl.getInstance().get(nameAttr);
            if (isACFS) {
                return new AsmClusterFileSystemImpl(nameAttr);
            }
            return new FileSystemImpl(nameAttr);
        }
        catch (InvalidArgsException iae) {
            throw new AsmClusterFileSystemException(iae);
        }
        catch (CRSException ce) {
            throw new AsmClusterFileSystemException(ce);
        }
    }

    public AsmBaseFileSystem getFileSystem(String volumeDevicePath) throws NotExistsException, AsmClusterFileSystemException {
        AsmBaseFileSystem abfs;
        try {
            abfs = this.getFileSystem(volumeDevicePath, true);
        }
        catch (NotExistsException ne1) {
            Trace.out((String)("Failed to match canonical_volume_device path . Exception : " + ne1.getMessage()));
            Trace.out((String)"Retrying with volume_device path");
            try {
                abfs = this.getFileSystem(volumeDevicePath, false);
            }
            catch (NotExistsException ne2) {
                Trace.out((String)("Failed to match device_path as well.Exception :" + ne2.getMessage()));
                throw ne2;
            }
        }
        return abfs;
    }

    private AsmBaseFileSystem getFileSystem(String volumeDevicePath, boolean canonical) throws NotExistsException, AsmClusterFileSystemException {
        List resList;
        CRSFactoryImpl crsFactory = null;
        String[] attrNames = new String[]{ResourceType.BaseFileSystem.VOLUME_DEVICE.name()};
        String[] attrValues = new String[]{volumeDevicePath};
        if (canonical) {
            volumeDevicePath = this.canonicalizeDevicePath(volumeDevicePath);
            Trace.out((String)("Canonicalize volume device " + volumeDevicePath));
            attrNames[0] = ResourceType.BaseFileSystem.CANONICAL_VOLUME_DEVICE.name();
            attrValues[0] = volumeDevicePath;
        }
        try {
            if (ASMFactoryImpl.isClientMode()) {
                return this.getDBAASFS(volumeDevicePath);
            }
        }
        catch (ASMException ae) {
            Trace.out((String)"failed to determine ASM mode");
            throw new AsmClusterFileSystemException((Throwable)((Object)ae));
        }
        try {
            crsFactory = CRSFactoryImpl.getInstance();
            resList = crsFactory.searchResources_matchAll(attrNames, attrValues);
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException(crse);
        }
        int numOfMatchingFSResources = 0;
        ResourceAttribute nameAttrForMatchingFSResource = null;
        if (resList != null && resList.size() > 0) {
            for (ResourceAttribute currNameAttr : resList) {
                if (!currNameAttr.getName().equalsIgnoreCase(ResourceType.BaseFileSystem.NAME.name())) {
                    throw new AsmClusterFileSystemException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, ResourceType.AsmClusterFileSystem.NAME.name(), currNameAttr.getName());
                }
                String currNameAttrValue = currNameAttr.getValue();
                if (currNameAttrValue == null || !(currNameAttrValue = currNameAttrValue.trim()).endsWith('.' + ResourceLiterals.ACFS.toString()) && !currNameAttrValue.endsWith('.' + ResourceLiterals.FS.toString())) continue;
                Trace.out((String)("Found a matching filesystem resource with " + ResourceType.BaseFileSystem.VOLUME_DEVICE.name() + "=" + volumeDevicePath + " -- Resource name: " + currNameAttrValue));
                nameAttrForMatchingFSResource = currNameAttr;
                ++numOfMatchingFSResources;
            }
            if (numOfMatchingFSResources > 0) {
                if (numOfMatchingFSResources != 1) {
                    throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.NOT_UNIQUE_FILESYSTEM_FOR_GIVEN_VOLUME_DEVICE, volumeDevicePath);
                }
                if (nameAttrForMatchingFSResource.getValue().toLowerCase().endsWith(ResourceLiterals.ACFS.toString())) {
                    return new AsmClusterFileSystemImpl(nameAttrForMatchingFSResource);
                }
                return new FileSystemImpl(nameAttrForMatchingFSResource);
            }
        }
        throw new NotExistsException((MessageKey)PrCaMsgID.NO_FILESYSTEM_FOUND_FOR_VOLUME_DEVICE, new Object[]{volumeDevicePath});
    }

    public List<AsmBaseFileSystem> getFileSystems() throws NotExistsException, AsmClusterFileSystemException {
        List resList;
        ArrayList<AsmBaseFileSystem> fileSystemList = new ArrayList<AsmBaseFileSystem>();
        CRSFactoryImpl crsFactory = null;
        String acfs_res_suffix = '.' + ResourceLiterals.ACFS.toString();
        String fs_res_suffix = '.' + ResourceLiterals.FS.toString();
        String appId_res_suffix = '_' + ResourceLiterals.FS.toString() + '.' + ResourceLiterals.TYPE.toString();
        try {
            if (ASMFactoryImpl.isClientMode()) {
                Trace.out((String)"ACFS-remote, looking for dbaasfs resources");
                return this.getDBAASFSList();
            }
        }
        catch (ASMException ae) {
            Trace.out((String)"failed to determine ASM mode");
            throw new AsmClusterFileSystemException((Throwable)((Object)ae));
        }
        try {
            crsFactory = CRSFactoryImpl.getInstance();
            Filter filter_stWOra = crsFactory.getFilter(Filter.Comparator.STARTS_WITH, ResourceLiterals.NAME.toString(), "ora.");
            Filter filter_enWAcfs = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.NAME.toString(), acfs_res_suffix);
            Filter filter_eqAcfstype = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE_ATTR.toString(), ResourceLiterals.ACFS_TYPE.toString());
            Filter filter_eqCAcfstype = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE_ATTR.toString(), ResourceLiterals.CLUSTER_ACFS_TYPE.toString());
            Filter filter_enWAppIdtype = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.TYPE_ATTR.toString(), appId_res_suffix);
            Filter filter_orAcfsType = crsFactory.getFilter(Filter.Operator.OR, filter_eqAcfstype, filter_eqCAcfstype);
            Filter filter_orType = crsFactory.getFilter(Filter.Operator.OR, filter_orAcfsType, filter_enWAppIdtype);
            Filter filter_andAcfs = crsFactory.getFilter(Filter.Operator.AND, filter_enWAcfs, filter_orType);
            Filter filter_enWFS = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.NAME.toString(), fs_res_suffix);
            Filter filter_enOR = crsFactory.getFilter(Filter.Operator.OR, filter_andAcfs, filter_enWFS);
            Filter fsFilter = crsFactory.getFilter(Filter.Operator.AND, filter_stWOra, filter_enOR);
            Trace.out((String)"Find file system resources");
            resList = crsFactory.searchResources(CRSEntity.Type.Resource, fsFilter);
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException(crse);
        }
        if (resList != null && resList.size() > 0) {
            for (ResourceAttribute currNameAttr : resList) {
                String currNameAttrValue = currNameAttr.getValue();
                if (currNameAttrValue == null) continue;
                currNameAttrValue = currNameAttrValue.trim();
                Trace.out((String)("Found a filesystem resource -- Resource name: " + currNameAttrValue));
                if (currNameAttrValue.toLowerCase().endsWith(ResourceLiterals.ACFS.toString())) {
                    fileSystemList.add(new AsmClusterFileSystemImpl(currNameAttr));
                    continue;
                }
                fileSystemList.add(new FileSystemImpl(currNameAttr));
            }
        }
        if (fileSystemList.size() == 0) {
            throw new NotExistsException((MessageKey)PrCaMsgID.FILESYSTEM_RES_NOT_FOUND, new Object[0]);
        }
        return fileSystemList;
    }

    public List<AsmBaseFileSystem> getValidationFileSystems(String mountPoint, boolean isClusterFS) throws NotExistsException, AsmClusterFileSystemException {
        List resList;
        boolean hasMountPt;
        ArrayList<AsmBaseFileSystem> fileSystemList = new ArrayList<AsmBaseFileSystem>();
        CRSFactoryImpl crsFactory = null;
        String acfs_res_suffix = '.' + ResourceLiterals.ACFS.toString();
        String fs_res_suffix = '.' + ResourceLiterals.FS.toString();
        String appId_res_suffix = '_' + ResourceLiterals.FS.toString() + '.' + ResourceLiterals.TYPE.toString();
        boolean isWindows = !new SystemFactory().CreateSystem().isUnixSystem();
        boolean bl = hasMountPt = mountPoint != null && mountPoint.length() > 0;
        if (hasMountPt && isWindows) {
            mountPoint = ASMFactoryImpl.getInternalMountPoint(mountPoint);
            Trace.out((String)("Is Windows platform: transform mount point to internal form: " + mountPoint));
        }
        String mountPointAttr = isWindows ? ResourceType.BaseFileSystem.INTERNAL_MOUNTPOINT_PATH.name() : ResourceType.BaseFileSystem.MOUNTPOINT_PATH.name();
        try {
            Filter filter_eqMtPoint;
            Filter filter_enWAcfs;
            Filter filter_stWOra;
            crsFactory = CRSFactoryImpl.getInstance();
            Filter fsFilter = null;
            if (isClusterFS) {
                filter_stWOra = crsFactory.getFilter(Filter.Comparator.STARTS_WITH, ResourceLiterals.NAME.toString(), "ora.");
                filter_enWAcfs = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.NAME.toString(), acfs_res_suffix);
                Filter filter_eqAcfsType = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE_ATTR.toString(), ResourceLiterals.ACFS_TYPE.toString());
                Filter filter_clause = crsFactory.getFilter(Filter.Operator.AND, filter_enWAcfs, filter_eqAcfsType);
                fsFilter = crsFactory.getFilter(Filter.Operator.AND, filter_clause, filter_stWOra);
            } else {
                filter_stWOra = crsFactory.getFilter(Filter.Comparator.STARTS_WITH, ResourceLiterals.NAME.toString(), "ora.");
                filter_enWAcfs = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.NAME.toString(), acfs_res_suffix);
                Filter filter_eqAcfstype = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE_ATTR.toString(), ResourceLiterals.ACFS_TYPE.toString());
                Filter filter_eqCAcfstype = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE_ATTR.toString(), ResourceLiterals.CLUSTER_ACFS_TYPE.toString());
                Filter filter_enWAppIdtype = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.TYPE_ATTR.toString(), appId_res_suffix);
                Filter filter_orAcfsType = crsFactory.getFilter(Filter.Operator.OR, filter_eqAcfstype, filter_eqCAcfstype);
                Filter filter_orType = crsFactory.getFilter(Filter.Operator.OR, filter_orAcfsType, filter_enWAppIdtype);
                Filter filter_andAcfs = crsFactory.getFilter(Filter.Operator.AND, filter_enWAcfs, filter_orType);
                Filter filter_enWFS = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.NAME.toString(), fs_res_suffix);
                Filter filter_enOR = crsFactory.getFilter(Filter.Operator.OR, filter_andAcfs, filter_enWFS);
                fsFilter = crsFactory.getFilter(Filter.Operator.AND, filter_stWOra, filter_enOR);
            }
            Filter filter = filter_eqMtPoint = hasMountPt ? crsFactory.getFilter(Filter.Comparator.EQ, mountPointAttr, mountPoint) : null;
            if (hasMountPt) {
                fsFilter = crsFactory.getFilter(Filter.Operator.AND, fsFilter, filter_eqMtPoint);
            }
            Trace.out((String)"Find file system resources");
            resList = crsFactory.searchResources(CRSEntity.Type.Resource, fsFilter);
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException(crse);
        }
        if (resList != null && resList.size() > 0) {
            for (ResourceAttribute currNameAttr : resList) {
                String currNameAttrValue = currNameAttr.getValue();
                if (currNameAttrValue == null) continue;
                currNameAttrValue = currNameAttrValue.trim();
                Trace.out((String)("Found a filesystem resource -- Resource name: " + currNameAttrValue));
                if (currNameAttrValue.toLowerCase().endsWith(ResourceLiterals.ACFS.toString())) {
                    fileSystemList.add(new AsmClusterFileSystemImpl(currNameAttr));
                    continue;
                }
                fileSystemList.add(new FileSystemImpl(currNameAttr));
            }
        }
        if (fileSystemList.size() == 0) {
            throw new NotExistsException((MessageKey)PrCaMsgID.FILESYSTEM_RES_NOT_FOUND, new Object[0]);
        }
        return fileSystemList;
    }

    private List<AsmBaseFileSystem> getNLocalFileSystems(String mountPoint, String nodeName) throws NotExistsException, AsmClusterFileSystemException {
        List resList;
        boolean hasMountPt;
        ArrayList<AsmBaseFileSystem> fileSystemList = new ArrayList<AsmBaseFileSystem>();
        CRSFactoryImpl crsFactory = null;
        String appId_res_suffix = '_' + ResourceLiterals.FS.toString() + '.' + ResourceLiterals.TYPE.toString();
        boolean isWindows = !new SystemFactory().CreateSystem().isUnixSystem();
        boolean bl = hasMountPt = mountPoint != null && mountPoint.length() > 0;
        if (hasMountPt && isWindows) {
            mountPoint = ASMFactoryImpl.getInternalMountPoint(mountPoint);
            Trace.out((String)("Is Windows platform: transform mount point to internal form: " + mountPoint));
        }
        String mountPointAttr = isWindows ? ResourceType.BaseFileSystem.INTERNAL_MOUNTPOINT_PATH.name() : ResourceType.BaseFileSystem.MOUNTPOINT_PATH.name();
        try {
            crsFactory = CRSFactoryImpl.getInstance();
            Filter filter_eqAcfsCType = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE_ATTR.toString(), ResourceLiterals.CLUSTER_ACFS_TYPE.toString());
            Filter filter_eqFsType = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE_ATTR.toString(), "ora." + ResourceLiterals.FS.toString() + '.' + ResourceLiterals.TYPE.toString());
            Filter filter_enWAppIdtype = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.TYPE_ATTR.toString(), appId_res_suffix);
            Filter filter_cntNode = crsFactory.getFilter(Filter.Comparator.CONTAINS, ResourceLiterals.HOSTING_MEMBERS.toString(), nodeName);
            Filter filter_eqMtPoint = hasMountPt ? crsFactory.getFilter(Filter.Comparator.EQ, mountPointAttr, mountPoint) : null;
            Filter filter_ORType = crsFactory.getFilter(Filter.Operator.OR, filter_eqAcfsCType, filter_eqFsType);
            Filter filter_ORAll = crsFactory.getFilter(Filter.Operator.OR, filter_ORType, filter_enWAppIdtype);
            Filter fsFilter = crsFactory.getFilter(Filter.Operator.AND, filter_ORAll, filter_cntNode);
            if (hasMountPt) {
                fsFilter = crsFactory.getFilter(Filter.Operator.AND, fsFilter, filter_eqMtPoint);
            }
            Trace.out((String)"Find file system resources");
            resList = crsFactory.searchResources(CRSEntity.Type.Resource, fsFilter);
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException(crse);
        }
        if (resList != null && resList.size() > 0) {
            for (ResourceAttribute currNameAttr : resList) {
                String currNameAttrValue = currNameAttr.getValue();
                if (currNameAttrValue == null) continue;
                currNameAttrValue = currNameAttrValue.trim();
                Trace.out((String)("Found a filesystem resource -- Resource name: " + currNameAttrValue));
                if (currNameAttrValue.toLowerCase().endsWith(ResourceLiterals.ACFS.toString())) {
                    fileSystemList.add(new AsmClusterFileSystemImpl(currNameAttr));
                    continue;
                }
                fileSystemList.add(new FileSystemImpl(currNameAttr));
            }
        }
        if (fileSystemList.size() == 0) {
            throw new NotExistsException((MessageKey)PrCaMsgID.FILESYSTEM_RES_NOT_FOUND, new Object[0]);
        }
        return fileSystemList;
    }

    public ACFSInfo getACFSInfo(String mountpoint) throws NotExistsException, AsmClusterFileSystemException {
        if (this.isFSMountPoint(mountpoint = ASMFactoryImpl.getInternalMountPoint(mountpoint), false)) {
            List<AsmBaseFileSystem> fsList = this.getValidationFileSystems(mountpoint, false);
            if (fsList.isEmpty()) {
                Trace.out((String)"Unexpected empty file system resource list");
                throw new AsmClusterFileSystemException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSINFO-mtp-error_1");
            }
            if (fsList.size() > 1) {
                Trace.out((String)"Unexpected multiple file systems for one mount point");
                throw new AsmClusterFileSystemException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSINFO-mtp-error_2");
            }
            AsmBaseFileSystem fs = fsList.get(0);
            return this.doGetACFSInfo(fs);
        }
        throw new NotExistsException((MessageKey)PrCaMsgID.ACFSINFO_INVALID_MOUNTPOINT, new Object[]{mountpoint});
    }

    public ACFSInfo getACFSInfo(String dgName, String volumeName) throws NotExistsException, AsmClusterFileSystemException {
        AsmClusterFileSystem fs = this.getACFS(volumeName, dgName);
        return this.doGetACFSInfo(fs);
    }

    public ACFSInfo getACFSInfo4VolDevice(String volDevice) throws NotExistsException, AsmClusterFileSystemException {
        AsmClusterFileSystem fs = this.getAsmClusterFileSystem(volDevice);
        return this.doGetACFSInfo(fs);
    }

    private ACFSInfo doGetACFSInfo(AsmBaseFileSystem acfs) throws NotExistsException, AsmClusterFileSystemException {
        try {
            String mountpoint = acfs.getMountPoint();
            if (!acfs.isRunning()) {
                Trace.out((String)"ACFS is not mounted");
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FS_NOT_MOUNTED, mountpoint);
            }
            if (acfs.isLocalResource()) {
                return new ACFSInfoImpl(mountpoint);
            }
            Trace.out((String)"Node-local ACFS, query in a mounted node");
            String node = "";
            try {
                List mtNodes = acfs.crsResource().fetchRunningNodes();
                if (mtNodes != null && !mtNodes.isEmpty()) {
                    node = ((Node)mtNodes.get(0)).getHostName();
                }
            }
            catch (CRSException ce) {
                throw new AsmClusterFileSystemException(ce);
            }
            return new ACFSInfoImpl(mountpoint, node);
        }
        catch (SoftwareModuleException sme) {
            throw new AsmClusterFileSystemException(sme);
        }
        catch (NodeException ne) {
            throw new AsmClusterFileSystemException(ne);
        }
    }

    public Volume createVolume(String device, String diskgroup, String volumename) throws AlreadyExistsException, VolumeException {
        try {
            VolumeImpl volumeImpl = new VolumeImpl(CRSFactoryImpl.getInstance().create(ResourceType.Volume.NAME.name(), VolumeImpl.getResourceName(diskgroup, volumename)));
            volumeImpl.create(device);
            return volumeImpl;
        }
        catch (CRSException e) {
            throw new VolumeException(e);
        }
        catch (SoftwareModuleException e) {
            throw new VolumeException(e);
        }
    }

    public ASM createASM(Version version) throws AlreadyExistsException, ASMException {
        if (null == version) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        try {
            ASMImpl asmImpl = new ASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ASMImpl.getResourceName()));
            asmImpl.create(version);
            return asmImpl;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.ASM_CREATE_FAILED, e, version.toString());
        }
    }

    public ASM createASM(String pwfile, Version version) throws AlreadyExistsException, ASMException {
        return this.createASM(pwfile, version, EntityOperations.EntityOpsMode.CRS);
    }

    private ASM createASM(String pwfile, Version version, EntityOperations.EntityOpsMode mode) throws AlreadyExistsException, ASMException {
        if (null == version) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        try {
            ASMImpl asmImpl = new ASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ASMImpl.getResourceName()), mode);
            asmImpl.create(pwfile, version);
            return asmImpl;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.ASM_CREATE_FAILED, e, version.toString());
        }
    }

    public ASM createClientASM(String pwfile, Version version) throws ASMException {
        try {
            return this.createASM(pwfile, version, EntityOperations.EntityOpsMode.Local);
        }
        catch (AlreadyExistsException e) {
            Trace.out((String)"Got AlreadyExistsException. Should never happen.");
            return null;
        }
    }

    public ASM createASM(String spfile, String diskString, Version version) throws AlreadyExistsException, ASMException {
        if (null == version) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        try {
            ASMImpl asmImpl = new ASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ASMImpl.getResourceName()));
            asmImpl.create(null, spfile, diskString, version);
            return asmImpl;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.ASM_CREATE_FAILED, e, version.toString());
        }
    }

    public ASM createASM(String pwfile, String spfile, String diskString, Version version) throws AlreadyExistsException, ASMException {
        if (null == version) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        try {
            ASMImpl asmImpl = new ASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ASMImpl.getResourceName()));
            asmImpl.create(null, pwfile, spfile, diskString, version);
            return asmImpl;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.ASM_CREATE_FAILED, e, version.toString());
        }
    }

    public ASM createASM(Listener listener, Version version) throws AlreadyExistsException, ASMException {
        if (null == listener) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "listener", listener);
        }
        if (null == version) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        try {
            ASMImpl asmImpl = new ASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ASMImpl.getResourceName()));
            asmImpl.create(listener, version);
            return asmImpl;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.ASM_CREATE_FAILED, e, version.toString());
        }
    }

    public ASM createASM(Listener listener, String pwfile, Version version) throws AlreadyExistsException, ASMException {
        if (null == listener) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "listener", listener);
        }
        if (null == version) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        try {
            ASMImpl asmImpl = new ASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ASMImpl.getResourceName()));
            asmImpl.create(listener, pwfile, version);
            return asmImpl;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.ASM_CREATE_FAILED, e, version.toString());
        }
    }

    public ASM createASM(Listener listener, String spfile, String diskString, Version version) throws AlreadyExistsException, ASMException {
        if (null == listener) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "listener", listener);
        }
        if (null == version) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        try {
            ASMImpl asmImpl = new ASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ASMImpl.getResourceName()));
            asmImpl.create(listener, spfile, diskString, version);
            return asmImpl;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.ASM_CREATE_FAILED, e, version.toString());
        }
    }

    public ASM createASM(Listener listener, String pwfile, String spfile, String diskString, Version version) throws AlreadyExistsException, ASMException {
        if (null == listener) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "listener", listener);
        }
        if (null == version) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        try {
            ASMImpl asmImpl = new ASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ASMImpl.getResourceName()));
            asmImpl.create(listener, pwfile, spfile, diskString, version);
            return asmImpl;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.ASM_CREATE_FAILED, e, ASMImpl.getResourceName(), version.toString());
        }
    }

    public ClusterASM createClusterASM(String pwfile, int count, Version version) throws AlreadyExistsException, ASMException {
        try {
            if (count <= 1 && count != -1) {
                throw new ASMException((MessageKey)PrCaMsgID.TOO_SMALL_COUNT_FOR_ASM, count);
            }
            if (count >= 1024) {
                throw new ASMException((MessageKey)PrCaMsgID.TOO_LARGE_COUNT_FOR_ASM, count);
            }
            ClusterASMImpl asmImpl = new ClusterASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ClusterASMImpl.getResourceName()));
            String serverCategory = null;
            if (m_upgradePhase == UpgradePhase.FIRST) {
                serverCategory = "";
            }
            asmImpl.create(pwfile, count, serverCategory, version);
            return asmImpl;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.ASM_CREATE_FAILED, e, ClusterASMImpl.getResourceName(), version.toString());
        }
    }

    public ProxyASM createProxyASM(String spfile, Version version) throws AlreadyExistsException, ASMException {
        try {
            Trace.out((String)"Construct proxyAsmImpl");
            ProxyASMImpl proxyAsmImpl = new ProxyASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ProxyASM.NAME.name(), ProxyASMImpl.getResourceName()));
            Trace.out((String)"Creating proxyAsm");
            proxyAsmImpl.create(spfile, version);
            return proxyAsmImpl;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.ASM_CREATE_FAILED, e, ProxyASMImpl.getResourceName(), version.toString());
        }
    }

    public IOServer createIOServer(String spfile, int count, Version version) throws AlreadyExistsException, ASMException {
        return this.createIOServer(spfile, count, null, version);
    }

    public IOServer createIOServer(int count, Listener lsnr, Version version) throws AlreadyExistsException, ASMException {
        return this.createIOServer(null, count, lsnr, version);
    }

    public IOServer createIOServer(String spfile, int count, Listener lsnr, Version version) throws AlreadyExistsException, ASMException {
        try {
            Trace.out((String)"Construct ioserverImpl");
            IOServerImpl ioserverImpl = new IOServerImpl(CRSFactoryImpl.getInstance().create(ResourceType.IOServer.NAME.name(), IOServerImpl.getResourceName()));
            Trace.out((String)"Creating ioserver");
            ioserverImpl.create(spfile, count, lsnr, version);
            return ioserverImpl;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.ASM_CREATE_FAILED, e, IOServerImpl.getResourceName(), version.toString());
        }
    }

    public CCMB createCCMB() throws AlreadyExistsException, ASMException {
        try {
            if (!ASMFactoryImpl.isClientMode()) {
                Trace.out((String)"CCMB is not supported in client ASM");
                throw new ASMException((MessageKey)PrCaMsgID.UNSUPPORTED_CCMB_ASM_CLUSTER, true);
            }
            Trace.out((String)"Construct CCMBImpl");
            CCMBImpl ccmImpl = new CCMBImpl(CRSFactoryImpl.getInstance().create(ResourceType.CCMB.NAME.name(), CCMBImpl.getResourceName()));
            Trace.out((String)"Creating CCMB");
            ccmImpl.create();
            return ccmImpl;
        }
        catch (CRSException ce) {
            throw new ASMException(ce);
        }
    }

    public ASM getASM() throws NotExistsException, ASMException {
        try {
            boolean isCluster = Cluster.isCluster();
            ASMMode mode = null;
            if (isCluster) {
                mode = this.getASMMode();
            }
            ASMImpl asmImpl = null;
            asmImpl = new ASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ASMImpl.getResourceName()));
            if (isCluster) {
                if (mode == ASMMode.REMOTE) {
                    Trace.out((String)"ASM mode is near-ASM");
                    asmImpl = new ClusterASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ASMImpl.getResourceName()));
                } else if (mode == ASMMode.CLIENT) {
                    Trace.out((String)"ASM mode is CLIENT");
                    try {
                        CRSResource cRSResource = asmImpl.crsResource();
                    }
                    catch (NotExistsException nee) {
                        throw new NotExistsException((MessageKey)PrCaMsgID.ASM_CLIENT_CLUSTER, (Throwable)nee, new Object[]{true});
                    }
                }
            }
            CRSResource crsRes = asmImpl.crsResource();
            return asmImpl;
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    public ClusterASM getClusterASM() throws NotExistsException, ASMException {
        try {
            ClusterASMImpl asmImpl = new ClusterASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ClusterASMImpl.getResourceName()));
            CRSResource crsRes = asmImpl.crsResource();
            ResourceAttribute attr = ((CRSResourceImpl)crsRes).getAttribute(ResourceLiterals.TYPE.name());
            Trace.out((String)("Resource type is " + attr.getValue()));
            String type = attr.getValue();
            if (asmImpl.getPresence() == ASMPresence.REMOTE) {
                return asmImpl;
            }
            throw new NotExistsException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, new Object[]{ClusterASMImpl.getResourceName(), ResourceType.ClusterASM.NAME.toString()});
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    public ProxyASM getProxyASM() throws NotExistsException, ASMException {
        try {
            ProxyASMImpl proxyasmImpl = new ProxyASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ProxyASM.NAME.name(), ProxyASMImpl.getResourceName()));
            CRSResource crsRes = proxyasmImpl.crsResource();
            return proxyasmImpl;
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    public IOServer getIOServer() throws NotExistsException, ASMException {
        try {
            IOServerImpl ioserverImpl = new IOServerImpl(CRSFactoryImpl.getInstance().create(ResourceType.IOServer.NAME.name(), IOServerImpl.getResourceName()));
            CRSResource crsRes = ioserverImpl.crsResource();
            return ioserverImpl;
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    public CCMB getCCMB() throws NotExistsException, ASMException {
        try {
            ResourceAttribute nameAttr = CRSFactoryImpl.getInstance().create(ResourceType.CCMB.NAME.name(), CCMBImpl.getResourceName());
            CRSFactoryImpl.getInstance().get(nameAttr);
            CCMBImpl ccmImpl = new CCMBImpl(nameAttr);
            return ccmImpl;
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        catch (SoftwareModuleException sme) {
            throw new ASMException(sme);
        }
    }

    public void createACFSFileSystem(String dgName, String fsName, String mountPath, int sizeMb) throws AsmClusterFileSystemException {
        try {
            String crsHome = "";
            try {
                NodeAppsFactoryImpl.getInstance().assertRoot();
                Utils.assertInput((String)dgName, (String)"dgName");
                Utils.assertInput((String)fsName, (String)"fsName");
                Utils.assertInput((String)mountPath, (String)"mountPath");
                crsHome = new Util().getCRSHome();
            }
            catch (InvalidArgsException iae) {
                Trace.out((String)"Empty or null input");
                throw new AsmClusterFileSystemException(iae);
            }
            catch (UtilException ue) {
                Trace.out((String)"failed to retrieve CRS home");
                throw new AsmClusterFileSystemException(ue);
            }
            catch (SoftwareModuleException sme) {
                Trace.out((String)"failed to assert root");
                throw new AsmClusterFileSystemException(sme);
            }
            ASMCMDUtil asmcmdUtil = new ASMCMDUtil(crsHome, null, new Version());
            OFSUtil ofsUtil = new OFSUtil(true);
            String crsUser = new Util().getCRSUser();
            asmcmdUtil.createVolumeMB(dgName, fsName, crsUser, sizeMb);
            String voldevice = "";
            try {
                voldevice = asmcmdUtil.getVolumeDevice(dgName, fsName, crsUser);
            }
            catch (NotExistsException nee) {
                Trace.out((String)("Volume device not found for volume " + fsName));
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.CREATE_ACFS_FAILED, nee, new Object[0]);
            }
            ofsUtil.createACFSfs(voldevice);
            AsmClusterFileSystem acfs = null;
            try {
                Trace.out((String)"Creating file system resource");
                FileSystemOptionalArgs args = new FileSystemOptionalArgs();
                args.setVolumeDevicePath(voldevice);
                args.setMountPointPath(mountPath);
                args.setFSType(FSEnums.FSTypeEnum.ACFS);
                acfs = this.createAsmClusterFileSystem(args, new Version());
            }
            catch (AsmClusterFileSystemException ae) {
                Trace.out((String)"failed to create file system resource");
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.CREATE_ACFS_FAILED, (Throwable)((Object)ae), new Object[0]);
            }
            try {
                Trace.out((String)("Mounting new file system in mount path " + mountPath));
                acfs.start();
            }
            catch (AlreadyRunningException are) {
                Trace.out((String)"file system already running");
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.CREATE_ACFS_FAILED, are, new Object[0]);
            }
            catch (SoftwareModuleException sme) {
                Trace.out((String)"failed to mount file system");
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.CREATE_ACFS_FAILED, sme, new Object[0]);
            }
        }
        catch (UtilException ue) {
            Trace.out((String)"failed to retrieve the CRS user");
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.CREATE_ACFS_FAILED, ue, new Object[0]);
        }
        catch (CmdToolUtilException ctue) {
            Trace.out((String)"failed to initiate util");
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.CREATE_ACFS_FAILED, ctue, new Object[0]);
        }
        catch (AlreadyExistsException aee) {
            Trace.out((String)("Volume" + fsName + " already exists"));
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.CREATE_ACFS_FAILED, aee, new Object[0]);
        }
        catch (NotExistsException nee) {
            Trace.out((String)("Disk group" + dgName + " not found"));
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.CREATE_ACFS_FAILED, nee, new Object[0]);
        }
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.createAsmClusterFileSystem(volDevice, volName, dgName, null, new String[0], null, null, null, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        if (null == mountPoint || mountPoint.trim().length() == 0) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mountPoint", mountPoint);
        }
        return this.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, new String[0], null, null, null, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, Version version, String user) throws AlreadyExistsException, AsmClusterFileSystemException {
        if (null == user || user.trim().length() == 0) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "user", user);
        }
        return this.createAsmClusterFileSystem(volDevice, volName, dgName, null, new String[]{user}, null, null, null, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String user, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, new String[]{user}, null, null, null, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String user, String fsOptions, String description, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, new String[]{user}, fsOptions, description, null, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String user, String fsOptions, String description, String[] auxvolumes, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, new String[]{user}, fsOptions, description, auxvolumes, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String[] users, String fsOptions, String description, String[] auxvolumes, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, users, fsOptions, description, auxvolumes, false, false, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String mountPoint, String[] users, String fsOptions, String description, String[] auxvolumes, boolean ghCreated, boolean isClientCluster, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.createAsmClusterFileSystem(volDevice, null, null, mountPoint, users, fsOptions, description, auxvolumes, ghCreated, isClientCluster, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String[] users, String fsOptions, String description, String[] auxvolumes, boolean ghCreated, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, users, fsOptions, description, auxvolumes, ghCreated, false, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String[] users, String fsOptions, String description, String[] auxvolumes, boolean ghCreated, boolean isClientCluster, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, null, users, fsOptions, description, auxvolumes, ghCreated, isClientCluster, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String mountOwner, String[] users, String fsOptions, String description, String[] auxvolumes, boolean ghCreated, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, mountOwner, users, fsOptions, description, auxvolumes, ghCreated, false, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String mountOwner, String[] users, String fsOptions, String description, String[] auxvolumes, boolean ghCreated, boolean isClientCluster, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        if (null == volDevice || volDevice.trim().length() == 0) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "volDevice", volDevice);
        }
        if (isClientCluster) {
            this.assertDBAASVolDevice(volDevice);
        }
        if (!(isClientCluster || null != volName && volName.trim().length() != 0)) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "volName", volName);
        }
        if (!(isClientCluster || null != dgName && dgName.trim().length() != 0)) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dgName", dgName);
        }
        if (null == version) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        if (!this.isACFSSupported(m_crsHome)) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.ACFS_NOT_SUPPORTED_MSG, new Object[0]);
        }
        Volume vol = null;
        if (!isClientCluster) {
            try {
                vol = this.getVolume(volDevice);
            }
            catch (VolumeException ve) {
                throw new AsmClusterFileSystemException((Throwable)((Object)ve));
            }
            catch (NotExistsException nee) {
                throw new AsmClusterFileSystemException(nee);
            }
        }
        Trace.out((String)("Canonicalize volume device " + volDevice));
        volDevice = this.canonicalizeDevicePath(volDevice);
        if (!isClientCluster && !this.isValidVolume(vol, volName)) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.INVALID_VOLUME, volName, volDevice);
        }
        if (auxvolumes == null) {
            try {
                OFSUtil ofs = new OFSUtil(new Util().getCRSHome());
                List formattedAuxVolumes = ofs.getAuxiliaryVolumes(volDevice);
                if (!formattedAuxVolumes.isEmpty() && !formattedAuxVolumes.contains("")) {
                    Trace.out((String)"Primary volume has auxiliary volumes configured");
                    auxvolumes = formattedAuxVolumes.toArray(new String[formattedAuxVolumes.size()]);
                } else {
                    Trace.out((String)"No formatted auxiliary volumes");
                }
            }
            catch (UtilException ue) {
                Trace.out((String)"failed to retrive CRS home");
                throw new AsmClusterFileSystemException(ue);
            }
            catch (CmdToolUtilException ctue) {
                Trace.out((String)"failed to retrieve auxiliary volumes");
            }
        }
        if (auxvolumes != null && auxvolumes.length > 0) {
            this.assertAuxiliaryVolumes(volDevice, auxvolumes);
        }
        if (!isClientCluster && !this.isValidDiskGroup(vol, dgName)) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.INVALID_DISKGROUP, dgName, volDevice);
        }
        try {
            AsmClusterFileSystem fs = this.getAsmClusterFileSystem(volDevice);
            throw new AlreadyExistsException((MessageKey)PrCaMsgID.ACFS_ALREADY_EXISTS, new Object[]{fs.getDiskGroup(), fs.getVolumeName()});
        }
        catch (NotExistsException fs) {
            Boolean isClusterFS = false;
            AsmBaseFileSystemImpl.validateMountPointPath(mountPoint);
            if (this.isFSMountPoint(mountPoint, isClusterFS)) {
                Trace.out((String)("Mount point path " + mountPoint + " is already in use by another FS resource"));
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FS_MOUNTPOINT_IN_USE, mountPoint);
            }
            String resourceName = isClientCluster ? this.generateODAFSResourceName(volDevice, true) : this.generateFSResourceName(dgName, volName, true);
            Trace.out((String)("resourceName = " + resourceName));
            try {
                Trace.out((String)"Ready to create ASM filesystem cluster resource");
                AsmClusterFileSystemImpl acfsImpl = new AsmClusterFileSystemImpl(CRSFactoryImpl.getInstance().create(ResourceType.AsmClusterFileSystem.NAME.name(), resourceName));
                if (this.m_autostart != null && this.m_autostart.length() > 0) {
                    if (auxvolumes != null && auxvolumes.length > 0) {
                        acfsImpl.create(volDevice, mountPoint, mountOwner, users, fsOptions, description, version, this.m_autostart, auxvolumes, ghCreated, isClientCluster);
                    } else {
                        acfsImpl.create(volDevice, mountPoint, mountOwner, users, fsOptions, description, version, this.m_autostart, null, ghCreated, isClientCluster);
                    }
                } else if (auxvolumes != null && auxvolumes.length > 0) {
                    acfsImpl.create(volDevice, mountPoint, mountOwner, users, fsOptions, description, version, null, auxvolumes, ghCreated, isClientCluster);
                } else {
                    acfsImpl.create(volDevice, mountPoint, mountOwner, users, fsOptions, description, version, null, null, ghCreated, isClientCluster);
                }
                return acfsImpl;
            }
            catch (CRSException e) {
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.ACFS_CREATE_FAILED, e, resourceName, volDevice);
            }
        }
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(FileSystemOptionalArgs fsOptionalArgs, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        boolean isClusterResource;
        if (fsOptionalArgs.getFSType() != FSEnums.FSTypeEnum.ACFS) {
            Trace.out((String)"ERROR! createAsmClusterFileSystem() is used only for ACFS filesystems");
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.FSTYPE_MUST_BE_ACFS, fsOptionalArgs.getFSType().getValue().toUpperCase());
        }
        if (fsOptionalArgs.getAuxVolumes() != null && fsOptionalArgs.getAuxVolumes().length > 1) {
            Trace.out((String)"Multiple auxiliary volumes were found");
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.UNSUPPORTED_MULTI_AUX_VOLS, new Object[0]);
        }
        try {
            fsOptionalArgs.setIsClientCluster(ASMFactoryImpl.isClientMode());
        }
        catch (ASMException ae) {
            Trace.out((String)"failed to determine ASM mode to check for member cluster configuration");
            throw new AsmClusterFileSystemException((Throwable)((Object)ae));
        }
        if (!fsOptionalArgs.isClientCluster()) {
            try {
                this.getVolDgDevice(fsOptionalArgs);
            }
            catch (NotExistsException nee) {
                throw new AsmClusterFileSystemException(nee);
            }
        }
        boolean bl = isClusterResource = fsOptionalArgs.getNodeNames() != null || fsOptionalArgs.getServerPools() != null;
        if (isClusterResource) {
            Trace.out((String)"Detected that we should create an ACFS cluster resource");
            return (AsmClusterFileSystem)this.createClusterResource(fsOptionalArgs, version);
        }
        Trace.out((String)"Detected that we should create a ACFS local resource");
        String volDevice = fsOptionalArgs.getVolumeDevicePath();
        String volName = fsOptionalArgs.getVolumeName();
        String dgName = fsOptionalArgs.getDiskGroupName();
        String mountPointPath = fsOptionalArgs.getMountPointPath();
        String mountOwner = fsOptionalArgs.getMountOwner();
        String[] users = fsOptionalArgs.getUsers();
        String fsOptions = fsOptionalArgs.getFSOptions();
        String description = fsOptionalArgs.getDescription();
        String[] auxvolumes = fsOptionalArgs.getAuxVolumes();
        boolean ghCreated = fsOptionalArgs.getGHCreated();
        boolean isClientCluster = fsOptionalArgs.isClientCluster();
        if (fsOptionalArgs.getAutostart() != null) {
            this.m_autostart = fsOptionalArgs.getAutostart().getValue();
        }
        return this.createAsmClusterFileSystem(volDevice, volName, dgName, mountPointPath, mountOwner, users, fsOptions, description, auxvolumes, ghCreated, isClientCluster, version);
    }

    public FileSystem createFileSystem(FileSystemOptionalArgs fsOptionalArgs, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        boolean isLocalResource;
        if (fsOptionalArgs.getFSType() == FSEnums.FSTypeEnum.ACFS) {
            Trace.out((String)"ERROR! Detected that we should create a ACFS local resource while calling createFileSystem() instead of createAsmClusterFileSystem().");
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.FSTYPE_MUST_BE_NON_ACFS, new Object[0]);
        }
        if (fsOptionalArgs.getAuxVolumes() != null) {
            Trace.out((String)"Auxiliary volumes specified for a non-ACFS file system");
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.INVALID_LOCAL_AUX_VOL, new Object[0]);
        }
        boolean bl = isLocalResource = fsOptionalArgs.getNodeNames() == null && fsOptionalArgs.getServerPools() == null;
        if (isLocalResource) {
            Trace.out((String)"ERROR! Detected that we should create an non-ACFS local resource which is not supported.");
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.CANNOT_CREATE_NON_ACFS_LOCAL_RESOURCE, new Object[0]);
        }
        if (!this.isSupportedFSType(fsOptionalArgs.getFSType())) {
            Trace.out((String)("Unsupported file system type: " + fsOptionalArgs.getFSType().getValue()));
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.UNSUPPORTED_PLATFORM_FS_TYPE, fsOptionalArgs.getFSType().getValue());
        }
        try {
            if (ASMFactoryImpl.isClientMode()) {
                Trace.out((String)"Non-ACFS are not supported for Client Clusters");
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.NONACFS_UNSUPPORTED_DOMU, true);
            }
        }
        catch (ASMException ae) {
            Trace.out((String)"failed to check ASM mode to validate support in member clusters");
            throw new AsmClusterFileSystemException((Throwable)((Object)ae));
        }
        try {
            this.getVolDgDevice(fsOptionalArgs);
        }
        catch (NotExistsException nee) {
            throw new AsmClusterFileSystemException(nee);
        }
        return (FileSystemImpl)this.createClusterResource(fsOptionalArgs, version);
    }

    public void upgradeACFS11202To11203FirstPhase() throws UpgradeException {
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            cf.upgradeType(ResourceType.AsmClusterFileSystem.class);
            List<AsmClusterFileSystem> acfsList = null;
            try {
                acfsList = this.getAsmClusterFileSystems();
            }
            catch (NotExistsException e) {
                return;
            }
            if (acfsList != null && acfsList.size() > 0) {
                ResourceAttribute[] ral = new ResourceAttribute[]{cf.create(ResourceType.LocalResource.VERSION.name(), new Version().toString()), cf.create(ResourceType.AsmClusterFileSystem.CANONICAL_VOLUME_DEVICE.name(), "")};
                ADVMUtil advmutil = new ADVMUtil(m_crsHome);
                for (AsmClusterFileSystem acfs : acfsList) {
                    String canVolDevice = advmutil.getCanonicalVolume(acfs.getVolumeDevice());
                    Trace.out((String)("Canonical form of the volume device = " + canVolDevice));
                    ral[1].setValue(canVolDevice);
                    CRSResourceImpl crsResImpl = (CRSResourceImpl)acfs.crsResource();
                    crsResImpl.update(ral);
                }
            }
        }
        catch (CRSException e) {
            throw new UpgradeException((MessageKey)PrCaMsgID.ACFS_UPGRADE_FAILED, (Throwable)e, new Object[]{Version.VersionEnum.V11202.toString(), Version.VersionEnum.V11203.toString()});
        }
        catch (AsmClusterFileSystemException e) {
            throw new UpgradeException((MessageKey)PrCaMsgID.ACFS_UPGRADE_FAILED, (Throwable)((Object)e), new Object[]{Version.VersionEnum.V11202.toString(), Version.VersionEnum.V11203.toString()});
        }
        catch (CmdToolUtilException e) {
            throw new UpgradeException((MessageKey)PrCaMsgID.ACFS_UPGRADE_FAILED, (Throwable)e, new Object[]{Version.VersionEnum.V11202.toString(), Version.VersionEnum.V11203.toString()});
        }
        catch (NotExistsException e) {
            throw new UpgradeException((MessageKey)PrCaMsgID.ACFS_UPGRADE_FAILED, (Throwable)e, new Object[]{Version.VersionEnum.V11202.toString(), Version.VersionEnum.V11203.toString()});
        }
    }

    public void upgradeACFS11204To12101LastPhase() throws UpgradeException {
        block15: {
            try {
                boolean isClientCluster = ASMFactoryImpl.isClientMode();
                if (isClientCluster) {
                    Trace.out((String)"Client cluster has no volume resource. No upgrade is needed.");
                    return;
                }
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                crsFactory.upgradeType(ResourceType.AsmClusterFileSystem.class);
                List<AsmClusterFileSystem> acfsList = null;
                try {
                    acfsList = this.getAsmClusterFileSystems();
                }
                catch (NotExistsException e) {
                    return;
                }
                if (acfsList == null || acfsList.size() <= 0) break block15;
                ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
                ResourceAttribute[] ral = new ResourceAttribute[4];
                Trace.out((String)"Adding Version attribute");
                attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), new Version().toString()));
                for (AsmClusterFileSystem acfs : acfsList) {
                    String volname = acfs.getVolumeName();
                    String voldev = acfs.getVolumeDevice();
                    String dgname = acfs.getDiskGroup();
                    Volume volume = null;
                    try {
                        volume = this.getVolume(volname, dgname);
                    }
                    catch (NotExistsException e) {
                        Trace.out((String)"Volume does not exists, creating a new volume");
                        volume = this.createVolume(voldev, dgname, volname);
                    }
                    AsmBaseFileSystemImpl abfsImpl = (AsmBaseFileSystemImpl)((Object)acfs);
                    AsmBaseFileSystemImpl parentFS = (AsmBaseFileSystemImpl)abfsImpl.getNestedFS(abfsImpl.getMountPoint());
                    attrList.addAll(abfsImpl.generateFSDependencies(volume, null, parentFS));
                    attrList.add(crsFactory.create(ResourceType.AsmClusterFileSystem.INTERNAL_MOUNTPOINT_PATH.name(), acfs.getMountPoint()));
                    CRSResourceImpl crsResImpl = (CRSResourceImpl)acfs.crsResource();
                    crsResImpl.update(attrList.toArray(new ResourceAttribute[attrList.size()]));
                }
            }
            catch (AsmClusterFileSystemException e) {
                throw new UpgradeException((MessageKey)PrCaMsgID.ACFS_UPGRADE_FAILED, (Throwable)((Object)e), new Object[]{Version.VersionEnum.V11204.toString(), Version.VersionEnum.V12101.toString()});
            }
            catch (AlreadyExistsException e) {
                Trace.out((Exception)((Object)e));
            }
            catch (VolumeException e) {
                throw new UpgradeException((MessageKey)PrCaMsgID.ACFS_UPGRADE_FAILED, (Throwable)((Object)e), new Object[]{Version.VersionEnum.V11204.toString(), Version.VersionEnum.V12101.toString()});
            }
            catch (ASMException e) {
                throw new UpgradeException((MessageKey)PrCaMsgID.ACFS_UPGRADE_FAILED, (Throwable)((Object)e), new Object[]{Version.VersionEnum.V11204.toString(), Version.VersionEnum.V12101.toString()});
            }
            catch (CRSException e) {
                throw new UpgradeException((MessageKey)PrCaMsgID.ACFS_UPGRADE_FAILED, (Throwable)e, new Object[]{Version.VersionEnum.V11204.toString(), Version.VersionEnum.V12101.toString()});
            }
            catch (NotExistsException e) {
                throw new UpgradeException((MessageKey)PrCaMsgID.ACFS_UPGRADE_FAILED, (Throwable)e, new Object[]{Version.VersionEnum.V11204.toString(), Version.VersionEnum.V12101.toString()});
            }
            catch (SoftwareModuleException e) {
                throw new UpgradeException((MessageKey)PrCaMsgID.ACFS_UPGRADE_FAILED, (Throwable)e, new Object[]{Version.VersionEnum.V11204.toString(), Version.VersionEnum.V12101.toString()});
            }
            catch (CmdToolUtilException e) {
                throw new UpgradeException((MessageKey)PrCaMsgID.ACFS_UPGRADE_FAILED, (Throwable)e, new Object[]{Version.VersionEnum.V11204.toString(), Version.VersionEnum.V12101.toString()});
            }
        }
    }

    public void upgradeVolume12101To12102LastPhase() throws UpgradeException {
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            cf.upgradeType(ResourceType.Volume.class);
            HashMap<String, ResourceAttribute> attrMap = null;
            List<Volume> volList = null;
            try {
                volList = this.getVolumes(null, null, null);
            }
            catch (NotExistsException nee) {
                Trace.out((String)"No Volume resources found to upgrade");
                return;
            }
            if (volList.size() > 0 && volList != null) {
                attrMap = new HashMap<String, ResourceAttribute>();
                attrMap.put(ResourceType.Volume.CANONICAL_VOLUME_DEVICE.name(), cf.create(ResourceType.Volume.CANONICAL_VOLUME_DEVICE.name(), ""));
                for (Volume vol : volList) {
                    ADVMUtil advmutil = new ADVMUtil(m_crsHome);
                    String canVolDevice = advmutil.getCanonicalVolume(vol.getVolumeDevice());
                    Trace.out((String)("Canonical form of the volume device = " + canVolDevice));
                    ((ResourceAttribute)attrMap.get(ResourceType.Volume.CANONICAL_VOLUME_DEVICE.name())).setValue(canVolDevice);
                    ResourceAttribute[] attrArr = attrMap.values().toArray(new ResourceAttribute[attrMap.size()]);
                    if (attrArr.length <= 0) continue;
                    CRSResourceImpl crsResImpl = (CRSResourceImpl)vol.crsResource();
                    crsResImpl.update(attrArr);
                }
            }
        }
        catch (VolumeException e) {
            throw new UpgradeException((MessageKey)PrCaMsgID.VOLUME_UPGRADE_FAILED, (Throwable)((Object)e), new Object[]{Version.VersionEnum.V12101, Version.VersionEnum.V12102});
        }
        catch (CmdToolUtilException e) {
            throw new UpgradeException((MessageKey)PrCaMsgID.VOLUME_UPGRADE_FAILED, (Throwable)e, new Object[]{Version.VersionEnum.V12101, Version.VersionEnum.V12102});
        }
        catch (CRSException e) {
            throw new UpgradeException((MessageKey)PrCaMsgID.VOLUME_UPGRADE_FAILED, (Throwable)e, new Object[]{Version.VersionEnum.V12101, Version.VersionEnum.V12102});
        }
        catch (NotExistsException e) {
            throw new UpgradeException((MessageKey)PrCaMsgID.VOLUME_UPGRADE_FAILED, (Throwable)e, new Object[]{Version.VersionEnum.V12101, Version.VersionEnum.V12102});
        }
    }

    public void updateDependency12102To12201LastPhase() throws UpgradeException {
        List<Volume> volumeList = null;
        ProxyASM proxyasm = null;
        Trace.out((String)"Calling updateDependency12102To12201LastPhase()");
        try {
            this.updateASMDepSiteTypeASM();
            try {
                volumeList = this.getVolumes();
            }
            catch (NotExistsException e) {
                volumeList = null;
            }
            try {
                proxyasm = this.getProxyASM();
            }
            catch (NotExistsException e) {
                proxyasm = null;
            }
            if (proxyasm != null) {
                this.updateProxyASMDependencyOnASM(proxyasm, true);
            }
            if (volumeList != null) {
                this.updateFSDependencyOnVolumes(volumeList);
            }
            Trace.out((String)"Calling updateDependenciesASMConversion(true)");
            this.updateDependenciesASMConversion(true);
        }
        catch (VolumeException e) {
            throw new UpgradeException((Throwable)((Object)e));
        }
        catch (ASMException e) {
            throw new UpgradeException((Throwable)((Object)e));
        }
        catch (NotExistsException e) {
            throw new UpgradeException((Throwable)e);
        }
        catch (CRSException e) {
            throw new UpgradeException((Throwable)e);
        }
    }

    public boolean isACFSSupported(String oraHome) throws AsmClusterFileSystemException {
        Trace.out((String)("Entry: oraHome=" + oraHome + ", m_crsHome=" + m_crsHome));
        try {
            Trace.out((String)"Checking if ACFS now...");
            return new USMDriverUtil(m_crsHome).checkACFSState(USMDriverUtil.ACFSDriverState.SUPPORTED, oraHome);
        }
        catch (CmdToolUtilException e) {
            throw new AsmClusterFileSystemException(e);
        }
    }

    private boolean isValidDiskGroup(Volume volume, String dgName) throws AsmClusterFileSystemException {
        if (null == dgName || dgName.trim().length() == 0) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dgName", dgName);
        }
        String dName = volume.getDiskGroup().trim();
        Trace.out((String)("Validate diskgroup " + dgName));
        return dgName.trim().equalsIgnoreCase(dName);
    }

    private boolean isValidVolume(Volume volume, String volName) throws AsmClusterFileSystemException {
        if (null == volName || volName.trim().length() == 0) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "volName", volName);
        }
        String vName = volume.getVolumeName().trim();
        Trace.out((String)("Validate volume name " + volName));
        return volName.trim().equalsIgnoreCase(vName);
    }

    private boolean isFSMountPoint(String mountpoint, Boolean isClusterFS) throws AsmClusterFileSystemException {
        if (null == mountpoint || mountpoint.trim().length() == 0) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mountpointpath", mountpoint);
        }
        try {
            List<AsmBaseFileSystem> fsList = this.getValidationFileSystems(mountpoint, isClusterFS);
            if (fsList != null && fsList.size() > 0) {
                Trace.out((String)"Mount point in use by a file system");
                return true;
            }
            return false;
        }
        catch (NotExistsException nee) {
            Trace.out((String)"No file systems where found for the specified mount point");
            return false;
        }
    }

    private boolean isLocalFSMountPoint(String mountpoint, String nodeName) throws AsmClusterFileSystemException {
        if (null == mountpoint || mountpoint.trim().length() == 0) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mountpointpath", mountpoint);
        }
        try {
            List<AsmBaseFileSystem> fsList = this.getNLocalFileSystems(mountpoint, nodeName);
            if (fsList != null && fsList.size() > 0) {
                Trace.out((String)("Mount point path in use by a fle system resource in node " + nodeName));
                return true;
            }
            return false;
        }
        catch (NotExistsException nee) {
            Trace.out((String)"No file system resources where found with the specified mount point and node");
            return false;
        }
    }

    public static boolean isDBAASCluster() {
        Trace.out((String)"isDBAASCluster: Not implemented yet");
        return false;
    }

    public static Pattern getParamPattern() {
        return Pattern.compile("((\\w+\\s*)=(\\s*\\w+))|((\\w+\\s*)=\\s*\"(([^\"])*)\")|((\\w+\\s*)=\\s*'(([^'])*)')");
    }

    public int getDefaultASMCount() {
        return 3;
    }

    public ASMPresence getASMPresence() throws ASMException {
        try {
            ASM asm = this.getASM();
            return asm.getPresence();
        }
        catch (NotExistsException e) {
            return ASMPresence.NONE;
        }
    }

    public ASMMode getASMMode() throws ASMException {
        if (m_asmmode == null) {
            try {
                m_asmmode = new ClusterUtil().getASMMode();
                Trace.out((String)("ASMMode = " + (Object)((Object)m_asmmode)));
            }
            catch (ClusterUtilException ce) {
                throw new ASMException((MessageKey)PrCaMsgID.GET_ASM_MODE_FAILED, ce, new Object[0]);
            }
        }
        return m_asmmode;
    }

    public ConnectionInfo getConnectionInfo(boolean ios, String svcName, String instName, String connID) throws ASMException {
        return this.getConnectionInfo(ios, svcName, instName, connID, 30);
    }

    public ConnectionInfo getConnectionInfoFromASMListener(boolean ios, String svcName, String instName, String connID, int nTrials) throws ASMException {
        return this.getConnectionInfoInt(ios, svcName, instName, connID, nTrials, true);
    }

    public ConnectionInfo getConnectionInfo(boolean ios, String svcName, String instName, String connID, int nTrials) throws ASMException {
        return this.getConnectionInfoInt(ios, svcName, instName, connID, nTrials, false);
    }

    public ConnectionInfo getConnectionInfoInt(boolean ios, String svcName, String instName, String connID, int nTrials, boolean useLsnr) throws ASMException {
        NativeSystem m_system = new SystemFactory().CreateSystem();
        try {
            if (!m_system.isLibraryLoaded()) {
                m_system.loadSRVMHASNativeLibrary();
            }
        }
        catch (NativeException ne) {
            throw new ASMException(ne);
        }
        ConnNativeResult result = null;
        if (!ios) {
            Trace.out((String)("Get connection info from ASM for service: " + svcName + ", instance: " + instName + ", connection id: " + connID));
        } else {
            Trace.out((String)("Get connection info from IOServer for service: " + svcName + ", instance: " + instName + ", connection id: " + connID));
        }
        try {
            int clusterType = 0;
            String connStr = null;
            HashMap<String, String> credMap = null;
            boolean isClientCluster = ASMFactoryImpl.isClientMode();
            if (isClientCluster) {
                try {
                    result = new ConnNativeResult();
                    clusterType = ConnNative.getConnectionInfoInt(result, ios, svcName, instName, connID, useLsnr);
                    connStr = result.getConnectionStr();
                    Trace.out((String)("Connection string in client cluster is " + connStr));
                    credMap = result.getCredMap();
                }
                catch (ConnNativeException e) {
                    throw new ASMException((Throwable)((Object)e));
                }
            }
            boolean isASM = false;
            for (int indx = 1; indx <= nTrials; ++indx) {
                try {
                    Trace.out((String)("ASM resource check. Trial " + indx));
                    ASM asm = this.getASM();
                    if (asm != null && asm.isRunning()) {
                        isASM = true;
                        result = new ConnNativeResult();
                        clusterType = ConnNative.getConnectionInfoInt(result, ios, svcName, instName, connID, useLsnr);
                        if (result != null) {
                            connStr = result.getConnectionStr();
                            Trace.out((String)("Connection string is " + connStr));
                            credMap = result.getCredMap();
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    if (indx == nTrials) {
                        Trace.out((String)"Timeout, throw exception");
                        throw new ASMException(e);
                    }
                    Trace.out((String)("Running ASM resource not found yet in trial " + indx + ". Not an error"));
                }
                if (isASM) continue;
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new ASMException(e);
                }
            }
            ASMMode asmMode = ASMMode.getEnumMember(clusterType);
            return new ConnectionInfo(connStr, credMap, connID, asmMode);
        }
        catch (EnumConstNotFoundException e) {
            throw new ASMException(e);
        }
    }

    public void updateIosTargetForInstances(String targetInst, String[] instNames) throws ASMException {
        try {
            Trace.out((String)"Update target instance for specified IOServer instances ...");
            IOServerImpl iosImpl = new IOServerImpl(CRSFactoryImpl.getInstance().create(ResourceType.IOServer.NAME.name(), IOServerImpl.getResourceName()));
            CRSResourceImpl crsRes = (CRSResourceImpl)iosImpl.crsResource();
            List<IOServerInstance> iosInsts = iosImpl.instances();
            ArrayList<Node> runningNodeList = new ArrayList<Node>();
            StringBuilder notRunningInsts = new StringBuilder();
            for (String instName : instNames) {
                boolean found = false;
                for (IOServerInstance inst : iosInsts) {
                    String runningInstName = inst.getUserAssignedName();
                    if (!instName.equals(runningInstName)) continue;
                    Node runningNode = inst.node();
                    Trace.out((String)("Found IOServer instance: " + runningInstName + " running on node " + runningNode.getName()));
                    runningNodeList.add(runningNode);
                    found = true;
                    break;
                }
                if (found) continue;
                if (notRunningInsts.length() != 0) {
                    notRunningInsts.append(",");
                }
                notRunningInsts.append(instName);
            }
            if (notRunningInsts.length() > 0) {
                throw new ASMException((MessageKey)PrCaMsgID.IOS_INSTANCES_NOT_RUNNING, notRunningInsts.toString());
            }
            this.updateIosTarget(iosImpl, targetInst, runningNodeList);
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        catch (AlreadyStoppedException e) {
            throw new ASMException(e);
        }
        catch (InstanceException e) {
            throw new ASMException(e);
        }
        catch (NotExistsException e) {
            throw new ASMException(e);
        }
        catch (NodeException e) {
            throw new ASMException(e);
        }
    }

    public void updateIosTargetOnNodes(String targetInst, String[] nodeNames) throws ASMException {
        try {
            Trace.out((String)"Update the target instance for IOServer instances running on specified nodes ...");
            IOServerImpl iosImpl = new IOServerImpl(CRSFactoryImpl.getInstance().create(ResourceType.IOServer.NAME.name(), IOServerImpl.getResourceName()));
            CRSResourceImpl crsRes = (CRSResourceImpl)iosImpl.crsResource();
            ArrayList<Node> runningNodeList = new ArrayList<Node>();
            List allRunningNodes = crsRes.fetchRunningNodes();
            StringBuilder notRunningNodes = new StringBuilder();
            for (String nodeName : nodeNames) {
                boolean found = false;
                for (Node runningNode : allRunningNodes) {
                    String runningNodeName = runningNode.getName();
                    if (!runningNodeName.equalsIgnoreCase(nodeName)) continue;
                    Trace.out((String)("Found the running node for IOServer: " + runningNodeName));
                    runningNodeList.add(runningNode);
                    found = true;
                    break;
                }
                if (found) continue;
                if (notRunningNodes.length() != 0) {
                    notRunningNodes.append(",");
                }
                notRunningNodes.append(nodeName);
            }
            if (notRunningNodes.length() > 0) {
                throw new ASMException((MessageKey)PrCaMsgID.NO_RUNNING_IOS_INSTANCE_ON_NODES, notRunningNodes.toString());
            }
            this.updateIosTarget(iosImpl, targetInst, runningNodeList);
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        catch (NodeException e) {
            throw new ASMException(e);
        }
        catch (NotExistsException e) {
            throw new ASMException(e);
        }
    }

    public void updateIosTarget(String targetInst) throws ASMException {
        try {
            Trace.out((String)"Update target instance for IOServer...");
            IOServerImpl iosImpl = new IOServerImpl(CRSFactoryImpl.getInstance().create(ResourceType.IOServer.NAME.name(), IOServerImpl.getResourceName()));
            CRSResourceImpl crsRes = (CRSResourceImpl)iosImpl.crsResource();
            List allRunningNodes = crsRes.fetchRunningNodes();
            this.updateIosTarget(iosImpl, targetInst, allRunningNodes);
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        catch (NotExistsException e) {
            throw new ASMException(e);
        }
    }

    private void updateIosTarget(IOServer ios, String targetInst, List<Node> runningNodeList) throws ASMException {
        try {
            Trace.out((String)("Update IOS target instance to " + targetInst));
            CRSResourceImpl crsRes = (CRSResourceImpl)ios.crsResource();
            String actionName = ResourceLiterals.RELOCATE_CLIENT.toString();
            ActionAttribute attrTargetType = new ActionAttribute(ResourceType.IOServer.TARGET_TYPE.name(), ResourceLiterals.ASM.name());
            ActionAttribute attrTargetName = new ActionAttribute(ResourceType.IOServer.TARGET_NAME.name(), targetInst);
            ActionAttribute[] attrs = new ActionAttribute[]{attrTargetType, attrTargetName};
            CompositeActionStatusImpl actionStatus = new CompositeActionStatusImpl();
            ActionListenerImpl actionLsnr = new ActionListenerImpl(actionStatus);
            Node[] nodesArr = new Node[runningNodeList.size()];
            runningNodeList.toArray(nodesArr);
            crsRes.requestAction(actionName, attrs, nodesArr, (ActionListener)actionLsnr);
            Trace.out((String)"Request Action completed");
            if (actionStatus.isSuccess()) {
                return;
            }
            throw new ASMException((MessageKey)PrCaMsgID.ERROR_UPDATE_IOS_TARGET_INSTANCE, actionStatus.getErrorMessage());
        }
        catch (NotExistsException e) {
            throw new ASMException(e);
        }
        catch (CompositeActionException e) {
            throw new ASMException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ASMException(e);
        }
    }

    public List<IOServerInstance> getIOSStatus(boolean detailedStat) throws ASMException {
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            IOServerImpl iosImpl = new IOServerImpl(cf.create(ResourceType.IOServer.NAME.name(), IOServerImpl.getResourceName()));
            CRSResourceImpl crsRes = (CRSResourceImpl)iosImpl.crsResource();
            List<IOServerInstance> iosInstList = iosImpl.allInstances();
            if (!detailedStat) {
                return iosInstList;
            }
            Trace.out((String)"Request target status for IOServer...");
            CompositeActionStatus compActionStat = cf.requestTargetStatus((CRSResource)crsRes, ResourceLiterals.IOS.name(), "");
            if (compActionStat == null) {
                return iosInstList;
            }
            Map actionStatusMap = compActionStat.getAllActionStatus();
            String clientConnectedAttr = ResourceLiterals.CLIENT_CONNECTED.toString();
            String clientNamesAttr = ResourceLiterals.CLIENT_NAMES.toString();
            String connectedToInstanceAttr = ResourceLiterals.CONNECTED_TO_INSTANCE.toString();
            String errorAttr = ResourceLiterals.ACTION_ERROR.toString();
            Trace.out((String)("iosInstList size " + iosInstList.size()));
            for (IOServerInstance iosInst : iosInstList) {
                Trace.out((String)("iosInst name is " + iosInst.getName()));
                Trace.out((String)("iosInst.getState() is " + iosInst.getState()));
                if (!iosInst.getState().equals("ONLINE")) continue;
                Trace.out((String)("iosInst is " + iosInst));
                ActionStatusImpl cs = (ActionStatusImpl)actionStatusMap.get(iosInst.node());
                Trace.out((String)("ActionStatus is " + cs));
                if (cs == null) continue;
                String errMsg = cs.getActionValue(errorAttr);
                if (errMsg != null) {
                    Trace.out((String)("Get error : " + errMsg));
                    continue;
                }
                String clientConnected = cs.getActionValue(clientConnectedAttr);
                iosInst.setClientConnected(Integer.valueOf(clientConnected));
                iosInst.setClientNames(cs.getActionValue(clientNamesAttr));
                iosInst.setConnectedToInstance(cs.getActionValue(connectedToInstanceAttr));
            }
            return iosInstList;
        }
        catch (NotExistsException e) {
            throw new ASMException(e);
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        catch (InstanceException e) {
            throw new ASMException(e);
        }
    }

    public List<ASMInstance> getASMStatus(boolean detailedStat) throws ASMException {
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            ClusterASMImpl asmImpl = new ClusterASMImpl(CRSFactoryImpl.getInstance().create(ResourceLiterals.NAME.name(), ClusterASMImpl.getResourceName()));
            CRSResourceImpl crsRes = (CRSResourceImpl)asmImpl.crsResource();
            List<ASMInstance> asmInstList = asmImpl.allInstances();
            if (!detailedStat) {
                return asmInstList;
            }
            Trace.out((String)"Request target status for asm instances...");
            CompositeActionStatus compActionStat = cf.requestTargetStatus((CRSResource)crsRes, ResourceLiterals.ASM.name(), "");
            if (compActionStat == null) {
                return asmInstList;
            }
            Map actionStatusMap = compActionStat.getAllActionStatus();
            String clientConnectedAttr = ResourceLiterals.CLIENT_CONNECTED.toString();
            String clientNamesAttr = ResourceLiterals.CLIENT_NAMES.toString();
            String errorAttr = ResourceLiterals.ACTION_ERROR.toString();
            for (ASMInstance asmInst : asmInstList) {
                ActionStatusImpl cs;
                if (!asmInst.getState().equals("ONLINE") || (cs = (ActionStatusImpl)actionStatusMap.get(asmInst.node())) == null) continue;
                String errMsg = cs.getActionValue(errorAttr);
                if (errMsg != null) {
                    Trace.out((String)("Get error : " + errMsg));
                    continue;
                }
                String clientConnected = cs.getActionValue(clientConnectedAttr);
                Trace.out((String)("client connected = " + clientConnectedAttr));
                asmInst.setClientConnected(Integer.valueOf(clientConnected));
                asmInst.setClientNames(cs.getActionValue(clientNamesAttr));
            }
            return asmInstList;
        }
        catch (NotExistsException e) {
            throw new ASMException(e);
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        catch (InstanceException e) {
            throw new ASMException(e);
        }
    }

    public void updateDependenciesASMConversion() throws ASMException {
        try {
            boolean toRemote = true;
            Trace.out((String)"Getting current ASM type");
            ASM asm1 = this.getASM();
            if (asm1.getPresence() == ASMPresence.REMOTE) {
                Trace.out((String)"Flex ASM update");
                toRemote = true;
            } else {
                Trace.out((String)"Standard ASM update");
                toRemote = false;
            }
            this.updateDependenciesASMConversion(toRemote);
        }
        catch (NotExistsException e) {
            Trace.out((String)"No conversion is needed because there is no asm configured");
        }
    }

    public void updateDependenciesASMConversion(boolean toRemote) throws ASMException {
        try {
            List<Volume> volumeList = null;
            List<DiskGroup> dgList = null;
            DatabaseFactory daf = DatabaseFactory.getInstance();
            try {
                volumeList = this.getVolumes(null, null, null);
            }
            catch (NotExistsException nee) {
                Trace.out((String)"No volume resources found");
            }
            try {
                dgList = this.getDiskGroups();
            }
            catch (NotExistsException nee) {
                Trace.out((String)"No diskgroups found");
            }
            List<Database> dbList = null;
            HashSet<String> dbsUpgraded = new HashSet<String>();
            HashSet<String> dgSet = new HashSet<String>();
            if (volumeList != null && volumeList.size() > 0) {
                this.updateVolumesDependencyOnASM(volumeList);
            }
            if (dgList != null && dgList.size() > 0) {
                for (DiskGroup dg : dgList) {
                    dgSet.add(dg.getName());
                }
                for (DiskGroup dg : dgList) {
                    dbList = dg.databases(true);
                    for (Database db : dbList) {
                        if (dbsUpgraded.contains(db.getName())) continue;
                        this.updateDatabaseDepASM(db, toRemote, dgSet);
                        dbsUpgraded.add(db.getName());
                    }
                }
            }
            this.updateMgmtDBDepASM(toRemote);
        }
        catch (VolumeException e) {
            throw new ASMException((Throwable)((Object)e));
        }
        catch (DatabaseException e) {
            throw new ASMException(e);
        }
        catch (NotExistsException e) {
            throw new ASMException(e);
        }
        catch (AlreadyExistsException e) {
            throw new ASMException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ASMException(e);
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    public void updateASMDependency4ASMLsnr(ResourceAttribute resAttr, boolean bAdd) throws NotExistsException, AlreadyExistsException, ASMException, CRSException {
        Trace.out((String)"Updating dependency for ASM...");
        ResourceAttribute asmAttr = CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ClusterASMImpl.getResourceName());
        ClusterASMImpl asmImpl = new ClusterASMImpl(asmAttr);
        CRSResourceImpl crsRes = (CRSResourceImpl)asmImpl.crsResource();
        this.updateDependencyOnASMListenerForConversion(crsRes, resAttr, bAdd);
    }

    public void updateASMDependency4Lsnr(ResourceAttribute resAttr, boolean bAdd) throws NotExistsException, ASMException, CRSException {
        Trace.out((String)"Updating dependency for ASM...");
        ClusterASMImpl asmImpl = new ClusterASMImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ClusterASMImpl.getResourceName()));
        CRSResourceImpl crsRes = (CRSResourceImpl)asmImpl.crsResource();
        ResourceAttribute startDepAttr = crsRes.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
        Trace.out((String)"Before update: name=%s,value=%s", (Object[])new Object[]{startDepAttr.getName(), startDepAttr.getValue()});
        ResourceDependency.updateDependencyAttr((ResourceAttribute)startDepAttr, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.WEAK_DEP, (boolean)bAdd);
        Trace.out((String)"After update: name=%s,value=%s", (Object[])new Object[]{startDepAttr.getName(), startDepAttr.getValue()});
        crsRes.update(startDepAttr);
    }

    public void updateIOServerDependency4ASMLsnr(ResourceAttribute resAttr, boolean bAdd) throws NotExistsException, AlreadyExistsException, ASMException, CRSException {
        Trace.out((String)"Updating dependency for IOServer...");
        IOServerImpl iosImpl = new IOServerImpl(CRSFactoryImpl.getInstance().create(ResourceType.IOServer.NAME.name(), IOServerImpl.getResourceName()));
        CRSResourceImpl crsRes = (CRSResourceImpl)iosImpl.crsResource();
        this.updateDependencyOnASMListenerForConversion(crsRes, resAttr, bAdd);
    }

    public void updateProxyASMDependencyOnASM(ProxyASM proxyasm, boolean bAdd) throws ASMException {
        Trace.out((String)"Updating dependency for ProxyASM to have global dependency on ASM...");
        ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
        try {
            ResourceAttribute asmAttr = CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.NAME.name(), ClusterASMImpl.getResourceName());
            CRSResourceImpl proxyRes = (CRSResourceImpl)proxyasm.crsResource();
            ResourceAttribute startDep = proxyRes.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            ResourceAttribute stopDep = proxyRes.getAttribute(ResourceType.LocalResource.STOP_DEPENDENCIES.name());
            ResourceDependency.updateDependencyAttrModifier((boolean)bAdd, (ResourceAttribute)startDep, (ResourceAttribute)asmAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            ResourceDependency.updateDependencyAttrModifier((!bAdd ? 1 : 0) != 0, (ResourceAttribute)startDep, (ResourceAttribute)asmAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[0]);
            ResourceDependency.updateDependencyAttrModifier((boolean)bAdd, (ResourceAttribute)startDep, (ResourceAttribute)asmAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_ALWAYS_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            ResourceDependency.updateDependencyAttrModifier((boolean)bAdd, (ResourceAttribute)stopDep, (ResourceAttribute)asmAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            attrList.add(startDep);
            attrList.add(stopDep);
            proxyRes.update(attrList);
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        catch (AlreadyExistsException e) {
            throw new ASMException(e);
        }
        catch (NotExistsException e) {
            throw new ASMException(e);
        }
    }

    public void updateVolumesDependencyOnASM(List<Volume> volumeList) throws ASMException {
        Trace.out((String)"Updating dependency for Volumes...");
        try {
            for (Volume volume : volumeList) {
                CRSResourceImpl volumeCrsRes = (CRSResourceImpl)volume.crsResource();
                try {
                    Trace.out((String)("Updating volume " + volume.getVolumeName()));
                    ArrayList<ResourceAttribute> resAttrs = new ArrayList<ResourceAttribute>();
                    ((VolumeImpl)volume).createVolumeDepAttrs(resAttrs, volume.getVolumeDevice());
                    volumeCrsRes.update(resAttrs);
                }
                catch (AlreadyExistsException e) {
                    Trace.out((String)("Got AlreadyExistsException: " + e.getMessage()));
                }
            }
        }
        catch (VolumeException e) {
            throw new ASMException((Throwable)((Object)e));
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        catch (NotExistsException e) {
            throw new ASMException(e);
        }
    }

    public void updateFSDependencyOnVolumes(List<Volume> volumeList) throws ASMException {
        Trace.out((String)"Updating dependency for Volumes...");
        try {
            for (Volume volume : volumeList) {
                String volResName = volume.getName();
                ResourceAttribute volResAttr = CRSFactoryImpl.getInstance().create(ResourceType.Volume.NAME.name(), volResName);
                String volDevice = volume.getVolumeDevice();
                try {
                    AsmBaseFileSystem fs = this.getFileSystem(volDevice);
                    CRSResourceImpl fsCrsRes = (CRSResourceImpl)fs.crsResource();
                    try {
                        this.updateDependencyForASMConversion(fsCrsRes, volResAttr);
                    }
                    catch (AlreadyExistsException e) {
                        Trace.out((String)("Got AlreadyExistsException: " + e.getMessage()));
                    }
                }
                catch (NotExistsException e) {
                    Trace.out((String)("Unable to update FS dependency on volume. No filesystem for device " + volDevice));
                }
            }
        }
        catch (VolumeException e) {
            throw new ASMException((Throwable)((Object)e));
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        catch (AsmClusterFileSystemException e) {
            throw new ASMException((Throwable)((Object)e));
        }
    }

    public void upgradeVolumeDepAttrs(ResourceAttribute resAttr, List<ResourceAttribute> attrList, boolean inclStartDep, boolean inclStopDep) throws UpgradeException {
        try {
            VolumeImpl volume = new VolumeImpl(resAttr);
            volume.upgradeVolumeDepAttrs(attrList, inclStartDep, inclStopDep);
        }
        catch (VolumeException e) {
            throw new UpgradeException((MessageKey)PrCrMsgID.FAILED_UPGRADE_DEPENDENCIES, (Throwable)((Object)e), new Object[]{resAttr.getValue()});
        }
    }

    private void updateDependencyOnASMListenerForConversion(CRSResourceImpl crsRes, ResourceAttribute resAttr, boolean bAdd) throws CRSException, AlreadyExistsException {
        ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
        Trace.out((String)("Adding dependency to res " + crsRes.getName()));
        Trace.out((String)("Attribute: name=" + resAttr.getName() + ",value=" + resAttr.getValue()));
        ResourceAttribute attr = crsRes.getAttribute(ResourceType.LocalResource.STOP_DEPENDENCIES.name());
        Trace.out((String)("Before update: name=" + attr.getName() + ",value=" + attr.getValue()));
        if (m_upgradePhase != UpgradePhase.FIRST) {
            ResourceDependency.updateDependencyAttr((ResourceAttribute)attr, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier)ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP, (boolean)bAdd);
            Trace.out((String)("After update: name=" + attr.getName() + ",value=" + attr.getValue()));
        }
        ResourceAttribute attr2 = crsRes.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
        Trace.out((String)("Before update: name=" + attr2.getName() + ",value=" + attr2.getValue()));
        if (m_upgradePhase == UpgradePhase.FIRST) {
            ResourceDependency.updateDependencyAttr((ResourceAttribute)attr2, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.WEAK_DEP, (boolean)bAdd);
            Trace.out((String)("After second update: name=" + attr2.getName() + ",value=" + attr2.getValue()));
        } else if (m_upgradePhase == UpgradePhase.LAST) {
            ResourceDependency.updateDependencyAttr((ResourceAttribute)attr2, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_DEP, (boolean)bAdd);
            Trace.out((String)("After update: name=" + attr2.getName() + ",value=" + attr2.getValue()));
            ResourceDependency.updateDependencyAttr((ResourceAttribute)attr2, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.WEAK_DEP, (!bAdd ? 1 : 0) != 0);
            ResourceDependency.updateDependencyAttr((ResourceAttribute)attr2, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (boolean)bAdd);
            Trace.out((String)("After second update: name=" + attr2.getName() + ",value=" + attr2.getValue()));
        } else {
            ResourceDependency.updateDependencyAttr((ResourceAttribute)attr2, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_DEP, (boolean)bAdd);
            Trace.out((String)("After update: name=" + attr2.getName() + ",value=" + attr2.getValue()));
            ResourceDependency.updateDependencyAttr((ResourceAttribute)attr2, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (boolean)bAdd);
            Trace.out((String)("After second update: name=" + attr2.getName() + ",value=" + attr2.getValue()));
        }
        attrList.add(attr);
        attrList.add(attr2);
        crsRes.update(attrList);
    }

    private void updateDependencyForASMConversion(CRSResourceImpl crsRes, ResourceAttribute resAttr) throws CRSException, AlreadyExistsException {
        ArrayList<ResourceAttribute> resAttrs = new ArrayList<ResourceAttribute>();
        resAttrs.add(resAttr);
        this.updateDependencyForASMConversion(crsRes, resAttrs);
    }

    private void updateDependencyForASMConversion(CRSResourceImpl crsRes, List<ResourceAttribute> resAttrs) throws CRSException, AlreadyExistsException {
        boolean bAdd = true;
        ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
        Trace.out((String)("Adding dependency to res " + crsRes.getName()));
        ResourceAttribute attr = crsRes.getAttribute(ResourceType.LocalResource.STOP_DEPENDENCIES.name());
        if (m_upgradePhase != UpgradePhase.FIRST) {
            for (ResourceAttribute resAttr : resAttrs) {
                Trace.out((String)("Attribute: name=" + resAttr.getName() + ",value=" + resAttr.getValue()));
                Trace.out((String)("Before update: name=" + attr.getName() + ",value=" + attr.getValue()));
                ResourceDependency.updateDependencyAttr((ResourceAttribute)attr, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier)ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP, (boolean)bAdd);
                Trace.out((String)("After update: name=" + attr.getName() + ",value=" + attr.getValue()));
            }
        }
        ResourceAttribute attr2 = crsRes.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
        Trace.out((String)("Before update: name=" + attr2.getName() + ",value=" + attr2.getValue()));
        for (ResourceAttribute resAttr : resAttrs) {
            ResourceDependency.updateDependencyAttr((ResourceAttribute)attr2, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_DEP, (boolean)bAdd);
            Trace.out((String)("After update: name=" + attr2.getName() + ",value=" + attr2.getValue()));
            ResourceDependency.updateDependencyAttr((ResourceAttribute)attr2, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (boolean)bAdd);
            Trace.out((String)("After second update: name=" + attr2.getName() + ",value=" + attr2.getValue()));
        }
        attrList.add(attr);
        attrList.add(attr2);
        crsRes.update(attrList);
    }

    private void updateASMDepSiteTypeASM() throws ASMException, NotExistsException, CRSException {
        Trace.out((String)"Add dispersion:active(site:type:ora.asm.type) in asm start dependency");
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        ResourceAttribute asmAttr = crsFactory.create(ResourceType.ClusterASM.NAME.name(), ClusterASMImpl.getResourceName());
        ResourceAttribute asmTypeAttr = crsFactory.create(ResourceLiterals.NAME.name(), ResourceLiterals.ASM_TYPE.toString());
        ClusterASMImpl asmImpl = new ClusterASMImpl(asmAttr);
        CRSResourceImpl crsRes = (CRSResourceImpl)asmImpl.crsResource();
        ResourceAttribute startDepAttr = crsRes.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
        ResourceDependency.updateDependencyAttrModifier((boolean)true, (ResourceAttribute)startDepAttr, (ResourceAttribute)asmTypeAttr, (ResourceDependency.DepType)ResourceDependency.DepType.DISPERSION_ACTIVE_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.SITE_MODIFIER_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP});
        crsRes.update(startDepAttr);
    }

    private void updateVolumeDepASM(Volume vol, boolean toFlex) throws VolumeException, NotExistsException, AlreadyExistsException, CRSException {
        ResourceDependency startDepHard = null;
        ResourceDependency stopDepHard = null;
        ResourceDependency startPullupDep = null;
        ResourceDependency startDepHardProxyASM = null;
        ResourceDependency stopDepHardProxyASM = null;
        ResourceDependency startPullupDepASM = null;
        String dg = "";
        CRSResourceImpl volRes = null;
        volRes = (CRSResourceImpl)vol.crsResource();
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        ArrayList<ResourceDependency.DepModifier> modListStartDepHard = new ArrayList<ResourceDependency.DepModifier>();
        ArrayList<ResourceDependency.DepModifier> modListStartDepPullup = new ArrayList<ResourceDependency.DepModifier>();
        ArrayList<ResourceDependency.DepModifier> modListStopDepHard = new ArrayList<ResourceDependency.DepModifier>();
        ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
        ArrayList<ResourceDependency> startList = new ArrayList<ResourceDependency>();
        ArrayList<ResourceDependency> stopList = new ArrayList<ResourceDependency>();
        dg = vol.getDiskGroup();
        ResourceAttribute dgAttr = CRSFactoryImpl.getInstance().create(ResourceType.DiskGroup.NAME.name(), DiskGroupImpl.getResourceName(dg));
        ResourceAttribute pxASMAttr = CRSFactoryImpl.getInstance().create(ResourceType.ProxyASM.NAME.name(), ProxyASMImpl.getResourceName());
        Trace.out((String)("Updating volume " + vol.getVolumeName()));
        Trace.out((String)"Setting dependencies modifiers");
        if (toFlex) {
            Trace.out((String)"Standard ASM to Flex ASM conversion");
            modListStartDepHard.add(ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
            modListStartDepHard.add(ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP);
            modListStartDepPullup.add(ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
            modListStopDepHard.add(ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            modListStopDepHard.add(ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
            startDepHardProxyASM = crsFactory.createResourceDependency(pxASMAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
            startPullupDepASM = crsFactory.createResourceDependency(pxASMAttr, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
            stopDepHardProxyASM = crsFactory.createResourceDependency(pxASMAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
        } else {
            Trace.out((String)"Flex ASM to Standard conversion");
            modListStopDepHard.add(ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
        }
        startDepHard = crsFactory.createResourceDependency(dgAttr, ResourceDependency.DepType.HARD_DEP, modListStartDepHard.toArray(new ResourceDependency.DepModifier[modListStartDepHard.size()]));
        startList.add(startDepHard);
        startPullupDep = crsFactory.createResourceDependency(dgAttr, ResourceDependency.DepType.PULLUP_DEP, modListStartDepPullup.toArray(new ResourceDependency.DepModifier[modListStartDepPullup.size()]));
        startList.add(startPullupDep);
        if (toFlex) {
            startList.add(startDepHardProxyASM);
            startList.add(startPullupDepASM);
        }
        stopDepHard = crsFactory.createResourceDependency(dgAttr, ResourceDependency.DepType.HARD_DEP, modListStopDepHard.toArray(new ResourceDependency.DepModifier[modListStopDepHard.size()]));
        stopList.add(stopDepHard);
        if (toFlex) {
            stopList.add(stopDepHardProxyASM);
        }
        ResourceAttribute startDep = crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])startList.toArray(new ResourceDependency[startList.size()])));
        ResourceAttribute stopDep = crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])stopList.toArray(new ResourceDependency[stopList.size()])));
        Trace.out((String)("" + ResourceType.LocalResource.START_DEPENDENCIES.name() + "=" + ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{startDepHard, startPullupDep})));
        Trace.out((String)("" + ResourceType.LocalResource.STOP_DEPENDENCIES.name() + "=" + ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{stopDepHard})));
        attrList.add(startDep);
        attrList.add(stopDep);
        Trace.out((String)"Executing resource update for start and stop dependencies");
        volRes.update(attrList);
    }

    public void updateDatabaseDepASM(Database db, DiskGroup dg, boolean toFlex) throws DatabaseException, ASMException, AlreadyExistsException, NotExistsException, CRSException {
        this.updateDatabaseDepASM(db, toFlex, null);
    }

    public void updateDatabaseDepASM(Database db, boolean toFlex, HashSet<String> dgSet) throws DatabaseException, ASMException, AlreadyExistsException, NotExistsException, CRSException {
        CRSResourceImpl dbRes = (CRSResourceImpl)db.crsResource();
        ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
        ResourceAttribute startDep = dbRes.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
        ResourceAttribute stopDep = dbRes.getAttribute(ResourceType.LocalResource.STOP_DEPENDENCIES.name());
        String[] resNames = ResourceDependency.getResourceNames((ResourceAttribute)startDep, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP);
        ArrayList<ResourceAttribute> dgAttrs = new ArrayList<ResourceAttribute>();
        ArrayList<ResourceAttribute> dgRmAttrs = new ArrayList<ResourceAttribute>();
        for (String resName : resNames) {
            if (resName.endsWith(String.valueOf('.') + ResourceLiterals.DG.toString())) {
                ResourceAttribute dgAttr = CRSFactoryImpl.getInstance().create(ResourceType.DiskGroup.NAME.name(), resName);
                if (dgSet != null && !dgSet.contains(resName)) {
                    Trace.out((Object)"Error! The diskgroup %s used in the dependencies does not exist", (String)resName);
                    dgRmAttrs.add(dgAttr);
                    continue;
                }
                Trace.out((String)("disk group name = " + resName));
                dgAttrs.add(dgAttr);
                continue;
            }
            Trace.out((String)("Ignore none diskgroup resource " + resName));
        }
        ResourceAttribute asmAttr = CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.NAME.name(), ClusterASMImpl.getResourceName());
        Trace.out((String)("Updating database " + db.getName()));
        if (toFlex) {
            Trace.out((String)"Standard ASM to Flex ASM conversion update");
            for (ResourceAttribute dgAttr : dgAttrs) {
                ResourceDependency.updateDependencyAttrModifier((boolean)true, (ResourceAttribute)startDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
                ResourceDependency.updateDependencyAttrModifier((boolean)true, (ResourceAttribute)startDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            }
            for (ResourceAttribute dgAttr : dgRmAttrs) {
                ResourceDependency.updateDependencyAttr((ResourceAttribute)startDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (boolean)false);
                ResourceDependency.updateDependency((ResourceAttribute)startDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_DEP, (boolean)false);
            }
        } else {
            Trace.out((String)"Flex ASM to Standard ASM conversion update");
            for (ResourceAttribute dgAttr : dgAttrs) {
                ResourceDependency.updateDependencyAttrModifier((boolean)false, (ResourceAttribute)startDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
                ResourceDependency.updateDependencyAttrModifier((boolean)false, (ResourceAttribute)startDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            }
            for (ResourceAttribute dgAttr : dgRmAttrs) {
                ResourceDependency.updateDependencyAttr((ResourceAttribute)startDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (boolean)false);
                ResourceDependency.updateDependencyAttr((ResourceAttribute)startDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_DEP, (boolean)false);
            }
            ResourceDependency.updateDependencyAttrModifier((boolean)false, (ResourceAttribute)startDep, (ResourceAttribute)asmAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
        }
        Trace.out((String)(startDep.getName() + "=" + startDep.getValue()));
        if (toFlex) {
            ResourceDependency.updateDependencyAttrModifier((boolean)true, (ResourceAttribute)stopDep, (ResourceAttribute)asmAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            for (ResourceAttribute dgAttr : dgAttrs) {
                ResourceDependency.updateDependencyAttrModifier((boolean)true, (ResourceAttribute)stopDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            }
            for (ResourceAttribute dgAttr : dgRmAttrs) {
                ResourceDependency.updateDependencyAttr((ResourceAttribute)stopDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (boolean)false);
            }
        } else {
            for (ResourceAttribute dgAttr : dgAttrs) {
                ResourceDependency.updateDependencyAttrModifier((boolean)false, (ResourceAttribute)stopDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            }
            for (ResourceAttribute dgAttr : dgRmAttrs) {
                ResourceDependency.updateDependencyAttr((ResourceAttribute)stopDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (boolean)false);
            }
            Trace.out((String)("Remove pullup for ASM dependencies to remove global modifier: " + stopDep.getName() + "=" + stopDep.getValue()));
            ResourceDependency.updateDependencyAttrModifier((boolean)false, (ResourceAttribute)stopDep, (ResourceAttribute)asmAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
        }
        Trace.out((String)(stopDep.getName() + "=" + stopDep.getValue()));
        attrList.add(startDep);
        attrList.add(stopDep);
        dbRes.update(attrList);
    }

    private void updateMgmtDBDepASM(boolean toFlex) throws NotExistsException, CRSException, AlreadyExistsException, SoftwareModuleException, ASMException, DatabaseException {
        try {
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            DatabaseFactory daf = DatabaseFactory.getInstance();
            MgmtDatabase mdb = daf.getMgmtDatabase();
            List dList = mdb.diskGroups();
            CRSResourceImpl dbRes = (CRSResourceImpl)mdb.crsResource();
            ResourceAttribute startDep = dbRes.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            ResourceAttribute stopDep = dbRes.getAttribute(ResourceType.LocalResource.STOP_DEPENDENCIES.name());
            ResourceAttribute asmAttr = CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.NAME.name(), ClusterASMImpl.getResourceName());
            ResourceAttribute dgAttr = null;
            for (DiskGroup dg : dList) {
                dgAttr = CRSFactoryImpl.getInstance().create(ResourceType.DiskGroup.NAME.name(), dg.crsResource().getName());
                if (toFlex) {
                    ResourceDependency.updateDependencyAttrModifier((boolean)true, (ResourceAttribute)startDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
                    ResourceDependency.updateDependencyAttrModifier((boolean)true, (ResourceAttribute)startDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
                    ResourceDependency.updateDependencyAttrModifier((boolean)true, (ResourceAttribute)stopDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
                    ResourceDependency.updateDependencyAttrModifier((boolean)true, (ResourceAttribute)stopDep, (ResourceAttribute)asmAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
                    continue;
                }
                ResourceDependency.updateDependencyAttrModifier((boolean)false, (ResourceAttribute)startDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
                ResourceDependency.updateDependencyAttrModifier((boolean)false, (ResourceAttribute)startDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
                ResourceDependency.updateDependencyAttrModifier((boolean)false, (ResourceAttribute)stopDep, (ResourceAttribute)dgAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
                ResourceDependency.updateDependencyAttrModifier((boolean)false, (ResourceAttribute)stopDep, (ResourceAttribute)asmAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            }
            Trace.out((String)(startDep.getName() + "=" + startDep.getValue()));
            Trace.out((String)(stopDep.getName() + "=" + stopDep.getValue()));
            attrList.add(startDep);
            attrList.add(stopDep);
            dbRes.update(attrList);
        }
        catch (NotExistsException nee) {
            Trace.out((String)"No MgmtDB was found");
        }
    }

    public void recreateASM(Version.VersionEnum sourceVersion, Version.VersionEnum destVersion) throws ASMException {
        block22: {
            ASMImpl asmi;
            boolean isCluster = Cluster.isCluster();
            String spfile = null;
            String diskstring = null;
            String pwfile = "";
            Trace.out((String)("Calling recreateASM for source version " + sourceVersion.toString() + " dest version " + destVersion.toString()));
            try {
                asmi = (ASMImpl)this.getASM();
                if (!isCluster) {
                    spfile = asmi.getSPFile();
                    diskstring = asmi.getDiskString();
                } else if (asmi.getPresence() != ASMPresence.NONE) {
                    pwfile = asmi.getPWFile();
                }
                asmi.remove(true);
            }
            catch (NotExistsException nee) {
                Trace.out((String)"ASM did not exist.");
            }
            catch (AlreadyRunningException are) {
                Trace.out((String)"ASM is running...");
                throw new ASMException(are);
            }
            try {
                if (isCluster) {
                    if (destVersion.compareTo((Enum)Version.VersionEnum.V12200) < 0) {
                        this.createASM(new Version());
                    } else {
                        Trace.out((String)"Create flex asm in reCreateASM");
                        ASMFactoryImpl.setUpgradePhase(UpgradePhase.FIRST);
                        int asmCount = -1;
                        if (Version.isPre12c((Version)sourceVersion.toVersion())) {
                            ClusterUtil clusterUtil = new ClusterUtil();
                            String[] nodes = clusterUtil.getNodeNames();
                            asmCount = nodes.length;
                            Trace.out((String)("The cluster has " + asmCount + " nodes."));
                            if (asmCount == 1) {
                                asmCount = 2;
                            }
                        }
                        this.createClusterASM(pwfile, asmCount, new Version());
                    }
                } else {
                    this.createASM(spfile, diskstring, new Version());
                }
            }
            catch (AlreadyExistsException aee) {
                Trace.out((String)"AlreadyExistsException encountered. Should not happpen.");
                throw new ASMException(aee);
            }
            catch (ClusterUtilException cue) {
                Trace.out((String)"ClusterUtilException encountered.");
                throw new ASMException(cue);
            }
            try {
                if (destVersion.compareTo((Enum)Version.VersionEnum.V12200) >= 0) break block22;
                asmi = (ASMImpl)this.getASM();
                List<DiskGroup> dgList = null;
                try {
                    dgList = this.getDiskGroups();
                    if (dgList != null && dgList.size() > 0) {
                        asmi.start();
                    }
                }
                catch (NotExistsException nee) {
                    Trace.out((String)"Diskgroup does not exist. Do not call asmi.start().");
                }
            }
            catch (AlreadyRunningException are) {
                Trace.out((String)"ASM is already running. Not a problem.");
            }
            catch (NotExistsException nee) {
                Trace.out((String)"ASM did not exist, when it should.");
                throw new ASMException(nee);
            }
            catch (SoftwareModuleException sme) {
                Trace.out((String)"SoftwareModuleException encountered...");
                throw new ASMException(sme);
            }
        }
    }

    public void setOHASDDependencies(int asmmode) throws ASMException {
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            if (!system.isOCRLibraryLoaded()) {
                Trace.out((String)"Going to load the ocr library");
                system.loadOCRNativeLibrary();
                Trace.out((String)"loaded ocr libraries");
            }
        }
        catch (NativeException ne) {
            Trace.out((Exception)((Object)ne));
            throw new ASMException((MessageKey)PrCcMsgID.SET_OHASD_DEP_FAILED, ne, new Object[0]);
        }
        OCRResult result = new OCRResult();
        OCRNative.setOHASDDependencies((int)asmmode, (OCRResult)result);
        if (!result.getStatus()) {
            Trace.out((String)("Native result string: " + result.getNativeResultString()));
            throw new ASMException((MessageKey)PrCcMsgID.SET_OHASD_DEP_FAILED, new Throwable(result.getNativeResultString()), new Object[0]);
        }
    }

    public boolean isSupportedFSType(FSEnums.FSTypeEnum fstype) {
        FSEnums.PlatformEnum platform;
        Trace.out((String)("Start platform support for FS type " + fstype.getValue()));
        try {
            Trace.out((String)("Platform name: " + DeterminePlatform.getOSName()));
            platform = !DeterminePlatform.getOSGroup().equalsIgnoreCase(FSEnums.PlatformEnum.WINDOWS.getValue()) ? FSEnums.PlatformEnum.getMember(DeterminePlatform.getOSName()) : FSEnums.PlatformEnum.WINDOWS;
        }
        catch (EnumConstantNotPresentException e) {
            Trace.out((String)"Platform name not found, defaulting to Linux.");
            platform = FSEnums.PlatformEnum.LINUX;
        }
        return platform.supportedFSType().contains((Object)fstype);
    }

    static String getInternalMountPoint(String mountPointPath) {
        boolean isWindows;
        mountPointPath = mountPointPath.trim();
        boolean bl = isWindows = !new SystemFactory().CreateSystem().isUnixSystem();
        if (mountPointPath.endsWith(File.separator)) {
            mountPointPath = mountPointPath.substring(0, mountPointPath.length() - 1);
        }
        if (isWindows) {
            mountPointPath = mountPointPath.toLowerCase();
        }
        Trace.out((String)("internal mountpoint = " + mountPointPath));
        return mountPointPath;
    }

    private String canonicalizeDevicePath(String volumeDevice) throws AsmClusterFileSystemException {
        try {
            boolean isWindows = !new SystemFactory().CreateSystem().isUnixSystem();
            String canVolDevice = null;
            if (!isWindows) {
                File file = new File(volumeDevice);
                canVolDevice = file.getCanonicalPath();
                Trace.out((String)("File canonicalized path: " + canVolDevice));
            } else {
                Trace.out((String)"Windows platform, do not canonicalize file path");
                canVolDevice = volumeDevice;
            }
            canVolDevice = new ADVMUtil(m_crsHome).getCanonicalVolume(canVolDevice);
            Trace.out((String)("ADVM canonicalized path: " + canVolDevice));
            return canVolDevice;
        }
        catch (IOException io) {
            Trace.out((String)("Canonicalize volume device path failed: " + io.getMessage()));
            throw new AsmClusterFileSystemException(io);
        }
        catch (CmdToolUtilException ctue) {
            Trace.out((String)("Canonicalize volume device path failed: " + ctue.getMessage()));
            throw new AsmClusterFileSystemException(ctue);
        }
    }

    public String generateODAFSResourceName(String device, boolean acfs) throws AsmClusterFileSystemException {
        if (device == null || device.trim().length() == 0) {
            throw new AsmClusterFileSystemException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "device");
        }
        Trace.out((String)"Generating resource name for Client Cluster FS");
        boolean isWindows = !new SystemFactory().CreateSystem().isUnixSystem();
        String[] splitStr = null;
        String volDeviceStr = null;
        if (isWindows) {
            volDeviceStr = this.canonicalizeDevicePath(device);
        } else {
            if (!Pattern.matches(DEVICE_REGEX, device)) {
                throw new AsmClusterFileSystemException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "device");
            }
            splitStr = device.split(ResourceLiterals.PATHSEP.toString());
            Trace.out((String)("Device split " + splitStr.length));
            volDeviceStr = splitStr[3];
        }
        splitStr = volDeviceStr.split(String.valueOf('-'));
        Trace.out((String)("Device split " + splitStr.length));
        String diskID = splitStr[1];
        String volumeName = splitStr[0];
        String fstype = acfs ? ResourceLiterals.ACFS.toString() : ResourceLiterals.FS.toString();
        return "ora." + diskID + '.' + volumeName.toLowerCase() + '.' + fstype;
    }

    public String generateFSResourceName(String diskgroup, String volumeName, boolean acfs) throws AsmClusterFileSystemException {
        if (diskgroup == null || diskgroup.trim().length() == 0) {
            throw new AsmClusterFileSystemException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "diskgroup");
        }
        if (volumeName == null || volumeName.trim().length() == 0) {
            throw new AsmClusterFileSystemException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "volumeName");
        }
        String fstype = acfs ? ResourceLiterals.ACFS.toString() : ResourceLiterals.FS.toString();
        return "ora." + diskgroup.toLowerCase() + '.' + volumeName.toLowerCase() + '.' + fstype;
    }

    public int getDefaultCardinality() throws ASMException {
        int siteNum = 0;
        if (!Cluster.isCluster()) {
            return 0;
        }
        int count = 3;
        try {
            ServerFactory sf = ServerFactory.getInstance();
            if (sf.isExtendedCluster()) {
                ClusterUtil clusterUtil = new ClusterUtil();
                String[] nodeNames = clusterUtil.getNodeNames();
                ArrayList<Node> nodeList = new ArrayList<Node>(nodeNames.length);
                for (String nodeName : nodeNames) {
                    Node node = sf.getNode(nodeName);
                    nodeList.add(node);
                }
                List sites = sf.getSitesForNodes(nodeList);
                if (sites != null) {
                    siteNum = sites.size();
                    Trace.out((String)("Got site number " + siteNum));
                }
                if (siteNum > 1) {
                    count = siteNum * 2;
                }
            }
            Trace.out((String)("ASM count is " + count));
        }
        catch (SiteException e) {
            throw new ASMException(e);
        }
        catch (ServerException e) {
            throw new ASMException(e);
        }
        catch (ClusterUtilException e) {
            throw new ASMException(e);
        }
        catch (NodeException e) {
            throw new ASMException(e);
        }
        return count;
    }

    private void assertDBAASVolDevice(String volDevice) throws AsmClusterFileSystemException {
        File devicePath = new File(volDevice);
        if (!devicePath.exists()) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.VOLDEVICE_NOT_EXIST, volDevice);
        }
    }

    private AsmBaseFileSystem getDBAASFS(String volDevice) throws NotExistsException, AsmClusterFileSystemException {
        try {
            String resourceName = this.generateODAFSResourceName(volDevice, true);
            ResourceAttribute nameAttr = CRSFactoryImpl.getInstance().create(ResourceType.DBAASFSCluster.NAME.name(), resourceName);
            CRSFactoryImpl.getInstance().get(nameAttr);
            AsmClusterFileSystemImpl fsImpl = new AsmClusterFileSystemImpl(nameAttr);
            return fsImpl;
        }
        catch (CRSException cre) {
            throw new AsmClusterFileSystemException(cre);
        }
    }

    private List<AsmBaseFileSystem> getDBAASFSList() throws AsmClusterFileSystemException, NotExistsException {
        List resList;
        ArrayList<AsmBaseFileSystem> fileSystemList = new ArrayList<AsmBaseFileSystem>(0);
        String appId_res_suffix = '_' + ResourceLiterals.FS.toString() + '.' + ResourceLiterals.TYPE.toString();
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter filter_eqDbaasfstype = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE_ATTR.toString(), ResourceLiterals.DBAASFS_TYPE.toString());
            Filter filter_eqCDbaasfstype = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE_ATTR.toString(), ResourceLiterals.DBAASFS_CLUSTER_TYPE.toString());
            Filter filter_ewAppidtype = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.TYPE_ATTR.toString(), appId_res_suffix);
            Filter fsFilter = crsFactory.getFilter(Filter.Operator.OR, filter_eqDbaasfstype, filter_eqCDbaasfstype);
            Filter finalFilter = crsFactory.getFilter(Filter.Operator.OR, fsFilter, filter_ewAppidtype);
            Trace.out((String)"Find file system resources");
            resList = crsFactory.searchResources(CRSEntity.Type.Resource, finalFilter);
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException(crse);
        }
        if (resList != null && resList.size() > 0) {
            fileSystemList = new ArrayList(resList.size());
            for (ResourceAttribute currNameAttr : resList) {
                String currNameAttrValue = currNameAttr.getValue();
                if (currNameAttrValue == null) continue;
                currNameAttrValue = currNameAttrValue.trim();
                Trace.out((String)("Found a filesystem resource -- Resource name: " + currNameAttrValue));
                if (currNameAttrValue.toLowerCase().endsWith(ResourceLiterals.ACFS.toString())) {
                    fileSystemList.add(new AsmClusterFileSystemImpl(currNameAttr));
                    continue;
                }
                fileSystemList.add(new FileSystemImpl(currNameAttr));
            }
        }
        if (fileSystemList.size() == 0) {
            throw new NotExistsException((MessageKey)PrCaMsgID.FILESYSTEM_RES_NOT_FOUND, new Object[0]);
        }
        return fileSystemList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getVolDgDevice(FileSystemOptionalArgs fOpt) throws NotExistsException, AsmClusterFileSystemException {
        String volName = fOpt.getVolumeName();
        String dgName = fOpt.getDiskGroupName();
        if (fOpt.getVolumeDevicePath() != null) {
            Trace.out((String)("Canonicalize volume device " + fOpt.getVolumeDevicePath()));
            fOpt.setVolumeDevicePath(this.canonicalizeDevicePath(fOpt.getVolumeDevicePath()));
            Trace.out((String)"Device specified, resolve diskgroup and volume name");
            try {
                Volume vol = this.getVolume(fOpt.getVolumeDevicePath());
                if (volName == null) {
                    fOpt.setVolumeName(vol.getVolumeName());
                } else if (!volName.equalsIgnoreCase(vol.getVolumeName())) {
                    throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.INVALID_VOLUME, volName, fOpt.getVolumeDevicePath());
                }
                if (dgName == null) {
                    fOpt.setDiskGroupName(vol.getDiskGroup());
                    return;
                }
                if (dgName.equalsIgnoreCase(vol.getDiskGroup())) return;
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.INVALID_DISKGROUP, dgName, fOpt.getVolumeDevicePath());
            }
            catch (VolumeException ve) {
                throw new AsmClusterFileSystemException((Throwable)((Object)ve));
            }
        } else {
            Trace.out((String)"Volume and diskgroup name specified, resolve device path");
            fOpt.setVolumeDevicePath(this.resolveDevicePath(dgName, volName));
        }
    }

    private String resolveDevicePath(String dgName, String volName) throws NotExistsException, AsmClusterFileSystemException {
        try {
            Utils.assertInput((String)dgName, (String)"disk group name");
            Utils.assertInput((String)volName, (String)"volume name");
        }
        catch (InvalidArgsException iae) {
            throw new AsmClusterFileSystemException(iae);
        }
        try {
            Volume vol = this.getVolume(volName, dgName);
            return vol.getCanonicalVolumeDevice();
        }
        catch (VolumeException ve) {
            throw new AsmClusterFileSystemException((Throwable)((Object)ve));
        }
    }

    private void assertAuxiliaryVolumes(String primaryVolDevice, String[] auxiliaryVolDevices) throws AsmClusterFileSystemException {
        try {
            if (!DeterminePlatform.getOSName().equals("Linux")) {
                Trace.out((String)"Unsupported OS platform for auxiliary volumes");
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.UNSUPPORTED_PLATFORM_AUXVOLS, new Object[0]);
            }
            String canAVol = "";
            OFSUtil ofs = new OFSUtil(new Util().getCRSHome());
            HashMap<String, List<String>> volumes = new HashMap<String, List<String>>();
            List formattedAuxVolumes = ofs.getAuxiliaryVolumes(primaryVolDevice);
            try {
                List<AsmBaseFileSystem> fsList = this.getFileSystems();
                volumes = new HashMap();
                boolean isACFS = false;
                for (AsmBaseFileSystem fs : fsList) {
                    isACFS = fs instanceof AsmClusterFileSystem;
                    if (isACFS) {
                        volumes.put(fs.getCanonicalVolumeDevice(), Arrays.asList(fs.getAuxVolumes()));
                        continue;
                    }
                    volumes.put(fs.getCanonicalVolumeDevice(), new ArrayList());
                }
            }
            catch (NotExistsException nee) {
                Trace.out((String)"No FS resources");
            }
            for (String auxiliaryVolDevice : auxiliaryVolDevices) {
                canAVol = this.canonicalizeDevicePath(auxiliaryVolDevice);
                if (primaryVolDevice.equalsIgnoreCase(canAVol)) {
                    Trace.out((String)"Primary volume device found in auxiliary volume list");
                    throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.PRIMARY_VOLUME_IN_AUX_LIST, canAVol);
                }
                if (ofs.isAuxiliaryVolume(canAVol)) {
                    if (!formattedAuxVolumes.contains(canAVol)) {
                        throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.AUXILIARY_VOLUME_NOT_FORMATTED, canAVol, primaryVolDevice);
                    }
                } else {
                    if (!volumes.isEmpty() && volumes.containsKey(canAVol)) {
                        Trace.out((String)("Volume device " + canAVol + " is in use as a primary volume device"));
                        throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.AUXILIARY_VOLUME_IS_PRIMARY, canAVol);
                    }
                    Trace.out((String)("Volume device " + canAVol + " is not formatted as auxiliary volume yet"));
                    throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.AUXILIARY_VOLUME_NOT_FORMATTED, canAVol, primaryVolDevice);
                }
                Trace.out((String)("Device " + canAVol + " is a valid auxiliary volume"));
            }
        }
        catch (UtilException ue) {
            throw new AsmClusterFileSystemException(ue);
        }
        catch (CmdToolUtilException cue) {
            throw new AsmClusterFileSystemException(cue);
        }
    }

    static {
        m_asmmode = null;
        m_upgradePhase = UpgradePhase.NONE;
        DEVICE_REGEX = "" + ResourceLiterals.PATHSEP.toString() + "dev" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ASM.toString() + ResourceLiterals.PATHSEP.toString() + "[a-z0-9]+\\-[0-9]+";
    }
}

