/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.asm.AsmClusterFileSystemException;
import oracle.cluster.asm.AuxiliaryADVMInfo;
import oracle.cluster.asm.PrimaryADVMInfo;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OFSUtil;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.deployment.ACFSInfo;
import oracle.cluster.impl.asm.AuxiliaryADVMInfoImpl;
import oracle.cluster.impl.asm.PrimaryADVMInfoImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.InstallException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ACFSInfoImpl
implements oracle.cluster.asm.ACFSInfo {
    private PrimaryADVMInfo m_primaryVolume;
    private List<AuxiliaryADVMInfo> m_auxVolumes;
    private ACFSInfo m_acfsInfo;

    public ACFSInfoImpl(String mountpoint, String node) throws AsmClusterFileSystemException {
        try {
            Utils.assertInput((String)mountpoint, (String)"mount point");
            String crsHome = new Util().getCRSHome();
            OFSUtil ofs = new OFSUtil(crsHome);
            if (node == null) {
                this.m_acfsInfo = ofs.getACFSInformation(mountpoint);
            } else {
                Utils.assertInput((String)node, (String)"node name");
                this.m_acfsInfo = ofs.getACFSInformation(mountpoint, node);
            }
            this.m_primaryVolume = new PrimaryADVMInfoImpl(this.m_acfsInfo.getPrimaryVolume());
            this.m_auxVolumes = new ArrayList<AuxiliaryADVMInfo>();
            for (ACFSInfo.ADVMInfo vol : this.m_acfsInfo.getAuxiliaryVolumes()) {
                this.m_auxVolumes.add(new AuxiliaryADVMInfoImpl(vol));
            }
        }
        catch (InvalidArgsException iae) {
            throw new AsmClusterFileSystemException(iae);
        }
        catch (UtilException ue) {
            throw new AsmClusterFileSystemException(ue);
        }
        catch (InstallException ie) {
            throw new AsmClusterFileSystemException(ie);
        }
        catch (CmdToolUtilException cme) {
            throw new AsmClusterFileSystemException(cme);
        }
    }

    public ACFSInfoImpl(String mountpoint) throws AsmClusterFileSystemException {
        this(mountpoint, null);
    }

    @Override
    public String getACFSVersion() {
        return this.m_acfsInfo.getACFSVersion();
    }

    @Override
    public String getOnDiskVersion() {
        return this.m_acfsInfo.getOnDiskVersion();
    }

    @Override
    public String getCompatibleADVM() {
        return this.m_acfsInfo.getCompatibleADVM();
    }

    @Override
    public String getFlags() {
        return this.m_acfsInfo.getFlags();
    }

    @Override
    public String getMountTime() {
        return this.m_acfsInfo.getMountTime();
    }

    @Override
    public long getAllocationUnit() {
        return this.m_acfsInfo.getAllocationUnit();
    }

    @Override
    public int getMetadataBlockSize() {
        return this.m_acfsInfo.getMetadataBlockSize();
    }

    @Override
    public int getVolumeCount() {
        return this.m_acfsInfo.getVolumeCount();
    }

    @Override
    public long getTotalSize() {
        return this.m_acfsInfo.getTotalSize();
    }

    @Override
    public long getTotalFreeSpace() {
        return this.m_acfsInfo.getTotalFreeSpace();
    }

    @Override
    public long getFileEntryTableAllocation() {
        return this.m_acfsInfo.getFileEntryTableAllocation();
    }

    @Override
    public int getSnapshotsCount() {
        return this.m_acfsInfo.getSnapshotsCount();
    }

    @Override
    public long getSnapshotsSpaceUsage() {
        return this.m_acfsInfo.getSnapshotsSpaceUsage();
    }

    @Override
    public String getReplicationStatus() {
        return this.m_acfsInfo.getReplicationStatus();
    }

    @Override
    public String getCompressionStatus() {
        return this.m_acfsInfo.getCompressionStatus();
    }

    @Override
    public String getPrimaryVolumeDevice() {
        return this.m_primaryVolume.getVolumeDevice();
    }

    @Override
    public String getVolumeLabel() throws AsmClusterFileSystemException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume.getLabel();
    }

    @Override
    public String getVolumeState() throws AsmClusterFileSystemException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume.getState().toString();
    }

    @Override
    public long getVolumeMajor() throws AsmClusterFileSystemException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume.getMajor();
    }

    @Override
    public long getVolumeMinor() throws AsmClusterFileSystemException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume.getMinor();
    }

    @Override
    public int getVolumeLogicalSectorSize() throws AsmClusterFileSystemException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume.getLogicalSectorSize();
    }

    @Override
    public long getVolumeSize() throws AsmClusterFileSystemException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume.getSize();
    }

    @Override
    public long getVolumeFreeSpace() throws AsmClusterFileSystemException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume.getFreeSpace();
    }

    @Override
    public String getVolumeDiskgroup() throws AsmClusterFileSystemException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume.getDiskgroup();
    }

    @Override
    public long getVolumeResizeIncrement() throws AsmClusterFileSystemException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume.getResizeIncrement();
    }

    @Override
    public int getVolumeStripeColumns() throws AsmClusterFileSystemException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume.getStripeColumns();
    }

    @Override
    public String getVolumeRedundancy() throws AsmClusterFileSystemException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume.getRedundancy();
    }

    @Override
    public long getVolumeStripeWidth() throws AsmClusterFileSystemException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume.getStripeWidth();
    }

    @Override
    public PrimaryADVMInfo getPrimaryVolume() throws AsmClusterFileSystemException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume;
    }

    @Override
    public List<AuxiliaryADVMInfo> getAuxiliaryVolumes() throws AsmClusterFileSystemException {
        if (this.m_auxVolumes == null) {
            Trace.out((String)"Invalid auxiliary volumes value");
            throw new AsmClusterFileSystemException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "acfsinfo-NAV");
        }
        return this.m_auxVolumes;
    }

    @Override
    public boolean isNodeLocal() {
        return this.m_acfsInfo.isNodeLocal();
    }

    private void assertPrimaryVolume() throws AsmClusterFileSystemException {
        if (this.m_primaryVolume == null) {
            Trace.out((String)"No primary volume is configured for this file system");
            throw new AsmClusterFileSystemException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "acfsinfo-NPV");
        }
    }
}

