/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.asm;

import oracle.cluster.asm.AsmClusterFileSystemException;
import oracle.cluster.asm.FSEnums;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCcMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public class FileSystemOptionalArgs {
    private String m_volDevicePath = null;
    private String m_volName = null;
    private String m_dgName = null;
    private String m_mountPointPath = null;
    private String m_mountOwner = null;
    private String[] m_users = null;
    private String[] m_nodeNames = null;
    private String[] m_serverPools = null;
    private FSEnums.FSTypeEnum m_fsType = null;
    private String m_fsOptions = null;
    private String m_description = null;
    private String m_applicationID = null;
    private FSEnums.AutostartEnum m_autostart = null;
    private boolean m_forceFlag = false;
    private String m_nfsName = null;
    private String m_exportServer = null;
    private String m_exportPath = null;
    private String[] m_auxvolumes = null;
    private boolean m_ghCreated = false;
    private boolean m_isClientCluster = false;

    public void setVolumeDevicePath(String volDevicePath) throws AsmClusterFileSystemException {
        this.validateAgainstNull(volDevicePath, "volDevicePath");
        this.m_volDevicePath = volDevicePath.trim();
    }

    public void setVolumeName(String volName) throws AsmClusterFileSystemException {
        this.validateAgainstNull(volName, "volName");
        this.m_volName = volName.trim();
        this.assertDBAASOptions();
    }

    public void setNFSName(String name) throws AsmClusterFileSystemException {
        this.validateAgainstNull(name, "nfsName");
        this.m_nfsName = name.trim();
    }

    public void setExportServerName(String exptSrvName) throws AsmClusterFileSystemException {
        this.validateAgainstNull(exptSrvName, "exportserver");
        this.m_exportServer = exptSrvName.trim();
    }

    public void setExportPath(String exptPath) throws AsmClusterFileSystemException {
        this.validateAgainstNull(exptPath, "exportpath");
        this.m_exportPath = exptPath;
    }

    public void setDiskGroupName(String dgName) throws AsmClusterFileSystemException {
        this.validateAgainstNull(dgName, "dgName");
        this.m_dgName = dgName.trim();
        this.assertDBAASOptions();
    }

    public void setMountPointPath(String mountPointPath) throws AsmClusterFileSystemException {
        this.validateAgainstNull(mountPointPath, "mountPointPath");
        this.m_mountPointPath = mountPointPath;
    }

    public void setUser(String user) throws AsmClusterFileSystemException {
        this.validateAgainstNull(user, "user");
        this.m_users = new String[]{user};
    }

    public void setUsers(String[] user) throws AsmClusterFileSystemException {
        this.validateAgainstNull(user, "mount users");
        this.m_users = user;
    }

    public void setMountOwner(String user) throws AsmClusterFileSystemException {
        this.validateAgainstNull(user, "mount owner");
        this.m_mountOwner = user;
    }

    public void setNodeNames(String[] nodeNames) throws AsmClusterFileSystemException {
        this.validateAgainstNull(nodeNames, "nodeNames");
        for (int i = 0; i < nodeNames.length; ++i) {
            nodeNames[i] = Utils.convertToCSSNodeName((String)nodeNames[i]);
        }
        this.m_nodeNames = nodeNames;
    }

    public void setServerPools(String[] serverPools) throws AsmClusterFileSystemException {
        this.validateAgainstNull(serverPools, "serverPools");
        this.m_serverPools = serverPools;
    }

    public void setFSType(FSEnums.FSTypeEnum fsType) throws AsmClusterFileSystemException {
        this.validateAgainstNull((Object)fsType, "fsType");
        this.m_fsType = fsType;
        this.assertDBAASOptions();
    }

    public void setFSOptions(String fsOptions) throws AsmClusterFileSystemException {
        this.validateAgainstNull(fsOptions, "fsOptions");
        this.m_fsOptions = fsOptions;
    }

    public void setDescription(String description) throws AsmClusterFileSystemException {
        this.validateAgainstNull(description, "description");
        this.m_description = description.trim();
    }

    public void setApplicationID(String applicationID) throws AsmClusterFileSystemException {
        this.validateAgainstNull(applicationID, "applicationID");
        this.m_applicationID = applicationID.trim();
    }

    public void setAutostart(FSEnums.AutostartEnum autostart) throws AsmClusterFileSystemException {
        this.validateAgainstNull((Object)autostart, "autostart");
        this.m_autostart = autostart;
    }

    public void setAuxVolumes(String[] auxvolumes) throws AsmClusterFileSystemException {
        this.validateAgainstNull(auxvolumes, "auxvolumes");
        this.m_auxvolumes = auxvolumes;
    }

    public void setForceFlag(boolean forceFlag) {
        this.m_forceFlag = forceFlag;
    }

    public void setGHCreated(boolean ghCreated) {
        this.m_ghCreated = ghCreated;
    }

    public void setIsClientCluster(boolean isClientCluster) throws AsmClusterFileSystemException {
        this.m_isClientCluster = isClientCluster;
        this.assertDBAASOptions();
    }

    public boolean getForceFlag() {
        return this.m_forceFlag;
    }

    public String getVolumeDevicePath() {
        return this.m_volDevicePath;
    }

    public String getNFSName() {
        return this.m_nfsName;
    }

    public String getExportServer() {
        return this.m_exportServer;
    }

    public String getExportPath() {
        return this.m_exportPath;
    }

    public String getVolumeName() {
        return this.m_volName;
    }

    public String getDiskGroupName() {
        return this.m_dgName;
    }

    public String getMountPointPath() {
        return this.m_mountPointPath;
    }

    public String getUser() {
        if (this.m_users != null && this.m_users.length > 0) {
            return this.m_users[0];
        }
        return null;
    }

    public String[] getUsers() {
        return this.m_users;
    }

    public String getMountOwner() {
        return this.m_mountOwner;
    }

    public String[] getNodeNames() {
        return this.m_nodeNames;
    }

    public String[] getServerPools() {
        return this.m_serverPools;
    }

    public FSEnums.FSTypeEnum getFSType() {
        return this.m_fsType;
    }

    public String getFSOptions() {
        return this.m_fsOptions;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getApplicationID() {
        return this.m_applicationID;
    }

    public FSEnums.AutostartEnum getAutostart() {
        return this.m_autostart;
    }

    public String[] getAuxVolumes() {
        return this.m_auxvolumes;
    }

    public boolean getGHCreated() {
        return this.m_ghCreated;
    }

    public boolean isClientCluster() {
        return this.m_isClientCluster;
    }

    private void validateAgainstNullAndEmptyString(String strToValidate, String paramName) throws AsmClusterFileSystemException {
        if (strToValidate == null || strToValidate.trim().length() == 0) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, paramName);
        }
    }

    private void validateAgainstNull(Object objToValidate, String paramName) throws AsmClusterFileSystemException {
        if (objToValidate == null) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, paramName);
        }
    }

    private void assertDBAASOptions() throws AsmClusterFileSystemException {
        if (this.m_isClientCluster) {
            if (this.m_volName != null) {
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.VOLNAME_UNSUPPORTED_DOMU, new Object[0]);
            }
            if (this.m_dgName != null) {
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.DGNAME_UNSUPPORTED_DOMU, new Object[0]);
            }
            if (this.m_fsType != FSEnums.FSTypeEnum.ACFS) {
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.NONACFS_UNSUPPORTED_DOMU, new Object[0]);
            }
        }
    }
}

