/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.asm;

import java.util.List;
import oracle.cluster.asm.AsmClusterFileSystemException;
import oracle.cluster.asm.FileSystemOptionalArgs;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Version;

public interface AsmBaseFileSystem
extends SoftwareModule {
    public String getDiskGroup();

    public String getVolumeDevice() throws AsmClusterFileSystemException;

    public String getCanonicalVolumeDevice() throws AsmClusterFileSystemException;

    public String getVolumeName();

    public String getMountPoint() throws AsmClusterFileSystemException;

    public String getFSOptions() throws AsmClusterFileSystemException;

    public String getFSDescription() throws AsmClusterFileSystemException;

    public String getNodeNames() throws AsmClusterFileSystemException;

    public String getServerPools() throws AsmClusterFileSystemException;

    public String getApplicationID() throws AsmClusterFileSystemException;

    public String[] getAuxVolumes() throws AsmClusterFileSystemException;

    public boolean isGHCreated() throws AsmClusterFileSystemException;

    public CRSResource crsResource() throws NotExistsException, AsmClusterFileSystemException;

    public boolean isLocalResource() throws AsmClusterFileSystemException;

    public String[] getUsers() throws AsmClusterFileSystemException;

    public List<String> getMountUsers() throws AsmClusterFileSystemException;

    public String getMountOwner() throws AsmClusterFileSystemException;

    public void setUser(String var1) throws AsmClusterFileSystemException;

    public void setMountOwner(String var1) throws AsmClusterFileSystemException, NotExistsException;

    public void setUser(String[] var1) throws AsmClusterFileSystemException;

    public void addUser(String var1) throws AlreadyExistsException, AsmClusterFileSystemException;

    public void removeUser(String var1) throws NotExistsException, AsmClusterFileSystemException;

    public void setCategory(ServerCategory var1) throws AsmClusterFileSystemException;

    public void modifyClusterResource(FileSystemOptionalArgs var1) throws AsmClusterFileSystemException;

    public void createClusterResource(FileSystemOptionalArgs var1, Version var2) throws AlreadyExistsException, AsmClusterFileSystemException;

    public void start(List<Node> var1) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException;

    public void stop(List<Node> var1, boolean var2) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException;

    public void remove(boolean var1) throws AlreadyRunningException, AsmClusterFileSystemException;

    public void relocate(boolean var1) throws NotRunningException, RelocateException, AsmClusterFileSystemException;

    public void relocateTo(Node var1, boolean var2) throws NotRunningException, RelocateException, AsmClusterFileSystemException;

    public static enum FileSystemResourceType {
        ACFS_LOCAL_RES,
        ACFS_CLUSTER_RES,
        NON_ACFS_CLUSTER_RES;

    }
}

