/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.asm;

import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.ops.mgmt.nls.MessageKey;

public enum ASMMode {
    LEGACY("legacy"),
    REMOTE("remote"),
    CLIENT("client"),
    NONE("none");

    public static final int LEGACY_CLUSTER_TYPE_NUM = 1;
    public static final int NEAR_CLUSTER_TYPE_NUM = 2;
    public static final int CLIENT_CLUSTER_TYPE_NUM = 3;
    private String m_asmMode;
    private int m_asmModeNum;

    private ASMMode(String asmMode) {
        this.m_asmMode = asmMode;
        if (this.m_asmMode.equals("legacy")) {
            this.m_asmModeNum = 1;
        } else if (this.m_asmMode.equals("near")) {
            this.m_asmModeNum = 2;
        } else if (this.m_asmMode.equals("client")) {
            this.m_asmModeNum = 3;
        }
    }

    public String toString() {
        return this.m_asmMode;
    }

    public static ASMMode getEnumMember(String asmMode) throws EnumConstNotFoundException {
        for (ASMMode embr : ASMMode.values()) {
            if (!embr.toString().equalsIgnoreCase(asmMode)) continue;
            return embr;
        }
        throw new EnumConstNotFoundException((MessageKey)PrCaMsgID.INVALID_ASMMODE, new Object[]{asmMode});
    }

    public static ASMMode getEnumMember(int asmClusterTypeNum) throws EnumConstNotFoundException {
        if (asmClusterTypeNum == 1) {
            return LEGACY;
        }
        if (asmClusterTypeNum == 2) {
            return REMOTE;
        }
        if (asmClusterTypeNum == 3) {
            return CLIENT;
        }
        throw new EnumConstNotFoundException((MessageKey)PrCaMsgID.INVALID_ASMMODE, new Object[]{asmClusterTypeNum});
    }
}

