/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.asm;

import java.util.List;
import oracle.cluster.asm.ACFSInfo;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMInstance;
import oracle.cluster.asm.ASMMode;
import oracle.cluster.asm.ASMPresence;
import oracle.cluster.asm.AsmBaseFileSystem;
import oracle.cluster.asm.AsmClusterFileSystem;
import oracle.cluster.asm.AsmClusterFileSystemException;
import oracle.cluster.asm.CCMB;
import oracle.cluster.asm.ClusterASM;
import oracle.cluster.asm.ConnectionInfo;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.asm.FileSystem;
import oracle.cluster.asm.FileSystemOptionalArgs;
import oracle.cluster.asm.IOServer;
import oracle.cluster.asm.IOServerInstance;
import oracle.cluster.asm.ProxyASM;
import oracle.cluster.asm.Volume;
import oracle.cluster.asm.VolumeException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.common.UpgradePhase;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.UpgradeException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;

public class ASMFactory {
    private static ASMFactory s_instance;
    private ASMFactoryImpl s_factoryImpl = ASMFactoryImpl.getInstance();

    private ASMFactory() throws SoftwareModuleException {
    }

    public static synchronized ASMFactory getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new ASMFactory();
        }
        return s_instance;
    }

    public static boolean isClientMode() throws ASMException {
        return ASMFactoryImpl.isClientMode();
    }

    public static void setUpgradePhase(UpgradePhase phase) {
        ASMFactoryImpl.setUpgradePhase(phase);
    }

    public static UpgradePhase getUpgradePhase() {
        return ASMFactoryImpl.getUpgradePhase();
    }

    public List<Volume> getVolumes() throws NotExistsException, VolumeException {
        return this.s_factoryImpl.getVolumes(null, null, null);
    }

    public Volume getVolume(String device) throws NotExistsException, VolumeException {
        if (device == null) {
            throw new VolumeException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "device", device);
        }
        return this.s_factoryImpl.getVolume(device);
    }

    public Volume getVolume(String volumename, String diskgroup) throws NotExistsException, VolumeException {
        return this.s_factoryImpl.getVolume(volumename, diskgroup);
    }

    public List<Volume> getVolumes(String diskgroup) throws NotExistsException, VolumeException {
        if (diskgroup == null) {
            throw new VolumeException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "diskgroup", diskgroup);
        }
        return this.s_factoryImpl.getVolumes(null, null, diskgroup);
    }

    public List<Volume> getVolumes(String device, String volumename, String diskgroup) throws NotExistsException, VolumeException {
        return this.s_factoryImpl.getVolumes(device, volumename, diskgroup);
    }

    public List<DiskGroup> getDiskGroups() throws NotExistsException, ASMException {
        return this.s_factoryImpl.getDiskGroups();
    }

    public DiskGroup getDiskGroup(String dgName) throws NotExistsException, ASMException {
        return this.s_factoryImpl.getDiskGroup(dgName);
    }

    public ASM createClientASM(String pwfile, Version version) throws ASMException {
        try {
            return this.s_factoryImpl.createClientASM(pwfile, version);
        }
        catch (SoftwareModuleException e) {
            throw new ASMException(e);
        }
    }

    public ASM createASM(Version version) throws AlreadyExistsException, ASMException {
        try {
            return this.s_factoryImpl.createASM(version);
        }
        catch (SoftwareModuleException e) {
            throw new ASMException(e);
        }
    }

    public ASM createASM(String pwfile, Version version) throws AlreadyExistsException, ASMException {
        try {
            return this.s_factoryImpl.createASM(pwfile, version);
        }
        catch (SoftwareModuleException e) {
            throw new ASMException(e);
        }
    }

    public ASM createASM(String spfile, String diskString, Version version) throws AlreadyExistsException, ASMException {
        try {
            return this.s_factoryImpl.createASM(spfile, diskString, version);
        }
        catch (SoftwareModuleException e) {
            throw new ASMException(e);
        }
    }

    public ASM createASM(String pwfile, String spfile, String diskString, Version version) throws AlreadyExistsException, ASMException {
        try {
            return this.s_factoryImpl.createASM(pwfile, spfile, diskString, version);
        }
        catch (SoftwareModuleException e) {
            throw new ASMException(e);
        }
    }

    public ASM createASM(Listener listener, Version version) throws AlreadyExistsException, ASMException {
        return this.s_factoryImpl.createASM(listener, version);
    }

    public ASM createASM(Listener listener, String pwfile, Version version) throws AlreadyExistsException, ASMException {
        return this.s_factoryImpl.createASM(listener, pwfile, version);
    }

    public ASM createASM(Listener listener, String spfile, String diskString, Version version) throws AlreadyExistsException, ASMException {
        return this.s_factoryImpl.createASM(listener, spfile, diskString, version);
    }

    public ASM createASM(Listener listener, String pwfile, String spfile, String diskString, Version version) throws AlreadyExistsException, ASMException {
        return this.s_factoryImpl.createASM(listener, pwfile, spfile, diskString, version);
    }

    public void updateDependenciesASMConversion() throws ASMException {
        this.s_factoryImpl.updateDependenciesASMConversion();
    }

    public ClusterASM createClusterASM(String pwfile, int count, Version version) throws AlreadyExistsException, ASMException {
        return this.s_factoryImpl.createClusterASM(pwfile, count, version);
    }

    public ProxyASM createProxyASM(Version version) throws AlreadyExistsException, ASMException {
        return this.s_factoryImpl.createProxyASM(null, version);
    }

    public ProxyASM createProxyASM(String spfile, Version version) throws AlreadyExistsException, ASMException {
        return this.s_factoryImpl.createProxyASM(spfile, version);
    }

    public IOServer createIOServer(int count, Version version) throws AlreadyExistsException, ASMException {
        return this.s_factoryImpl.createIOServer(null, count, version);
    }

    public IOServer createIOServer(String spfile, int count, Version version) throws AlreadyExistsException, ASMException {
        return this.s_factoryImpl.createIOServer(spfile, count, version);
    }

    public IOServer createIOServer(int count, Listener lsnr, Version version) throws AlreadyExistsException, ASMException {
        return this.s_factoryImpl.createIOServer(count, lsnr, version);
    }

    public IOServer createIOServer(String spfile, int count, Listener lsnr, Version version) throws AlreadyExistsException, ASMException {
        return this.s_factoryImpl.createIOServer(spfile, count, lsnr, version);
    }

    public CCMB createCCMB() throws AlreadyExistsException, ASMException {
        return this.s_factoryImpl.createCCMB();
    }

    public ASM getASM() throws NotExistsException, ASMException {
        return this.s_factoryImpl.getASM();
    }

    public ClusterASM getClusterASM() throws NotExistsException, ASMException {
        return this.s_factoryImpl.getClusterASM();
    }

    public ProxyASM getProxyASM() throws NotExistsException, ASMException {
        return this.s_factoryImpl.getProxyASM();
    }

    public IOServer getIOServer() throws NotExistsException, ASMException {
        return this.s_factoryImpl.getIOServer();
    }

    public CCMB getCCMB() throws NotExistsException, ASMException {
        return this.s_factoryImpl.getCCMB();
    }

    public void createACFSFileSystem(String dgName, String fsName, String mountPath, int sizeMb) throws AsmClusterFileSystemException {
        this.s_factoryImpl.createACFSFileSystem(dgName, fsName, mountPath, sizeMb);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.createAsmClusterFileSystem(volDevice, volName, dgName, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, Version version, String user) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.createAsmClusterFileSystem(volDevice, volName, dgName, version, user);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String user, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, user, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String user, String fsOptions, String description, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, user, fsOptions, description, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String user, String fsOptions, String description, String[] auxvolumes, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, user, fsOptions, description, auxvolumes, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String[] users, String fsOptions, String description, String[] auxvolumes, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, users, fsOptions, description, auxvolumes, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String mountPoint, String[] users, String fsOptions, String description, String[] auxvolumes, boolean ghCreated, boolean isClientCluster, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.createAsmClusterFileSystem(volDevice, mountPoint, users, fsOptions, description, auxvolumes, ghCreated, isClientCluster, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String[] users, String fsOptions, String description, String[] auxvolumes, boolean ghCreated, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, users, fsOptions, description, auxvolumes, ghCreated, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(String volDevice, String volName, String dgName, String mountPoint, String mountOwner, String[] users, String fsOptions, String description, String[] auxvolumes, boolean ghCreated, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.createAsmClusterFileSystem(volDevice, volName, dgName, mountPoint, mountOwner, users, fsOptions, description, auxvolumes, ghCreated, version);
    }

    public AsmClusterFileSystem createAsmClusterFileSystem(FileSystemOptionalArgs fsOptionalArgs, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.createAsmClusterFileSystem(fsOptionalArgs, version);
    }

    public FileSystem createFileSystem(FileSystemOptionalArgs fsOptionalArgs, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.createFileSystem(fsOptionalArgs, version);
    }

    public AsmClusterFileSystem getAsmClusterFileSystem(String volDevice) throws NotExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.getAsmClusterFileSystem(volDevice);
    }

    public AsmClusterFileSystem getAsmClusterFileSystem(String volName, String dgName) throws NotExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.getACFS(volName, dgName);
    }

    public AsmBaseFileSystem getFileSystem(String volDevice) throws NotExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.getFileSystem(volDevice);
    }

    public AsmBaseFileSystem getFileSystem(String volName, String dgName) throws NotExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.getFileSystem(volName, dgName);
    }

    public List<AsmBaseFileSystem> getFileSystems() throws NotExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.getFileSystems();
    }

    public ACFSInfo getACFSInfo(String mountpoint) throws NotExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.getACFSInfo(mountpoint);
    }

    public ACFSInfo getACFSInfo(String dgName, String volumeName) throws NotExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.getACFSInfo(dgName, volumeName);
    }

    public ACFSInfo getACFSInfo4VolDevice(String volDevice) throws NotExistsException, AsmClusterFileSystemException {
        return this.s_factoryImpl.getACFSInfo4VolDevice(volDevice);
    }

    public Volume createVolume(String device, String diskgroup, String volumename) throws AlreadyExistsException, VolumeException {
        return this.s_factoryImpl.createVolume(device, diskgroup, volumename);
    }

    public void upgradeACFS11202To11203FirstPhase() throws UpgradeException {
        this.s_factoryImpl.upgradeACFS11202To11203FirstPhase();
    }

    public void upgradeACFS11204To12101LastPhase() throws UpgradeException {
        this.s_factoryImpl.upgradeACFS11204To12101LastPhase();
    }

    public void upgradeVolume12101To12102LastPhase() throws UpgradeException {
        this.s_factoryImpl.upgradeVolume12101To12102LastPhase();
    }

    public void updateDependency12102To12201LastPhase() throws UpgradeException {
        this.s_factoryImpl.updateDependency12102To12201LastPhase();
    }

    public void updateProxyASMDependencyOnASM(ProxyASM proxyasm, boolean bAdd) throws ASMException {
        this.s_factoryImpl.updateProxyASMDependencyOnASM(proxyasm, bAdd);
    }

    public void startDiskGroup(String dgName, Node node) throws ASMException, AlreadyRunningException {
        this.s_factoryImpl.startDiskGroup(dgName, node);
    }

    public void startDiskGroup(String dgName) throws ASMException, AlreadyRunningException {
        this.s_factoryImpl.startDiskGroup(dgName);
    }

    public void startDiskGroupByName(String dgName, Node node) throws ASMException {
        this.s_factoryImpl.startDiskGroupByName(dgName, node);
    }

    public void startDiskGroupByName(String dgName) throws ASMException {
        this.s_factoryImpl.startDiskGroupByName(dgName);
    }

    public void startFileSystems(String[] volNames, String[] dgNames) throws AsmClusterFileSystemException, NotExistsException, AlreadyRunningException {
        this.s_factoryImpl.startFileSystems(volNames, dgNames);
    }

    public void startFileSystems(String[] volNames, String[] dgNames, Node node) throws AsmClusterFileSystemException, NotExistsException, AlreadyRunningException {
        this.s_factoryImpl.startFileSystems(volNames, dgNames, node);
    }

    public void startFileSystems(List<AsmBaseFileSystem> baseFSList, Node node) throws CompositeOperationException, ASMException, AlreadyRunningException {
        if (node == null) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node", node);
        }
        ASMFactoryImpl.startFileSystems(baseFSList, node);
    }

    public void startFileSystems(List<AsmBaseFileSystem> baseFSList) throws CompositeOperationException, ASMException, AlreadyRunningException {
        ASMFactoryImpl.startFileSystems(baseFSList, null);
    }

    public int getDefaultASMCount() {
        return this.s_factoryImpl.getDefaultASMCount();
    }

    public ASMPresence getASMPresence() throws ASMException {
        return this.s_factoryImpl.getASMPresence();
    }

    public ASMMode getASMMode() throws ASMException {
        return this.s_factoryImpl.getASMMode();
    }

    public boolean isLegacyASMMode() throws ASMException {
        return this.s_factoryImpl.getASMMode() == ASMMode.LEGACY;
    }

    public boolean isRemoteASMMode() throws ASMException {
        return this.s_factoryImpl.getASMMode() == ASMMode.REMOTE;
    }

    public boolean isClientASMMode() throws ASMException {
        return this.s_factoryImpl.getASMMode() == ASMMode.CLIENT;
    }

    public static boolean isDBAASCluster() {
        return ASMFactoryImpl.isDBAASCluster();
    }

    public ConnectionInfo getConnectionInfoFromASMListener(boolean ios, String svcName, String instName, String connID, int nTrials) throws ASMException {
        return this.s_factoryImpl.getConnectionInfoFromASMListener(ios, svcName, instName, connID, nTrials);
    }

    public ConnectionInfo getConnectionInfo(boolean ios, String svcName, String instName, String connID) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(ios, svcName, instName, connID);
    }

    public ConnectionInfo getASMConnectionInfo(String svcName, String instName, String connID) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(false, svcName, instName, connID);
    }

    public ConnectionInfo getASMConnectionInfo(String svcName, String instName) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(false, svcName, instName, null);
    }

    public ConnectionInfo getASMConnectionInfo(String svcName) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(false, svcName, null, null);
    }

    public ConnectionInfo getASMConnectionInfo() throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(false, null, null, null);
    }

    public ConnectionInfo getASMConnectionInfo(String svcName, int nTrials) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(false, svcName, null, null, nTrials);
    }

    public ConnectionInfo getASMConnectionInfo2(String svcName, String connID) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(false, svcName, null, connID);
    }

    public ConnectionInfo getASMConnectionInfo2(String instName) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(false, null, instName, null);
    }

    public ConnectionInfo getASMConnectionInfo3(String instName, String connID) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(false, null, instName, connID);
    }

    public ConnectionInfo getASMConnectionInfo3(String connID) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(false, null, null, connID);
    }

    public ConnectionInfo getIOSConnectionInfo(String svcName, String instName, String connID) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(true, svcName, instName, connID);
    }

    public ConnectionInfo getIOSConnectionInfo(String svcName, String instName) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(true, svcName, instName, null);
    }

    public ConnectionInfo getIOSConnectionInfo(String svcName) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(true, svcName, null, null);
    }

    public ConnectionInfo getIOSConnectionInfo() throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(true, null, null, null);
    }

    public ConnectionInfo getIOSConnectionInfo2(String svcName, String connID) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(true, svcName, null, connID);
    }

    public ConnectionInfo getIOSConnectionInfo2(String instName) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(true, null, instName, null);
    }

    public ConnectionInfo getIOSConnectionInfo3(String instName, String connID) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(true, null, instName, connID);
    }

    public ConnectionInfo getIOSConnectionInfo3(String connID) throws ASMException {
        return this.s_factoryImpl.getConnectionInfo(true, null, null, connID);
    }

    public void recreateASM(Version.VersionEnum sourceVersion, Version.VersionEnum destVersion) throws ASMException {
        this.s_factoryImpl.recreateASM(sourceVersion, destVersion);
    }

    public void setOHASDDependencies(int asmmode) throws ASMException {
        this.s_factoryImpl.setOHASDDependencies(asmmode);
    }

    public void updateIosTargetForInstances(String targetInst, String[] instNames) throws ASMException {
        if (targetInst == null) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "targetInst", targetInst);
        }
        if (instNames == null) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "instNames", instNames);
        }
        this.s_factoryImpl.updateIosTargetForInstances(targetInst, instNames);
    }

    public void updateIosTargetOnNodes(String targetInst, String[] nodeNames) throws ASMException {
        if (targetInst == null) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "targetInst", targetInst);
        }
        if (nodeNames == null) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeNames", nodeNames);
        }
        this.s_factoryImpl.updateIosTargetOnNodes(targetInst, nodeNames);
    }

    public void updateIosTarget(String targetInst) throws ASMException {
        if (targetInst == null) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "targetInst", targetInst);
        }
        this.s_factoryImpl.updateIosTarget(targetInst);
    }

    public List<IOServerInstance> getIOSStatus(boolean detailedStat) throws ASMException {
        return this.s_factoryImpl.getIOSStatus(detailedStat);
    }

    public List<ASMInstance> getASMStatus(boolean detailedStat) throws ASMException {
        return this.s_factoryImpl.getASMStatus(detailedStat);
    }

    public boolean isACFSSupported(String oraHome) throws AsmClusterFileSystemException {
        return this.s_factoryImpl.isACFSSupported(oraHome);
    }

    public int getDefaultCardinality() throws ASMException {
        return this.s_factoryImpl.getDefaultCardinality();
    }
}

