/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LayersBridge
extends KeymapManager
implements KeymapManager.WithRevert {
    private static final String EXT_REMOVED = "removed";
    private static final Logger LOG = Logger.getLogger(LayersBridge.class.getName());
    static final String KEYMAPS_FOLDER = "Keymaps";
    private static final String SHORTCUTS_FOLDER = "Shortcuts";
    private static final String LAYERS_BRIDGE = "LayersBridge";
    private Map<GlobalAction, DataObject> actionToDataObject = new HashMap<GlobalAction, DataObject>();
    private Map<String, Set<ShortcutAction>> categoryToActions;
    private Map<GlobalAction, GlobalAction> actions = new HashMap<GlobalAction, GlobalAction>();
    private volatile List<String> keymapNames;
    private volatile Map<String, String> keymapDisplayNames;
    private Map<String, Map<ShortcutAction, Set<String>>> keymaps = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private volatile Map<ShortcutAction, Set<String>> baseKeyMap;
    private Map<String, Map<ShortcutAction, Set<String>>> keymapDefaults = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private static final GlobalAction REMOVED = new GlobalAction(null, null, "<removed>"){
        {
            this.name = "";
        }
    };
    private static final String OPENIDE_DELEGATE_ACTION = "org.openide.awt.GeneralAction$DelegateAction";
    private static volatile Field KEY_FIELD;
    private String cachedProfile;

    public LayersBridge() {
        super(LAYERS_BRIDGE);
    }

    @Override
    public synchronized Map<String, Set<ShortcutAction>> getActions() {
        if (this.categoryToActions == null) {
            this.categoryToActions = new HashMap<String, Set<ShortcutAction>>();
            this.initActions("Actions", null);
            this.categoryToActions.remove("Hidden");
            this.categoryToActions = Collections.unmodifiableMap(this.categoryToActions);
        }
        return this.categoryToActions;
    }

    private void initActions(String string, String string2) {
        FileObject fileObject = FileUtil.getConfigFile((String)string);
        if (fileObject == null) {
            return;
        }
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        Enumeration enumeration = dataFolder.children();
        while (enumeration.hasMoreElements()) {
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (!(dataObject instanceof DataFolder)) continue;
            this.initActions((DataFolder)dataObject, null, string2);
        }
    }

    private void initActions(DataFolder dataFolder, String string, String string2) {
        Object object;
        String string3 = dataFolder.getName();
        if (string2 != null) {
            string3 = string2;
        } else {
            object = (String)dataFolder.getPrimaryFile().getAttribute("SystemFileSystem.localizingBundle");
            if (object != null) {
                try {
                    string3 = NbBundle.getBundle((String)object).getString(dataFolder.getPrimaryFile().getPath());
                }
                catch (MissingResourceException missingResourceException) {
                    ErrorManager.getDefault().notify((Throwable)missingResourceException);
                }
            }
            if (string != null) {
                string3 = string + '/' + string3;
            }
        }
        object = dataFolder.children();
        while (object.hasMoreElements()) {
            DataObject dataObject = (DataObject)object.nextElement();
            if (dataObject instanceof DataFolder) {
                this.initActions((DataFolder)dataObject, string3, string2);
                continue;
            }
            GlobalAction globalAction = this.createAction(dataObject, string3, dataObject.getPrimaryFile().getName(), false);
            if (globalAction == null || this.actions.containsKey(globalAction)) continue;
            this.actions.put(globalAction, globalAction);
            Set<ShortcutAction> set = this.categoryToActions.get(string3);
            if (set == null) {
                set = new HashSet<ShortcutAction>();
                this.categoryToActions.put(string3, set);
            }
            set.add(globalAction);
            while (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            this.actionToDataObject.put(globalAction, dataObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshKeymapNames() {
        Object object;
        DataFolder dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, null);
        Enumeration enumeration = dataFolder.children(false);
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (enumeration.hasMoreElements()) {
            String string;
            object = ((DataObject)enumeration.nextElement()).getPrimaryFile();
            if (!object.isFolder()) continue;
            String string2 = object.getNameExt();
            try {
                string = object.getFileSystem().getStatus().annotateName(string2, Collections.singleton(object));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                string = string2;
            }
            arrayList.add(string2);
            hashMap.put(string2, string);
        }
        if (arrayList.isEmpty()) {
            arrayList.add("NetBeans");
        }
        object = this;
        synchronized (object) {
            this.keymapNames = arrayList;
            this.keymapDisplayNames = hashMap;
        }
    }

    @Override
    public List<String> getProfiles() {
        List<String> list = this.keymapNames;
        if (list == null) {
            this.refreshKeymapNames();
            list = this.keymapNames;
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public String getProfileDisplayName(String string) {
        String string2;
        Map<String, String> map = this.keymapDisplayNames;
        if (map == null) {
            this.refreshKeymapNames();
            map = this.keymapDisplayNames;
        }
        return (string2 = map.get(string)) == null ? string : string2;
    }

    @Override
    public Map<ShortcutAction, Set<String>> getKeymap(String string) {
        if (!this.keymaps.containsKey(string)) {
            DataFolder dataFolder = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
            Map<ShortcutAction, Set<String>> map = this.readKeymap(dataFolder);
            dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, string);
            this.overrideWithKeyMap(map, this.readKeymap(dataFolder), string);
            map.remove(REMOVED);
            this.keymaps.put(string, map);
        }
        return Collections.unmodifiableMap(this.keymaps.get(string));
    }

    private Map<ShortcutAction, Set<String>> getBaseKeyMap() {
        if (this.baseKeyMap == null) {
            DataFolder dataFolder = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
            Map<ShortcutAction, Set<String>> map = this.readKeymap(dataFolder);
            this.baseKeyMap = map;
        }
        return this.baseKeyMap;
    }

    private Map<ShortcutAction, Set<String>> overrideWithKeyMap(Map<ShortcutAction, Set<String>> map, Map<ShortcutAction, Set<String>> map2, String string) {
        HashSet hashSet = new HashSet();
        Map<String, ShortcutAction> map3 = null;
        for (ShortcutAction object : map2.keySet()) {
            hashSet.addAll(map2.get(object));
        }
        Iterator<Object> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Set set = (Set)entry.getValue();
            if (LOG.isLoggable(Level.FINER)) {
                for (String string2 : set) {
                    ShortcutAction shortcutAction;
                    if (!hashSet.contains(string2)) continue;
                    if (map3 == null) {
                        map3 = LayersBridge.shortcutToAction(map2);
                    }
                    if ((shortcutAction = map3.get(string2)).getId().equals(((ShortcutAction)entry.getKey()).getId())) continue;
                    LOG.finer("[" + string + "] change keybinding " + string2 + " from " + ((ShortcutAction)entry.getKey()).getId() + " to " + shortcutAction.getId());
                }
            }
            set.removeAll(hashSet);
            if (!set.isEmpty()) continue;
            iterator.remove();
        }
        map.putAll(map2);
        return map;
    }

    @Override
    public synchronized Map<ShortcutAction, Set<String>> getDefaultKeymap(String string) {
        if (!this.keymapDefaults.containsKey(string)) {
            DataFolder dataFolder = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
            Map<ShortcutAction, Set<String>> map = this.readKeymap(dataFolder, true);
            this.overrideWithKeyMap(map, this.readOriginalKeymap(dataFolder), string);
            dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, string);
            this.overrideWithKeyMap(map, this.readKeymap(dataFolder, true), string);
            this.overrideWithKeyMap(map, this.readOriginalKeymap(dataFolder), string);
            map.remove(REMOVED);
            this.keymapDefaults.put(string, map);
        }
        return Collections.unmodifiableMap(this.keymapDefaults.get(string));
    }

    DataObject getDataObject(Object object) {
        return this.actionToDataObject.get(object);
    }

    @Override
    public void revertProfile(String string) throws IOException {
        final DataFolder dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, string);
        if (dataFolder == null) {
            return;
        }
        final Collection collection = (Collection)dataFolder.getPrimaryFile().getAttribute("revealEntries");
        dataFolder.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject[] fileObjectArray = collection.iterator();
                while (fileObjectArray.hasNext()) {
                    FileObject[] fileObjectArray2 = (FileObject[])fileObjectArray.next();
                    try {
                        fileObjectArray2.call();
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (Exception exception) {
                        throw new IOException("Unexpected error", exception);
                    }
                }
                for (FileObject fileObject : fileObjectArray = dataFolder.getPrimaryFile().getChildren()) {
                    if (!fileObject.canRevert()) continue;
                    fileObject.revert();
                }
                dataFolder.getPrimaryFile().refresh();
            }
        });
        this.keymaps.remove(string);
    }

    private Map<ShortcutAction, Set<String>> readOriginalKeymap(DataFolder dataFolder) {
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        if (dataFolder == null) {
            return hashMap;
        }
        FileObject fileObject = dataFolder.getPrimaryFile();
        Collection collection = (Collection)fileObject.getAttribute("revealEntries");
        HashSet<String> hashSet = new HashSet<String>();
        for (FileObject fileObject2 : collection) {
            try {
                Object object;
                Object object2;
                GlobalAction globalAction;
                hashSet.add(fileObject2.getName());
                if (EXT_REMOVED.equals(fileObject2.getExt()) && FileUtil.findBrother((FileObject)fileObject2, (String)"shadow") == null) {
                    globalAction = REMOVED;
                } else {
                    object2 = DataShadow.findOriginal((FileObject)fileObject2);
                    if (object2 == null || (object = DataObject.find((FileObject)object2)) instanceof DataFolder) continue;
                    globalAction = this.createActionWithLookup((DataObject)object, null, fileObject2.getName(), false);
                }
                if (globalAction == null) continue;
                object2 = fileObject2.getName();
                LOG.log(Level.FINEST, "Overriden action {0}: {1}, by {2}", new Object[]{globalAction.getId(), object2, fileObject2.getPath()});
                object = (Set)hashMap.get(globalAction);
                if (object == null) {
                    object = new HashSet();
                    hashMap.put(globalAction, (Set<String>)object);
                }
                object.add(object2);
            }
            catch (IOException iOException) {}
        }
        return hashMap;
    }

    @Override
    public void revertActions(String string, Collection<ShortcutAction> collection) throws IOException {
        Map<ShortcutAction, Set<String>> map = this.getDefaultKeymap(string);
        Map<ShortcutAction, Set<String>> map2 = this.getKeymap(string);
        DataFolder dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, string);
        if (dataFolder == null) {
            return;
        }
        final FileObject fileObject = dataFolder.getPrimaryFile();
        final Collection collection2 = (Collection)fileObject.getAttribute("revealEntries");
        final HashSet<String> hashSet = new HashSet<String>();
        final HashSet<String> hashSet2 = new HashSet<String>();
        for (ShortcutAction shortcutAction : collection) {
            Set<String> set = map.get(shortcutAction);
            if (set != null) {
                hashSet.addAll(set);
            }
            if ((set = map2.get(shortcutAction)) == null) continue;
            hashSet2.addAll(set);
        }
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fileObject2;
                if (hashSet != null) {
                    for (Object object : collection2) {
                        if (!hashSet.remove(object.getName())) continue;
                        try {
                            ((Callable)object).call();
                        }
                        catch (IOException iOException) {
                            throw iOException;
                        }
                        catch (Exception exception) {
                            throw new IOException("Cannot revert", exception);
                        }
                    }
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        Object object;
                        object = (String)iterator.next();
                        fileObject2 = fileObject.getFileObject((String)object, LayersBridge.EXT_REMOVED);
                        if (fileObject2 == null) continue;
                        fileObject2.delete();
                        iterator.remove();
                    }
                }
                for (Object object : hashSet2) {
                    fileObject2 = fileObject.getFileObject((String)object, "shadow");
                    if (fileObject2 == null) continue;
                    fileObject2.delete();
                }
            }
        });
    }

    private Map<ShortcutAction, Set<String>> readKeymap(DataFolder dataFolder) {
        return this.readKeymap(dataFolder, false);
    }

    private Map<ShortcutAction, Set<String>> readKeymap(DataFolder dataFolder, boolean bl) {
        LOG.log(Level.FINEST, "Reading keymap from: {0}", dataFolder);
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        if (dataFolder == null) {
            return hashMap;
        }
        Enumeration enumeration = dataFolder.children(false);
        while (enumeration.hasMoreElements()) {
            GlobalAction globalAction;
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (dataObject instanceof DataFolder || (globalAction = this.createActionWithLookup(dataObject, null, dataObject.getPrimaryFile().getName(), bl)) == null) continue;
            String string = dataObject.getPrimaryFile().getName();
            LOG.log(Level.FINEST, "Action {0}: {1}, by {2}", new Object[]{globalAction.getId(), string, dataObject.getPrimaryFile().getPath()});
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(globalAction);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashMap.put(globalAction, hashSet);
            }
            hashSet.add(string);
        }
        return hashMap;
    }

    @Override
    public void deleteProfile(String string) {
        FileObject fileObject = FileUtil.getConfigFile((String)KEYMAPS_FOLDER);
        if (fileObject == null) {
            return;
        }
        if ((fileObject = fileObject.getFileObject(string)) == null) {
            return;
        }
        try {
            fileObject.delete();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    @Override
    public void saveKeymap(String string, Map<ShortcutAction, Set<String>> map) {
        this.keymaps.remove(string);
        this.keymapDefaults.remove(string);
        DataFolder dataFolder = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
        DataFolder dataFolder2 = LayersBridge.getRootFolder(KEYMAPS_FOLDER, string);
        if (dataFolder2 == null) {
            dataFolder2 = LayersBridge.getRootFolder(KEYMAPS_FOLDER, null);
            try {
                dataFolder2 = DataFolder.create((DataFolder)dataFolder2, (String)string);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return;
            }
        }
        this.saveKeymap(dataFolder, dataFolder2, map);
    }

    private void saveKeymap(DataFolder dataFolder, DataFolder dataFolder2, Map<ShortcutAction, Set<String>> map) {
        GlobalAction globalAction;
        Object object2;
        Object object3;
        LOG.log(Level.FINEST, "Saving keymap to: {0}", dataFolder2.getPrimaryFile().getPath());
        this.getActions();
        Map<String, ShortcutAction> map2 = LayersBridge.shortcutToAction(map);
        HashSet<String> hashSet = new HashSet<String>(map2.keySet());
        FileObject fileObject = dataFolder2.getPrimaryFile();
        Enumeration enumeration = dataFolder2.children();
        while (enumeration.hasMoreElements()) {
            object3 = (DataObject)enumeration.nextElement();
            if (object3.getPrimaryFile().getExt().equals(EXT_REMOVED)) continue;
            object2 = (GlobalAction)map2.get(object3.getName());
            if (object2 != null) {
                GlobalAction iOException = this.createAction((DataObject)object3, null, object3.getPrimaryFile().getName(), false);
                if (iOException == null) {
                    LOG.log(Level.FINEST, "Broken action shortcut will be removed: {0}, will replace by {1}", new Object[]{object3.getName(), ((GlobalAction)object2).getId()});
                } else if (iOException.equals(object2)) {
                    LOG.log(Level.FINEST, "Found same binding: {0} -> {1}", new Object[]{object3.getName(), iOException.getId()});
                    map2.remove(object3.getName());
                    continue;
                }
            }
            try {
                LOG.log(Level.FINEST, "Removing obsolete binding: {0}", object3.getName());
                object3.delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object3 = new HashSet();
        enumeration = dataFolder.children();
        while (enumeration.hasMoreElements()) {
            object2 = (DataObject)enumeration.nextElement();
            GlobalAction globalAction2 = (GlobalAction)map2.get(object2.getName());
            if (globalAction2 == null || !globalAction2.equals(globalAction = this.createAction((DataObject)object2, null, object2.getPrimaryFile().getName(), false))) continue;
            LOG.log(Level.FINEST, "Leaving default shortcut: {0}", object2.getName());
            object3.add(object2.getName());
        }
        for (String string : map2.keySet()) {
            globalAction = (GlobalAction)map2.get(string);
            DataObject dataObject = this.actionToDataObject.get(globalAction);
            if (dataObject == null) {
                if (System.getProperty("org.netbeans.optionsDialog") == null) continue;
                System.out.println("No original DataObject specified! Not possible to create shadow1. " + globalAction);
                continue;
            }
            FileObject fileObject2 = fileObject.getFileObject(string, EXT_REMOVED);
            try {
                if (fileObject2 != null) {
                    fileObject2.delete();
                }
                if (object3.contains(string)) continue;
                DataShadow.create((DataFolder)dataFolder2, (String)string, (DataObject)dataObject);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (dataFolder != null) {
            enumeration = dataFolder.children();
            while (enumeration.hasMoreElements()) {
                DataObject dataObject = (DataObject)enumeration.nextElement();
                if (hashSet.contains(dataObject.getName())) continue;
                try {
                    globalAction = dataObject.getPrimaryFile();
                    if (fileObject.getFileObject(globalAction.getName(), EXT_REMOVED) != null) continue;
                    LOG.log(Level.FINEST, "Masking out binding: {0}", globalAction.getName());
                    dataFolder2.getPrimaryFile().createData(globalAction.getName(), EXT_REMOVED);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static DataFolder getExistingProfile(String string) {
        FileObject fileObject = FileUtil.getConfigRoot();
        FileObject fileObject2 = fileObject.getFileObject(KEYMAPS_FOLDER);
        if (fileObject2 == null) {
            return null;
        }
        FileObject fileObject3 = fileObject2.getFileObject(string);
        if (fileObject3 == null) {
            return null;
        }
        return DataFolder.findFolder((FileObject)fileObject3);
    }

    private static DataFolder getRootFolder(String string, String string2) {
        FileObject fileObject = FileUtil.getConfigRoot();
        FileObject fileObject2 = fileObject.getFileObject(string);
        try {
            if (fileObject2 == null) {
                fileObject2 = fileObject.createFolder(string);
            }
            if (fileObject2 == null) {
                return null;
            }
            if (string2 == null) {
                return DataFolder.findFolder((FileObject)fileObject2);
            }
            FileObject fileObject3 = fileObject2.getFileObject(string2);
            if (fileObject3 == null) {
                fileObject3 = fileObject2.createFolder(string2);
            }
            if (fileObject3 == null) {
                return null;
            }
            return DataFolder.findFolder((FileObject)fileObject3);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    private GlobalAction createActionWithLookup(DataObject dataObject, String string, String string2, boolean bl) {
        GlobalAction globalAction = this.createAction(dataObject, string, string2, bl);
        if (globalAction == null) {
            return null;
        }
        GlobalAction globalAction2 = this.actions.get(globalAction);
        return globalAction2 == null ? globalAction : globalAction2;
    }

    private GlobalAction createAction(DataObject dataObject, String string, String string2, boolean bl) {
        InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        if (bl && fileObject.canRevert()) {
            return null;
        }
        if (instanceCookie == null) {
            if (!EXT_REMOVED.equals(fileObject.getExt())) {
                LOG.log(Level.WARNING, "Invalid shortcut: {0}", dataObject);
                return null;
            }
            if (FileUtil.findBrother((FileObject)fileObject, (String)"shadow") != null) {
                return null;
            }
            return REMOVED;
        }
        try {
            Object object = instanceCookie.instanceCreate();
            if (object == null) {
                return null;
            }
            if (!(object instanceof Action)) {
                return null;
            }
            return LayersBridge.createAction((Action)object, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static GlobalAction createAction(Action action, String string, String string2) {
        Object object = string2;
        try {
            if (action.getClass().getName().equals(OPENIDE_DELEGATE_ACTION)) {
                Object object2;
                if (KEY_FIELD == null) {
                    object2 = action.getClass();
                    Field field = ((Class)object2).getSuperclass().getDeclaredField("key");
                    field.setAccessible(true);
                    KEY_FIELD = field;
                }
                if ((object2 = (String)KEY_FIELD.get(action)) != null) {
                    object = object2;
                }
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Exceptions.printStackTrace((Throwable)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        return new GlobalAction(action, string, (String)object);
    }

    static Map<String, ShortcutAction> shortcutToAction(Map<ShortcutAction, Set<String>> map) {
        HashMap<String, ShortcutAction> hashMap = new HashMap<String, ShortcutAction>();
        for (Map.Entry<ShortcutAction, Set<String>> entry : map.entrySet()) {
            ShortcutAction shortcutAction = entry.getKey();
            Set<String> set = entry.getValue();
            ShortcutAction shortcutAction2 = shortcutAction = shortcutAction != null ? shortcutAction.getKeymapManagerInstance(LAYERS_BRIDGE) : null;
            if (!(shortcutAction instanceof GlobalAction)) continue;
            for (String string : set) {
                hashMap.put(string, shortcutAction);
            }
        }
        return hashMap;
    }

    @Override
    public void refreshActions() {
        this.refreshKeymapNames();
    }

    @Override
    public String getCurrentProfile() {
        return this.cachedProfile;
    }

    @Override
    public void setCurrentProfile(String string) {
        this.cachedProfile = string;
    }

    @Override
    public boolean isCustomProfile(String string) {
        DataFolder dataFolder = LayersBridge.getExistingProfile(string);
        if (dataFolder == null) {
            return true;
        }
        FileObject fileObject = dataFolder.getPrimaryFile();
        if (!fileObject.canRevert()) {
            return false;
        }
        FileObject fileObject2 = dataFolder.getPrimaryFile().getParent();
        if (fileObject2 == null) {
            return true;
        }
        Collection collection = (Collection)fileObject2.getAttribute("revealEntries");
        if (collection == null) {
            return true;
        }
        for (FileObject fileObject3 : collection) {
            if (!fileObject3.getNameExt().equals(string)) continue;
            return false;
        }
        return true;
    }

    static String getOrigActionClass(ShortcutAction shortcutAction) {
        if (!(shortcutAction instanceof GlobalAction)) {
            return null;
        }
        GlobalAction globalAction = (GlobalAction)shortcutAction;
        return globalAction.action == null ? null : globalAction.action.getClass().getName();
    }

    private static class GlobalAction
    implements ShortcutAction {
        private Action action;
        String name;
        private String id;

        private GlobalAction(Action action, String string, String string2) {
            this.action = action;
            this.id = string2;
        }

        @Override
        public String getDisplayName() {
            if (this.name == null) {
                try {
                    this.name = (String)this.action.getValue("Name");
                }
                catch (MissingResourceException missingResourceException) {
                    LOG.log(Level.WARNING, "Missing resources for action {0}, class {1}: {2}", new Object[]{this.id, this.action.getClass().getName(), missingResourceException.getLocalizedMessage()});
                }
                if (this.name == null) {
                    this.name = "";
                }
                this.name = this.name.replaceAll("&", "").trim();
            }
            return this.name;
        }

        @Override
        public String getId() {
            if (this.id == null) {
                this.id = this.action.getClass().getName();
            }
            return this.id;
        }

        @Override
        public String getDelegatingActionId() {
            return null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof GlobalAction)) {
                return false;
            }
            return ((GlobalAction)object).action == this.action || ((GlobalAction)object).action.equals(this.action);
        }

        public int hashCode() {
            return this.action == null ? 111 : this.action.hashCode();
        }

        public String toString() {
            return "GlobalAction[" + this.getDisplayName() + ":" + this.id + "]";
        }

        @Override
        public ShortcutAction getKeymapManagerInstance(String string) {
            if (LayersBridge.LAYERS_BRIDGE.equals(string)) {
                return this;
            }
            return null;
        }
    }
}

