/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay.print;

import oracle.help.common.Topic;
import oracle.help.topicDisplay.print.TopicPrintJob;

public abstract class BaseTopicPrintJob
implements TopicPrintJob {
    private static String PRINT_THREAD_NAME = "Help Topic PrintJob";
    private Thread _printThread = null;

    public void printTopic(Topic topic) {
        if (topic != null) {
            this._printThread = new Thread((Runnable)new PrintingThread(topic, null), PRINT_THREAD_NAME);
            this._printThread.start();
        }
    }

    public void printTopics(Topic[] topicArray) {
        if (topicArray != null && topicArray.length > 0) {
            this._printThread = new Thread((Runnable)new PrintingThread(null, topicArray), PRINT_THREAD_NAME);
            this._printThread.start();
        }
    }

    protected abstract void printTopicImpl(Topic var1);

    protected abstract void printTopicsImpl(Topic[] var1);

    private class PrintingThread
    implements Runnable {
        private Topic _topic;
        private Topic[] _topics;

        public PrintingThread(Topic topic, Topic[] topicArray) {
            this._topic = topic;
            this._topics = topicArray;
        }

        public void run() {
            if (this._topic != null) {
                BaseTopicPrintJob.this.printTopicImpl(this._topic);
            } else if (this._topics != null) {
                BaseTopicPrintJob.this.printTopicsImpl(this._topics);
            }
        }
    }
}

