/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.util;

import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.util.java.StaticLocaleContext;

public class MenuUtils {
    public static final String SEPARATOR = "menu.separator";
    public static final String FILE = "menu.File";
    public static final String DISPLAY = "menu.Display";
    public static final String DISPLAY_NEW = "menu.Display_New";
    public static final String PRINT_TOPIC = "menu.PrintTopic";
    public static final String CLOSE = "menu.Close";
    public static final String EXIT = "menu.Exit";
    public static final String PRINT_TREE = "menu.PrintTree";
    public static final String PRINT_TOPICS = "menu.PrintTopics";
    public static final String VIEW = "menu.View";
    public static final String GO = "menu.Go";
    public static final String BACK = "menu.Back";
    public static final String FORWARD = "menu.Forward";
    public static final String TOOLS = "menu.Tools";
    public static final String FIND = "menu.Find";
    public static final String PREFERENCES = "menu.Preferences";
    public static final String DOCK = "menu.Dock";
    public static final String UNDOCK = "menu.Undock";
    public static final String NAVIGATOR = "menu.Navigator";
    public static final String HELP = "menu.Help";
    public static final String HELP_ON_HELP = "menu.HelpOnHelp";
    public static final String ABOUT = "menu.About";
    public static final Map<String, KeyStroke> MENU_LABEL_KEYSTROKES = new HashMap<String, KeyStroke>();
    public static final Map<String, KeyStroke> MISC_BUNDLE_KEYSTROKES = new HashMap<String, KeyStroke>();
    private static String MENU_RESOURCE_BUNDLE;

    public static JMenuItem createItem(String string, boolean bl) {
        String string2 = MenuUtils.getDefaultMenuLabel(string);
        return MenuUtils.createItem(string2, MENU_LABEL_KEYSTROKES.get(string), bl);
    }

    public static JMenuItem createItem(String string, KeyStroke keyStroke, boolean bl) {
        JMenuItem jMenuItem;
        if (string.charAt(0) == '+') {
            jMenuItem = new JCheckBoxMenuItem();
            string = string.substring(1);
        } else {
            jMenuItem = new JMenuItem();
        }
        MenuUtils.setMenuLabelAndAccelerator(jMenuItem, string, keyStroke, bl);
        return jMenuItem;
    }

    public static void setMenuLabelAndAccelerator(JMenuItem jMenuItem, String string, boolean bl) {
        MenuUtils.setMenuLabelAndAccelerator(jMenuItem, MenuUtils.getDefaultMenuLabel(string), MENU_LABEL_KEYSTROKES.get(string), bl);
    }

    public static void setMenuLabelAndAccelerator(JMenuItem jMenuItem, String string, KeyStroke keyStroke, boolean bl) {
        jMenuItem.setText(StringUtils.stripMnemonic((String)string));
        if (!bl) {
            int n;
            if (!(jMenuItem instanceof JMenu) && keyStroke != null && KeyEvent.getKeyText(keyStroke.getKeyCode()).indexOf("known") == -1) {
                jMenuItem.setAccelerator(keyStroke);
            }
            if ((n = StringUtils.getMnemonicKeyCode((String)string)) != 0) {
                jMenuItem.setMnemonic(n);
            }
        }
    }

    public static String getDefaultMenuLabel(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(MENU_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        String string2 = resourceBundle.getString(string);
        return string2;
    }

    public static String removeSpecialMenuChars(String string) {
        String string2 = string;
        if (string2 != null) {
            if (string2.charAt(0) == '+') {
                string2 = string2.substring(1);
            }
            string2 = StringUtils.stripMnemonic((String)string2);
        }
        return string2;
    }

    public static KeyStroke getMiscBundleKeyStroke(String string) {
        return MISC_BUNDLE_KEYSTROKES.get(string);
    }

    static {
        MENU_LABEL_KEYSTROKES.put(DISPLAY, KeyStroke.getKeyStroke(79, 2));
        MENU_LABEL_KEYSTROKES.put(DISPLAY_NEW, KeyStroke.getKeyStroke(78, 2));
        MENU_LABEL_KEYSTROKES.put(PRINT_TOPIC, KeyStroke.getKeyStroke(80, 2));
        MENU_LABEL_KEYSTROKES.put(CLOSE, KeyStroke.getKeyStroke(87, 2));
        MENU_LABEL_KEYSTROKES.put(EXIT, KeyStroke.getKeyStroke(115, 8));
        MENU_LABEL_KEYSTROKES.put(PRINT_TREE, KeyStroke.getKeyStroke(84, 2));
        MENU_LABEL_KEYSTROKES.put(PRINT_TOPICS, KeyStroke.getKeyStroke(83, 2));
        MENU_LABEL_KEYSTROKES.put(BACK, KeyStroke.getKeyStroke(37, 8));
        MENU_LABEL_KEYSTROKES.put(FORWARD, KeyStroke.getKeyStroke(39, 8));
        MENU_LABEL_KEYSTROKES.put(FIND, KeyStroke.getKeyStroke(70, 2));
        MENU_LABEL_KEYSTROKES.put(DOCK, KeyStroke.getKeyStroke(82, 2));
        MENU_LABEL_KEYSTROKES.put(UNDOCK, KeyStroke.getKeyStroke(85, 2));
        MENU_LABEL_KEYSTROKES.put(NAVIGATOR, KeyStroke.getKeyStroke(74, 2));
        MISC_BUNDLE_KEYSTROKES.put("edit.copy", KeyStroke.getKeyStroke(67, 2));
        MISC_BUNDLE_KEYSTROKES.put("edit.selectAll", KeyStroke.getKeyStroke(65, 2));
        MISC_BUNDLE_KEYSTROKES.put("edit.increase", KeyStroke.getKeyStroke('+'));
        MISC_BUNDLE_KEYSTROKES.put("edit.decrease", KeyStroke.getKeyStroke('-'));
        MISC_BUNDLE_KEYSTROKES.put("addfavoriteitem.addtofavoritesdot", KeyStroke.getKeyStroke(68, 2));
        MENU_RESOURCE_BUNDLE = "oracle.help.resource.MenuLabels";
    }
}

