/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.htmlBrowser.find;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.htmlBrowser.FindSupport;
import oracle.help.java.util.MnemonicUtils;

public class FindDialog
extends JDialog
implements ActionListener {
    private FindSupport _findSupport;
    private JLabel _findWhat;
    private JTextField _textField;
    private JCheckBox _caseSensitive;
    private JButton _findNext;
    private JButton _close;
    private String _prevSearch = "";
    private static final String MISC_RESOURCE_BUNDLE = "oracle.help.resource.MiscBundle";
    private static final String FIND = "find.title";
    private static final String FIND_WHAT = "find.prompt";
    private static final String FIND_FINISHED = "find.finished";
    private static final String CASE_SENSITIVE = "find.case";
    private static final String FIND_NEXT = "find.next";
    private static final String CLOSE = "find.close";
    private static final String _KEY_CLOSE = "CLOSE";

    public FindDialog(Frame frame, FindSupport findSupport) {
        super(frame, true);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(MISC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        this.setTitle(StringUtils.stripMnemonic((String)resourceBundle.getString(FIND)));
        this._findSupport = findSupport;
        this._textField = new JTextField(20);
        this._textField.addActionListener(this);
        this._findWhat = MnemonicUtils.createLabel(resourceBundle.getString(FIND_WHAT), this._textField);
        this._caseSensitive = MnemonicUtils.createCheckBox(resourceBundle.getString(CASE_SENSITIVE));
        this._findNext = MnemonicUtils.createButton(resourceBundle.getString(FIND_NEXT));
        this._findNext.addActionListener(this);
        this._close = MnemonicUtils.createButton(resourceBundle.getString(CLOSE));
        this._close.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this._findWhat);
        jPanel.add(this._textField);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this._caseSensitive, "South");
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this._findNext, "North");
        jPanel3.add((Component)this._close, "South");
        jPanel3.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel2, "West");
        this.getContentPane().add((Component)jPanel3, "East");
        this.addWindowListener(WindowUtils.getWindowCloser());
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, _KEY_CLOSE, KeyStroke.getKeyStroke(27, 0), 1);
        this.pack();
        WindowUtils.centerWindow((Window)this, (Component)frame);
        this.setVisible(true);
        this._textField.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._close || _KEY_CLOSE.equals(actionEvent.getActionCommand())) {
            this.setVisible(false);
            this.dispose();
        } else if ((object == this._findNext || object == this._textField) && this._findSupport != null) {
            this._findSupport.setCaseSensitive(this._caseSensitive.isSelected());
            if (!this._textField.getText().equals(this._prevSearch)) {
                this._prevSearch = this._textField.getText();
                this._findSupport.setSearchString(this._prevSearch);
            }
            if (!this._findSupport.findNext()) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(MISC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
                JOptionPane.showMessageDialog(this, resourceBundle.getString(FIND_FINISHED), resourceBundle.getString(FIND), 2);
            }
        }
    }
}

