/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.ewt.help.HelpProvider;
import oracle.help.AppletWindowManager;
import oracle.help.CustomProtocolHandler;
import oracle.help.DefaultNavigatorPanel;
import oracle.help.DefaultWindowManager;
import oracle.help.WindowManager;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.ImageLoader;
import oracle.help.library.Book;
import oracle.help.library.Library;
import oracle.help.library.LibraryException;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorException;
import oracle.help.navigator.NavigatorListener;
import oracle.help.navigator.NavigatorTabPanel;
import oracle.help.navigator.favoritesNavigator.DefaultFavoritesModel;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.navigator.favoritesNavigator.FavoritesNavigator;
import oracle.help.topicDisplay.TopicDisplayException;

public class Help
implements oracle.bali.ewt.help.HelpProvider,
HelpProvider,
NavigatorListener {
    private ArrayList _tabPanels;
    private Library _library;
    private boolean _useLabelInfo;
    private boolean _combineBooks;
    private boolean _dockedByDefault = false;
    private boolean _addedFavNav = false;
    private DefaultNavigatorPanel _navigatorWindowPanel;
    private WindowManager _windowManager;
    private Book _defaultBook;
    private String _defaultTopicID;
    private FavoritesModel _favoritesModel;

    public Help() {
        this(true, false);
    }

    public Help(Class clazz) {
        this(clazz, true, false);
    }

    public Help(AppletContext appletContext, String string) {
        this(appletContext, string, true, false);
    }

    public Help(boolean bl, boolean bl2) {
        this(bl, bl2, false);
    }

    public Help(boolean bl, boolean bl2, boolean bl3) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("oracle.help.htmlBrowser.ICEBrowser");
        }
        catch (Exception exception) {
            clazz = null;
            System.err.println("Help : Failed to load ICEBrowser");
            exception.printStackTrace();
        }
        if (clazz != null) {
            this._initHelpSystem(clazz, null, null, bl, bl2, false, bl3);
        }
    }

    public Help(Class clazz, boolean bl, boolean bl2) {
        this(clazz, bl, bl2, false);
    }

    public Help(Class clazz, boolean bl, boolean bl2, boolean bl3) {
        this(clazz, bl, bl2, bl3, false);
    }

    public Help(Class clazz, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (clazz == null) {
            throw new IllegalArgumentException("Help: Cannot instantiate Help with null htmlBrowserClass");
        }
        this._initHelpSystem(clazz, null, null, bl, bl2, bl3, bl4);
    }

    public Help(AppletContext appletContext, String string, boolean bl, boolean bl2) {
        if (appletContext == null) {
            throw new IllegalArgumentException("Help: Cannot instantiate Help with null appletContext");
        }
        this._initHelpSystem(null, appletContext, string, bl, bl2, false, false);
    }

    public static void setHelpLocale(Locale locale) {
        StaticLocaleContext.setLocale((Locale)locale);
    }

    public static Locale getHelpLocale() {
        return StaticLocaleContext.getLocale();
    }

    public static void setHelpEncoding(String string) {
        StaticLocaleContext.setEncoding((String)string);
    }

    public static String getHelpEncoding() {
        return StaticLocaleContext.getEncoding();
    }

    public void setIconImage(Image image) {
        ImageLoader.setIconImage(image);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this._windowManager.showNavigatorWindow();
        } else {
            this._windowManager.hideAllWindows();
        }
    }

    public void addBook(Book book) {
        try {
            this._library.addBook(book);
        }
        catch (LibraryException libraryException) {
            System.err.println(libraryException.getMessage());
            return;
        }
        this._createNavigatorsForBook(book);
    }

    public void removeBook(Book book) {
        try {
            this._library.removeBook(book);
        }
        catch (LibraryException libraryException) {
            System.err.println(libraryException.getMessage());
        }
    }

    public void removeAllBooks() {
        int n = 0;
        Book[] bookArray = this._library.getBooks();
        if (bookArray != null) {
            for (n = 0; n < bookArray.length; ++n) {
                this.removeBook(bookArray[n]);
            }
        }
    }

    public Book[] getBooks() {
        return this._library.getBooks();
    }

    public int getBookCount() {
        return this._library.getBookCount();
    }

    public static void registerClientWindow(Window window) {
        WindowUtils.registerWindow((Window)window);
    }

    public static void unregisterClientWindow(Window window) {
        WindowUtils.unregisterWindow((Window)window);
    }

    public void registerCustomProtocolHandler(String string, CustomProtocolHandler customProtocolHandler) {
        if (this._windowManager != null) {
            this._windowManager.registerCustomProtocolHandler(string, customProtocolHandler);
        } else {
            System.err.println("Attempting to registerCustomProtocolHandler before WindowManager creation");
        }
    }

    public void showNavigatorWindow() {
        this._windowManager.showNavigatorWindow();
    }

    public void showNavigatorWindow(Navigator navigator) {
        if (navigator != null) {
            this._navigatorWindowPanel.setActiveNavigator(navigator);
        }
        this._windowManager.showNavigatorWindow();
    }

    public void showNavigatorWindow(Book book) {
        NavigatorTabPanel navigatorTabPanel = null;
        if (book != null) {
            for (int i = 0; i < this._tabPanels.size() && navigatorTabPanel == null; ++i) {
                NavigatorTabPanelInfo navigatorTabPanelInfo = (NavigatorTabPanelInfo)this._tabPanels.get(i);
                if (navigatorTabPanelInfo.book != book) continue;
                navigatorTabPanel = navigatorTabPanelInfo.tabPanel;
            }
        }
        if (navigatorTabPanel != null) {
            this._navigatorWindowPanel.setActiveNavigatorTabPanel(navigatorTabPanel);
        }
        this._windowManager.showNavigatorWindow();
    }

    public Navigator[] getAllNavigators() {
        return this._navigatorWindowPanel.getAllNavigators();
    }

    public void showTopic(Book book, String string) throws TopicDisplayException {
        this.showTopic(book, string, false);
    }

    public void showTopic(Book book, String string, boolean bl) throws TopicDisplayException {
        this.showTopic(book, string, bl, null, null);
    }

    public void showTopic(Book book, String string, boolean bl, Point point, Dimension dimension) throws TopicDisplayException {
        URL uRL;
        if (string != null) {
            uRL = this._library.mapIDToURL(string);
            if (uRL == null) {
                throw new TopicDisplayException("Cannot Display Topic: Topic ID " + string + " not found.");
            }
        } else {
            throw new TopicDisplayException("Cannot Display Topic:: Topic ID parameter was null");
        }
        SimpleURLTarget simpleURLTarget = new SimpleURLTarget(null, uRL.toString());
        SimpleTopic simpleTopic = new SimpleTopic(null, (Target)simpleURLTarget, null);
        this._windowManager.displayTopic((Topic)simpleTopic, bl, point, dimension);
    }

    public void showHelp(Object object, String string, Component component) {
        if (object == null) {
            object = this._defaultBook;
        }
        if (string == null) {
            string = this._defaultTopicID;
        }
        if (object == null || string == null) {
            this.showNavigatorWindow();
        } else {
            this.showTopic((Book)object, string);
        }
    }

    public void showHelp(Component component) {
        String string = null;
        Book book = null;
        if (component != null) {
            string = HelpUtils.getHelpID((Component)component);
            book = (Book)HelpUtils.getHelpSet((Component)component);
        }
        if (string == null) {
            this.showNavigatorWindow();
        } else {
            this.showTopic(book, string);
        }
    }

    public void setHelpOnHelp(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("Help::setHelpOnHelp() url parameter must be non-null");
        }
        SimpleURLTarget simpleURLTarget = new SimpleURLTarget(null, uRL.toString());
        SimpleTopic simpleTopic = new SimpleTopic("", (Target)simpleURLTarget, null);
        this._navigatorWindowPanel.setHelpOnHelpTopic((Topic)simpleTopic);
    }

    public void setHelpOnHelp(Book book, String string) {
        if (book == null || string == null) {
            throw new IllegalArgumentException("Help::setHelpOnHelp() both parameters must be non-null");
        }
        IndirectTarget indirectTarget = new IndirectTarget(book, string);
        SimpleTopic simpleTopic = new SimpleTopic("", (Target)indirectTarget, book);
        this._navigatorWindowPanel.setHelpOnHelpTopic((Topic)simpleTopic);
    }

    public void setDefaultBook(Book book) {
        this._defaultBook = book;
    }

    public void setDefaultTopicID(String string) {
        this._defaultTopicID = string;
    }

    public void dispose() {
        if (this._library != null) {
            this.removeAllBooks();
            this._library = null;
        }
        if (this._navigatorWindowPanel != null) {
            this._navigatorWindowPanel.removeNavigatorWindowListener(this);
            this._navigatorWindowPanel = null;
        }
        if (this._windowManager != null) {
            this._windowManager.dispose();
            this._windowManager = null;
        }
        this._defaultBook = null;
        this._defaultTopicID = null;
        this._tabPanels.clear();
        this._tabPanels = null;
    }

    public void topicSelected(NavigatorEvent navigatorEvent) {
    }

    public void topicActivated(NavigatorEvent navigatorEvent) {
        try {
            if (navigatorEvent.getTopic() != null) {
                Topic topic = navigatorEvent.getTopic();
                boolean bl = false;
                if (navigatorEvent.getMode() == 2) {
                    bl = true;
                }
                if (topic.hasTarget()) {
                    this._windowManager.displayTopic(topic, bl, null, null);
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public void enableFavoritesNavigator(URL uRL) {
        if (this._favoritesModel == null) {
            if (uRL == null) {
                throw new IllegalArgumentException("Null location for favorites.xml");
            }
            this._favoritesModel = new DefaultFavoritesModel(uRL, this._library);
            try {
                for (int i = 0; i < this._tabPanels.size(); ++i) {
                    NavigatorTabPanelInfo navigatorTabPanelInfo = (NavigatorTabPanelInfo)this._tabPanels.get(i);
                    FavoritesNavigator favoritesNavigator = (FavoritesNavigator)Navigator.createNavigator(FavoritesNavigator.class.getName(), null, null);
                    favoritesNavigator.setFavoritesModel(this._favoritesModel);
                    navigatorTabPanelInfo.tabPanel.addNavigator(favoritesNavigator);
                }
            }
            catch (NavigatorException navigatorException) {
                navigatorException.printStackTrace();
            }
            this._windowManager.setFavoritesModel(this._favoritesModel);
            this._addedFavNav = true;
        } else {
            System.err.println("Error: enableFavoritesNavigator invoked multiple times");
        }
    }

    private void _initHelpSystem(Class clazz, AppletContext appletContext, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this._defaultBook = null;
        this._defaultTopicID = null;
        this._useLabelInfo = bl2;
        this._dockedByDefault = bl4;
        this._combineBooks = bl;
        this._tabPanels = new ArrayList();
        this._library = new Library();
        this._navigatorWindowPanel = new DefaultNavigatorPanel();
        this._navigatorWindowPanel.addNavigatorWindowListener(this);
        if (clazz != null) {
            this._windowManager = new DefaultWindowManager(clazz, this._navigatorWindowPanel, this._library, bl3, bl4);
        } else if (appletContext != null) {
            this._windowManager = new AppletWindowManager(appletContext, string, this._navigatorWindowPanel, this._library);
        } else {
            throw new IllegalArgumentException("ERROR:  Must have non-null htmlBrowserClass or appletContext to instantiate Help object.");
        }
    }

    private void _createNavigatorsForBook(Book book) {
        int n;
        Object object;
        if (book == null) {
            return;
        }
        View[] viewArray = book.getAllViews();
        if (viewArray == null) {
            return;
        }
        NavigatorTabPanel navigatorTabPanel = null;
        if (this._combineBooks) {
            if (this._tabPanels.size() > 0) {
                object = (NavigatorTabPanelInfo)this._tabPanels.get(0);
                navigatorTabPanel = ((NavigatorTabPanelInfo)object).tabPanel;
            }
        } else {
            for (n = 0; n < this._tabPanels.size() && navigatorTabPanel == null; ++n) {
                object = (NavigatorTabPanelInfo)this._tabPanels.get(n);
                if (((NavigatorTabPanelInfo)object).book != book) continue;
                navigatorTabPanel = ((NavigatorTabPanelInfo)object).tabPanel;
            }
        }
        if (navigatorTabPanel == null) {
            navigatorTabPanel = new NavigatorTabPanel();
            this._navigatorWindowPanel.addNavigatorTabPanel(navigatorTabPanel, book.getBookTitle());
            this._tabPanels.add(new NavigatorTabPanelInfo(navigatorTabPanel, book));
        }
        for (n = 0; n < viewArray.length; ++n) {
            object = viewArray[n];
            this._createNavigatorForView(navigatorTabPanel, (View)object);
        }
        if (!(this._favoritesModel == null || this._combineBooks && this._addedFavNav)) {
            try {
                object = (FavoritesNavigator)Navigator.createNavigator(FavoritesNavigator.class.getName(), null, null);
                ((FavoritesNavigator)object).setFavoritesModel(this._favoritesModel);
                navigatorTabPanel.addNavigator((Navigator)object);
                this._addedFavNav = true;
            }
            catch (NavigatorException navigatorException) {
                navigatorException.printStackTrace();
            }
        }
    }

    private void _createNavigatorForView(NavigatorTabPanel navigatorTabPanel, View view) {
        Object object;
        if (view == null) {
            return;
        }
        Object object2 = null;
        Navigator[] navigatorArray = navigatorTabPanel.getNavigators();
        if (navigatorArray != null) {
            for (int i = 0; object2 == null && i < navigatorArray.length; ++i) {
                object = navigatorArray[i];
                if (!((Navigator)object).getType().equals(view.getType())) continue;
                if (this._useLabelInfo) {
                    if (((Navigator)object).getLabel() != null) {
                        if (!((Navigator)object).getLabel().equals(view.getLabel())) continue;
                        object2 = object;
                        continue;
                    }
                    if (view.getLabel() != null) continue;
                    object2 = object;
                    continue;
                }
                object2 = object;
            }
        }
        if (object2 == null) {
            object = null;
            Image image = null;
            if (this._useLabelInfo) {
                object = view.getLabel();
            }
            if (view.getLabelImage() != null) {
                try {
                    URL uRL = view.getLabelImage().getURL();
                    if (uRL != null) {
                        image = ImageLoader.loadImage(uRL);
                    }
                }
                catch (Exception exception) {
                    image = null;
                }
            }
            try {
                object2 = Navigator.createNavigator(view.getType(), (String)object, image);
                navigatorTabPanel.addNavigator((Navigator)object2);
            }
            catch (Exception exception) {
                System.err.println("Could Not Create Navigator " + exception.getMessage());
                exception.printStackTrace();
                return;
            }
        }
        object2.addView(view);
    }

    private class NavigatorTabPanelInfo {
        public NavigatorTabPanel tabPanel;
        public Book book;

        public NavigatorTabPanelInfo(NavigatorTabPanel navigatorTabPanel, Book book) {
            this.tabPanel = navigatorTabPanel;
            this.book = book;
        }
    }
}

