/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.ResourceBundle;
import oracle.help.Help;
import oracle.help.library.Book;
import oracle.help.navigator.Navigator;

public class CSHManager {
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String POPUP_TEXT = "cshmanager.popuptext";
    private Help _help;
    private String _popupText;
    private Book _defaultBook;
    private Hashtable _topicTable;
    private HelpKeyListener _helpKeyListener;
    private HelpMouseListener _helpMouseListener;

    public CSHManager(Help help) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, Help.getHelpLocale());
        this._popupText = resourceBundle.getString(POPUP_TEXT);
        this._help = help;
        this._helpKeyListener = new HelpKeyListener();
        this._helpMouseListener = new HelpMouseListener();
        this._topicTable = new Hashtable();
    }

    public void setDefaultBook(Book book) {
        this._defaultBook = book;
    }

    public void addBook(Book book, boolean bl) {
        this._help.addBook(book);
        if (bl) {
            this._defaultBook = book;
        }
    }

    public void removeBook(Book book) {
        this._help.removeBook(book);
    }

    public void showNavigatorWindow() {
        this._help.showNavigatorWindow();
    }

    public void showNavigatorWindow(Navigator navigator) {
        if (navigator != null) {
            this._help.showNavigatorWindow(navigator);
        }
    }

    public void showNavigatorWindow(Book book) {
        this._help.showNavigatorWindow(book);
    }

    public Navigator[] getAllNavigators() {
        return this._help.getAllNavigators();
    }

    public void addComponent(Component component, String string) {
        if (this._defaultBook != null) {
            this.addComponent(component, this._defaultBook, string);
        }
    }

    public void addComponent(Component component, Book book, String string) {
        this.addComponent(component, book, string, false, false);
    }

    public void addComponent(Component component, String string, boolean bl, boolean bl2) {
        if (this._defaultBook != null) {
            this.addComponent(component, this._defaultBook, string, bl, bl2);
        }
    }

    public void addComponent(Component component, Book book, String string, boolean bl, boolean bl2) {
        TopicInfo topicInfo;
        if (bl) {
            component.addKeyListener(this._helpKeyListener);
        }
        if (bl2) {
            component.addMouseListener(this._helpMouseListener);
        }
        if ((topicInfo = (TopicInfo)this._topicTable.get(component)) != null) {
            this._topicTable.remove(component);
        }
        this._topicTable.put(component, new TopicInfo(book, string));
    }

    public void removeComponent(Component component) {
        if (component != null) {
            try {
                component.removeKeyListener(this._helpKeyListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                component.removeMouseListener(this._helpMouseListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._topicTable.remove(component);
        }
    }

    public void showHelpForComponent(Component component) {
        TopicInfo topicInfo = this._findTopicInfo(component);
        if (topicInfo != null) {
            this._help.showTopic(topicInfo.book, topicInfo.topicId);
        }
    }

    public void showTopic(String string) {
        this._help.showTopic(this._defaultBook, string);
    }

    protected Help getHelpObject() {
        return this._help;
    }

    private TopicInfo _findTopicInfo(Component component) {
        if (component == null) {
            return null;
        }
        TopicInfo topicInfo = (TopicInfo)this._topicTable.get(component);
        if (topicInfo != null) {
            return topicInfo;
        }
        return this._findTopicInfo(component.getParent());
    }

    private class TopicInfo {
        public Book book;
        public String topicId;

        public TopicInfo(Book book, String string) {
            this.book = book;
            this.topicId = string;
        }
    }

    private class HelpMouseListener
    extends MouseAdapter
    implements ActionListener {
        private PopupMenu _popup;
        private Component _component;

        public HelpMouseListener() {
            MenuItem menuItem = new MenuItem(CSHManager.this._popupText);
            menuItem.addActionListener(this);
            this._popup = new PopupMenu();
            this._popup.add(menuItem);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this._component = (Component)mouseEvent.getSource();
                if (this._popup.getParent() != null) {
                    this._popup.getParent().remove(this._popup);
                }
                this._component.add(this._popup);
                this._popup.addNotify();
                this._popup.show(this._component, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this._component = (Component)mouseEvent.getSource();
                if (this._popup.getParent() != null) {
                    this._popup.getParent().remove(this._popup);
                }
                this._component.add(this._popup);
                this._popup.addNotify();
                this._popup.show(this._component, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this._component = (Component)mouseEvent.getSource();
                if (this._popup.getParent() != null) {
                    this._popup.getParent().remove(this._popup);
                }
                this._component.add(this._popup);
                this._popup.addNotify();
                this._popup.show(this._component, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CSHManager.this.showHelpForComponent(this._component);
            this._popup.getParent().remove(this._popup);
        }
    }

    private class HelpKeyListener
    extends KeyAdapter {
        private HelpKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 112) {
                CSHManager.this.showHelpForComponent((Component)keyEvent.getSource());
                keyEvent.consume();
            }
        }
    }
}

