/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.util;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.LightweightPeer;
import oracle.ewt.UIDefaults;
import oracle.ewt.laf.basic.BasicLookAndFeel;
import oracle.ewt.lwAWT.VirtualComponent;
import oracle.ewt.util.FocusUtils;

public class WindowUtils {
    private static WindowCloser _sWindowCloser;
    private static Frame _sSharedOwnerFrame;

    public static Window getActiveWindow() {
        return ActiveWindowTracker.getWindowTracker().getActiveWindow();
    }

    public static void registerApplet(Applet applet) {
        ActiveWindowTracker.getWindowTracker().registerApplet(applet);
    }

    public static void unregisterApplet(Applet applet) {
        ActiveWindowTracker.getWindowTracker().unregisterApplet(applet);
    }

    public static void registerWindow(Window window) {
        window.addWindowListener(ActiveWindowTracker.getWindowTracker());
    }

    public static void unregisterWindow(Window window) {
        window.removeWindowListener(ActiveWindowTracker.getWindowTracker());
    }

    public static Window getWindow(Component component) {
        while (component != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static Component getFocusOwner(Window window) {
        if (window == null) {
            return null;
        }
        Component component = window.getFocusOwner();
        if (component == null && WindowUtils.getActiveWindow() == window) {
            component = FocusUtils.getMostRecentFocusOwner(window);
        }
        return component;
    }

    public static Frame parentFrame(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static void centerWindow(Window window) {
        int n;
        Dimension dimension = window.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = (dimension2.width - dimension.width) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = (dimension2.height - dimension.height) / 2) < 0) {
            n = 0;
        }
        window.setLocation(n2, n);
    }

    public static WindowListener getWindowCloser() {
        if (_sWindowCloser == null) {
            _sWindowCloser = new WindowCloser();
        }
        return _sWindowCloser;
    }

    public static void centerWindow(Window window, Component component) {
        if (component == null || !component.isShowing()) {
            WindowUtils.centerWindow(window);
            return;
        }
        Point point = component.getLocationOnScreen();
        Dimension dimension = component.getSize();
        Dimension dimension2 = window.getSize();
        int n = point.x + (dimension.width - dimension2.width) / 2;
        int n2 = point.y + (dimension.height - dimension2.height) / 3;
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        if (n + dimension2.width > dimension3.width) {
            n = dimension3.width - dimension2.width;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 + dimension2.height > dimension3.height) {
            n2 = dimension3.height - dimension2.height;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        window.setLocation(n, n2);
    }

    public static Frame getSharedOwnerFrame() {
        if (_sSharedOwnerFrame == null) {
            _sSharedOwnerFrame = new Frame();
        }
        return _sSharedOwnerFrame;
    }

    private static class WindowCloser
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            windowEvent.getWindow().hide();
        }
    }

    private static class ActiveWindowTracker
    extends WindowAdapter {
        private static ActiveWindowTracker _sWindowTracker;
        private boolean _receivingAppletActivates = false;
        private Window _activeWindow;
        private Applet _applet;
        private Frame _appletFrame;

        private ActiveWindowTracker() {
        }

        static ActiveWindowTracker getWindowTracker() {
            if (_sWindowTracker == null) {
                _sWindowTracker = new ActiveWindowTracker();
            }
            return _sWindowTracker;
        }

        public void windowActivated(WindowEvent windowEvent) {
            Window window;
            Window window2 = windowEvent.getWindow();
            if (window2 == this._appletFrame) {
                this._receivingAppletActivates = true;
            }
            if ((window = this._activeWindow) != window2) {
                this._activeWindow = window2;
                this._repaint(window2);
                if (!this._receivingAppletActivates && window == null && this._appletFrame != null) {
                    this._repaint(this._appletFrame);
                }
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            Applet applet;
            Window window = windowEvent.getWindow();
            if (window == this._appletFrame) {
                this._receivingAppletActivates = true;
            }
            if (window == this._activeWindow) {
                this._activeWindow = null;
            }
            this._repaint(window);
            if (!this._receivingAppletActivates && (applet = this._applet) != null) {
                applet.repaint(200L);
            }
        }

        public Window getActiveWindow() {
            if (!this._receivingAppletActivates && this._activeWindow == null) {
                return this._appletFrame;
            }
            return this._activeWindow;
        }

        public void registerApplet(Applet applet) {
            Frame frame;
            this._applet = applet;
            this._appletFrame = frame = WindowUtils.parentFrame(applet);
            WindowUtils.registerWindow(frame);
        }

        public void unregisterApplet(Applet applet) {
            if (this._applet == applet) {
                WindowUtils.unregisterWindow(this._appletFrame);
                this._applet = null;
                this._appletFrame = null;
            }
        }

        private void _repaint(Container container) {
            if (container instanceof VirtualComponent) {
                UIDefaults uIDefaults = ((VirtualComponent)((Object)container)).getUIDefaults();
                if (uIDefaults.get(BasicLookAndFeel.WINDOW_ACTIVATION_REPAINTING) == Boolean.TRUE) {
                    this._definitelyRepaint(container);
                }
            } else {
                Component[] componentArray = container.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    Component component = componentArray[i];
                    if (!(component instanceof Container)) continue;
                    this._repaint((Container)component);
                }
            }
        }

        private void _definitelyRepaint(Container container) {
            container.repaint();
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (component.getPeer() instanceof LightweightPeer) continue;
                if (component instanceof Container) {
                    this._definitelyRepaint((Container)component);
                    continue;
                }
                component.repaint();
            }
        }
    }
}

