/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.util;

import java.awt.Component;
import java.awt.Container;
import oracle.ewt.ColorScheme;
import oracle.ewt.LookAndFeel;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.VirtualComponent;
import oracle.ewt.lwAWT.lwMenu.LWMenu;

public class LookAndFeelUtils {
    private LookAndFeelUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setComponentTreeLookAndFeel(Component component, LookAndFeel lookAndFeel) {
        if (component instanceof Container) {
            LWComponent lWComponent = component instanceof LWComponent ? (LWComponent)component : null;
            try {
                if (lWComponent != null) {
                    lWComponent.freezeRepaints();
                }
                LookAndFeelUtils._propagateLookAndFeel((Container)component, lookAndFeel);
                component.validate();
            }
            finally {
                if (lWComponent != null) {
                    lWComponent.unfreezeRepaints();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setComponentTreeColorScheme(Component component, ColorScheme colorScheme) {
        if (component instanceof Container) {
            LWComponent lWComponent = component instanceof LWComponent ? (LWComponent)component : null;
            try {
                if (lWComponent != null) {
                    lWComponent.freezeRepaints();
                }
                LookAndFeelUtils._propagateColorScheme((Container)component, colorScheme);
                component.validate();
            }
            finally {
                if (lWComponent != null) {
                    lWComponent.unfreezeRepaints();
                }
            }
        }
    }

    private static void _propagateColorScheme(Container container, ColorScheme colorScheme) {
        Object object;
        if (container instanceof VirtualComponent) {
            ((VirtualComponent)((Object)container)).setColorScheme(colorScheme);
            if (container instanceof LWMenu && (object = ((LWMenu)container).getSubMenu()) != null) {
                LookAndFeelUtils._propagateColorScheme((Container)object, colorScheme);
            }
        }
        object = container.getComponents();
        for (int i = 0; i < ((Component[])object).length; ++i) {
            Component component = object[i];
            if (!(component instanceof Container)) continue;
            LookAndFeelUtils._propagateColorScheme((Container)component, colorScheme);
        }
    }

    private static void _propagateLookAndFeel(Container container, LookAndFeel lookAndFeel) {
        Object object;
        if (container instanceof VirtualComponent) {
            ((VirtualComponent)((Object)container)).setLookAndFeel(lookAndFeel);
            if (container instanceof LWMenu && (object = ((LWMenu)container).getSubMenu()) != null) {
                LookAndFeelUtils._propagateLookAndFeel((Container)object, lookAndFeel);
            }
        }
        object = container.getComponents();
        for (int i = 0; i < ((Component[])object).length; ++i) {
            Component component = object[i];
            if (!(component instanceof Container)) continue;
            LookAndFeelUtils._propagateLookAndFeel((Container)component, lookAndFeel);
        }
    }
}

