/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import oracle.bali.share.util.BooleanUtils;

public final class FocusUtils {
    private static boolean _sJDK14orHigher = false;
    private static Method _sSetFocusTraversalKeysEnabled;
    private static Method _sIsFocusable;
    private static Method _sSetFocusable;
    private static Method _sFocusEventOppComp;

    public static final boolean areNewFocusAPIsAvailable() {
        return _sJDK14orHigher;
    }

    public static final Component getMostRecentFocusOwner(Window window) {
        Component component = null;
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method method = Window.class.getMethod("getMostRecentFocusOwner", null);
                component = (Component)method.invoke((Object)window, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return component;
    }

    public static final void transferFocus(Component component, boolean bl) {
        boolean bl2 = bl;
        if (!bl) {
            if (FocusUtils.areNewFocusAPIsAvailable()) {
                try {
                    Class<?> clazz = component.getClass();
                    Method method = clazz.getMethod("transferFocusBackward", null);
                    method.invoke((Object)component, (Object[])null);
                }
                catch (Exception exception) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
        }
        if (bl2) {
            component.transferFocus();
        }
    }

    public static final void installDefaultKeyboardNavigation() {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Class<?> clazz = Class.forName("java.awt.AWTKeyStroke");
                Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
                Method method = clazz.getMethod("getAWTKeyStroke", classArray);
                Object[] objectArray = new Object[]{new Integer(9), new Integer(0)};
                Object object = method.invoke(null, objectArray);
                Object[] objectArray2 = new Object[]{new Integer(9), new Integer(1)};
                Object object2 = method.invoke(null, objectArray2);
                Class<?> clazz2 = Class.forName("java.util.TreeSet");
                Class[] classArray2 = new Class[]{Object.class};
                Method method2 = clazz2.getMethod("add", classArray2);
                Object obj = clazz2.newInstance();
                method2.invoke(obj, object);
                Object obj2 = clazz2.newInstance();
                method2.invoke(obj2, object2);
                Class<?> clazz3 = Class.forName("java.awt.KeyboardFocusManager");
                Class<?> clazz4 = Class.forName("java.util.Set");
                Class[] classArray3 = new Class[]{Integer.TYPE, clazz4};
                Method method3 = clazz3.getMethod("setDefaultFocusTraversalKeys", classArray3);
                Method method4 = clazz3.getMethod("getCurrentKeyboardFocusManager", null);
                Object object3 = method4.invoke(null, (Object[])null);
                Object[] objectArray3 = new Object[]{new Integer(0), obj};
                method3.invoke(object3, objectArray3);
                Object[] objectArray4 = new Object[]{new Integer(1), obj2};
                method3.invoke(object3, objectArray4);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static final void setFocusTraversalKeysEnabled(Component component, boolean bl) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method method = FocusUtils._getFocusTraversalMethod();
                Object[] objectArray = new Object[]{new Boolean(bl)};
                method.invoke((Object)component, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setFocusTraversalKeysEnabled(Component component, boolean bl, boolean bl2) {
        FocusUtils.setFocusTraversalKeysEnabled(component, bl);
        if (bl2 && FocusUtils.areNewFocusAPIsAvailable() && component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                FocusUtils.setFocusTraversalKeysEnabled(container.getComponent(i), bl, bl2);
            }
        }
    }

    public static final void disableDefaultKeyboardNavigation() {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Class<?> clazz = Class.forName("java.util.Collections");
                Field field = clazz.getField("EMPTY_SET");
                Object object = field.get(null);
                Class<?> clazz2 = Class.forName("java.awt.KeyboardFocusManager");
                Class<?> clazz3 = Class.forName("java.util.Set");
                Class[] classArray = new Class[]{Integer.TYPE, clazz3};
                Method method = clazz2.getMethod("setDefaultFocusTraversalKeys", classArray);
                Method method2 = clazz2.getMethod("getCurrentKeyboardFocusManager", null);
                Object object2 = method2.invoke(null, (Object[])null);
                Object[] objectArray = new Object[]{new Integer(0), object};
                method.invoke(object2, objectArray);
                Object[] objectArray2 = new Object[]{new Integer(1), object};
                method.invoke(object2, objectArray2);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setDefaultFocusTraversalKeys(Component component, boolean bl) {
        FocusUtils.setDefaultFocusTraversalKeys(component);
        if (bl && FocusUtils.areNewFocusAPIsAvailable() && component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                FocusUtils.setDefaultFocusTraversalKeys(container.getComponent(i), bl);
            }
        }
    }

    public static final void setDefaultFocusTraversalKeys(Component component) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Class<?> clazz = Class.forName("java.awt.Component");
                Class<?> clazz2 = Class.forName("java.util.Set");
                Class<?> clazz3 = Class.forName("java.awt.KeyboardFocusManager");
                Class<?> clazz4 = Class.forName("java.awt.AWTKeyStroke");
                Class<?> clazz5 = Class.forName("java.util.TreeSet");
                Class<?> clazz6 = Class.forName("java.awt.event.InputEvent");
                Class[] classArray = new Class[]{Integer.TYPE, clazz2};
                Class[] classArray2 = new Class[]{Integer.TYPE, Integer.TYPE};
                Class[] classArray3 = new Class[]{Object.class};
                Method method = clazz.getMethod("setFocusTraversalKeys", classArray);
                Method method2 = clazz4.getMethod("getAWTKeyStroke", classArray2);
                Method method3 = clazz5.getMethod("add", classArray3);
                Field field = clazz3.getField("FORWARD_TRAVERSAL_KEYS");
                Field field2 = clazz3.getField("BACKWARD_TRAVERSAL_KEYS");
                Field field3 = clazz6.getField("SHIFT_DOWN_MASK");
                Object obj = clazz5.newInstance();
                Object obj2 = clazz5.newInstance();
                Object object = field.get(null);
                Object object2 = field2.get(null);
                Object object3 = field3.get(null);
                Object[] objectArray = new Object[]{new Integer(9), new Integer(0)};
                Object[] objectArray2 = new Object[]{new Integer(9), object3};
                Object object4 = method2.invoke(null, objectArray);
                Object object5 = method2.invoke(null, objectArray2);
                method3.invoke(obj, object4);
                method3.invoke(obj2, object5);
                Object[] objectArray3 = new Object[]{object, obj};
                Object[] objectArray4 = new Object[]{object2, obj2};
                method.invoke((Object)component, objectArray3);
                method.invoke((Object)component, objectArray4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setDefaultFocusTraversalPolicy(Container container) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Class<?> clazz = Class.forName("java.awt.Container");
                Method method = clazz.getMethod("getFocusTraversalPolicy", null);
                Class<?> clazz2 = Class.forName("java.awt.DefaultFocusTraversalPolicy");
                Object object = method.invoke((Object)container, (Object[])null);
                if (!clazz2.isInstance(object)) {
                    Class[] classArray = new Class[]{Class.forName("java.awt.FocusTraversalPolicy")};
                    Method method2 = clazz.getMethod("setFocusTraversalPolicy", classArray);
                    Object[] objectArray = new Object[]{clazz2.newInstance()};
                    method2.invoke((Object)container, objectArray);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final boolean isFocusable(Component component) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method method = FocusUtils._getIsFocusableMethod();
                Object object = method.invoke((Object)component, (Object[])null);
                return Boolean.TRUE.equals(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return component.isFocusTraversable();
    }

    public static final void setFocusable(Component component, boolean bl) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method method = FocusUtils._getSetFocusableMethod();
                Object[] objectArray = new Object[]{BooleanUtils.getBoolean((boolean)bl)};
                Object object = method.invoke((Object)component, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Component getOppositeComponent(FocusEvent focusEvent) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method method = FocusUtils._getFocusEventOppCompMethod();
                return (Component)method.invoke((Object)focusEvent, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Method _getFocusTraversalMethod() {
        if (_sSetFocusTraversalKeysEnabled == null) {
            try {
                Class<Component> clazz = Component.class;
                Class[] classArray = new Class[]{Boolean.TYPE};
                _sSetFocusTraversalKeysEnabled = clazz.getMethod("setFocusTraversalKeysEnabled", classArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sSetFocusTraversalKeysEnabled;
    }

    private static Method _getIsFocusableMethod() {
        if (_sIsFocusable == null) {
            try {
                Class<Component> clazz = Component.class;
                _sIsFocusable = clazz.getMethod("isFocusable", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sIsFocusable;
    }

    private static Method _getSetFocusableMethod() {
        if (_sSetFocusable == null) {
            try {
                Class<Component> clazz = Component.class;
                Class[] classArray = new Class[]{Boolean.TYPE};
                _sSetFocusable = clazz.getMethod("setFocusable", classArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sSetFocusable;
    }

    private static Method _getFocusEventOppCompMethod() {
        if (_sFocusEventOppComp == null) {
            try {
                Class<FocusEvent> clazz = FocusEvent.class;
                _sFocusEventOppComp = clazz.getMethod("getOppositeComponent", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sFocusEventOppComp;
    }

    private FocusUtils() {
    }

    static {
        try {
            Class<?> clazz = Class.forName("java.awt.KeyboardFocusManager");
            _sJDK14orHigher = true;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _sSetFocusTraversalKeysEnabled = null;
        _sIsFocusable = null;
        _sSetFocusable = null;
        _sFocusEventOppComp = null;
    }
}

