/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.util;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.lang.reflect.Method;
import oracle.ewt.util.FocusUtils;

public class ClipboardProxy {
    private static final String EWT_CLIPBOARD_NAME = "EWT non-System";
    private static Clipboard _sClipboard;
    private static Clipboard _sPrivateClipboard;

    public static Clipboard getSystemClipboard() {
        if (_sClipboard == null) {
            SecurityManager securityManager = System.getSecurityManager();
            try {
                _sClipboard = securityManager != null ? (securityManager.checkTopLevelWindow(new Frame()) ? Toolkit.getDefaultToolkit().getSystemClipboard() : ClipboardProxy._getPrivateClipboard()) : Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (Exception exception) {
                _sClipboard = ClipboardProxy._getPrivateClipboard();
            }
        }
        return _sClipboard;
    }

    public static boolean isSystemClipboard(Clipboard clipboard) {
        if (clipboard == ClipboardProxy.getSystemClipboard()) {
            return _sPrivateClipboard == null;
        }
        return false;
    }

    public static Clipboard getSystemSelection(Toolkit toolkit) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method method = Toolkit.class.getMethod("getSystemSelection", null);
                Clipboard clipboard = (Clipboard)method.invoke((Object)toolkit, (Object[])null);
                return clipboard;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private ClipboardProxy() {
    }

    private static Clipboard _getPrivateClipboard() {
        if (_sPrivateClipboard == null) {
            _sPrivateClipboard = new Clipboard(EWT_CLIPBOARD_NAME);
        }
        return _sPrivateClipboard;
    }
}

