/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.PaintContextProxy;
import oracle.ewt.toolBar.ToolBar;

public abstract class ToolBarItem
extends PaintContextProxy
implements Accessible {
    public static final int ID_UNSPECIFIED = -1;
    private int _id = -1;
    private AccessibleContext _accessibleContext;

    public void setID(int n) {
        this._id = n;
    }

    public int getID() {
        return this._id;
    }

    protected abstract void setParent(ToolBar var1);

    public abstract ToolBar getParent();

    public abstract void setLocation(int var1, int var2);

    public abstract Point getLocation();

    public abstract Dimension getSize();

    public abstract Dimension getPreferredSize();

    public abstract Dimension getMinimumSize();

    public abstract void setSize(int var1, int var2);

    public abstract void storeSize(int var1, int var2);

    public abstract boolean inside(int var1, int var2);

    public abstract boolean isVisible();

    public abstract void setVisible(boolean var1);

    public abstract boolean isEnabled();

    public abstract void setEnabled(boolean var1);

    public boolean mouseEntered(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    public boolean mouseExited(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    public boolean mouseMoved(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    public boolean mousePressed(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    public boolean mouseReleased(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    public boolean mouseDragged(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    public void paint(Graphics graphics) {
    }

    public String getHelpText() {
        return null;
    }

    public void setHelpText(String string) {
    }

    public abstract Component getComponent();

    public int getPaintState() {
        int n = super.getPaintState() & 0x15;
        if (!this.isEnabled()) {
            n |= 1;
        }
        return n;
    }

    public Object getPaintData(Object object) {
        return null;
    }

    public final AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = this.createAccessibleContext();
        }
        return this._accessibleContext;
    }

    protected final AccessibleContext accessAccessibleContext() {
        return this._accessibleContext;
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    protected PaintContext getPaintContext() {
        ToolBar toolBar = this.getParent();
        if (toolBar != null) {
            return toolBar.getPaintContext();
        }
        return null;
    }

    public class Access
    extends AccessibleContext
    implements AccessibleComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SEPARATOR;
        }

        public String getAccessibleName() {
            Object object;
            String string = this.accessibleName;
            if (string == null && (object = ToolBarItem.this.getPaintData(PaintContext.LABEL_KEY)) instanceof String) {
                string = (String)object;
            }
            return string;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = this.getAccessibleParent().getAccessibleContext().getAccessibleStateSet();
            if (!this.isVisible()) {
                accessibleStateSet.remove(AccessibleState.VISIBLE);
                accessibleStateSet.remove(AccessibleState.SHOWING);
            }
            if (!this.isEnabled()) {
                accessibleStateSet.remove(AccessibleState.ENABLED);
            }
            return accessibleStateSet;
        }

        public Accessible getAccessibleParent() {
            return ToolBarItem.this.getParent();
        }

        public int getAccessibleIndexInParent() {
            return ToolBarItem.this.getParent().getItemIndex(ToolBarItem.this);
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return ToolBarItem.this.getParent().getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return ToolBarItem.this.getPaintBackground();
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            return ToolBarItem.this.getPaintForeground();
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            Cursor cursor = ToolBarItem.this.getParent().getCursor();
            if (cursor == null) {
                cursor = Cursor.getDefaultCursor();
            }
            return cursor;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return ToolBarItem.this.getPaintFont();
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return ToolBarItem.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return (ToolBarItem.this.getPaintState() & 1) == 0;
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isVisible() {
            return ToolBarItem.this.isVisible();
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return this.isVisible() && ToolBarItem.this.getParent().isShowing();
        }

        public boolean contains(Point point) {
            Point point2 = this.getLocation();
            return ToolBarItem.this.inside(point.x + point2.x, point.y + point2.y);
        }

        public Point getLocationOnScreen() {
            if (this.isShowing()) {
                ToolBar toolBar = ToolBarItem.this.getParent();
                Point point = toolBar.getLocationOnScreen();
                Point point2 = this.getLocation();
                point.x += point2.x;
                point.y += point2.y;
                point.translate(toolBar.getCanvasOriginX(), toolBar.getCanvasOriginY());
                return point;
            }
            return null;
        }

        public Point getLocation() {
            Point point = ToolBarItem.this.getLocation();
            point = ToolBarItem.this.getParent().convertInteriorToOuter(point.x, point.y);
            return point;
        }

        public void setLocation(Point point) {
        }

        public Rectangle getBounds() {
            if (!this.isShowing()) {
                return null;
            }
            return new Rectangle(this.getLocation(), this.getSize());
        }

        public void setBounds(Rectangle rectangle) {
        }

        public Dimension getSize() {
            return ToolBarItem.this.getSize();
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public void removeFocusListener(FocusListener focusListener) {
        }
    }
}

