/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import oracle.ewt.layout.DirectionalLayout;
import oracle.ewt.table.TableScrollBox;

final class TableScrollBoxLayout
implements LayoutManager,
DirectionalLayout {
    private Component _hscroll;
    private Component _vscroll;
    private Component _center;

    public void addLayoutComponent(String string, Component component) {
        if ("Hscroll".equals(string)) {
            this._hscroll = component;
        } else if ("Vscroll".equals(string)) {
            this._vscroll = component;
        } else if ("Center".equals(string)) {
            this._center = component;
        }
    }

    public final void removeLayoutComponent(Component component) {
        if (component == this._hscroll) {
            this._hscroll = null;
        } else if (component == this._vscroll) {
            this._vscroll = null;
        } else if (component == this._center) {
            this._center = null;
        }
    }

    public final Dimension preferredLayoutSize(Container container) {
        Cloneable cloneable;
        Dimension dimension = new Dimension(0, 0);
        if (this._center != null) {
            cloneable = this._center.getPreferredSize();
            dimension.width = cloneable.width;
            dimension.height = cloneable.height;
        }
        if (this._hscroll != null) {
            cloneable = this._hscroll.getPreferredSize();
            dimension.height += cloneable.height;
            dimension.width = Math.max(cloneable.width, dimension.width);
        }
        if (this._vscroll != null) {
            cloneable = this._vscroll.getPreferredSize();
            dimension.width += cloneable.width;
            dimension.height = Math.max(cloneable.height, dimension.height);
        }
        cloneable = container.getInsets();
        dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
        dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
        return dimension;
    }

    public final Dimension minimumLayoutSize(Container container) {
        Cloneable cloneable;
        Dimension dimension = new Dimension(0, 0);
        if (this._center != null) {
            cloneable = this._center.getMinimumSize();
            dimension.width = cloneable.width;
            dimension.height = cloneable.height;
        }
        if (this._hscroll != null) {
            cloneable = this._hscroll.getMinimumSize();
            dimension.height += cloneable.height;
            dimension.width = Math.max(cloneable.width, dimension.width);
        }
        if (this._vscroll != null) {
            cloneable = this._vscroll.getMinimumSize();
            dimension.width += cloneable.width;
            dimension.height = Math.max(cloneable.height, dimension.height);
        }
        cloneable = container.getInsets();
        dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
        dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
        return dimension;
    }

    public final void layoutContainer(Container container) {
        int n;
        Dimension dimension = container.getSize();
        TableScrollBox tableScrollBox = (TableScrollBox)container;
        tableScrollBox.setScrollBars(this._hscroll, this._vscroll);
        Dimension dimension2 = new Dimension(0, 0);
        Dimension dimension3 = new Dimension(0, 0);
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        if (tableScrollBox.isHScrollbarVisible()) {
            dimension2 = this._hscroll.getPreferredSize();
        }
        if (tableScrollBox.isVScrollbarVisible()) {
            dimension3 = this._vscroll.getPreferredSize();
        }
        boolean bl = tableScrollBox.getActualReadingDirection() == 1;
        int n2 = 0;
        int n3 = 0;
        if (this._center != null) {
            n2 = dimension.width - dimension3.width;
            n3 = dimension.height - dimension2.height;
            if (bl) {
                this._center.setBounds(insets.left, insets.top, n2, n3);
            } else {
                this._center.setBounds(insets.left + dimension3.width, insets.top, n2, n3);
            }
        }
        if (tableScrollBox.isHScrollbarVisible()) {
            n = tableScrollBox.getHScrollbarOffset() + 1;
            if (bl) {
                this._hscroll.setBounds(insets.left + n, insets.top + n3, n2 - n, dimension2.height);
            } else {
                this._hscroll.setBounds(insets.left + dimension3.width, insets.top + n3, n2 - n, dimension2.height);
            }
        }
        if (tableScrollBox.isVScrollbarVisible()) {
            n = tableScrollBox.getVScrollbarOffset() + 1;
            if (bl) {
                this._vscroll.setBounds(insets.left + n2, insets.top + n, dimension3.width, n3 - n);
            } else {
                this._vscroll.setBounds(insets.left, insets.top + n, dimension3.width, n3 - n);
            }
        }
    }
}

