/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.tabPanel;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import oracle.ewt.ColorScheme;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.event.Cancelable;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.help.HelpCapable;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.tabBar.TabBar;
import oracle.ewt.tabBar.TabBarEvent;
import oracle.ewt.tabBar.TabBarItem;
import oracle.ewt.tabBar.TabBarListener;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.ewt.tabPanel.TabPanelSheet;
import oracle.ewt.tabPanel.TabPanelValidateEvent;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;

public class TabPanel
extends LWComponent
implements TabBarListener {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int START = 4;
    public static final int END = 5;
    private static final int _SHOW_PANEL_DELAY = 200;
    private TabPanelSheet _sheet;
    private TabBar _tabBar;
    private Vector _pagePack;
    private TabPanelPage _selectedPage;
    private ListenerManager _listeners;
    private Task _showTask;
    private boolean _isContentBackgroundSet;
    private static int _sInstanceCounter;
    private static TaskScheduler _sTaskScheduler;

    public TabPanel() {
        this.setLayout(new BorderLayout());
        TabBar tabBar = new TabBar();
        tabBar.setAlignment(this.getAlignment());
        this._tabBar = tabBar;
        this._pagePack = new Vector();
        this._sheet = new TabPanelSheet(this);
        this.setOrientation(0);
        this.add("North", this._tabBar);
        this.add("Center", this._sheet);
        tabBar.addTabBarListener(this);
        this.updateUI(TabPanel.class);
    }

    public Object getUIClassID() {
        return "TabbedPaneUI";
    }

    public final TabPanelPage addPage(String string, Component component) {
        return this.addPage(string, component, null, false);
    }

    public final TabPanelPage addPage(String string, Component component, TabPanelPage tabPanelPage, boolean bl) {
        TabPanelPage tabPanelPage2 = new TabPanelPage(component, string);
        if (bl) {
            tabPanelPage2.setVisible(false);
        }
        return this.addPage(tabPanelPage2, tabPanelPage);
    }

    public final TabPanelPage addPage(TabPanelPage tabPanelPage) {
        return this.addPage(tabPanelPage, null);
    }

    public TabPanelPage addPage(TabPanelPage tabPanelPage, TabPanelPage tabPanelPage2) {
        TabBar tabBar = this.getTabBar();
        if (tabPanelPage.getParent() != null) {
            tabPanelPage.getParent().removePage(tabPanelPage);
        }
        Component component = tabPanelPage.getContent();
        component.setVisible(false);
        this._sheet.add(component);
        if (tabPanelPage2 == null) {
            this._pagePack.addElement(tabPanelPage);
            tabPanelPage.setParent(this);
            TabBarItem tabBarItem = tabPanelPage.getTabBarItem();
            tabBar.addItem(tabBarItem);
        } else {
            int n = this.getIndexOf(tabPanelPage2);
            this._pagePack.insertElementAt(tabPanelPage, n);
            tabPanelPage.setParent(this);
            TabBarItem tabBarItem = tabPanelPage.getTabBarItem();
            tabBar.addItem(tabBarItem, tabBar.getItem(n));
        }
        this.__fireVisibleDataChanged();
        return tabPanelPage;
    }

    public TabPanelPage getPage(int n) {
        if (n < 0 || n >= this.getPageCount()) {
            throw new IllegalArgumentException();
        }
        return (TabPanelPage)this._pagePack.elementAt(n);
    }

    public int getIndexOf(TabPanelPage tabPanelPage) {
        if (tabPanelPage != null) {
            return this._pagePack.indexOf(tabPanelPage);
        }
        return -1;
    }

    public TabPanelPage getSelectedPage() {
        return this._selectedPage;
    }

    public int getPageCount() {
        return this._pagePack.size();
    }

    public void showDropDownMenu() {
        this.getTabBar().showDropDownMenu();
    }

    public void removeAllPages() {
        this.getTabBar().removeAllItems();
        this._sheet.removeAll();
        int n = this.getPageCount() - 1;
        while (n >= 0) {
            this.getPage(n--).setParent(null);
        }
        this._pagePack.removeAllElements();
        this.__fireVisibleDataChanged();
    }

    public void removeAll() {
        this.removeAllPages();
        super.removeAll();
        this._sheet = null;
        this._tabBar = null;
    }

    public void removePage(TabPanelPage tabPanelPage) {
        if (tabPanelPage == null) {
            throw new IllegalArgumentException();
        }
        this.getTabBar().removeItem(tabPanelPage.getTabBarItem());
        this._sheet.remove(tabPanelPage.getContent());
        this._pagePack.removeElement(tabPanelPage);
        tabPanelPage.setParent(null);
        if (tabPanelPage == this._selectedPage) {
            TabBarItem tabBarItem = this.getTabBar().getSelectedItem();
            this._selectedPage = tabBarItem == null ? null : this.getPage(tabBarItem.indexOf());
        }
        this.__fireVisibleDataChanged();
    }

    public void setOrientation(int n) {
        TabBar tabBar = this.getTabBar();
        if (n != tabBar.getOrientation()) {
            this.remove(tabBar);
            tabBar.setOrientation(n);
            n = tabBar.getOrientation();
            if (n == 0) {
                this.add("North", tabBar);
            } else if (n == 1) {
                this.add("South", tabBar);
            } else if (n == 2) {
                this.add("West", tabBar);
            } else {
                this.add("East", tabBar);
            }
            this._sheet.setOrientation(n);
            this.repaint();
        }
    }

    public void setContentBackground(Color color) {
        this._isContentBackgroundSet = true;
        this._setContentBackground(color, color);
    }

    private void _setContentBackground(Color color, Color color2) {
        this.getTabBar().setSelectedBackground(color);
        this._sheet.setBackground(color2);
    }

    public int getOrientation() {
        return this.getTabBar().getOrientation();
    }

    public Color getContentBackground() {
        return this.getTabBar().getItemBackground();
    }

    public void setAlignment(int n) {
        super.setAlignment(n);
        TabBar tabBar = this.getTabBar();
        if (tabBar != null) {
            tabBar.setAlignment(n);
        }
    }

    public void addTabPanelListener(TabPanelListener tabPanelListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(tabPanelListener);
    }

    public void removeTabPanelListener(TabPanelListener tabPanelListener) {
        this._listeners.removeListener(tabPanelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tabBarSelectionChanged(TabBarEvent tabBarEvent) {
        TabPanelPage tabPanelPage;
        TabPanelPage tabPanelPage2 = this.getSelectedPage();
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            TabBarItem tabBarItem;
            if (tabPanelPage2 != null) {
                this._sheet.repaintItemBorder(this._getItemForPage(tabPanelPage2));
            }
            if ((tabBarItem = tabBarEvent.getItem()) == null) {
                tabPanelPage = null;
            } else {
                this._sheet.repaintItemBorder(tabBarItem);
                tabPanelPage = this.getPage(tabBarItem.indexOf());
                if (tabPanelPage != null) {
                    Component component = tabPanelPage.getContent();
                    if (component instanceof HelpCapable) {
                        String string = ((HelpCapable)((Object)component)).getHelpTopic();
                        if (tabBarEvent.getSource() instanceof TabBar) {
                            ((TabBar)tabBarEvent.getSource()).setHelpTopic(string);
                        }
                    }
                } else if (tabBarEvent.getSource() instanceof TabBar) {
                    ((TabBar)tabBarEvent.getSource()).setHelpTopic(null);
                }
            }
            this.setSelectedPage(tabPanelPage);
            if (tabPanelPage2 == null || !this.isShowing()) {
                bl = true;
            } else {
                if (this._showTask == null) {
                    this._showTask = new ShowTask();
                }
                _sTaskScheduler.schedule(this._showTask, 200);
            }
        }
        if (bl) {
            this._displaySelectedContents();
        }
        this.processEvent(new TabPanelEvent(this, 2001, tabPanelPage));
        object = this.accessAccessibleContext();
        if (object != null && tabPanelPage2 != tabPanelPage) {
            if (tabPanelPage2 != null) {
                tabPanelPage2.getAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
            if (tabPanelPage != null) {
                tabPanelPage.getAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            }
            ((AccessibleContext)object).firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
        }
    }

    public void tabBarSelectionChanging(TabBarEvent tabBarEvent) {
        TabBarItem tabBarItem = tabBarEvent.getItem();
        TabPanelPage tabPanelPage = this.getPage(tabBarItem.indexOf());
        TabPanelValidateEvent tabPanelValidateEvent = new TabPanelValidateEvent(this, 2000, tabPanelPage);
        this.processEvent(tabPanelValidateEvent);
        if (tabPanelValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tabBarEvent)).cancel();
        }
    }

    public void tabBarLayoutChanged(TabBarEvent tabBarEvent) {
        this._sheet.repaintAllItems();
    }

    public void enable() {
        this.getTabBar().setEnabled(true);
        super.enable();
    }

    public void disable() {
        this.getTabBar().setEnabled(false);
        super.disable();
    }

    public void postProcessKey(KeyEvent keyEvent) {
        super.postProcessKey(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled() || !keyEvent.isControlDown() || keyEvent.getID() != 401 || keyEvent.getKeyCode() != 9 || !this.isAncestorOf(keyEvent.getComponent())) {
            return;
        }
        this.getTabBar().requestFocus();
        if (keyEvent.isShiftDown()) {
            this.getTabBar().moveSelection(false);
        } else {
            this.getTabBar().moveSelection(true);
        }
        keyEvent.consume();
    }

    protected void updateUI(Class clazz) {
        if (clazz == TabPanel.class) {
            this.updateUI();
        }
    }

    public void setColorScheme(ColorScheme colorScheme) {
        super.setColorScheme(colorScheme);
        if (!this._isContentBackgroundSet) {
            this._setContentBackground(this.getUIDefaults().getColor("TabBar.selectedItemBackground"), this.getUIDefaults().getColor("TabPanel.itemBackground"));
        }
    }

    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        if (componentUI != null && !this._isContentBackgroundSet) {
            this._setContentBackground(this.getUIDefaults().getColor("TabBar.selectedItemBackground"), this.getUIDefaults().getColor("TabPanel.itemBackground"));
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TabPanelEvent) {
            this.processTabPanelEvent((TabPanelEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processTabPanelEvent(TabPanelEvent tabPanelEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                TabPanelListener tabPanelListener = (TabPanelListener)enumeration.nextElement();
                switch (tabPanelEvent.getID()) {
                    case 2000: {
                        tabPanelListener.tabPanelSelectionChanging(tabPanelEvent);
                        break;
                    }
                    case 2001: {
                        tabPanelListener.tabPanelSelectionChanged(tabPanelEvent);
                        break;
                    }
                }
            }
        }
    }

    protected TabBar getTabBar() {
        return this._tabBar;
    }

    protected void setSelectedPage(TabPanelPage tabPanelPage) {
        this._selectedPage = tabPanelPage;
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    protected String getDefaultName() {
        return this.getBaseClassName() + _sInstanceCounter++;
    }

    void setContent(Component component, TabPanelPage tabPanelPage) {
        if (component == null) {
            throw new NullPointerException();
        }
        this._sheet.remove(tabPanelPage.getContent());
        tabPanelPage.setPageContent(component);
        component.setVisible(false);
        this._sheet.add(tabPanelPage.getLabel(), component);
        if (this.getSelectedPage() == tabPanelPage) {
            this._displaySelectedContents();
        }
    }

    void _setLabel(String string, TabPanelPage tabPanelPage) {
        Component component = tabPanelPage.getContent();
        this._sheet.remove(component);
        this._sheet.add(string, component);
        if (this.getSelectedPage() == tabPanelPage) {
            component.setVisible(false);
            this._displaySelectedContents();
        }
    }

    void _displaySelectedContents() {
        TabBarItem tabBarItem = this.getTabBar().getSelectedItem();
        if (tabBarItem != null) {
            this._sheet.displayContents(this.getSelectedPage().getContent());
        }
    }

    void __fireVisibleDataChanged() {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }
    }

    private TabBarItem _getItemForPage(TabPanelPage tabPanelPage) {
        return tabPanelPage.getTabBarItem();
    }

    static {
        _sTaskScheduler = TaskScheduler.getDefaultTaskScheduler();
    }

    private class Access
    extends AccessibleLWComponent
    implements AccessibleSelection {
        public Access() {
            super(TabPanel.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        public int getAccessibleChildrenCount() {
            return TabPanel.this.getPageCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= TabPanel.this.getPageCount()) {
                return null;
            }
            return TabPanel.this.getPage(n);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleAt(Point point) {
            TabBar tabBar = TabPanel.this.getTabBar();
            Point point2 = tabBar.getLocation();
            TabBarItem tabBarItem = tabBar.getItemAt(point.x - point2.x, point.y - point2.y);
            if (tabBarItem == null) {
                return TabPanel.this.getSelectedPage();
            }
            return this.getAccessibleChild(tabBar.getIndexOf(tabBarItem));
        }

        public int getAccessibleSelectionCount() {
            return TabPanel.this.getSelectedPage() == null ? 0 : 1;
        }

        public Accessible getAccessibleSelection(int n) {
            if (n == 0) {
                return TabPanel.this.getSelectedPage();
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            if (n < 0 || n >= TabPanel.this.getPageCount()) {
                return false;
            }
            return TabPanel.this.getPage(n) == TabPanel.this.getSelectedPage();
        }

        public void addAccessibleSelection(int n) {
            TabPanel.this.getPage(n).setSelected(true);
        }

        public void removeAccessibleSelection(int n) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }

    private class ShowTask
    implements Task {
        private ShowTask() {
        }

        public void runTask(TaskEvent taskEvent) {
            TabPanel.this._displaySelectedContents();
        }
    }
}

