/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.tabBar;

import java.awt.Component;
import java.awt.Dimension;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.popup.ToolTipSite;
import oracle.ewt.tabBar.TabBar;
import oracle.ewt.tabBar.TabBarItem;

public class TabBarToolTipClient
implements ToolTipClient {
    private static final ToolTipClient _sToolTipClient = new TabBarToolTipClient();
    private static final int[] _ALIGNMENTS = new int[]{2, 1, 5, 6, 12, 10, 11, 12};

    public static ToolTipClient getToolTipClient() {
        return _sToolTipClient;
    }

    public ToolTipSite getToolTipSite(Component component, int n, int n2) {
        if (!(component instanceof TabBar)) {
            return null;
        }
        TabBar tabBar = (TabBar)component;
        TabBarItem tabBarItem = tabBar.getItemAt(n, n2);
        if (tabBarItem != null && this.shouldDisplay(tabBarItem)) {
            return new ToolTipSite(this.getToolTipValue(tabBarItem), tabBarItem.getOuterBounds(), _ALIGNMENTS, null);
        }
        return null;
    }

    protected Object getToolTipValue(TabBarItem tabBarItem) {
        return tabBarItem.getLabel();
    }

    protected boolean shouldDisplay(TabBarItem tabBarItem) {
        Dimension dimension = tabBarItem.getSize();
        Dimension dimension2 = tabBarItem.getPreferredSize();
        return dimension.width < dimension2.width || dimension.height < dimension2.height;
    }

    protected TabBarToolTipClient() {
    }
}

