/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.print;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.Vector;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.imageCanvas.ImageCanvas;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.print.DebugPrintGraphics;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.util.WindowUtils;

public class DebugPrintJob
extends PrintJob {
    private static final double _PAGE_WIDTH_INCHES = 8.5;
    private static final double _PAGE_HEIGHT_INCHES = 11.0;
    private static final double _END_HARDWARE_MARGIN_INCHES = 0.125;
    private static final double _EDGE_HARDWARE_MARGIN_INCHES = 0.125;
    private Frame _parentFrame;
    private String _jobName;
    private Vector _pageVector = new Vector();
    private boolean _isEnded;

    public DebugPrintJob(Frame frame, String string) {
        this._parentFrame = frame;
        this._jobName = string;
    }

    public Graphics getGraphics() {
        if (this._isEnded) {
            throw new IllegalStateException();
        }
        Dimension dimension = this.getPageDimension();
        DebugPrintGraphics debugPrintGraphics = new DebugPrintGraphics(dimension.width, dimension.height, this);
        this._pageVector.addElement(debugPrintGraphics);
        int n = this.getPageResolution();
        int n2 = (int)((double)n * 0.125);
        int n3 = (int)((double)n * 0.125);
        ((Graphics)debugPrintGraphics).clipRect(n2, n3, dimension.width - 2 * n2, dimension.height - 2 * n3);
        return debugPrintGraphics;
    }

    public Dimension getPageDimension() {
        return new Dimension((int)(8.5 * (double)this.getPageResolution()), (int)(11.0 * (double)this.getPageResolution()));
    }

    public int getPageResolution() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public boolean lastPageFirst() {
        return false;
    }

    public void end() {
        if (!this._isEnded) {
            this._isEnded = true;
            TabPanel tabPanel = new TabPanel();
            Vector vector = this._pageVector;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                DebugPrintGraphics debugPrintGraphics = (DebugPrintGraphics)vector.elementAt(i);
                ImageCanvas imageCanvas = new ImageCanvas(debugPrintGraphics.getGraphicsImage());
                tabPanel.addPage(IntegerUtils.getString((int)(i + 1)), new ScrollBox(imageCanvas));
            }
            BufferedDialog bufferedDialog = new BufferedDialog(this._parentFrame, this._jobName);
            bufferedDialog.add("Center", tabPanel);
            bufferedDialog.pack();
            bufferedDialog.addWindowListener(WindowUtils.getWindowCloser());
            WindowUtils.centerWindow(bufferedDialog, this._parentFrame);
            bufferedDialog.setVisible(true);
        }
    }
}

