/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.popup;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.popup.LabelToolTip;
import oracle.ewt.popup.MLLabelToolTip;
import oracle.ewt.popup.PopupOwner;
import oracle.ewt.popup.PopupUtils;
import oracle.ewt.popup.ToolTip;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.popup.ToolTipSite;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;

public class ToolTipManager {
    private PopupOwner _owner;
    private Component _over;
    private ToolTip _currentTip;
    private ToolTipSite _site;
    private ToolTipClient _client;
    private final Impl _impl = new Impl();
    private Task _task;
    private Point _lastPoint;
    private int _delay = 500;
    private final Hashtable _table = new Hashtable();
    private static final int _INITIAL_DELAY = 500;
    private static final int _BROWSE_DELAY = 20;
    private static final int _CURSOR_SIZE = 18;
    private static final int[] _sDefaultAlignments = new int[]{2, 17, 22, 1, 16, 21, 10, 5};
    private static ToolTipManager _sToolTipManager;

    public static ToolTipManager getToolTipManager() {
        if (_sToolTipManager == null) {
            _sToolTipManager = new ToolTipManager();
        }
        return _sToolTipManager;
    }

    public void registerComponent(LWComponent lWComponent) {
        this._registerComponentImpl(lWComponent);
    }

    public void registerComponent(Component component, String string) {
        this._registerComponentImpl(component, string);
    }

    public void registerComponent(Component component, ToolTipClient toolTipClient) {
        this._registerComponentImpl(component, toolTipClient);
    }

    public void unregisterComponent(Component component) {
        this._unregisterComponentImpl(component);
    }

    public synchronized void show(Component component) {
        this.show(component, 0, 0);
    }

    public synchronized void show(Component component, int n, int n2) {
        this.enter(component);
        this._lastPoint = new Point(n, n2);
        this.schedule();
    }

    public synchronized void enter(Component component) {
        if (this._over != null) {
            this.leave(this._over);
        }
        this._task = new Tsk();
        Object object = null;
        if (component instanceof LWComponent) {
            object = ((LWComponent)component).getToolTipValue();
        }
        if (object == null) {
            object = this._table.get(component);
        }
        if (object instanceof ToolTipClient) {
            this._client = (ToolTipClient)object;
            this._site = null;
        } else {
            this._client = null;
            this._site = object == null ? null : new ToolTipSite(object, null);
        }
        this._over = component;
        component.addMouseMotionListener(this._impl);
    }

    public synchronized void hide() {
        PopupOwner popupOwner = this._owner;
        if (this._task != null) {
            TaskScheduler.getDefaultTaskScheduler().cancel(this._task);
        }
        this._owner = null;
        if (popupOwner != null) {
            popupOwner.removePopup((Component)((Object)this._currentTip));
        }
        this._site = null;
    }

    protected synchronized void schedule() {
        if (this._owner == null) {
            TaskScheduler.getDefaultTaskScheduler().schedule(this._task, this._getDelay());
        }
    }

    protected synchronized void cancel() {
        PopupOwner popupOwner = this._owner;
        if (this._task != null) {
            TaskScheduler.getDefaultTaskScheduler().cancel(this._task);
        }
        this._owner = null;
        if (popupOwner != null) {
            popupOwner.removePopup((Component)((Object)this._currentTip));
        }
        this._site = null;
    }

    protected ToolTipManager() {
    }

    synchronized void _showToolTip(Task task) {
        if (task != this._task) {
            return;
        }
        if (this._over == null) {
            return;
        }
        this._delay = 20;
        ToolTipClient toolTipClient = this._client;
        ToolTipSite toolTipSite = this._site;
        int n = this._lastPoint.x;
        int n2 = this._lastPoint.y;
        if (toolTipClient != null && toolTipSite == null) {
            this._site = toolTipSite = toolTipClient.getToolTipSite(this._over, n, n2);
        } else if (toolTipSite == null) {
            Object object = null;
            if (this._over instanceof LWComponent) {
                object = ((LWComponent)this._over).getToolTipValue();
            }
            if (object == null) {
                object = this._table.get(this._over);
            }
            if (object != null && !(object instanceof ToolTipClient)) {
                this._site = new ToolTipSite(object, null);
            }
        }
        if (toolTipSite != null && this._over.isShowing()) {
            int[] nArray;
            boolean bl = false;
            ToolTip toolTip = toolTipSite.getToolTip();
            if (toolTip == null) {
                toolTip = this._getDefaultToolTip();
                bl = true;
            }
            if ((nArray = toolTipSite.getAlignments()) == null) {
                nArray = this._getAlignments();
            }
            toolTip.setToolTipValue(toolTipSite.getValue());
            Rectangle rectangle = toolTipSite.getArea();
            if (rectangle == null) {
                rectangle = this._over.getBounds();
                rectangle.y = 0;
                rectangle.x = 0;
            }
            if (toolTipSite.contains(n, n2)) {
                rectangle.add(new Rectangle(n, n2, 18, 18));
                this._currentTip = toolTip;
                Component component = (Component)((Object)toolTip);
                if (bl) {
                    Dimension dimension = component.getPreferredSize();
                    PopupOwner popupOwner = PopupUtils.displayPopupRelativeTo(this._over, component, rectangle, dimension, dimension, nArray);
                    if (popupOwner == null) {
                        toolTip = MLLabelToolTip.getToolTip();
                        toolTip.setToolTipValue(toolTipSite.getValue());
                        this._currentTip = toolTip;
                        component = (Component)((Object)toolTip);
                        popupOwner = PopupUtils.displayPopupRelativeTo(this._over, component, rectangle, null, nArray);
                    }
                    this._owner = popupOwner;
                } else {
                    this._owner = PopupUtils.displayPopupRelativeTo(this._over, component, rectangle, null, nArray);
                }
            }
        }
    }

    private void _registerComponentImpl(Component component, Object object) {
        this._table.put(component, object);
        component.addMouseListener(this._impl);
    }

    private void _registerComponentImpl(LWComponent lWComponent) {
        lWComponent.addMouseListener(this._impl);
    }

    private void _unregisterComponentImpl(Component component) {
        this._table.remove(component);
        component.removeMouseListener(this._impl);
    }

    private ToolTip _getDefaultToolTip() {
        return LabelToolTip.getToolTip();
    }

    private int _getDelay() {
        return this._delay;
    }

    private int[] _getAlignments() {
        return _sDefaultAlignments;
    }

    public void leaveLater(final Component component) {
        if (this._over == component) {
            Task task = new Task(){

                public void runTask(TaskEvent taskEvent) {
                    ToolTipManager.this.leave(component);
                }
            };
            TaskScheduler.getDefaultTaskScheduler().schedule(task, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(Component component) {
        Component component2 = this._over;
        if (component2 == component) {
            if (this._owner != null && this._owner instanceof Container) {
                Object object = ((Container)((Object)this._owner)).getTreeLock();
                synchronized (object) {
                    ToolTipManager toolTipManager = this;
                    synchronized (toolTipManager) {
                        component2 = this._over;
                        if (component2 == component) {
                            this.cancel();
                            component2.removeMouseMotionListener(this._impl);
                            this._over = null;
                            this._delay = 500;
                        }
                    }
                }
            }
            ToolTipManager toolTipManager = this;
            synchronized (toolTipManager) {
                component2 = this._over;
                if (component2 == component) {
                    this.cancel();
                    component2.removeMouseMotionListener(this._impl);
                    this._over = null;
                    this._delay = 500;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moved(int n, int n2) {
        ToolTipManager toolTipManager = this;
        synchronized (toolTipManager) {
            ToolTipSite toolTipSite = this._site;
            if (toolTipSite != null) {
                if (!toolTipSite.contains(n, n2)) {
                    this.cancel();
                }
                this._task = new Tsk();
            }
        }
        this._lastPoint = new Point(n, n2);
        this.schedule();
    }

    private class Impl
    extends MouseAdapter
    implements MouseMotionListener {
        private Impl() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ToolTipManager.this.cancel();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ToolTipManager.this.enter((Component)mouseEvent.getSource());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ToolTipManager.this.leave(mouseEvent.getComponent());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ToolTipManager.this.moved(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class Tsk
    implements Task {
        private Tsk() {
        }

        public void runTask(TaskEvent taskEvent) {
            ToolTipManager.this._showToolTip(this);
        }
    }
}

