/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.popup;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.util.ComponentUtils;

class MouseGrabSupport
implements MouseGrabProvider {
    private MouseListener _grabs;
    private MouseMotionListener _motionGrabs;
    private Component _proxy;

    MouseGrabSupport() {
    }

    public void addMouseGrab(MouseListener mouseListener) {
        this._grabs = AWTEventMulticaster.add(mouseListener, this._grabs);
    }

    public void addMouseMotionGrab(MouseMotionListener mouseMotionListener) {
        this._motionGrabs = AWTEventMulticaster.add(mouseMotionListener, this._motionGrabs);
    }

    public Component getProxyComponent() {
        if (this._proxy == null) {
            this._proxy = new ProxyComp();
            Redispatcher redispatcher = new Redispatcher();
            this._proxy.addMouseListener(redispatcher);
            this._proxy.addMouseMotionListener(redispatcher);
        }
        return this._proxy;
    }

    public void processMouseGrabs(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (n == 503 || n == 506) {
            if (this._motionGrabs != null) {
                switch (mouseEvent.getID()) {
                    case 503: {
                        this._motionGrabs.mouseMoved(mouseEvent);
                        break;
                    }
                    case 506: {
                        this._motionGrabs.mouseDragged(mouseEvent);
                    }
                }
            }
        } else if (this._grabs != null) {
            switch (mouseEvent.getID()) {
                case 500: {
                    this._grabs.mouseClicked(mouseEvent);
                    break;
                }
                case 501: {
                    this._grabs.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this._grabs.mouseReleased(mouseEvent);
                    break;
                }
                case 504: {
                    this._grabs.mouseEntered(mouseEvent);
                    break;
                }
                case 505: {
                    this._grabs.mouseExited(mouseEvent);
                }
            }
        }
    }

    public void removeMouseGrab(MouseListener mouseListener) {
        this._grabs = AWTEventMulticaster.remove(this._grabs, mouseListener);
    }

    public void removeMouseMotionGrab(MouseMotionListener mouseMotionListener) {
        this._motionGrabs = AWTEventMulticaster.remove(this._motionGrabs, mouseMotionListener);
    }

    private class Redispatcher
    implements MouseListener,
    MouseMotionListener {
        private Component _dragComponent;
        private Component _mouseComponent;
        private Component _clickComponent;

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = new Point();
            Component component = this._checkTarget(mouseEvent, point);
            this._redispatchEvent(mouseEvent, component, 501, point);
            this._dragComponent = this._clickComponent = component;
            mouseEvent.consume();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = new Point();
            Component component = this._checkTarget(mouseEvent, point);
            if (component == this._clickComponent) {
                this._redispatchEvent(mouseEvent, component, 500, point);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this._dragComponent != null) {
                this._redispatchEvent(mouseEvent, this._dragComponent, 502);
                this._dragComponent = null;
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this._checkTarget(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this._checkTarget(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this._checkTarget(mouseEvent);
            this._redispatchEvent(mouseEvent, this._dragComponent, 506);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Component component = this._mouseComponent;
            Point point = new Point();
            Component component2 = this._checkTarget(mouseEvent, point);
            if (component == component2 && component2 != null) {
                this._redispatchEvent(mouseEvent, component2, 503, point);
            }
        }

        private Component _checkTarget(MouseEvent mouseEvent) {
            return this._checkTarget(mouseEvent, new Point());
        }

        private Component _checkTarget(MouseEvent mouseEvent, Point point) {
            Component component = null;
            if (mouseEvent.getID() != 505) {
                point.x = mouseEvent.getX();
                point.y = mouseEvent.getY();
                Component component2 = MouseGrabSupport.this.getProxyComponent();
                component = ComponentUtils.getTargetComponent(component2.getParent(), point);
            }
            if (component != this._mouseComponent) {
                if (this._mouseComponent != null && (this._dragComponent == null || this._dragComponent == this._mouseComponent)) {
                    this._redispatchEvent(mouseEvent, this._mouseComponent, 505);
                    this._mouseComponent = null;
                }
                if (component != null && (this._dragComponent == null || this._dragComponent == component)) {
                    this._redispatchEvent(mouseEvent, component, 504, point);
                    this._mouseComponent = component;
                }
            }
            return component;
        }

        private void _redispatchEvent(MouseEvent mouseEvent, Component component, int n) {
            if (component == null) {
                return;
            }
            Container container = MouseGrabSupport.this.getProxyComponent().getParent();
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            for (Component component2 = component; component2 != container && component2 != null; component2 = component2.getParent()) {
                Point point2 = component2.getLocation();
                point.x -= point2.x;
                point.y -= point2.y;
            }
            this._redispatchEvent(mouseEvent, component, n, point);
        }

        private void _redispatchEvent(MouseEvent mouseEvent, Component component, int n, Point point) {
            if (component == null) {
                return;
            }
            MouseEvent mouseEvent2 = new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            MouseGrabSupport.this.processMouseGrabs(mouseEvent2);
            Component component2 = MouseGrabSupport.this.getProxyComponent();
            if (mouseEvent2.isConsumed() || component == component2.getParent()) {
                component2.setCursor(Cursor.getDefaultCursor());
                return;
            }
            if (component instanceof LWComponent) {
                ((LWComponent)component).redispatchEvent(mouseEvent2);
            } else {
                component.dispatchEvent(mouseEvent2);
            }
            Cursor cursor = component.getCursor();
            if (cursor != component2.getCursor()) {
                component2.setCursor(cursor);
            }
        }
    }

    private static class ProxyComp
    extends LWComponent {
        private ProxyComp() {
        }

        public final void repaint(long l, int n, int n2, int n3, int n4) {
        }
    }
}

