/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.pivot;

import oracle.ewt.event.Cancelable;
import oracle.ewt.pivot.PivotHeader;
import oracle.ewt.pivot.PivotTable;
import oracle.ewt.pivot.PivotValidateEvent;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableCellSelectListener;
import oracle.ewt.table.TableColSelectListener;
import oracle.ewt.table.TableEditListener;
import oracle.ewt.table.TableEvent;
import oracle.ewt.table.TableFocusListener;
import oracle.ewt.table.TableResizeListener;
import oracle.ewt.table.TableRowSelectListener;
import oracle.ewt.table.TableScrollListener;

final class PivotGridTabAdapt
implements TableCellSelectListener,
TableColSelectListener,
TableEditListener,
TableFocusListener,
TableResizeListener,
TableRowSelectListener,
TableScrollListener {
    private PivotTable _pivot;

    public PivotGridTabAdapt(PivotTable pivotTable) {
        this._pivot = pivotTable;
    }

    public void cellSelecting(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2001, tableEvent.getColumn(), tableEvent.getRow());
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    public void cellSelected(TableEvent tableEvent) {
        this._pivot.getRowPivotHeader().getGrid().getGridSelection().deselectAll();
        this._pivot.getColumnPivotHeader().getGrid().getGridSelection().deselectAll();
        this._pivot.postEvent(new TableEvent(this._pivot, 2002, tableEvent.getColumn(), tableEvent.getRow()));
    }

    public void cellDeselecting(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2003, tableEvent.getColumn(), tableEvent.getRow());
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    public void cellDeselected(TableEvent tableEvent) {
        this._pivot.postEvent(new TableEvent(this._pivot, 2004, tableEvent.getColumn(), tableEvent.getRow()));
    }

    public void columnSelecting(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2009, tableEvent.getColumn(), tableEvent.getRow());
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    public void columnSelected(TableEvent tableEvent) {
        this._pivot.getRowPivotHeader().getGrid().getGridSelection().deselectAll();
        this._pivot.getColumnPivotHeader().getGrid().getGridSelection().deselectAll();
        this._pivot.postEvent(new TableEvent(this._pivot, 2010, tableEvent.getColumn(), tableEvent.getRow()));
    }

    public void columnDeselecting(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2011, tableEvent.getColumn(), tableEvent.getRow());
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    public void columnDeselected(TableEvent tableEvent) {
        this._pivot.postEvent(new TableEvent(this._pivot, 2012, tableEvent.getColumn(), tableEvent.getRow()));
    }

    public void cellEditing(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2017, tableEvent.getColumn(), tableEvent.getRow());
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    public void cellEdited(TableEvent tableEvent) {
        this._pivot.postEvent(new TableEvent(this._pivot, 2018, tableEvent.getColumn(), tableEvent.getRow()));
    }

    public void focusCellChanging(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2027, tableEvent.getColumn(), tableEvent.getRow());
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    public void focusCellChanged(TableEvent tableEvent) {
        this._pivot.postEvent(new TableEvent(this._pivot, 2028, tableEvent.getColumn(), tableEvent.getRow()));
    }

    public void columnResizing(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2013, tableEvent.getColumn(), -1);
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        } else {
            this._pivot.getPivotGrid().setCurrentlyResizing(true);
        }
    }

    public void columnResized(TableEvent tableEvent) {
        this._pivot.getPivotGrid().setCurrentlyResizing(false);
        SpreadTable spreadTable = (SpreadTable)tableEvent.getSource();
        int n = tableEvent.getColumn();
        int n2 = spreadTable.getColumnWidth(n);
        if (this._pivot.getEqualSizedColumns()) {
            this._pivot.tryDefaultColumns();
            spreadTable.setColumnWidth(n, -1);
            this._pivot.getColumnPivotHeader().setColumnWidth(n, -1);
            this._pivot.setDefaultColumnWidth(n2);
        } else {
            this._pivot.setColumnWidth(n, n2);
        }
        this._pivot.postEvent(new TableEvent(this._pivot, 2014, n, -1));
    }

    public void rowResizing(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2015, -1, tableEvent.getRow());
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        } else {
            this._pivot.getPivotGrid().setCurrentlyResizing(true);
        }
    }

    public void rowResized(TableEvent tableEvent) {
        this._pivot.getPivotGrid().setCurrentlyResizing(false);
        SpreadTable spreadTable = (SpreadTable)tableEvent.getSource();
        int n = tableEvent.getRow();
        int n2 = spreadTable.getRowHeight(n);
        if (this._pivot.getEqualSizedRows()) {
            this._pivot.tryDefaultRows();
            spreadTable.setRowHeight(n, -1);
            this._pivot.getRowPivotHeader().setRowHeight(n, -1);
            this._pivot.setDefaultRowHeight(n2);
        } else {
            this._pivot.setRowHeight(n, n2);
        }
        this._pivot.postEvent(new TableEvent(this._pivot, 2016, -1, n));
    }

    public void rowSelecting(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2005, tableEvent.getColumn(), tableEvent.getRow());
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    public void rowSelected(TableEvent tableEvent) {
        this._pivot.getColumnPivotHeader().getGrid().getGridSelection().deselectAll();
        this._pivot.getRowPivotHeader().getGrid().getGridSelection().deselectAll();
        this._pivot.postEvent(new TableEvent(this._pivot, 2006, tableEvent.getColumn(), tableEvent.getRow()));
    }

    public void rowDeselecting(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2007, tableEvent.getColumn(), tableEvent.getRow());
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    public void rowDeselected(TableEvent tableEvent) {
        this._pivot.postEvent(new TableEvent(this._pivot, 2008, tableEvent.getColumn(), tableEvent.getRow()));
    }

    public void columnScrolling(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2019, tableEvent.getColumn(), -1);
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    public void rowScrolling(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2021, -1, tableEvent.getRow());
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    public void columnScrolled(TableEvent tableEvent) {
        PivotHeader pivotHeader = this._pivot.getColumnPivotHeader();
        if (pivotHeader != null) {
            pivotHeader.setFirstColumnOnScreen(tableEvent.getColumn());
        }
        this._pivot.postEvent(new TableEvent(this._pivot, 2020, tableEvent.getColumn(), tableEvent.getRow()));
    }

    public void rowScrolled(TableEvent tableEvent) {
        PivotHeader pivotHeader = this._pivot.getRowPivotHeader();
        if (pivotHeader != null) {
            pivotHeader.setFirstRowOnScreen(tableEvent.getRow());
        }
        this._pivot.postEvent(new TableEvent(this._pivot, 2022, tableEvent.getColumn(), tableEvent.getRow()));
    }
}

