/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import oracle.ewt.painter.AbstractWrappingPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.ImmInsets;

public abstract class AbstractBorderPainter
extends AbstractWrappingPainter
implements BorderPainter {
    private BorderPainter _wrappedBorderPainter;
    private boolean _alwaysAddInsets;

    public AbstractBorderPainter() {
        this._init(null, true);
    }

    public AbstractBorderPainter(Painter painter) {
        this(painter, true);
    }

    public AbstractBorderPainter(Painter painter, boolean bl) {
        super(painter);
        this._init(painter, bl);
    }

    public final Dimension getSize(PaintContext paintContext, int n, int n2) {
        ImmInsets immInsets = this.getOwnInsets(paintContext);
        return this._addInsets(paintContext, super.getSize(paintContext, n -= immInsets.left + immInsets.right, n2 -= immInsets.top + immInsets.bottom));
    }

    public final Dimension getPreferredSize(PaintContext paintContext) {
        return this._addInsets(paintContext, super.getPreferredSize(paintContext));
    }

    public final Dimension getMinimumSize(PaintContext paintContext) {
        return this._addInsets(paintContext, super.getMinimumSize(paintContext));
    }

    public final Dimension getMaximumSize(PaintContext paintContext) {
        return this._addInsets(paintContext, super.getMaximumSize(paintContext));
    }

    public final void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(paintContext, graphics, n, n2, n3, n4);
        ImmInsets immInsets = this.getOwnInsets(paintContext);
        super.paint(paintContext, graphics, n + immInsets.left, n2 + immInsets.top, n3 - immInsets.left - immInsets.right, n4 - immInsets.top - immInsets.bottom);
    }

    public final Painter getPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        ImmInsets immInsets = this.getOwnInsets(paintContext);
        if (n3 < 0 || n4 < 0 || n3 > n || n4 > n2) {
            return null;
        }
        if (n3 >= immInsets.left && n3 < n - immInsets.right && n4 >= immInsets.top && n4 < n2 - immInsets.bottom) {
            return this.getContentPainterAt(paintContext, n - immInsets.left - immInsets.right, n2 - immInsets.top - immInsets.bottom, n3 - immInsets.left, n4 - immInsets.top, painter);
        }
        return this.getBorderPainterAt(paintContext, n, n2, n3, n4, painter);
    }

    public final ImmInsets getInsets(PaintContext paintContext) {
        ImmInsets immInsets = this.getOwnInsets(paintContext);
        if (this._wrappedBorderPainter != null) {
            ImmInsets immInsets2 = this._wrappedBorderPainter.getInsets(paintContext);
            immInsets = new ImmInsets(immInsets.top + immInsets2.top, immInsets.left + immInsets2.left, immInsets.bottom + immInsets2.bottom, immInsets.right + immInsets2.right);
        }
        return immInsets;
    }

    public final ImmInsets getFillInsets(PaintContext paintContext) {
        if (this._wrappedBorderPainter != null) {
            ImmInsets immInsets = this._wrappedBorderPainter.getFillInsets(paintContext);
            if (immInsets.equals(ImmInsets.getEmptyInsets())) {
                return this.getOwnFillInsets(paintContext);
            }
            ImmInsets immInsets2 = this.getOwnInsets(paintContext);
            return new ImmInsets(immInsets2.top + immInsets.top, immInsets2.left + immInsets.left, immInsets2.bottom + immInsets.bottom, immInsets2.right + immInsets.right);
        }
        return this.getOwnFillInsets(paintContext);
    }

    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        return ImmInsets.getEmptyInsets();
    }

    protected ImmInsets getOwnFillInsets(PaintContext paintContext) {
        return this.getOwnInsets(paintContext);
    }

    protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public final boolean isTransparent(PaintContext paintContext) {
        return this.isBorderTransparent(paintContext) || super.isTransparent(paintContext);
    }

    protected Painter getContentPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        return super.getPainterAt(paintContext, n, n2, n3, n4, painter);
    }

    protected Painter getBorderPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        return this;
    }

    public final boolean contentContains(PaintContext paintContext, int n, int n2, int n3, int n4) {
        return super.contains(paintContext, n, n2, n3, n4);
    }

    public final boolean borderContains(PaintContext paintContext, int n, int n2, int n3, int n4) {
        return this.getBorderPainterAt(paintContext, n, n2, n3, n4, null) != null;
    }

    protected abstract boolean isBorderTransparent(PaintContext var1);

    private Dimension _addInsets(PaintContext paintContext, Dimension dimension) {
        if (this._alwaysAddInsets || dimension.width > 0 && dimension.height > 0) {
            ImmInsets immInsets = this.getOwnInsets(paintContext);
            dimension.width += immInsets.left + immInsets.right;
            dimension.height += immInsets.top + immInsets.bottom;
        }
        return dimension;
    }

    private void _init(Painter painter, boolean bl) {
        if (painter instanceof BorderPainter) {
            this._wrappedBorderPainter = (BorderPainter)painter;
        }
        this._alwaysAddInsets = bl;
    }
}

