/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow.laf;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.lwAWT.lwWindow.Desktop;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.WindowManager;
import oracle.ewt.util.InputEventUtils;

final class KeyWindowActivater
implements KeyListener {
    private static KeyWindowActivater _sInstance;

    public static KeyWindowActivater getInstance() {
        if (_sInstance == null) {
            _sInstance = new KeyWindowActivater();
        }
        return _sInstance;
    }

    private KeyWindowActivater() {
    }

    public void keyPressed(KeyEvent keyEvent) {
        LWWindow lWWindow = this._getWindow((Component)keyEvent.getSource());
        if (lWWindow == null) {
            return;
        }
        Desktop desktop = lWWindow.getDesktop();
        if (desktop == null) {
            return;
        }
        WindowManager windowManager = desktop.getWindowManager();
        if (this._isForwardNavigationKey(keyEvent)) {
            windowManager.transferActivationForward();
            keyEvent.consume();
        } else if (this._isBackwardNavigationKey(keyEvent)) {
            windowManager.transferActivationBackward();
            keyEvent.consume();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this._isForwardNavigationKey(keyEvent) || this._isBackwardNavigationKey(keyEvent)) {
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this._isForwardNavigationKey(keyEvent) || this._isBackwardNavigationKey(keyEvent)) {
            keyEvent.consume();
        }
    }

    private boolean _isBackwardNavigationKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 9 && InputEventUtils.getMods(keyEvent) == 3;
    }

    private boolean _isForwardNavigationKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 9 && InputEventUtils.getMods(keyEvent) == 2;
    }

    private LWWindow _getWindow(Component component) {
        while (component != null) {
            if (component instanceof LWWindow) {
                return (LWWindow)component;
            }
            component = component.getParent();
        }
        return null;
    }
}

